package jp.groupsession.v2.restapi.parameter.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 *
 * <br>[機  能] パラメータ初期設定用アノテーション
 * <br>[解  説] リクエストでパラメータが指定されていない場合、アノテーションで指定した値がセットされる。
 * <br>[備  考]
 *
 * @author JTS
 */
@Target({ElementType.METHOD, ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface Default {
    /** @return 初期設定値*/
    String value();
}