package jp.groupsession.v2.restapi.parameter.annotation;


import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;

/**
 *
 * <br>[機  能] 対応日付フォーマット注釈
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
@Target({ElementType.METHOD, ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Repeatable(UDateFormat.Holder.class)
public @interface UDateFormat {
    /** @return 日付フォーマット*/
    Format value();
    /** 日付フォーマット複数注釈 */
    @Retention(RetentionPolicy.RUNTIME)
    @Target(ElementType.METHOD)
    @interface Holder {
        /** @return 日付フォーマット複数注釈用*/
        UDateFormat[] value();
    }

    /** 日付時間フォーマット注釈*/
    @Retention(RetentionPolicy.RUNTIME)
    @Target(ElementType.FIELD)
    @interface DateTimeFormat {
        /** @return 日付時間フォーマット*/
        String value();
    }
    /** 日付フォーマット 列挙型*/
    public enum Format {
        /** yyyy/MM/dd hh:mm:ss */
        @DateTimeFormat("yyyy/MM/dd HH:mm:ss")
        DATETIME_SLUSH,
        /** yyyy-MM-dd hh-mm-ss */
        @DateTimeFormat("yyyy-MM-dd HH-mm-ss")
        DATETIME_CORON,
        /** yyyyMMdd hhmmss */
        @DateTimeFormat("yyyyMMdd HHmmss")
        DATETIME_TYOKKETU,
        /** yyyy/MM/dd hh:mm */
        @DateTimeFormat("yyyy/MM/dd HH:mm")
        DATETIME_SLUSH_HHMM,
        /** yyyy-MM-dd hh-mm */
        @DateTimeFormat("yyyy-MM-dd HH-mm")
        DATETIME_CORON_HHMM,
        /** yyyyMMdd hhmm */
        @DateTimeFormat("yyyyMMdd HHmm")
        DATETIME_TYOKKETU_HHMM,
        /** yyyy/MM/dd */
        @DateTimeFormat("yyyy/MM/dd")
        DATE_SLUSH,
        /** yyyy-MM-dd */
        @DateTimeFormat("yyyy-MM-dd")
        DATE_HIHUN,
        /** yyyyMMdd */
        @DateTimeFormat("yyyyMMdd")
        DATE_TYOKKETU,
        /** yyyy */
        @DateTimeFormat("yyyy")
        YEAR_SEIREKI,
        /** yy(年の下2桁） */
        @DateTimeFormat("yy")
        YEAR_SEIREKI2KETA,
        /** MM */
        @DateTimeFormat("MM")
        MONTH,
        /** dd */
        @DateTimeFormat("dd")
        DAY,
        /** hh:mm:ss */
        @DateTimeFormat("HH:mm:ss")
        TIME_CORON,
        /** hh-mm-ss */
        @DateTimeFormat("HH-mm-ss")
        TIME_HIHUN,
        /** hhmmss */
        @DateTimeFormat("HHmmss")
        TIME_TYOKKETU,
        /** hh:mm */
        @DateTimeFormat("HH:mm")
        TIME_CORON_HHMM,
        /** hh-mm */
        @DateTimeFormat("HH-mm")
        TIME_HIHUN_HHMM,
        /** hhmm */
        @DateTimeFormat("HHmm")
        TIME_TYOKKETU_HHMM,
        /** hh */
        @DateTimeFormat("HH")
        HOUR,
        /** mm */
        @DateTimeFormat("mm")
        MINUTES,
        /** ss */
        @DateTimeFormat("ss")
        SECONDS;
        /** @return フォーマット文字列*/
        public String value() {
            String name;
            try {
                name = (String) this.getClass().getMethod("name").invoke(this);
                DateTimeFormat ant
                    = this.getClass().getField(name)
                        .getAnnotation(DateTimeFormat.class);
                return ant.value();
            } catch (IllegalAccessException | IllegalArgumentException
                    | InvocationTargetException | NoSuchMethodException
                    | SecurityException | NoSuchFieldException e) {
            }
            return "";

        }
    }
}
