package jp.groupsession.v2.ntp.ntp040.model;

import java.io.Serializable;

import jp.co.sjts.util.NullDefault;
import jp.co.sjts.util.date.UDate;

/**
 * <br>[機  能] 日報で使用する アドレス帳 会社拠点情報を格納するModelクラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class Ntp040DBCompanyBaseModel implements Serializable {

    /** ABA_SID mapping */
    private int abaSid__;
    /** ACO_SID mapping */
    private int acoSid__;
    /** ABA_TYPE mapping */
    private int abaType__;
    /** ABA_NAME mapping */
    private String abaName__;
    /** ABA_POSTNO1 mapping */
    private String abaPostno1__;
    /** ABA_POSTNO2 mapping */
    private String abaPostno2__;
    /** TDF_SID mapping */
    private int tdfSid__;
    /** ABA_ADDR1 mapping */
    private String abaAddr1__;
    /** ABA_ADDR2 mapping */
    private String abaAddr2__;
    /** ABA_BIKO mapping */
    private String abaBiko__;
    /** ABA_AUID mapping */
    private int abaAuid__;
    /** ABA_ADATE mapping */
    private UDate abaAdate__;
    /** ABA_EUID mapping */
    private int abaEuid__;
    /** ABA_EDATE mapping */
    private UDate abaEdate__;

    /**
     * <p>Default Constructor
     */
    public Ntp040DBCompanyBaseModel() {
    }

    /**
     * <p>get ABA_SID value
     * @return ABA_SID value
     */
    public int getAbaSid() {
        return abaSid__;
    }

    /**
     * <p>set ABA_SID value
     * @param abaSid ABA_SID value
     */
    public void setAbaSid(int abaSid) {
        abaSid__ = abaSid;
    }

    /**
     * <p>get ACO_SID value
     * @return ACO_SID value
     */
    public int getAcoSid() {
        return acoSid__;
    }

    /**
     * <p>set ACO_SID value
     * @param acoSid ACO_SID value
     */
    public void setAcoSid(int acoSid) {
        acoSid__ = acoSid;
    }

    /**
     * <p>get ABA_TYPE value
     * @return ABA_TYPE value
     */
    public int getAbaType() {
        return abaType__;
    }

    /**
     * <p>set ABA_TYPE value
     * @param abaType ABA_TYPE value
     */
    public void setAbaType(int abaType) {
        abaType__ = abaType;
    }

    /**
     * <p>get ABA_NAME value
     * @return ABA_NAME value
     */
    public String getAbaName() {
        return abaName__;
    }

    /**
     * <p>set ABA_NAME value
     * @param abaName ABA_NAME value
     */
    public void setAbaName(String abaName) {
        abaName__ = abaName;
    }

    /**
     * <p>get ABA_POSTNO1 value
     * @return ABA_POSTNO1 value
     */
    public String getAbaPostno1() {
        return abaPostno1__;
    }

    /**
     * <p>set ABA_POSTNO1 value
     * @param abaPostno1 ABA_POSTNO1 value
     */
    public void setAbaPostno1(String abaPostno1) {
        abaPostno1__ = abaPostno1;
    }

    /**
     * <p>get ABA_POSTNO2 value
     * @return ABA_POSTNO2 value
     */
    public String getAbaPostno2() {
        return abaPostno2__;
    }

    /**
     * <p>set ABA_POSTNO2 value
     * @param abaPostno2 ABA_POSTNO2 value
     */
    public void setAbaPostno2(String abaPostno2) {
        abaPostno2__ = abaPostno2;
    }

    /**
     * <p>get TDF_SID value
     * @return TDF_SID value
     */
    public int getTdfSid() {
        return tdfSid__;
    }

    /**
     * <p>set TDF_SID value
     * @param tdfSid TDF_SID value
     */
    public void setTdfSid(int tdfSid) {
        tdfSid__ = tdfSid;
    }

    /**
     * <p>get ABA_ADDR1 value
     * @return ABA_ADDR1 value
     */
    public String getAbaAddr1() {
        return abaAddr1__;
    }

    /**
     * <p>set ABA_ADDR1 value
     * @param abaAddr1 ABA_ADDR1 value
     */
    public void setAbaAddr1(String abaAddr1) {
        abaAddr1__ = abaAddr1;
    }

    /**
     * <p>get ABA_ADDR2 value
     * @return ABA_ADDR2 value
     */
    public String getAbaAddr2() {
        return abaAddr2__;
    }

    /**
     * <p>set ABA_ADDR2 value
     * @param abaAddr2 ABA_ADDR2 value
     */
    public void setAbaAddr2(String abaAddr2) {
        abaAddr2__ = abaAddr2;
    }

    /**
     * <p>get ABA_BIKO value
     * @return ABA_BIKO value
     */
    public String getAbaBiko() {
        return abaBiko__;
    }

    /**
     * <p>set ABA_BIKO value
     * @param abaBiko ABA_BIKO value
     */
    public void setAbaBiko(String abaBiko) {
        abaBiko__ = abaBiko;
    }

    /**
     * <p>get ABA_AUID value
     * @return ABA_AUID value
     */
    public int getAbaAuid() {
        return abaAuid__;
    }

    /**
     * <p>set ABA_AUID value
     * @param abaAuid ABA_AUID value
     */
    public void setAbaAuid(int abaAuid) {
        abaAuid__ = abaAuid;
    }

    /**
     * <p>get ABA_ADATE value
     * @return ABA_ADATE value
     */
    public UDate getAbaAdate() {
        return abaAdate__;
    }

    /**
     * <p>set ABA_ADATE value
     * @param abaAdate ABA_ADATE value
     */
    public void setAbaAdate(UDate abaAdate) {
        abaAdate__ = abaAdate;
    }

    /**
     * <p>get ABA_EUID value
     * @return ABA_EUID value
     */
    public int getAbaEuid() {
        return abaEuid__;
    }

    /**
     * <p>set ABA_EUID value
     * @param abaEuid ABA_EUID value
     */
    public void setAbaEuid(int abaEuid) {
        abaEuid__ = abaEuid;
    }

    /**
     * <p>get ABA_EDATE value
     * @return ABA_EDATE value
     */
    public UDate getAbaEdate() {
        return abaEdate__;
    }

    /**
     * <p>set ABA_EDATE value
     * @param abaEdate ABA_EDATE value
     */
    public void setAbaEdate(UDate abaEdate) {
        abaEdate__ = abaEdate;
    }

    /**
     * <p>to Csv String
     * @return Csv String
     */
    public String toCsvString() {
        StringBuilder buf = new StringBuilder();
        buf.append(abaSid__);
        buf.append(",");
        buf.append(acoSid__);
        buf.append(",");
        buf.append(abaType__);
        buf.append(",");
        buf.append(NullDefault.getString(abaName__, ""));
        buf.append(",");
        buf.append(NullDefault.getString(abaPostno1__, ""));
        buf.append(",");
        buf.append(NullDefault.getString(abaPostno2__, ""));
        buf.append(",");
        buf.append(tdfSid__);
        buf.append(",");
        buf.append(NullDefault.getString(abaAddr1__, ""));
        buf.append(",");
        buf.append(NullDefault.getString(abaAddr2__, ""));
        buf.append(",");
        buf.append(NullDefault.getString(abaBiko__, ""));
        buf.append(",");
        buf.append(abaAuid__);
        buf.append(",");
        buf.append(NullDefault.getStringFmObj(abaAdate__, ""));
        buf.append(",");
        buf.append(abaEuid__);
        buf.append(",");
        buf.append(NullDefault.getStringFmObj(abaEdate__, ""));
        return buf.toString();
    }

}
