package jp.groupsession.v2.rsv.biz;

import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

import jp.co.sjts.util.DataSizeUtil;
import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.rsv.dao.RsvBinDao;
import jp.groupsession.v2.rsv.dao.RsvDatausedSumDao;
import jp.groupsession.v2.rsv.dao.RsvSisDataDao;
import jp.groupsession.v2.rsv.model.RsvDatausedSumModel;
import jp.groupsession.v2.rsv.model.RsvSisDataModel;

/**
 * <br>[機  能] 施設予約プラグインの使用データサイズを操作するビジネスロジッククラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class RsvUsedDataBiz {


    /** DBコネクション */
    private Connection con__ = null;

    /**
     * <p>Default Constructor
     * @param con コネクション
     */
    public RsvUsedDataBiz(Connection con) {
        con__ = con;
    }

    /**
     * <p>con を取得します。
     * @return con
     */
    public Connection getCon() {
        return con__;
    }

    /**
     * <p>con をセットします。
     * @param con con
     */
    public void setCon(Connection con) {
        con__ = con;
    }

    /**
     * <br>[機  能] 施設情報の使用データサイズを登録する
     * <br>[解  説]
     * <br>[備  考]
     * @param rsdSid 施設SID
     * @param entryType 登録種別 true: 加算、false: 減算
     * @throws SQLException SQL実行例外
     */
    public void insertRsvDataSize(int rsdSid, boolean entryType)
        throws SQLException {
        if (rsdSid <= 0) {
            return;
        }

        insertRsvDataSize(Arrays.asList(rsdSid), entryType);
    }


    /**
     * <br>[機  能] 施設情報の使用データサイズを登録する
     * <br>[解  説]
     * <br>[備  考]
     * @param rsdSid 施設SID
     * @param rsdTourokuMdl
     * @throws SQLException SQL実行例外
     * @throws UnsupportedEncodingException エンコード実行例外
     */
    public void insertRsvDataSize(int rsdSid, RsvSisDataModel rsdTourokuMdl)
        throws SQLException, UnsupportedEncodingException {
        if (rsdSid <= 0) {
            return;
        }
        List<Integer> rsdSidList = Arrays.asList(rsdSid);
        long rsvDataSize = 0;
        //施設情報のサイズを取得
        rsvDataSize = DataSizeUtil.getUseDBsize(rsdTourokuMdl.getRsdName(),
                                                rsdTourokuMdl.getRsdSnum(),
                                                rsdTourokuMdl.getRsdProp1(),
                                                rsdTourokuMdl.getRsdProp2(),
                                                rsdTourokuMdl.getRsdProp3(),
                                                rsdTourokuMdl.getRsdProp4(),
                                                rsdTourokuMdl.getRsdProp5(),
                                                rsdTourokuMdl.getRsdProp6(),
                                                rsdTourokuMdl.getRsdProp7(),
                                                rsdTourokuMdl.getRsdProp8(),
                                                rsdTourokuMdl.getRsdProp9(),
                                                rsdTourokuMdl.getRsdProp10(),
                                                rsdTourokuMdl.getRsdImgCmt1(),
                                                rsdTourokuMdl.getRsdImgCmt2(),
                                                rsdTourokuMdl.getRsdImgCmt3(),
                                                rsdTourokuMdl.getRsdImgCmt4(),
                                                rsdTourokuMdl.getRsdImgCmt5(),
                                                rsdTourokuMdl.getRsdImgCmt6(),
                                                rsdTourokuMdl.getRsdImgCmt7(),
                                                rsdTourokuMdl.getRsdImgCmt8(),
                                                rsdTourokuMdl.getRsdImgCmt9(),
                                                rsdTourokuMdl.getRsdImgCmt10(),
                                                rsdTourokuMdl.getRsdBiko(),
                                                rsdTourokuMdl.getRsdPlaCmt());

        //施設情報の添付ファイルサイズを取得
        RsvBinDao rsvBinDao = new RsvBinDao(con__);
        rsvDataSize += rsvBinDao.getTotalFileSize(rsdSidList);

        //使用データサイズを登録
        RsvDatausedSumModel dataUsedMdl = new RsvDatausedSumModel();
        dataUsedMdl.setSumType(GSConst.USEDDATA_SUMTYPE_DIFF);
        dataUsedMdl.setRsvSyrkSumSize(0);
        dataUsedMdl.setRsvDataSumSize(rsvDataSize);
        RsvDatausedSumDao dataUsedDao = new RsvDatausedSumDao(con__);
        dataUsedDao.insert(dataUsedMdl);
    }

    /**
     * <br>[機  能] 施設情報の使用データサイズを登録する
     * <br>[解  説]
     * <br>[備  考]
     * @param rsdSidList 施設SID
     * @param entryType 登録種別 true: 加算、false: 減算
     * @throws SQLException SQL実行例外
     */
    public void insertRsvDataSize(List<Integer> rsdSidList, boolean entryType)
        throws SQLException {

        if (rsdSidList == null || rsdSidList.isEmpty()) {
            return;
        }

        //施設情報のサイズを取得
        RsvSisDataDao rsvSisDataDao = new RsvSisDataDao(con__);
        long rsvDataSize = rsvSisDataDao.getDataSize(rsdSidList);

        //施設情報の添付ファイルサイズを取得
        RsvBinDao rsvBinDao = new RsvBinDao(con__);
        rsvDataSize += rsvBinDao.getTotalFileSize(rsdSidList);

        //減算の場合はデータサイズを負数に反転する
        if (!entryType) {
            rsvDataSize *= -1;
        }

        //使用データサイズを登録
        RsvDatausedSumModel dataUsedMdl = new RsvDatausedSumModel();
        dataUsedMdl.setSumType(GSConst.USEDDATA_SUMTYPE_DIFF);
        dataUsedMdl.setRsvSyrkSumSize(0);
        dataUsedMdl.setRsvDataSumSize(rsvDataSize);
        RsvDatausedSumDao dataUsedDao = new RsvDatausedSumDao(con__);
        dataUsedDao.insert(dataUsedMdl);
    }

        /**
     * <br>[機  能] 施設情報の使用データサイズを登録する
     * <br>[解  説]
     * <br>[備  考]
     * @param rsdSidList 施設SID
     * @param dataSize データ使用量
     * @throws SQLException SQL実行例外
     */
    public void insertRsvDataSize(List<Integer> rsdSidList, long dataSize)
        throws SQLException {

        if (rsdSidList == null || rsdSidList.isEmpty()) {
            return;
        }

        long rsvDataSize = dataSize;

        //施設情報の添付ファイルサイズを取得
        RsvBinDao rsvBinDao = new RsvBinDao(con__);
        rsvDataSize += rsvBinDao.getTotalFileSize(rsdSidList);

        //使用データサイズを登録
        RsvDatausedSumModel dataUsedMdl = new RsvDatausedSumModel();
        dataUsedMdl.setSumType(GSConst.USEDDATA_SUMTYPE_DIFF);
        dataUsedMdl.setRsvSyrkSumSize(0);
        dataUsedMdl.setRsvDataSumSize(rsvDataSize);
        RsvDatausedSumDao dataUsedDao = new RsvDatausedSumDao(con__);
        dataUsedDao.insert(dataUsedMdl);
    }
}
