package jp.groupsession.v2.rng;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.stream.Collectors;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;

import jp.co.sjts.util.ValidateUtil;
import jp.co.sjts.util.date.UDate;
import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.cmn.GSConstCommon;
import jp.groupsession.v2.cmn.GSContext;
import jp.groupsession.v2.cmn.GroupSession;
import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.biz.UserBiz;
import jp.groupsession.v2.cmn.config.PluginConfig;
import jp.groupsession.v2.cmn.dao.MlCountMtController;
import jp.groupsession.v2.cmn.dao.base.CmnGroupmDao;
import jp.groupsession.v2.cmn.dao.base.CmnPluginAdminDao;
import jp.groupsession.v2.cmn.dao.base.CmnUsrmInfDao;
import jp.groupsession.v2.cmn.formbuilder.EnumFormModelKbn;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.cmn.model.base.CmnGroupmModel;
import jp.groupsession.v2.cmn.model.base.CmnUsrmInfModel;
import jp.groupsession.v2.man.GSConstMain;
import jp.groupsession.v2.rng.biz.RngDoNextBiz;
import jp.groupsession.v2.rng.biz.RngTemplateBiz;
import jp.groupsession.v2.rng.dao.RingiDao;
import jp.groupsession.v2.rng.dao.RngActionparamDao;
import jp.groupsession.v2.rng.dao.RngKeiroStepDao;
import jp.groupsession.v2.rng.dao.RngSingiDao;
import jp.groupsession.v2.rng.dao.RngTemplateActionDao;
import jp.groupsession.v2.rng.dao.RngTemplateDao;
import jp.groupsession.v2.rng.dao.RngTemplatecategoryAdmDao;
import jp.groupsession.v2.rng.model.RingiDataModel;
import jp.groupsession.v2.rng.model.RngActionparamModel;
import jp.groupsession.v2.rng.model.RngKeiroStepModel;
import jp.groupsession.v2.rng.model.RngSingiModel;
import jp.groupsession.v2.rng.model.RngTemplateActionModel;
import jp.groupsession.v2.rng.model.RngTemplateModel;
import jp.groupsession.v2.rng.model.RngTemplatecategoryAdmModel;
import jp.groupsession.v2.sml.GSConstSmail;
import jp.groupsession.v2.sml.SmlSender;
import jp.groupsession.v2.sml.model.SmlSenderModel;
import jp.groupsession.v2.struts.msg.GsMessage;
import jp.groupsession.v2.usr.GSConstUser;
import jp.groupsession.v2.usr.IUserGroupListener;

/**
 * <br>[機  能] ユーザ・グループに変更があった場合に実行されるリスナーを実装
 * <br>[解  説] 稟議についての処理を行う
 * <br>[備  考]
 *
 * @author JTS
 */
public class RngIUserGroupListenerImpl implements IUserGroupListener {

    /**
     * <br>[機  能] ユーザ追加時に実行される
     * <br>[解  説]
     * <br>[備  考]
     * @param usid 追加されるユーザSID
     * @param con DBコネクション
     * @param cntCon MlCountMtController
     * @param eusid 更新者ユーザSID
     * @param reqMdl リクエスト情報
     * @throws SQLException SQL実行例外
     */
    public void addUser(MlCountMtController cntCon,
                        Connection con, int usid, int eusid, RequestModel reqMdl)
        throws SQLException {

    }

    /**
     * <br>[機  能] ユーザ削除時に実行される
     * <br>[解  説]
     * <br>[備  考]
     * @param usid ユーザSID
     * @param con DBコネクション
     * @param eusid 更新者ユーザSID
     * @param reqMdl リクエスト情報
     * @throws SQLException SQL実行例外
     */
    public void deleteUser(Connection con, int usid, int eusid, RequestModel reqMdl)
        throws SQLException {

        try {
            //承認者の処理
            RingiDao dao = new RingiDao(con);
            List<RingiDataModel> proRngSidList = dao.getProgressRingiSidList(usid);
            int rngSid = 0;
            UDate now = new UDate();
            RngKeiroStepDao kDao = new RngKeiroStepDao(con);
            RngSingiDao sDao = new RngSingiDao(con);
            MlCountMtController cntCon =
                    GroupSession.getResourceManager().getCountController(reqMdl);
            PluginConfig pconfig = GroupSession.getResourceManager().getPluginConfig(reqMdl);
            CommonBiz cmnBiz = new CommonBiz();
            boolean smailPluginUseFlg = cmnBiz.isCanUsePlugin(GSConstMain.PLUGIN_ID_SMAIL, pconfig);
            String rootPath = "";
            GSContext gscontext = GroupSession.getContext();
            Object pathObj = gscontext.get(GSContext.APP_ROOT_PATH);
            if (pathObj != null) {
                rootPath = (String) pathObj;
            }

            for (int i = 0; i < proRngSidList.size(); i++) {
                rngSid = proRngSidList.get(i).getRngSid();
                RngDoNextBiz nextBiz = new RngDoNextBiz(con, reqMdl, sDao, kDao, rngSid);
                int rksSid = sDao.getRksSid(rngSid, usid, RngConst.RNG_RNCSTATUS_CONFIRM);

                int sinkouFlg = kDao.getNoUser(rksSid);
                if (sinkouFlg == 0 && proRngSidList.get(i).getRngCompflg() == 0) {
                    //稟議審議情報の更新
                    RngSingiModel singiMdl = new RngSingiModel();
                    singiMdl.setRngSid(rngSid);
                    singiMdl.setUsrSid(usid);
                    singiMdl.setRksSid(rksSid);
                    singiMdl.setRssStatus(RngConst.RNG_RNCSTATUS_APPR);
                    singiMdl.setRssEuid(usid);
                    singiMdl.setRssEdate(now);
                    sDao.updateSingi(singiMdl);
                    nextBiz.doNext(cntCon, rksSid, rootPath, pconfig,
                            smailPluginUseFlg, usid, 1, true);
                }
            }

            //最終確認者
            List<RingiDataModel> rngSidList = dao.getConfirmRingiSidList(usid);
            for (int i = 0; i < rngSidList.size(); i++) {
                rngSid = rngSidList.get(i).getRngSid();
                //稟議審議情報の更新
                RngSingiDao singiDao = new RngSingiDao(con);
                RngSingiModel singiMdl = new RngSingiModel();
                singiMdl.setRssEdate(now);
                singiMdl.setUsrSid(usid);
                singiMdl.setRngSid(rngSid);
                singiMdl.setRssStatus(RngConst.RNG_RNCSTATUS_CONFIRMATION);
                singiDao.updateConfirm(singiMdl);

                RngKeiroStepDao keiroDao = new RngKeiroStepDao(con);
                RngKeiroStepModel keiroMdl = new RngKeiroStepModel();
                keiroMdl.setRksEdate(now);
                List<Integer> rksList = singiDao.checkConfirm(rngSid, usid);
                if (rksList.size() > 0) {
                    keiroMdl.setRksChkdate(now);
                    keiroMdl.setRksStatus(RngConst.RNG_RNCSTATUS_CONFIRMATION);
                    keiroDao.updateConfirm(keiroMdl, rksList);
                }
            }

            //連携APIの条件，パラメータにて削除対象のユーザを使用している場合、エラーフラグを立てる
            RngActionparamDao rapDao = new RngActionparamDao(con);
            List<RngActionparamModel> rapMdlList = rapDao.select();
            if (rapMdlList == null || rapMdlList.isEmpty()) {
                return;
            }
            CmnUsrmInfDao usiDao = new CmnUsrmInfDao(con);
            CmnUsrmInfModel usiMdl = usiDao.select(usid);

            List<RngActionparamModel> updateList = new ArrayList<>();
            for (RngActionparamModel rapMdl : rapMdlList) {
                boolean isDeleteUser = __isDeleteUser(rapMdl, usiMdl);
                if (isDeleteUser) {
                    updateList.add(rapMdl);
                }
            }

            if (updateList.isEmpty()) {
                return;
            }

            for (RngActionparamModel mdl : updateList) {
                rapDao.update(mdl);
            }

            GsMessage gsMsg = new GsMessage(reqMdl);
            __sendSmailForTemplate(updateList, gsMsg.getMessage("cmn.user"), con, reqMdl);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * <br>[機  能] 条件JSONにて削除対象のユーザを使用しているかを確認する
     * <br>[解  説]
     * <br>[備  考] 削除対象のユーザが存在する場合、条件JSONにエラー情報を追加する
     * @param rapMdl アクションパラメータ情報
     * @param usrMdl ユーザ情報
     * @return true：条件JSONに削除対象のユーザを使用している, false:使用していない
     */
    private boolean __isDeleteUser(RngActionparamModel rapMdl, CmnUsrmInfModel usrMdl) {

        int usrSid = usrMdl.getUsrSid();
        String usrName = usrMdl.getUsiName();
        ObjectMapper mapper = new ObjectMapper();
        String conditionJson = rapMdl.getRapConditionJson();
        JsonNode node;
        try {
            node = mapper.readTree(conditionJson);
        } catch (JsonProcessingException e) {
            //条件JSONが不正な場合はエラー情報を追加できない
            return false;
        }

        JsonNode conditionListNode = node.get("conditionList");
        if (conditionListNode == null || conditionListNode.isEmpty()) {
            return false;
        }

        boolean ret = false;
        for (JsonNode conditionNode : conditionListNode) {
            int compareTarget = -1;
            if (conditionNode.get("compareTarget") != null
                && ValidateUtil.isNumber(conditionNode.get("compareTarget").asText())) {
                compareTarget = Integer.parseInt(conditionNode.get("compareTarget").asText());
            }
            if (compareTarget != usrSid) {
                //比較対象が削除するユーザではない場合、何もしない
                continue;
            }

            int paramKbn = -1;
            if (conditionNode.get("paramKbn") != null) {
                paramKbn = conditionNode.get("paramKbn").asInt();
            }

            int paramFormType = -1;
            if (conditionNode.get("paramFormType") != null) {
                paramFormType = conditionNode.get("paramFormType").asInt();
            }

            int paramValue = -1;
            if (conditionNode.get("paramValue") != null) {
                paramValue = conditionNode.get("paramValue").asInt();
            }

            if (__isUserSelect(paramKbn, paramFormType, paramValue)) {
                ObjectNode replaceNode = (ObjectNode) conditionNode;
                replaceNode.put("errorTargetName", usrName);
                replaceNode.put("errorFlg", true);
                ret = true;
            }
        }
        rapMdl.setRapConditionJson(node.toString());
        return ret;
    }

    /**
     * <br>[機  能] 設定値区分，フォームタイプ，設定値詳細から、「ユーザ選択」かを確認する
     * <br>[解  説]
     * <br>[備  考]
     * @param paramKbn 設定値区分
     * @param formType フォームタイプ
     * @param paramValue 設定値詳細
     * @return true：ユーザ選択である, false：ユーザ選択ではない
     */
    private boolean __isUserSelect(int paramKbn, int formType, int paramValue) {

        //フォーム要素でユーザが指定されている
        if (paramKbn == RngConst.API_PARAMKBN_FORM
            && formType == EnumFormModelKbn.user.getValue()
            && paramValue != RngConst.API_COMPARE_PARAM_POSITION) {
            return true;
        }

        //申請者でユーザが指定されている
        if (paramKbn == RngConst.API_PARAMKBN_ADDUSER
            && paramValue != RngConst.API_COMPARE_PARAM_POSITION) {
            return true;
        }

        //承認者でユーザが指定されている
        if (paramKbn == RngConst.API_PARAMKBN_LETUSER
            && paramValue != RngConst.API_COMPARE_PARAM_POSITION) {
            return true;
        }

        return false;
    }

    /**
     * <br>[機  能] 条件JSONにて削除対象のグループを使用しているかを確認する
     * <br>[解  説]
     * <br>[備  考] 削除対象のグループが存在する場合、条件JSONにエラー情報を追加する
     * @param rapMdl アクションパラメータ情報
     * @param groupMdl グループ情報
     * @return true：条件JSONに削除対象のグループを使用している, false:使用していない
     */
    private boolean __isConditionGroup(RngActionparamModel rapMdl, CmnGroupmModel groupMdl) {

        int grpSid = groupMdl.getGrpSid();
        String grpName = groupMdl.getGrpName();
        ObjectMapper mapper = new ObjectMapper();
        String paramJson = rapMdl.getRapConditionJson();
        JsonNode node;
        try {
            node = mapper.readTree(paramJson);
        } catch (JsonProcessingException e) {
            //条件JSONが不正な場合はエラー情報を追加できない
            return false;
        }

        JsonNode conditionListNode = node.get("conditionList");
        if (conditionListNode == null || conditionListNode.isEmpty()) {
            return false;
        }
        boolean ret = false;

        for (JsonNode conditionNode : conditionListNode) {
            int compareTarget = -1;
            if (conditionNode.get("compareTarget") != null
                && ValidateUtil.isNumber(conditionNode.get("compareTarget").asText())) {
                compareTarget = Integer.parseInt(conditionNode.get("compareTarget").asText());
            }

            if (compareTarget != grpSid) {
                //比較対象が削除するグループではない場合、何もしない
                continue;
            }

            int paramKbn = -1;
            if (conditionNode.get("paramKbn") != null) {
                paramKbn = conditionNode.get("paramKbn").asInt();
            }

            int paramFormType = -1;
            if (conditionNode.get("paramFormType") != null) {
                paramFormType = conditionNode.get("paramFormType").asInt();
            }

            if (paramKbn == RngConst.API_PARAMKBN_FORM
                && paramFormType == EnumFormModelKbn.group.getValue()) {
                ObjectNode replaceNode = (ObjectNode) conditionNode;
                replaceNode.put("errorTargetName", grpName);
                replaceNode.put("errorFlg", true);
                ret = true;
            }
        }
        rapMdl.setRapConditionJson(node.toString());
        return ret;
    }

    /**
     * <br>[機  能] グループ追加時に実行される
     * <br>[解  説]
     * <br>[備  考]
     * @param gsid グループSID
     * @param con DBコネクション
     * @param eusid 更新者ユーザSID
     * @throws SQLException SQL実行例外
     */
    public void addGroup(Connection con, int gsid, int eusid) throws SQLException {
    }

    /**
     * <br>[機  能] グループ削除時に実行される
     * <br>[解  説]
     * <br>[備  考]
     * @param gsid グループSID
     * @param con DBコネクション
     * @param eusid 更新者ユーザSID
     * @param reqMdl RequestModel
     */
    public void deleteGroup(
            Connection con, int gsid, int eusid, RequestModel reqMdl) {

        try {
            //連携APIの条件，パラメータにて削除対象のユーザを使用している場合、エラーフラグを立てる
            RngActionparamDao rapDao = new RngActionparamDao(con);
            List<RngActionparamModel> rapMdlList = rapDao.select();
            if (rapMdlList == null || rapMdlList.isEmpty()) {
                return;
            }
            CmnGroupmDao groupDao = new CmnGroupmDao(con);
            CmnGroupmModel groupMdl = groupDao.selectGroup(gsid);

            List<RngActionparamModel> updateList = new ArrayList<>();
            for (RngActionparamModel rapMdl : rapMdlList) {
                boolean isDeleteGroup = __isConditionGroup(rapMdl, groupMdl);
                if (isDeleteGroup) {
                    updateList.add(rapMdl);
                }
            }

            if (updateList.isEmpty()) {
                return;
            }

            for (RngActionparamModel rapMdl : rapMdlList) {
                rapDao.update(rapMdl);
            }

            GsMessage gsMsg = new GsMessage(reqMdl);
            __sendSmailForTemplate(updateList, gsMsg.getMessage("cmn.group"), con, reqMdl);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * <br>[機  能] ユーザの所属グループが変更になった場合に実行される
     * <br>[解  説]
     * <br>[備  考]
     * @param con DBコネクション
     * @param usid ユーザSID
     * @param pastGsids 変更前のグループSID配列
     * @param gsids 変更後のグループSID配列
     * @param eusid 更新者ユーザSID
     * @throws SQLException SQL実行例外
     */
    public void changeBelong(Connection con, int usid, int[] pastGsids, int[] gsids, int eusid)
        throws SQLException {
    }

    /**
     * <br>[機  能] ユーザのデフォルトグループが変更になった場合に実行される
     * <br>[解  説]
     * <br>[備  考]
     * @param usid ユーザSID
     * @param gsid 変更後のデフォルトグループ
     * @param con DBコネクション
     * @param eusid 更新者ユーザSID
     * @throws SQLException SQL実行例外
     */
    public void changeDefaultBelong(Connection con, int usid, int gsid, int eusid)
        throws SQLException {
    }

    /**
     * <br>[機  能] 決裁後アクションの更新が必要な旨をショートメールで管理者に送信する
     * <br>[解  説]
     * <br>[備  考]
     * @param updateList 更新対象のアクションパラメータ一覧
     * @param delTargetName 削除対象名("ユーザ" 又は "グループ")
     * @param con コネクション
     * @param reqMdl リクエスト情報
     * @throws Exception
     */
    private void __sendSmailForTemplate(
        List<RngActionparamModel> updateList,
        String delTargetName,
        Connection con, RequestModel reqMdl) throws Exception {

        RngTemplateActionDao rtaDao = new RngTemplateActionDao(con);
        List<Integer> rtpaSidList = updateList.stream()
            .map(RngActionparamModel::getRtpaSid)
            .distinct()
            .collect(Collectors.toList());
        List<RngTemplateActionModel> rtaMdlList = rtaDao.select(rtpaSidList);
        rtaMdlList = new ArrayList<>(rtaMdlList.stream()
            .collect(Collectors.toMap(
                mdl -> mdl.getRtpSid(),
                mdl -> mdl,
                (mdl1, mdl2) -> {
                    if (mdl1.getRtpVer() < mdl2.getRtpVer()) {
                        return mdl2;
                    }
                    return mdl1;
                })
            ).values());

        RngTemplateDao templateDao = new RngTemplateDao(con);
        RngTemplatecategoryAdmDao rtcaDao = new RngTemplatecategoryAdmDao(con);
        ArrayList<RngTemplateModel> templateModelList = new ArrayList<>();
        List<Integer> categorySidList = new ArrayList<>();

        for (RngTemplateActionModel rtaMdl : rtaMdlList) {
            RngTemplateModel templateMdl
                = templateDao.select(rtaMdl.getRtpSid(), rtaMdl.getRtpVer());
            templateModelList.add(templateMdl);
            ArrayList<RngTemplatecategoryAdmModel> rtaList
                = rtcaDao.select(templateMdl.getRtcSid());
            categorySidList.addAll(rtaList.stream()
                .map(RngTemplatecategoryAdmModel::getRtcSid)
                .collect(Collectors.toList()));
        }

        UserBiz userBiz = new UserBiz();
        List<CmnUsrmInfModel> userList
                = userBiz.getBelongUserList(con, GSConstUser.SID_ADMIN, new ArrayList<>());
        List<Integer> sysAdminUserList = userList.stream()
            .map(CmnUsrmInfModel::getUsrSid)
            .collect(Collectors.toList());
        CmnPluginAdminDao cpaDao = new CmnPluginAdminDao(con);
        List<Integer> pluginAdminUserList
            = cpaDao.getPluginAdminUsrSid(RngConst.PLUGIN_ID_RINGI);

        List<Integer> adminUserList = new ArrayList<>();
        adminUserList.addAll(sysAdminUserList);
        adminUserList.addAll(pluginAdminUserList);
        adminUserList = adminUserList.stream()
            .distinct()
            .collect(Collectors.toList());
        adminUserList.removeIf(sid -> sid == GSConst.SYSTEM_USER_ADMIN);
        adminUserList.removeIf(sid -> sid == GSConst.SYSTEM_USER_MAIL);

        MlCountMtController cntCon =
                GroupSession.getResourceManager().getCountController(reqMdl);

        //システム管理者, プラグイン管理者ユーザにショートメールを送信
        __sendSmailAdmin(
            adminUserList, templateModelList, delTargetName, con, cntCon, reqMdl);

        //カテゴリ管理者にショートメールを送信
        __sendSmailCategory(
            adminUserList, templateModelList,
            categorySidList, delTargetName, con, cntCon, reqMdl);
    }

    /**
     * <br>[機  能] システム管理者，稟議のプラグイン管理者に決裁後アクションの修正が必要な旨のメールを送信する
     * <br>[解  説]
     * <br>[備  考]
     * @param adminUserList システム管理者，稟議のプラグイン管理者のユーザSID一覧
     * @param templateModelList テンプレート情報一覧
     * @param delTargetName 削除対象名("ユーザ" 又は "グループ")
     * @param con DBコネクション
     * @param cntCon 採番コントローラ
     * @param reqMdl リクエスト情報
     * @throws Exception
     */
    private void __sendSmailAdmin(
        List<Integer> adminUserList,
        List<RngTemplateModel> templateModelList,
        String delTargetName, Connection con,
        MlCountMtController cntCon, RequestModel reqMdl) throws Exception {

        if (adminUserList.isEmpty()) {
            return;
        }

        GsMessage gsMsg = new GsMessage(reqMdl);

        //ショートメール送信用モデルを作成する。
        SmlSenderModel smlModel = new SmlSenderModel();
        //送信者(システムメールを指定)
        smlModel.setSendUsid(GSConst.SYSTEM_USER_MAIL);
        //TO
        smlModel.setSendToUsrSidArray(adminUserList);
        String msg = gsMsg.getMessage("rng.71");
        String msg2 = gsMsg.getMessage("rng.129");

        //タイトル
        String title = msg + " " + msg2;
        smlModel.setSendTitle(title);

        //本文
        RngTemplateBiz templateBiz = new RngTemplateBiz();
        String bodyText = templateBiz.getTemplateSmailTuutiBody(reqMdl, templateModelList, true);
        if (bodyText.length() > GSConstCommon.MAX_LENGTH_SMLBODY) {
            String textMessage = gsMsg.getMessage("cmn.mail.omit");
            bodyText = textMessage + "\r\n\r\n" + bodyText;
            bodyText = bodyText.substring(0, GSConstCommon.MAX_LENGTH_SMLBODY);
        }
        smlModel.setSendBody(bodyText);
        //メール形式
        smlModel.setSendType(GSConstSmail.SAC_SEND_MAILTYPE_NORMAL);
        //マーク
        smlModel.setSendMark(GSConstSmail.MARK_KBN_NONE);

        //メール送信処理開始
        CommonBiz cmnBiz = new CommonBiz();
        PluginConfig pluginConfig = cmnBiz.getPluginConfigForMain(con, reqMdl);
        String appRootPath = (String) GroupSession.getContext().get(GSContext.APP_ROOT_PATH);
        SmlSender sender =
            new SmlSender(
                    con,
                    cntCon,
                    smlModel, pluginConfig,
                    appRootPath,
                    reqMdl);
        sender.execute();
    }

    /**
     * <br>[機  能] カテゴリ管理者に決裁後アクションの修正が必要な旨のメールを送信する
     * <br>[解  説]
     * <br>[備  考]
     * @param adminUserList システム管理者，稟議のプラグイン管理者のユーザSID一覧
     * @param templateModelList テンプレート情報一覧
     * @param categorySidList カテゴリSID一覧
     * @param delTargetName 削除対象名("ユーザ" 又は "グループ")
     * @param con DBコネクション
     * @param cntCon 採番コントローラ
     * @param reqMdl リクエスト情報
     * @throws Exception
     */
    private void __sendSmailCategory(
        List<Integer> adminUserList,
        List<RngTemplateModel> templateModelList,
        List<Integer> categorySidList, String delTargetName,
        Connection con, MlCountMtController cntCon, RequestModel reqMdl) throws Exception {

        if (categorySidList.isEmpty()) {
            return;
        }

        RngTemplateBiz templateBiz = new RngTemplateBiz();
        //ユーザ指定部分を取得 (キー：ユーザSID，値：カテゴリSID一覧)
        Map<Integer, Set<Integer>> userCategoryMap
            = templateBiz.getUserCategoryMap(con, categorySidList, adminUserList);

        if (userCategoryMap.isEmpty()) {
            return;
        }

        Map<Integer, List<RngTemplateModel>> categoryTemplateNameMap = templateModelList.stream()
            .collect(Collectors.groupingBy(
                RngTemplateModel::getRtcSid,
                Collectors.mapping(mdl -> mdl, Collectors.toList())
            ));

        //ショートメール送信用モデルを作成する。
        SmlSenderModel smlModel = new SmlSenderModel();
        //送信者(システムメールを指定)
        smlModel.setSendUsid(GSConst.SYSTEM_USER_MAIL);

        //タイトル
        GsMessage gsMsg = new GsMessage(reqMdl);
        String msg = gsMsg.getMessage("rng.71");
        String msg2 = gsMsg.getMessage("rng.129");
        String title = msg + " " + msg2;
        smlModel.setSendTitle(title);

        //メール形式
        smlModel.setSendType(GSConstSmail.SAC_SEND_MAILTYPE_NORMAL);
        //マーク
        smlModel.setSendMark(GSConstSmail.MARK_KBN_NONE);

        CommonBiz cmnBiz = new CommonBiz();
        PluginConfig pluginConfig = cmnBiz.getPluginConfigForMain(con, reqMdl);
        String appRootPath = (String) GroupSession.getContext().get(GSContext.APP_ROOT_PATH);

        List<Integer> doneUser = new ArrayList<>();
        for (Entry<Integer, Set<Integer>> entry : userCategoryMap.entrySet()) {
            Set<Integer> sendTarget = new HashSet<>();
            int usrSid = entry.getKey();
            if (doneUser.contains(usrSid)) {
                continue;
            }
            sendTarget.add(usrSid);

            //送信先のユーザと全く同じカテゴリの管理者の場合は一緒にメールを送信する
            userCategoryMap.entrySet().stream()
                .filter(e -> e.getValue().equals(entry.getValue()))
                .map(e -> e.getKey())
                .forEach(e -> {
                    sendTarget.add(e);
                });

            //本文
            List<RngTemplateModel> targetTemplateList = new ArrayList<>();
            for (int categorySid : entry.getValue()) {
                targetTemplateList.addAll(categoryTemplateNameMap.get(categorySid));
            }
            String bodyText
                = templateBiz.getTemplateSmailTuutiBody(reqMdl, targetTemplateList, false);
            if (bodyText.length() > GSConstCommon.MAX_LENGTH_SMLBODY) {
                String textMessage = gsMsg.getMessage("cmn.mail.omit");
                bodyText = textMessage + "\r\n\r\n" + bodyText;
                bodyText = bodyText.substring(0, GSConstCommon.MAX_LENGTH_SMLBODY);
            }
            smlModel.setSendBody(bodyText);
            //TO
            smlModel.setSendToUsrSidArray(new ArrayList<Integer>(sendTarget));

            SmlSender sender =
                new SmlSender(
                    con,
                    cntCon,
                    smlModel, pluginConfig,
                    appRootPath,
                    reqMdl);
            sender.execute();

            doneUser.addAll(sendTarget);
        }
    }
}
