package jp.groupsession.v2.rng.apiconnect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;

import jp.groupsession.v2.cmn.GSConst;

/**
 * <br>[機  能] 稟議承認時の連携APIを実行するスレッド
 * <br>[解  説]
 * <br>[備  考] ドメインごとに1つスレッドが用意されます
 *
 * @author JTS
 */
public class RngApiDomainThread extends Thread {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(RngApiDomainThread.class);
    /** ドメイン */
    private String domain__ = null;

    /** 実行中の実行用スレッドの個数を、ドメインごとに保持するマップ */
    private static Map<String, Integer> domainThreadCount__ = new HashMap<>();
    /** 実行済みのAPIの数を、ドメインごとに保持するマップ */
    private static Map<String, Integer> domainEndCount__ = new HashMap<>();

    /**
     * @return the domainEndCount__
     */
    public static Map<String, Integer> getDomainEndCount() {
        return domainEndCount__;
    }

    /**
     * @return the domainThreadCount__
     */
    public static Map<String, Integer> getDomainThreadCount() {
        return domainThreadCount__;
    }

    /**
     * <br>[機  能] デフォルトコンストラクタ
     * <br>[解  説]
     * <br>[備  考]
     * @param domain ドメイン
     */
    public RngApiDomainThread(String domain) {
        domain__ = domain;
    }

    /**
     * <br>[機  能] ドメインスレッド処理
     * <br>[解  説] 実行予約リストから稟議SIDを取得し、実行スレッドにて連携APIを実行する
     * <br>[備  考]
     */
    public void run() {
        log__.info("稟議決裁時のドメインスレッド処理開始 ドメイン:" + domain__);
        try {
            ThreadContext.put(GSConst.KEY_LOGTHREADSTRAGE_DOMAIN, domain__);

            //スレッド名の設定
            Thread.currentThread().setName("RingApiDomainThread"
                                            + "-" + System.currentTimeMillis()
                                            + "-" + domain__
                                            + "-" + Thread.currentThread().getId());

            __doExecuteThread(domain__);
        } catch (Exception e1) {
            log__.error(e1);
        } finally {
            boolean newDomainThreadFlg = false;
            synchronized (RngApiThreadBiz.getDomainThreadMap()) {
                RngApiThreadBiz.getDomainThreadMap().remove(domain__);
                if (RngApiThreadBiz.getDomainThreadMap().size() < 3) {
                    newDomainThreadFlg = true;
                }
            }
            try {
                //スレッド名に"END-"を設定する
                Thread.currentThread().setName(
                        "END-" + Thread.currentThread().getName());
            } catch (Throwable e) {
            }
            //実行待ちのドメインがあれば、実行
            synchronized (RngApiThreadBiz.getWaitApiDomainSet()) {
                Set<String> waitApiDomainSet = RngApiThreadBiz.getWaitApiDomainSet();
                if (newDomainThreadFlg && !waitApiDomainSet.isEmpty()) {
                    Iterator<String> domainSet = waitApiDomainSet.iterator();
                    while (domainSet.hasNext()) {
                        String domain = domainSet.next();
                        RngApiThreadBiz.getWaitApiDomainSet().remove(domain);
                        RngApiDomainThread thread = new RngApiDomainThread(domain);
                        RngApiThreadBiz.getDomainThreadMap().put(domain, thread);
                        thread.start();
                        break;
                    }
                }
            }
            log__.info("稟議決裁時のドメインスレッド処理終了 ドメイン:" + domain__);
        }
    }

    /**
     * <br>[機  能] 実行予約リストから稟議SIDを取り出し、実行スレッドを呼び出す
     * <br>[解  説] 実行スレッドは各ドメインごとに最大3つまで稼働する。実行スレッドが全て完了するまで待機する。
     * <br>[備  考]
     * @param domain ドメイン
     */
    private void __doExecuteThread(String domain) throws InterruptedException {

        List<Integer> rngSidList;
        synchronized (RngApiThreadBiz.getDomainApiMap()) {
            rngSidList =
                RngApiThreadBiz.getDomainApiMap().getOrDefault(domain__, new ArrayList<>());
            if (rngSidList == null || rngSidList.isEmpty()) {
                return;
            }
            //実行用に取得した稟議SIDはマップから除外する
            RngApiThreadBiz.getDomainApiMap().put(domain__, new ArrayList<>());
        }

        int maxThreadCount = 3;
        int rngSidSize = rngSidList.size();

        while (true) {
            synchronized (domainEndCount__) {
                if (domainEndCount__.getOrDefault(domain, 0) >= rngSidSize) {
                    break;
                }
            }
            if (domainThreadCount__.getOrDefault(domain, 0) >= maxThreadCount) {
                sleep(5000);
                log__.info("ドメイン:" + domain + "の稟議決裁時ドメインスレッドにて、最大スレッド数に達したため5秒スリープ");
                continue;
            }
            if (rngSidList.isEmpty()) {
                log__.info("ドメイン:" + domain + "の稟議決裁時ドメインスレッドにて、稟議SIDが空になったため5秒スリープ(実行スレッドの完了待ち)");
                sleep(5000);
                continue;
            }
            int rngSid = rngSidList.remove(0);
            synchronized (domainThreadCount__) {
                int threadCount = domainThreadCount__.getOrDefault(domain, 0);
                threadCount++;
                domainThreadCount__.put(domain, threadCount);
            }

            RngApiExecuteThread exeThread = new RngApiExecuteThread(domain, rngSid);
            exeThread.start();
        }
        //実行スレッドにて実行中に追加された稟議SIDを考慮し、もう一度実行処理を行う
        synchronized (domainEndCount__) {
            domainEndCount__.put(domain__, 0);
        }
        //実行スレッドの実行中に稟議が承認された場合を考慮し、再度残りの稟議を確認して実行
        __doExecuteThread(domain);
    }
}
