package jp.groupsession.v2.rng.apiconnect;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.AbstractMap.SimpleEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionMapping;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import jp.co.sjts.util.Encoding;
import jp.co.sjts.util.NullDefault;
import jp.co.sjts.util.StringUtil;
import jp.co.sjts.util.ValidateUtil;
import jp.co.sjts.util.date.UDate;
import jp.co.sjts.util.date.UDateUtil;
import jp.co.sjts.util.encryption.EncryptionException;
import jp.co.sjts.util.io.IOToolsException;
import jp.co.sjts.util.jdbc.DBConnectionException;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.cmn.GSConstCommon;
import jp.groupsession.v2.cmn.GSConstLog;
import jp.groupsession.v2.cmn.GSContext;
import jp.groupsession.v2.cmn.GroupSession;
import jp.groupsession.v2.cmn.ITempFileUtil;
import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.biz.apiconnect.ApiConnectBiz;
import jp.groupsession.v2.cmn.biz.apiconnect.ApiExecuter;
import jp.groupsession.v2.cmn.biz.apiconnect.EnumContentType;
import jp.groupsession.v2.cmn.dao.GroupDao;
import jp.groupsession.v2.cmn.dao.base.CmnApiConnectDao;
import jp.groupsession.v2.cmn.dao.base.CmnApiConnectHeaderDao;
import jp.groupsession.v2.cmn.dao.base.CmnApiConnectParamDao;
import jp.groupsession.v2.cmn.dao.base.CmnCmbsortConfDao;
import jp.groupsession.v2.cmn.dao.base.CmnUsrmDao;
import jp.groupsession.v2.cmn.dao.base.CmnUsrmInfDao;
import jp.groupsession.v2.cmn.exception.TempFileException;
import jp.groupsession.v2.cmn.http.HttpPart;
import jp.groupsession.v2.cmn.http.HttpResponseModel;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.cmn.model.base.CmnApiConnectHeaderModel;
import jp.groupsession.v2.cmn.model.base.CmnApiConnectModel;
import jp.groupsession.v2.cmn.model.base.CmnApiConnectParamModel;
import jp.groupsession.v2.cmn.model.base.CmnBinfModel;
import jp.groupsession.v2.cmn.model.base.CmnCmbsortConfModel;
import jp.groupsession.v2.cmn.model.base.CmnGroupmModel;
import jp.groupsession.v2.cmn.model.base.CmnUsrmInfModel;
import jp.groupsession.v2.cmn.model.base.CmnUsrmModel;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.biz.RngBiz;
import jp.groupsession.v2.rng.biz.RngTemplateActionFileBiz;
import jp.groupsession.v2.rng.dao.RngActionResultDao;
import jp.groupsession.v2.rng.dao.RngActionResultDataDao;
import jp.groupsession.v2.rng.dao.RngActionparamDao;
import jp.groupsession.v2.rng.dao.RngBinDao;
import jp.groupsession.v2.rng.dao.RngFormdataDao;
import jp.groupsession.v2.rng.dao.RngRndataDao;
import jp.groupsession.v2.rng.dao.RngTemplateActionDao;
import jp.groupsession.v2.rng.dao.RngTemplateDao;
import jp.groupsession.v2.rng.dao.RngTemplateFormDao;
import jp.groupsession.v2.rng.model.AddRngActionModel;
import jp.groupsession.v2.rng.model.AddRngActionParamModel;
import jp.groupsession.v2.rng.model.RngActionResultDataModel;
import jp.groupsession.v2.rng.model.RngActionResultModel;
import jp.groupsession.v2.rng.model.RngActionparamModel;
import jp.groupsession.v2.rng.model.RngBinModel;
import jp.groupsession.v2.rng.model.RngFormdataModel;
import jp.groupsession.v2.rng.model.RngRndataModel;
import jp.groupsession.v2.rng.model.RngTemplateActionModel;
import jp.groupsession.v2.rng.model.RngTemplateFormModel;
import jp.groupsession.v2.rng.model.RngTemplateModel;
import jp.groupsession.v2.struts.msg.GsMessage;
import jp.groupsession.v2.usr.GSPassword;

/**
 * <br>[機  能] 稟議承認時の連携API実行ビジネスロジッククラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class RngApiExecuteBiz {

    /** ログ */
    private static Log log__ = LogFactory.getLog(RngApiExecuteBiz.class);
    /** リクエスト情報 */
    private String domain__ = null;

    /** 稟議情報(申請日時, 承認日時を含む) */
    RngRndataModel rngMdl__ = null;

    /** -----申請者情報を保持するパラメータ----- */
    /** 申請者情報 */
    private CmnUsrmInfModel sinseiUsrInfMdl__ = null;
    /** 申請者情報 */
    private CmnUsrmModel sinseiUsrMdl__ = null;
    /** 申請者が所属するグループ情報 */
    CmnGroupmModel groupMdl__ = null;

    /** -----承認者情報を保持するパラメータ----- */
    /** 承認者情報 */
    private CmnUsrmInfModel syouninUsrInfMdl__ = null;
    /** 承認者情報 */
    private CmnUsrmModel syouninUsrMdl__ = null;
    /** 承認者が所属するグループ情報 */
    private CmnGroupmModel syouninGroupMdl__ = null;

    /** -----確認時添付----- */
    /** 確認時添付リスト */
    private List<CmnBinfModel> kakuninTempList__ = new ArrayList<>();

    /** -----フォームに入力された値を取得するのに必要なパラメータ----- */
    /** フォームに入力された添付ファイル情報 */
    private List<CmnBinfModel> formTempList__ = new ArrayList<>();
    /** フォームに入力された値 key:フォームID, value:表要素ごとにまとめたフォームの値 */
    private Map<String, Map<Integer, List<String>>> formValueMap__ = new HashMap<>();
    /** 各フォームのタイプを格納したマップ */
    Map<String, Integer> formTypeMap__ = new HashMap<>();
    /** ユーザ情報 */
    private List<UserValue> userValueList__ = new ArrayList<>();
    /** グループ情報 */
    private List<CmnGroupmModel> groupValueList__ = new ArrayList<>();
    /** チェックボックスの選択要素を表示順に保持するマップ キー：チェックボックスのフォームID, 値：チェックボックスの選択肢(表示順)*/
    Map<String, List<String>> checkboxSortMap__ = new HashMap<>();
    /** 繰り返し実行対象フォームマップ キー：繰り返し実行対象になっている表のフォームID, 値：表内にあるフォームのフォームID */
    private Map<String, Set<String>> repeatChildFormMap__ = new HashMap<>();

    /** テンプレート情報 */
    private RngTemplateModel templateModel__ = null;

    /** テスト実行画面から入力値を設定する際に使用するセッター */
    /**
     * @param rngMdl the rngMdl to set
     */
    public void setRngMdl(RngRndataModel rngMdl) {
        rngMdl__ = rngMdl;
    }
    /**
     * @param sinseiUsrInfMdl the sinseiUsrInfMdl to set
     */
    public void setSinseiUsrInfMdl(CmnUsrmInfModel sinseiUsrInfMdl) {
        sinseiUsrInfMdl__ = sinseiUsrInfMdl;
    }
    /**
     * @param sinseiUsrMdl the sinseiUsrMdl to set
     */
    public void setSinseiUsrMdl(CmnUsrmModel sinseiUsrMdl) {
        sinseiUsrMdl__ = sinseiUsrMdl;
    }
    /**
     * @param groupMdl the groupMdl to set
     */
    public void setGroupMdl(CmnGroupmModel groupMdl) {
        groupMdl__ = groupMdl;
    }
    /**
     * @param syouninUsrInfMdl the syouninUsrInfMdl to set
     */
    public void setSyouninUsrInfMdl(CmnUsrmInfModel syouninUsrInfMdl) {
        syouninUsrInfMdl__ = syouninUsrInfMdl;
    }
    /**
     * @param syouninUsrMdl the syouninUsrMdl to set
     */
    public void setSyouninUsrMdl(CmnUsrmModel syouninUsrMdl) {
        syouninUsrMdl__ = syouninUsrMdl;
    }
    /**
     * @param syouninGroupMdl the syouninGroupMdl to set
     */
    public void setSyouninGroupMdl(CmnGroupmModel syouninGroupMdl) {
        syouninGroupMdl__ = syouninGroupMdl;
    }
    /**
     * @param kakuninTempList the kakuninTempList to set
     */
    public void setKakuninTempList(List<CmnBinfModel> kakuninTempList) {
        kakuninTempList__ = kakuninTempList;
    }
    /**
     * @param formTempList the formTempList to set
     */
    public void setFormTempList(List<CmnBinfModel> formTempList) {
        formTempList__ = formTempList;
    }
    /**
     * @param formValueMap the formValueMap to set
     */
    public void setFormValueMap(
            Map<String, Map<Integer, List<String>>> formValueMap) {
        formValueMap__ = formValueMap;
    }
    /**
     * @param formTypeMap the formTypeMap to set
     */
    public void setFormTypeMap(Map<String, Integer> formTypeMap) {
        formTypeMap__ = formTypeMap;
    }
    /**
     * @param repeatChildFormMap the repeatChildFormMap to set
     */
    public void setRepeatChildFormMap(Map<String, Set<String>> repeatChildFormMap) {
        repeatChildFormMap__ = repeatChildFormMap;
    }
    /**
     * @param templateModel the templateModel to set
     */
    public void setTemplateModel(RngTemplateModel templateModel) {
        templateModel__ = templateModel;
    }

    /**
     * <br>[機  能] コンストラクタ
     * <br>[解  説]
     * <br>[備  考]
     * @param domain ドメイン
     */
    public RngApiExecuteBiz(String domain) {
        domain__ = domain;
    }

    /**
     * <br>[機  能] ユーザ情報系のパラメータで使用する内容を保持するクラス
     * <br>[解  説]
     * <br>[備  考]
     */
    class UserValue {
        /** ユーザ情報 */
        private CmnUsrmInfModel usrmInfMdl__ = null;
        /** ユーザ情報 */
        private CmnUsrmModel usrmMdl__ = null;
        /** ユーザ所属グループ情報 */
        private CmnGroupmModel belongGroupMdl__ = null;

        /**
         * @return the usrmInfMdl
         */
        public CmnUsrmInfModel getUsrmInfMdl() {
            return usrmInfMdl__;
        }
        /**
         * @param usrmInfMdl the usrmInfMdl to set
         */
        public void setUsrmInfMdl(CmnUsrmInfModel usrmInfMdl) {
            usrmInfMdl__ = usrmInfMdl;
        }
        /**
         * @return the usrmMdl
         */
        public CmnUsrmModel getUsrmMdl() {
            return usrmMdl__;
        }
        /**
         * @param usrmMdl the usrmMdl to set
         */
        public void setUsrmMdl(CmnUsrmModel usrmMdl) {
            usrmMdl__ = usrmMdl;
        }
        /**
         * @return the belongGroupMdl
         */
        public CmnGroupmModel getBelongGroupMdl() {
            return belongGroupMdl__;
        }
        /**
         * @param belongGroupMdl the belongGroupMdl to set
         */
        public void setBelongGroupMdl(CmnGroupmModel belongGroupMdl) {
            belongGroupMdl__ = belongGroupMdl;
        }
    }
    /**
     * <br>[機  能] 連携APIの順次実行で使用する情報を保持するクラス
     * <br>[解  説]
     * <br>[備  考]
     */
    class ExecuteTargetApiInfo {
        /** 稟議に紐づいている決裁後アクション情報一覧 */
        private List<RngTemplateActionModel> rtpaMdlList__;
        /** 稟議に紐づいているアクションパラメータ一覧 */
        private List<RngActionparamModel> actionParamList__;
        /** 各アクションパラメータで使用する連携API情報一覧 */
        private List<CmnApiConnectModel> cacList__;
        /** 各アクションパラメータで使用する連携APIパラメータ一覧 */
        private List<CmnApiConnectParamModel> cacParamList__;
        /** 各アクションパラメータで使用する連携API ヘッダ情報一覧 */
        private List<CmnApiConnectHeaderModel> headerList__;
        /** 実行条件を満たしたアクションパラメータを格納したマップ
          * 外側のキー：決裁後アクションSID, 内側のマップのキー: アクションパラメータSID, 内側のマップの値：実行条件を満たした行番号*/
        private Map<Integer, Map<Integer, List<Integer>>> matchConditionParamMap__;

        /**
         * @return the rtpaMdlList
         */
        public List<RngTemplateActionModel> getRtpaMdlList() {
            return rtpaMdlList__;
        }
        /**
         * @return the actionParamList
         */
        public List<RngActionparamModel> getActionParamList() {
            return actionParamList__;
        }
        /**
         * @return the cacList
         */
        public List<CmnApiConnectModel> getCacList() {
            return cacList__;
        }
        /**
         * @return the cacParamList
         */
        public List<CmnApiConnectParamModel> getCacParamList() {
            return cacParamList__;
        }
        /**
         * @return the headerList
         */
        public List<CmnApiConnectHeaderModel> getHeaderList() {
            return headerList__;
        }
        /**
         * @return the matchConditionParamMap
         */
        public Map<Integer, Map<Integer, List<Integer>>> getMatchConditionParamMap() {
            return matchConditionParamMap__;
        }

        /**
         * <br>[機  能] コンストラクタ
         * <br>[解  説]
         * <br>[備  考]
         * @param rtpaMdlList 稟議に紐づいている決裁後アクション情報一覧
         * @param actionParamList 稟議に紐づいているアクションパラメータ一覧
         * @param cacList 各アクションパラメータで使用する連携API情報一覧
         * @param cacParamList アクションパラメータ一覧
         * @param headerList 各アクションパラメータで使用する連携API ヘッダ情報一覧
         * @param matchConditionParamMap 実行条件を満たしたアクションパラメータを格納したマップ
         */
        public ExecuteTargetApiInfo(
            List<RngTemplateActionModel> rtpaMdlList,
            List<RngActionparamModel> actionParamList,
            List<CmnApiConnectModel> cacList,
            List<CmnApiConnectParamModel> cacParamList,
            List<CmnApiConnectHeaderModel> headerList,
            Map<Integer, Map<Integer, List<Integer>>> matchConditionParamMap) {

            rtpaMdlList__ = rtpaMdlList;
            actionParamList__ = actionParamList;
            cacList__ = cacList;
            cacParamList__ = cacParamList;
            headerList__ = headerList;
            matchConditionParamMap__ = matchConditionParamMap;
        }
    }
    /**
     * <br>[機  能] 稟議情報Modelを作成する
     * <br>[解  説]
     * <br>[備  考]
     * @param rngSid 稟議SID
     * @throws Exception
     */
    public void doApi(int rngSid) throws Exception {

        ExecuteTargetApiInfo targetInfo = __getExecuteTargetFromSid(rngSid);
        if (targetInfo == null) {
            //実行するアクションパラメータが存在しないため、処理を終了
            return;
        }

        List<RngTemplateActionModel> rtpaMdlList = targetInfo.getRtpaMdlList();
        Map<Integer, Map<Integer, List<Integer>>> matchConditionParamMap
            = targetInfo.getMatchConditionParamMap();
        Map<Integer, RngActionparamModel> actionParamMap =  targetInfo.getActionParamList().stream()
            .collect(
                Collectors.toMap(
                    mdl -> mdl.getRapSid(),
                    mdl -> mdl,
                    (mdl1, mdl2) -> mdl2
                )
            );

        Map<Integer, CmnApiConnectModel> cacMap = targetInfo.getCacList().stream()
            .collect(
                Collectors.toMap(
                    mdl -> mdl.getCacSid(),
                    mdl -> mdl,
                    (mdl1, mdl2) -> mdl2)
            );
        Map<Integer, List<CmnApiConnectParamModel>> cacParamMap
            = targetInfo.getCacParamList().stream()
                .collect(
                    Collectors.groupingBy(
                        CmnApiConnectParamModel::getCacSid,
                        Collectors.mapping(mdl -> mdl, Collectors.toList())
                    )
                );
        Map<Integer, List<CmnApiConnectHeaderModel>> headerMap = targetInfo.getHeaderList().stream()
            .collect(
                Collectors.groupingBy(
                    CmnApiConnectHeaderModel::getCacSid,
                    Collectors.mapping(mdl -> mdl, Collectors.toList())
                )
            );

        //連携APIの実行
        int resultSortNo = 1;
        for (RngTemplateActionModel rtpaMdl : rtpaMdlList) {
            if (matchConditionParamMap.getOrDefault(
                rtpaMdl.getRtpaSid(), new HashMap<>()).isEmpty()) {
                ApiResult apiResult = new ApiResult(true, new HashMap<>(), new ArrayList<>());
                __insertOperationLog(apiResult, rtpaMdl, 0, resultSortNo);
                resultSortNo++;
                continue;
            }
            int cacSid = rtpaMdl.getCacSid();

            for (Entry<Integer, List<Integer>> idxEntry
                : matchConditionParamMap.get(rtpaMdl.getRtpaSid()).entrySet()) {
                int actionParamSid = idxEntry.getKey();
                RngActionparamModel actionParam = actionParamMap.get(actionParamSid);
                //実行対象の行番号(繰り返し実行ではないときは、-1のみが入る)
                List<Integer> rowNoList = idxEntry.getValue();
                ApiResult apiResult =
                    __sendApi(rtpaMdl, actionParam,
                        rowNoList, cacMap.get(cacSid),
                        cacParamMap.get(cacSid), headerMap.get(cacSid));
                __insertOperationLog(apiResult, rtpaMdl, rowNoList.size(), resultSortNo);
                resultSortNo++;
            }
        }
    }

    /**
     * <br>[機  能] テンプレート情報から、チェックボックス要素の並び順と繰り返し実行対象の表にあるフォーム要素を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param node json情報
     * @param repeatFormIdSet 繰り返し実行対象のフォームID一覧
     * @author JTS
     */
    private void __setTemplateInfo(JsonNode node, Set<String> repeatFormIdSet) {
        __setCheckBoxSort(node);
        __setRepeatChild(node, repeatFormIdSet);

        if (node.isObject() || node.isArray()) {
            Iterator<JsonNode> elements = node.elements();
            while (elements.hasNext()) {
                JsonNode childNode = elements.next();
                __setTemplateInfo(childNode, repeatFormIdSet);
            }
        }
    }

    /**
     * <br>[機  能] テンプレート情報から、チェックボックス要素の並び順を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param node json情報
     * @author JTS
     */
    private void __setCheckBoxSort(JsonNode node) {
        if (node.get("type") == null) {
            return;
        }
        String type = node.get("type").asText();
        if (Objects.equals(type, "check")) {
            JsonNode body = node.get("body");
            JsonNode list = body.get("list");
            String formId = node.get("formID").asText();
            List<String> selectList = new ArrayList<>();
            for (JsonNode listChild : list) {
                selectList.add(listChild.asText());
            }
            checkboxSortMap__.put(formId, selectList);
        }
    }

    /**
     * <br>[機  能] テンプレート情報から、実行対象の表にあるフォーム要素を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param node json情報
     * @param repeatFormIdSet 繰り返し実行対象のフォームID一覧
     * @author JTS
     */
    private void __setRepeatChild(JsonNode node, Set<String> repeatFormIdSet) {
        if (node.get("formID") == null) {
            return;
        }
        String formId = node.get("formID").asText();
        if (!repeatFormIdSet.contains(formId)) {
            return;
        }
        JsonNode tableInfo = node.get("body");
        JsonNode tableBodyArray = tableInfo.get("body");
        Set<String> childSet =
            repeatChildFormMap__.getOrDefault(formId, new HashSet<>());
        for (JsonNode tableBodyItem : tableBodyArray) {
            JsonNode formTable = tableBodyItem.get("formTable");
            for (JsonNode formTableArray : formTable) {
                for (JsonNode childForm : formTableArray) {
                    childSet.add(childForm.get("formID").asText());
                }
            }
        }
        repeatChildFormMap__.put(formId, childSet);
    }

    /**
     * <br>[機  能] APIの実行に必要な情報を返す
     * <br>[解  説]
     * <br>[備  考] 実行部分で必要なフォーム入力値や、申請者情報などはprivate変数に保持する
     * @param rngSid 稟議SID
     * @return 実行対象のアクションパラメータ
     * @throws Exception
     */
    private ExecuteTargetApiInfo __getExecuteTargetFromSid(int rngSid) throws Exception {
        Connection con = null;
        try {
            con = GroupSession.getConnection(domain__, 1000);
            RngRndataDao rngDao = new RngRndataDao(con);
            RngRndataModel rngMdl = rngDao.select(rngSid);
            if (rngMdl == null) {
                return null;
            }
            rngMdl__ = rngMdl;
            RngTemplateDao templateDao = new RngTemplateDao(con);
            RngTemplateModel templateMdl =
                templateDao.select(rngMdl.getRtpSid(), rngMdl.getRtpVer());
            if (templateMdl == null || templateMdl.getRtpJkbn() == GSConst.JTKBN_DELETE) {
                return null;
            }
            templateModel__ = templateMdl;

            RngTemplateActionDao rtpaDao = new RngTemplateActionDao(con);
            List<RngTemplateActionModel> rtpaMdlList =
                rtpaDao.selectApi(rngMdl.getRtpSid(), rngMdl.getRtpVer());
            if (rtpaMdlList == null || rtpaMdlList.isEmpty()) {
                return null;
            }

            CmnUsrmInfDao cuiDao = new CmnUsrmInfDao(con);
            CmnUsrmDao cuDao = new CmnUsrmDao(con);
            GroupDao groupDao = new GroupDao(con);

            //申請者情報
            int applicateUsrSid = rngMdl.getRngApplicate();
            sinseiUsrInfMdl__ = cuiDao.select(applicateUsrSid);
            sinseiUsrMdl__ = cuDao.select(applicateUsrSid);
            groupMdl__ = groupDao.getDefaultGroup(applicateUsrSid);

            //承認者情報
            int syouninUsrSid = rngMdl.getRngEuid();
            syouninUsrInfMdl__ = cuiDao.select(syouninUsrSid);
            syouninUsrMdl__ = cuDao.select(syouninUsrSid);
            syouninGroupMdl__ = groupDao.getDefaultGroup(syouninUsrSid);

            //確認時添付ファイルSID
            RngBinDao rbDao = new RngBinDao(con);
            List<RngBinModel> rngBinMdlList = rbDao.getBinListFromRngSid(rngSid);
            String[] binSids = rngBinMdlList.stream()
                .map(mdl -> String.valueOf(mdl.getBinSid()))
                .toArray(String[]::new);
            CommonBiz cmnBiz = new CommonBiz();
            List<CmnBinfModel> allTempList =
                cmnBiz.getBinInfo(con, binSids, domain__);

            List<Long> kakuninTempSidList = rngBinMdlList.stream()
                .filter(mdl -> mdl.getUsrSid() != 0)
                .map(mdl -> mdl.getBinSid())
                .collect(Collectors.toList());
            kakuninTempList__.addAll(
                allTempList.stream()
                    .filter(mdl -> kakuninTempSidList.contains(mdl.getBinSid()))
                    .collect(Collectors.toList()
                )
            );
            kakuninTempList__ = kakuninTempList__.stream()
                .sorted(Comparator.comparing(mdl -> mdl.getBinFileName().toLowerCase()))
                .collect(Collectors.toList());

            List<Long> formTempSidList = rngBinMdlList.stream()
                .filter(mdl -> mdl.getUsrSid() == 0)
                .map(mdl -> mdl.getBinSid())
                .collect(Collectors.toList());
            formTempList__.addAll(
                allTempList.stream()
                    .filter(mdl -> formTempSidList.contains(mdl.getBinSid()))
                    .collect(Collectors.toList()
                )
            );
            formTempList__ = formTempList__.stream()
                .sorted(Comparator.comparing(mdl -> mdl.getBinFileName().toLowerCase()))
                .collect(Collectors.toList());

            RngActionparamDao paramDao = new RngActionparamDao(con);
            List<Integer> rtpaSidList = rtpaMdlList.stream()
                .map(mdl -> mdl.getRtpaSid())
                .collect(Collectors.toList());

            //テンプレートからフォームの種別(テキスト入力, ユーザ選択,・・・)を取得
            RngTemplateFormDao rtfDao = new RngTemplateFormDao(con);
            List<RngTemplateFormModel> rtfList =
                rtfDao.select(rngMdl__.getRtpSid(), rngMdl__.getRtpVer());
            formTypeMap__ = rtfList.stream()
                .collect(Collectors.toMap(
                    RngTemplateFormModel::getRtfId,
                    RngTemplateFormModel::getRtfType,
                    (mdl1, mdl2) -> mdl2
                    )
                );

            //フォーム入力値をマップに格納
            RngFormdataDao rfDao = new RngFormdataDao(con);
            List<RngFormdataModel> formList = rfDao.select(rngMdl__.getRngSid());

            //全てのアクションパラメータで使用するユーザ情報，グループ情報をループ処理の前に取得
            List<RngActionparamModel> allParamList = paramDao.select(rtpaSidList);

            //チェックボックスの並び順, 繰り返し対象の表の中にあるフォームIDの取得
            String templateForm = templateMdl.getRtpForm();
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(templateForm);
            Set<String> repeatFormIdSet = rtpaMdlList.stream()
                .filter(mdl -> mdl.getRtpaRepeatKbn() == 1
                    && mdl.getRtpaRepeatType() == 0
                    && formTypeMap__.getOrDefault(mdl.getRftId(), 0) != 15)
                .map(RngTemplateActionModel::getRftId)
                .collect(Collectors.toSet());
            __setTemplateInfo(node, repeatFormIdSet);


            RequestModel reqMdl = new RequestModel();
            reqMdl.setLocale(Locale.JAPANESE);
            RngTemplateActionFileBiz fileBiz = new RngTemplateActionFileBiz(reqMdl);
            LinkedList<AddRngActionModel> checkActionModelList
                = fileBiz.getAddRngActionMdlList(rngMdl__.getRtpSid(), rngMdl__.getRtpVer(), con);

            ExecuteTargetApiInfo ret = __getExecuteTarget(con, rtpaMdlList, allParamList,
                formList, formTypeMap__, repeatChildFormMap__, checkActionModelList);
            return ret;
        } catch (Exception e) {
            log__.warn("連携API情報の取得処理でエラーが発生したため、稟議SID:" + rngSid + "の稟議で決裁後アクションが実行されませんでした", e);
            return null;
        } finally {
            //取得自体が終わったタイミングで一度コネクションを破棄
            JDBCUtil.closeConnection(con);
            con = null;
        }
    }

    /**
     * <br>[機  能] 入力された情報から、APIの実行対象の情報を返す
     * <br>[解  説]
     * <br>[備  考] 実行テスト時に呼び出すf
     * @param con コネクション
     * @param rtpaMdlList 決裁後アクション一覧
     * @param allParamList アクションパラメータ一覧
     * @param formList フォーム情報一覧
     * @param formTypeMap 各フォームのタイプを格納したマップ
     * @param repeatChildFormMap 繰り返し実行が有効になっている表の中の子要素フォームIDマップ
     * @param checkActionModelList チェック対象の稟議テンプレート情報
     * @return APIの実行対象情報
     * @throws SQLException
     */
    private ExecuteTargetApiInfo __getExecuteTarget(
        Connection con, List<RngTemplateActionModel> rtpaMdlList,
        List<RngActionparamModel> allParamList,
        List<RngFormdataModel> formList,
        Map<String, Integer> formTypeMap,
        Map<String, Set<String>> repeatChildFormMap,
        LinkedList<AddRngActionModel> checkActionModelList) throws SQLException {

        formTypeMap__ = formTypeMap;
        repeatChildFormMap__ = repeatChildFormMap;

        //フォーム入力値をマップに格納
        __setFormValueMap(formList);

        //外のマップのキーは決裁後アクションSID,　中のキーをアクションパラメータSID, 値を行番号List<Integer>
        Map<Integer, Map<Integer, List<Integer>>> matchConditionParamMap = new HashMap<>();
        //全てのアクションパラメータで使用するユーザ情報，グループ情報をループ処理の前に取得
        Map<Integer, Integer> rtpaSortMap = rtpaMdlList.stream()
            .collect(
                Collectors.toMap(
                    RngTemplateActionModel::getRtpaSid,
                    RngTemplateActionModel::getRtpaSort,
                    (mdl1, mdl2) -> mdl2
                )
            );
        Map<Integer, List<RngActionparamModel>> rngActionParammap = allParamList.stream()
            .sorted(Comparator.comparingInt(mdl -> rtpaSortMap.get(mdl.getRtpaSid())))
            .sorted(Comparator.comparingInt(RngActionparamModel::getRapSort))
            .collect(Collectors.groupingBy(
                RngActionparamModel::getRtpaSid,
                Collectors.mapping(mdl -> mdl, Collectors.toList())
            ));

        Map<Integer, RngTemplateActionModel> rtpaMap = rtpaMdlList.stream()
            .collect(
                Collectors.toMap(
                    RngTemplateActionModel::getRtpaSid,
                    mdl -> mdl,
                    (mdl1, mdl2) -> mdl2
                )
            );
        RequestModel reqMdl = new RequestModel();
        reqMdl.setLocale(Locale.JAPANESE);
        RngTemplateActionFileBiz fileBiz = new RngTemplateActionFileBiz(reqMdl);

        //使用できない決裁後アクションを削除する
        for (AddRngActionModel actionModel : checkActionModelList) {
            if (fileBiz.isRepeatFormError(actionModel)) {
                RngTemplateActionModel rtpaMdl = rtpaMdlList.stream()
                    .filter(mdl -> mdl.getRtpaSort() == actionModel.getIndex())
                    .findFirst().orElse(null);
                if (rtpaMdl != null) {
                    rngActionParammap.remove(rtpaMdl.getRtpaSid());
                }
            }
        }

        Map<Integer, List<Integer>> needPositionUsrMap = new HashMap<>();
        for (Entry<Integer, List<RngActionparamModel>> entry : rngActionParammap.entrySet()) {
            RngTemplateActionModel mdl = rtpaMap.get(entry.getKey());
            List<RngActionparamModel> actionParamList = entry.getValue();
            if (actionParamList == null) {
                continue;
            }

            String repeatFormId = null;
            if (mdl.getRtpaRepeatKbn() == RngConst.API_REPEAT_KBN_ON
                && mdl.getRtpaRepeatType() == RngConst.API_REPEAT_TYPE_FORM) {
                repeatFormId = mdl.getRftId();
            }
            List<Integer> rowNoList = new ArrayList<>();
            if (mdl.getRtpaRepeatKbn() == 1
                && mdl.getRtpaRepeatType() == 0
                && formTypeMap__.getOrDefault(mdl.getRftId(), 0) != 15) {
                //添付ファイル以外のフォーム要素で繰り返し実行をする場合
                Set<String> repeatChildForm =
                    repeatChildFormMap.getOrDefault(repeatFormId, new HashSet<>());
                for (String childFormId : repeatChildForm) {
                    Map<Integer, List<String>> formValue = formValueMap__.get(childFormId);
                    if (formValue == null) {
                        continue;
                    }
                    rowNoList.addAll(formValue.keySet());
                }
            } else {
                rowNoList.add(-1);
            }

            //重複を無くし、行番号の順で並び替え
            rowNoList = rowNoList.stream()
                .distinct()
                .sorted()
                .collect(Collectors.toList());

            Map<Integer, List<Integer>> addMap = new HashMap<>();
            for (RngActionparamModel actionParam : actionParamList) {
                List<Integer> addValueList = new ArrayList<>();
                for (int idx = 0; idx < rowNoList.size(); idx++) {
                    try {
                        int rowNo = rowNoList.get(idx);
                        int checkResult = __checkParamCondition(
                            actionParam, repeatFormId, rowNo, needPositionUsrMap);
                        if (checkResult == 2) {
                            //条件を満たさない場合は置き換え用リストに追加しない
                            continue;
                        }
                        if (checkResult == 0) {
                            addValueList.add(rowNo);
                        }
                        if (checkResult == 1) {
                            //役職以外の条件を満たす場合は、置き換え用リストに追加する
                            //ただし、その後のアクションパラメータも追加対象になる
                            addValueList.add(rowNo);
                        }
                    } catch (Exception e) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("タイトル:" + rngMdl__.getRngTitle());
                        sb.append("(SID:" + rngMdl__.getRngSid() + ")");
                        sb.append("の決裁後アクションにて、");
                        sb.append("アクションパラメータ:\"" + actionParam.getRapName() + "\"");
                        sb.append("の実行条件取得時にエラーが発生したため、");
                        sb.append("このアクションパラメータを実行しませんでした。");
                        log__.warn(sb.toString(), e);
                    }
                }
                if (!addValueList.isEmpty()) {
                    addMap.put(actionParam.getRapSid(), addValueList);
                }
            }
            matchConditionParamMap.put(entry.getKey(), addMap);
        }

        Map<Integer, RngActionparamModel> actionParamMap =  allParamList.stream()
            .collect(
                Collectors.toMap(
                    mdl -> mdl.getRapSid(),
                    mdl -> mdl,
                    (mdl1, mdl2) -> mdl2)
            );
        //役職情報を使用したチェック
        __checkPosition(needPositionUsrMap, matchConditionParamMap, rtpaMap, actionParamMap, con);


        //アクションパラメータのJSONが正常かチェック
        __checkActionParamJson(
            matchConditionParamMap, rtpaMap, actionParamMap, checkActionModelList, con);


        //実行対象のアクションパラメータから、リクエストボディで使用しているユーザ，グループ情報を取得する
        Set<Integer> needUsrSet = new HashSet<>();
        Set<Integer> needGrpSet = new HashSet<>();
        for (Entry<Integer, Map<Integer, List<Integer>>> entry
            : matchConditionParamMap.entrySet()) {
            if (entry.getValue() == null) {
                continue;
            }
            int templateActionSid = entry.getKey();
            RngTemplateActionModel rtpaMdl = rtpaMap.get(templateActionSid);
            String repeatFormId = null;
            if (rtpaMdl.getRtpaRepeatKbn() == RngConst.API_REPEAT_KBN_ON
                && rtpaMdl.getRtpaRepeatType() == RngConst.API_REPEAT_TYPE_FORM) {
                repeatFormId = rtpaMdl.getRftId();
            }
            for (Entry<Integer, List<Integer>> idxEntry : entry.getValue().entrySet()) {
                try {
                    RngActionparamModel actionParam = actionParamMap.get(idxEntry.getKey());
                    String paramJson = actionParam.getRapParamJson();
                    List<Integer> rowNoList = idxEntry.getValue();
                    //ユーザSID, グループSIDをSetに追加していく
                    __setParamUserGroupSid(
                        paramJson, repeatFormId, rowNoList, needUsrSet, needGrpSet);
                } catch (Exception e) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("タイトル:" + rngMdl__.getRngTitle());
                    sb.append("(SID:" + rngMdl__.getRngSid() + ")");
                    sb.append("の決裁後アクションにて、");
                    sb.append("アクションパラメータ:\"");
                    sb.append(actionParamMap.get(idxEntry.getKey()).getRapName() + "\"");
                    sb.append("の実行条件取得時にエラーが発生したため、");
                    sb.append("このアクションパラメータを実行しませんでした。");
                    log__.warn(sb.toString(), e);
                }
            }
        }
        //ユーザ，グループ情報の取得
        __setUserGroupData(con, needUsrSet, needGrpSet);

        List<Integer> cacSidList = rtpaMdlList.stream()
            .filter(mdl -> matchConditionParamMap.get(mdl.getRtpaSid()) != null
                && !matchConditionParamMap.get(mdl.getRtpaSid()).isEmpty())
            .map(mdl -> mdl.getCacSid())
            .distinct()
            .collect(Collectors.toList());

        CmnApiConnectDao cacDao = new CmnApiConnectDao(con);
        List<CmnApiConnectModel> cacList = cacDao.select(cacSidList);
        CmnApiConnectParamDao cacpDao = new CmnApiConnectParamDao(con);
        List<CmnApiConnectParamModel> cacpList = cacpDao.select(cacSidList);
        CmnApiConnectHeaderDao cachDao = new CmnApiConnectHeaderDao(con);
        List<CmnApiConnectHeaderModel> cachList = cachDao.select(cacSidList);

        ExecuteTargetApiInfo ret = new ExecuteTargetApiInfo(
            rtpaMdlList, allParamList, cacList, cacpList, cachList, matchConditionParamMap);
        return ret;
    }

    /**
     * <br>[機  能] パスパラメータ, クエリパラメータ，ボディパラメータの中で必要なユーザSID,グループSIDをセットする
     * <br>[解  説]
     * <br>[備  考]
     * @param paramJson 条件JSON文字列
     * @param repeatFormId 繰り返し実行対象になっている表のフォームID
     * @param rowNoList 繰り返し実行にて、実行条件を満たしている行番号のリスト
     * @param usrSet ユーザSIDセット
     * @param grpSet グループSIDセット
     * @throws SQLException
     */
    private void __setParamUserGroupSid(
        String paramJson, String repeatFormId, List<Integer> rowNoList,
        Set<Integer> usrSet, Set<Integer> grpSet) throws SQLException {

        //paramJsonに何も入っていない場合は処理を終了(本来、最低でも{}が入る)
        if (StringUtil.isNullZeroString(paramJson)) {
            return;
        }
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node;
        try {
            node = mapper.readTree(paramJson);
        } catch (JsonProcessingException e) {
            throw new RngApiJsonFormatException("format");
        }
        //paramJsonの中身が空のため処理を終了
        if (node.isEmpty()) {
            return;
        }

        JsonNode pathNode = node.get("path");
        if (pathNode != null) {
            __setFormUserGroupSid(pathNode, repeatFormId, rowNoList, usrSet, grpSet);
        }

        JsonNode queryNode = node.get("query");
        if (queryNode != null) {
            __setFormUserGroupSid(queryNode, repeatFormId, rowNoList, usrSet, grpSet);
        }

        JsonNode bodyNode = node.get("body");
        if (bodyNode != null) {
            __setFormUserGroupSid(bodyNode, repeatFormId, rowNoList, usrSet, grpSet);
        }
    }

    /**
     * <br>[機  能] パラメータJSONで使用しているフォームIDの中から、ユーザ選択とグループ選択にて指定されているSIDをSetに設定する
     * <br>[解  説]
     * <br>[備  考] 単体パラメータにユーザ,グループ選択(複数)が指定されている場合1つめの値を適用させるが、SIDだけではどれが1つめか
     *              を判断できないため、ユーザ，グループは入力されたものを全て取得しその後の処理で絞り込む
     * @param jsonNode JSON
     * @param repeatFormId 繰り返し実行対象になっている表のフォームID
     * @param rowNoList 繰り返し実行にて、実行条件を満たしている行番号のリスト
     * @param usrSet ユーザSIDセット
     * @param grpSet グループSIDセット
     * @throws SQLException
     */
    private void __setFormUserGroupSid(
        JsonNode jsonNode, String repeatFormId, List<Integer> rowNoList,
        Set<Integer> usrSet, Set<Integer> grpSet) {

        Set<String> repeatFormSet =
            repeatChildFormMap__.getOrDefault(repeatFormId, new HashSet<>());
        for (JsonNode oneParam : jsonNode) {
            int useKbn = Integer.parseInt(__getJsonNode(oneParam, "useKbn").asText());
            if (useKbn == RngConst.API_PARAM_NOT_USE) {
                continue;
            }
            JsonNode paramList = __getJsonNode(oneParam, "paramList");
            String paramType = __getJsonNode(oneParam, "paramType").asText();
            //モデルの場合は、子パラメータから値を取得
            if (Objects.equals(paramType, "model")) {
                __setFormUserGroupSid(
                    paramList, repeatFormId, rowNoList, usrSet, grpSet);
                continue;
            }
            //タイプがパラメータ，リストの場合
            List<JsonNode> targetNode = new ArrayList<>();
            for (JsonNode paramListNode : paramList) {
                if (paramListNode.isArray()) {
                    for (JsonNode arrayNode : paramListNode) {
                        targetNode.add(arrayNode);
                    }
                } else {
                    targetNode.add(paramListNode);
                }
                for (JsonNode paramInfo : targetNode) {
                    //フォーム要素以外は無効
                    int paramKbn = Integer.parseInt(
                        __getJsonNode(paramInfo, "paramKbn").asText());
                    if (paramKbn != RngConst.API_PARAMKBN_FORM) {
                        continue;
                    }
                    String formId = __getJsonNode(paramInfo, "paramFormId").asText();

                    int formType = formTypeMap__.get(formId);
                    if (formType != 11 && formType != 12) {
                        continue;
                    }
                    Map<Integer, List<String>> formValue = formValueMap__.get(formId);
                    if (formValue == null) {
                        continue;
                    }
                    List<String> addSidList = new ArrayList<>();
                    int paramIndex = Integer.parseInt(
                        __getJsonNode(paramInfo, "paramIndex").asText());
                    if (repeatFormSet.contains(formId)) {
                        //繰り返し実行対象の表内にある要素の場合
                        for (int rowNo : rowNoList) {
                            addSidList.addAll(formValue.getOrDefault(rowNo, new ArrayList<>()));
                        }
                    } else {
                        if (paramIndex == 0 || paramIndex == -1) {
                            for (Entry<Integer, List<String>> entry : formValue.entrySet()) {
                                for (String inputValue : entry.getValue()) {
                                    addSidList.add(inputValue);
                                }
                            }
                        } else if (paramIndex == 1) {
                            addSidList.addAll(formValue.getOrDefault(0, new ArrayList<>()));
                        } else if (paramIndex == 2) {
                            addSidList.addAll(
                                formValue.getOrDefault(formValue.size() - 1, new ArrayList<>()));
                        }
                    }
                    List<Integer> addSid = addSidList.stream()
                        .map(Integer::valueOf)
                        .collect(Collectors.toList());
                    if (formType == 11) {
                        usrSet.addAll(addSid);
                    } else if (formType == 12) {
                        grpSet.addAll(addSid);
                    }
                }
            }
        }
    }

    /**
     * <br>[機  能] key:フォームID, value:稟議申請時に入力された値を格納したマップを設定する
     * <br>[解  説]
     * <br>[備  考]
     * @param formList フォーム情報
     * @throws SQLException
     */
    private void __setFormValueMap(List<RngFormdataModel> formList) throws SQLException {

        //フォームに入力された値を取得
        Map<String, List<RngFormdataModel>> inputParamMap = formList.stream()
            .collect(Collectors.groupingBy(
                RngFormdataModel::getRfdId,
                Collectors.mapping(mdl -> mdl, Collectors.toList())
            ));
        for (Entry<String, List<RngFormdataModel>> entry : inputParamMap.entrySet()) {
            String formId = entry.getKey();
            Map<Integer, List<String>> map = entry.getValue().stream()
                .collect(Collectors.groupingBy(
                    RngFormdataModel::getRfdRowno,
                    Collectors.mapping(mdl -> mdl.getRfdValue(), Collectors.toList())
                ));
            formValueMap__.put(formId, map);
        }
    }

    /**
     * <br>[機  能] 各アクションパラメータで使用するユーザ情報とグループ情報を取得する
     * <br>[解  説] ユーザ情報，グループ情報は入力値されたユーザSID，グループSIDからDBアクセスを行って取得する必要があるため、ループ処理の前に取得する
     * <br>[備  考]
     * @param con コネクション
     * @param usrSet 取得対象のユーザSID
     * @param grpSet 取得対象のグループSID
     * @throws SQLException SQLException
     */
    private void __setUserGroupData(
        Connection con,
        Set<Integer> usrSet, Set<Integer> grpSet) throws SQLException {

        CmnUsrmInfDao cuiDao = new CmnUsrmInfDao(con);
        CmnUsrmDao cuDao = new CmnUsrmDao(con);
        GroupDao groupDao = new GroupDao(con);
        CmnCmbsortConfDao sortDao = new CmnCmbsortConfDao(con);
        CmnCmbsortConfModel sortMdl = sortDao.getCmbSortData();

        //ユーザ選択，及びグループ選択の場合はDBアクセスが必要なため、後で一括で取得する
        if (!usrSet.isEmpty()) {
            List<Integer> usrSidList = new ArrayList<>(usrSet);
            String[] usrSidArray = usrSidList.stream()
                .map(String::valueOf)
                .toArray(String[]::new);
            List<CmnUsrmInfModel> usrmInfList =
                cuiDao.getUsersInfList(usrSidArray, sortMdl);
            List<CmnUsrmModel> usrmList = cuDao.select(usrSidList);
            Map<Integer, CmnUsrmModel> usrmMap = usrmList.stream()
                .collect(
                    Collectors.toMap(
                        mdl -> mdl.getUsrSid(),
                        mdl -> mdl,
                        (mdl1, mdl2) -> mdl2
                    )
                );
            Map<Integer, CmnGroupmModel> groupMap = groupDao.getDefaultGroup(usrSidList);
            for (CmnUsrmInfModel usrmInfMdl : usrmInfList) {
                UserValue userValue = new UserValue();
                userValue.setUsrmInfMdl(usrmInfMdl);
                userValue.setUsrmMdl(usrmMap.get(usrmInfMdl.getUsrSid()));
                userValue.setBelongGroupMdl(groupMap.get(usrmInfMdl.getUsrSid()));
                userValueList__.add(userValue);
            }
        }

        if (!grpSet.isEmpty()) {
            int[] grpSidArray = grpSet.stream()
                .mapToInt(Integer::intValue)
                .toArray();
            List<CmnGroupmModel> groupList = groupDao.getGroupsAll(grpSidArray, sortMdl);
            for (CmnGroupmModel groupMdl : groupList) {
                groupValueList__.add(groupMdl);
            }
        }
    }

    /**
     * <br>[機  能] アクションパラメータの使用条件が満たされているかを確認する
     * <br>[解  説]
     * <br>[備  考] 条件に役職が含まれている場合はここで判定しない。また、そのユーザをマップに保持する
     * @param rngParamMdl 稟議アクションパラメータ情報
     * @param repeatFormId 繰り返し実行対象の表のフォームID
     * @param rowNo 繰り返し実行時の行番号
     * @param needPositionUsrMap 役職情報による判定が必要なユーザ キー：アクションパラメータSID, 値：役職が必要なユーザSID一覧
     * @return 0:全ての条件を満たしている，1:役職情報がOKであれば全て満たされる, 2:満たしていない
     */
    private int __checkParamCondition(
        RngActionparamModel rngParamMdl, String repeatFormId,
        int rowNo, Map<Integer, List<Integer>> needPositionUsrMap) {

        //使用条件JSON文字列が設定されていない場合は、条件が無いとして扱う(本来最低でも{}は入る)
        if (StringUtil.isNullZeroString(rngParamMdl.getRapConditionJson())) {
            return 0;
        }
        JsonNode node;
        try {
            ObjectMapper mapper = new ObjectMapper();
            node = mapper.readTree(rngParamMdl.getRapConditionJson());
        } catch (JsonProcessingException e) {
            //JSON文字列が不正な場合は、条件のチェックが出来ない為使用不可能とする
            return 2;
        }

        //使用条件が無いため、"条件を満たしている"として扱う
        if (node.isEmpty()) {
            return 0;
        }

        int conditionType = Integer.parseInt(__getJsonNode(node, "conditionType").asText());
        JsonNode conditionList = __getJsonNode(node, "conditionList");
        boolean positionFlg = false;
        List<Integer> positionUsrList = new ArrayList<>();
        for (JsonNode condition : conditionList) {
            int paramKbn = Integer.parseInt(__getJsonNode(condition, "paramKbn").asText());
            int paramValue = Integer.parseInt(__getJsonNode(condition, "paramValue").asText());
            String compareTarget = null;
            int compareType = Integer.parseInt(__getJsonNode(condition, "compareType").asText());
            if (compareType != RngConst.API_COMPARE_CONDITION_EXISTFILE
                && compareType != RngConst.API_COMPARE_CONDITION_NOTEXISTFILE) {
                compareTarget = __getJsonNode(condition, "compareTarget").asText();
            }
            boolean result = false;
            if (paramKbn == RngConst.API_PARAMKBN_FORM) {
                String paramFormId = __getJsonNode(condition, "paramFormId").asText();
                List<String> inputList = new ArrayList<>();
                Map<Integer, List<String>> formValue = formValueMap__.get(paramFormId);
                if (formTypeMap__.getOrDefault(repeatFormId, 0) == 15) {
                    //添付ファイルフォーム要素で繰り返し実行になっている場合
                    switch (compareType) {
                        case RngConst.API_COMPARE_CONDITION_EXISTFILE:
                            result = !formTempList__.isEmpty();
                            break;
                        case RngConst.API_COMPARE_CONDITION_NOTEXISTFILE:
                            result = formTempList__.isEmpty();
                            break;
                        default:
                            break;
                    }
                }
                if (formValue != null) {
                    //役職情報が条件に入っている場合は、一旦それを除いた部分の条件チェックを行う
                    if (paramValue == 117) {
                        for (Entry<Integer, List<String>> entry : formValue.entrySet()) {
                            for (String inputValue : entry.getValue()) {
                                positionUsrList.add(Integer.parseInt(inputValue));
                                positionFlg = true;
                            }
                        }
                        continue;
                    }
                    Set<String> repeatChildFormId =
                        repeatChildFormMap__.getOrDefault(repeatFormId, new HashSet<>());
                    if (repeatChildFormId.contains(paramFormId)) {
                        //実行条件に繰り返し実行対象の表内の要素が指定されている場合は、特定の行の値を使用する
                        inputList.addAll(formValue.getOrDefault(rowNo, new ArrayList<>()));
                    } else {
                        //実行条件に繰り返し実行対象の表内の要素が指定されていない場合は、全ての行の値を使用する
                        for (Entry<Integer, List<String>> entry : formValue.entrySet()) {
                            inputList.addAll(entry.getValue());
                        }
                    }
                }
                String value = "";
                List<String> valueList = new ArrayList<>();
                boolean isFirst = true;
                for (String inputValue : inputList) {
                    //チェックボックス，ユーザ選択，グループ選択は複数選択可能
                    valueList.add(inputValue);
                    if (isFirst) {
                        value = inputValue;
                    }
                    isFirst = false;
                }
                switch (compareType) {
                    case RngConst.API_COMPARE_CONDITION_EQUAL:
                        result = Objects.equals(value, compareTarget);
                        break;
                    case RngConst.API_COMPARE_CONDITION_NOTEQUAL:
                        result = !Objects.equals(value, compareTarget);
                        break;
                    case RngConst.API_COMPARE_CONDITION_CONTAIN:
                        result = false;
                        for (String str : valueList) {
                            if (str.contains(compareTarget)) {
                                result = true;
                                break;
                            }
                        }
                        break;
                    case RngConst.API_COMPARE_CONDITION_NOTCONTAIN:
                        result = true;
                        for (String str : valueList) {
                            if (str.contains(compareTarget)) {
                                result = false;
                                break;
                            }
                        }
                        break;
                    case RngConst.API_COMPARE_CONDITION_MORE:
                    case RngConst.API_COMPARE_CONDITION_MORETHAN:
                    case RngConst.API_COMPARE_CONDITION_LESS:
                    case RngConst.API_COMPARE_CONDITION_LESSTHAN:
                        if (ValidateUtil.isNumberDot(value)) {
                            Double numValue = Double.parseDouble(value);
                            Double compareValue = Double.parseDouble(compareTarget);
                            if (compareType == RngConst.API_COMPARE_CONDITION_MORE) {
                                result = numValue >= compareValue;
                            } else if (compareType == RngConst.API_COMPARE_CONDITION_MORETHAN) {
                                result = numValue > compareValue;
                            } else if (compareType == RngConst.API_COMPARE_CONDITION_LESS) {
                                result = numValue <= compareValue;
                            } else if (compareType == RngConst.API_COMPARE_CONDITION_LESSTHAN) {
                                result = numValue < compareValue;
                            }
                            break;
                        }
                        UDate valueDate = new UDate();
                        valueDate.setZeroDdHhMmSs();
                        UDate compareDate = new UDate();
                        compareDate.setZeroDdHhMmSs();
                        if (ValidateUtil.isTimeFormat(value)) {
                            valueDate.setHour(Integer.parseInt(value.split(":")[0]));
                            valueDate.setMinute(Integer.parseInt(value.split(":")[1]));
                            compareDate.setHour(Integer.parseInt(compareTarget.split(":")[0]));
                            compareDate.setMinute(Integer.parseInt(compareTarget.split(":")[1]));
                        } else if (ValidateUtil.isSlashDateFormat(value)) {
                            valueDate.setDate(value.replaceAll("/", ""));
                            compareDate.setDate(compareTarget.replaceAll("/", ""));
                        }
                        int compareResult = new UDate().compare(compareDate, valueDate);
                        if (compareType == RngConst.API_COMPARE_CONDITION_MORETHAN) {
                            result = (compareResult == UDate.LARGE);
                        } else if (compareType == RngConst.API_COMPARE_CONDITION_MORE) {
                            result = (compareResult >= UDate.EQUAL);
                        } else if (compareType == RngConst.API_COMPARE_CONDITION_LESS) {
                            result = (compareResult <= UDate.EQUAL);
                        } else if (compareType == RngConst.API_COMPARE_CONDITION_LESSTHAN) {
                            result = (compareResult == UDate.SMALL);
                        }
                        break;
                    case RngConst.API_COMPARE_CONDITION_EXISTFILE:
                        result = !StringUtil.isNullZeroString(value);
                        break;
                    case RngConst.API_COMPARE_CONDITION_NOTEXISTFILE:
                        result = StringUtil.isNullZeroString(value);
                        break;
                    default:
                        break;
                }
            } else if (paramKbn == RngConst.API_PARAMKBN_ADDUSER
                || paramKbn == RngConst.API_PARAMKBN_LETUSER) {
                //申請者，最終承認者
                int usrSid = rngMdl__.getRngApplicate();
                CmnUsrmInfModel usrMdl = sinseiUsrInfMdl__;
                if (paramKbn == RngConst.API_PARAMKBN_LETUSER) {
                    usrSid = rngMdl__.getRngEuid();
                    usrMdl = syouninUsrInfMdl__;
                }
                boolean isError = false;
                String value = "";
                switch (paramValue) {
                    case RngConst.API_COMPARE_PARAM_NOSELECT:
                        if (usrSid < 0) {
                            isError = true;
                            break;
                        }
                        value = String.valueOf(usrSid);
                        break;
                    case RngConst.API_COMPARE_PARAM_POSITION:
                        if (usrMdl == null) {
                            isError = true;
                            break;
                        }
                        value = String.valueOf(usrMdl.getPosSid());
                        break;
                    default:
                        break;
                }

                if (isError) {
                    //申請者，承認者が正常に入力されていない場合
                    result = false;
                } else {
                    switch (compareType) {
                        case RngConst.API_COMPARE_CONDITION_EQUAL:
                            result = Objects.equals(value, compareTarget);
                            break;
                        case RngConst.API_COMPARE_CONDITION_NOTEQUAL:
                            result = !Objects.equals(value, compareTarget);
                            break;
                        default:
                            break;
                    }
                }
            } else if (paramKbn == RngConst.API_PARAMKBN_ADDDATE
                || paramKbn == RngConst.API_PARAMKBN_LETDATE) {
                //申請日時，最終承認日時
                UDate date = rngMdl__.getRngAdate();
                if (paramKbn == RngConst.API_PARAMKBN_LETDATE) {
                    date = rngMdl__.getRngEdate();
                }

                if (date == null) {
                    result = false;
                } else {
                    compareTarget = compareTarget.concat(":00");
                    UDate compareDate = new UDate();
                    compareDate.setTimeStamp(
                        compareTarget.replace("/", "").replace(":", "").replace(" ", ""));

                    int compareResult = new UDate().compare(compareDate, date);
                    switch (compareType) {
                        case RngConst.API_COMPARE_CONDITION_MORETHAN:
                            result = (compareResult == UDate.LARGE);
                            break;
                        case RngConst.API_COMPARE_CONDITION_MORE:
                            result = (compareResult >= UDate.EQUAL);
                            break;
                        case RngConst.API_COMPARE_CONDITION_LESS:
                            result = (compareResult <= UDate.EQUAL);
                            break;
                        case RngConst.API_COMPARE_CONDITION_LESSTHAN:
                            result = (compareResult == UDate.SMALL);
                            break;
                        default:
                            break;
                    }
                }
            } else if (paramKbn == RngConst.API_PARAMKBN_RINGIINFO) {
                //稟議情報
                switch (paramValue) {
                    //タイトル
                    case RngConst.API_COMPARE_PARAM_TITLE:
                        if (rngMdl__.getRngTitle() == null) {
                            result = false;
                            break;
                        }
                        switch (compareType) {
                            case RngConst.API_COMPARE_CONDITION_CONTAIN:
                                result = rngMdl__.getRngTitle().contains(compareTarget);
                                break;
                            case RngConst.API_COMPARE_CONDITION_NOTCONTAIN:
                                result = !rngMdl__.getRngTitle().contains(compareTarget);
                                break;
                            default:
                                break;
                        }
                        break;
                    //申請ID
                    case RngConst.API_COMPARE_PARAM_SINSEIID:
                        String rngId = NullDefault.getString(rngMdl__.getRngId(), "");
                        switch (compareType) {
                            case RngConst.API_COMPARE_CONDITION_CONTAIN:
                                result = rngId.contains(compareTarget);
                                break;
                            case RngConst.API_COMPARE_CONDITION_NOTCONTAIN:
                                result = !rngId.contains(compareTarget);
                                break;
                            default:
                                break;
                        }
                        break;
                    //確認時添付ファイル
                    case RngConst.API_COMPARE_PARAM_FILE:
                        switch (compareType) {
                            case RngConst.API_COMPARE_CONDITION_EXISTFILE:
                                result = !kakuninTempList__.isEmpty();
                                break;
                            case RngConst.API_COMPARE_CONDITION_NOTEXISTFILE:
                                result = kakuninTempList__.isEmpty();
                                break;
                            default:
                                break;
                        }
                        break;
                    default:
                        break;
                }
            }

            if (conditionType == RngConst.EXECUTE_CONDITION_AND && !result) {
                //実行条件タイプがANDで、判定がfalseだったときは実行条件を満たしていない
                return 2;
            }
            if (conditionType == RngConst.EXECUTE_CONDITION_OR && result) {
                //実行条件タイプがORで、判定がtrueだったときは実行条件を満たしている
                return 0;
            }
        }

        if (positionFlg) {
            needPositionUsrMap.put(rngParamMdl.getRapSid(), positionUsrList);
            return 1;
        }
        if (conditionType == RngConst.EXECUTE_CONDITION_AND) {
            if (positionFlg) {
                return 1;
            } else {
                return 0;
            }
        } else {
            if (positionFlg) {
                return 1;
            } else {
                return 2;
            }
        }
    }

    /**
     * <br>[機  能] 役職情報を使用した実行条件チェックを行う
     * <br>[解  説]
     * <br>[備  考]
     * @param needPositionUsrMap 役職が必要なユーザのマップ key:アクションパラメータSID, value:ユーザSID一覧
     * @param matchConditionParamMap 現状条件を満たしているパラメータマップ
     * @param rtpaMap 決裁後アクションSIDごとにまとめた決裁後アクション情報
     * @param actionParamMap アクションパラメータSIDごとにまとめたアクションパラメータ情報
     * @param con コネクション
     * @throws SQLException
     */
    private void __checkPosition(
        Map<Integer, List<Integer>> needPositionUsrMap,
        Map<Integer, Map<Integer, List<Integer>>> matchConditionParamMap,
        Map<Integer, RngTemplateActionModel> rtpaMap,
        Map<Integer, RngActionparamModel> actionParamMap,
        Connection con) throws SQLException {

        if (needPositionUsrMap.isEmpty()) {
            return;
        }

        //条件のチェックに必要な役職情報を取得する
        String[] positionUsrArray = needPositionUsrMap.values().stream()
            .flatMap(List::stream)
            .distinct()
            .map(String::valueOf)
            .toArray(String[]::new);
        CmnUsrmInfDao cuiDao = new CmnUsrmInfDao(con);
        ArrayList<CmnUsrmInfModel> posUsrList =
            cuiDao.getUsersInfList(positionUsrArray, new CmnCmbsortConfModel());
        Map<Integer, Integer> usrPosMap = posUsrList.stream()
            .collect(Collectors.toMap(
                CmnUsrmInfModel::getUsrSid,
                CmnUsrmInfModel::getPosSid,
                (mdl1, mdl2) -> mdl2)
            );

        //役職情報のチェックが必要なアクションパラメータをチェックする
        for (Entry<Integer, Map<Integer, List<Integer>>> entry
            : matchConditionParamMap.entrySet()) {
            RngTemplateActionModel rtpaMdl = rtpaMap.get(entry.getKey());
            String repeatFormId = null;
            if (rtpaMdl.getRtpaRepeatKbn() == RngConst.API_REPEAT_KBN_ON
                && rtpaMdl.getRtpaRepeatType() == RngConst.API_REPEAT_TYPE_FORM) {
                repeatFormId = rtpaMdl.getRftId();
            }
            Map<Integer, List<Integer>> replaceMap = new HashMap<>();
            List<Integer> replaceRowNoList = new ArrayList<>();
            //アクションパラメータSIDごとに、各行で役職チェックを実行
            for (Entry<Integer, List<Integer>> idxEntry : entry.getValue().entrySet()) {
                try {
                    int rapSid = idxEntry.getKey();
                    RngActionparamModel actionParam = actionParamMap.get(rapSid);
                    for (int rowNo : idxEntry.getValue()) {
                        if (needPositionUsrMap.get(rapSid) == null
                            || __checkPositionCondition(
                            actionParam, usrPosMap, repeatFormId, rowNo)) {
                            replaceRowNoList.add(rowNo);
                        }
                    }
                    if (!replaceRowNoList.isEmpty()) {
                        replaceMap.put(rapSid, replaceRowNoList);
                    }
                } catch (Exception e) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("タイトル:" + rngMdl__.getRngTitle());
                    sb.append("(SID:" + rngMdl__.getRngSid() + ")");
                    sb.append("の決裁後アクションにて、");
                    sb.append("アクションパラメータ:\"");
                    sb.append(actionParamMap.get(idxEntry.getKey()).getRapName() + "\"");
                    sb.append("の実行条件取得時にエラーが発生したため、");
                    sb.append("このアクションパラメータを実行しませんでした。");
                    log__.warn(sb.toString(), e);
                }
            }
            matchConditionParamMap.put(entry.getKey(), replaceMap);
        }
    }

    /**
     * <br>[機  能] アクションパラメータに適切なJSONが設定されているかチェックを行う
     * <br>[解  説]
     * <br>[備  考]
     * @param matchConditionParamMap 現状条件を満たしているパラメータマップ
     * @param rtpaMap 決裁後アクションSIDごとにまとめた決裁後アクション情報
     * @param actionParamMap アクションパラメータSIDごとにまとめたアクションパラメータ情報
     * @param checkActionModelList
     * @param con コネクション
     * @throws SQLException
     */
    private void __checkActionParamJson(
        Map<Integer, Map<Integer, List<Integer>>> matchConditionParamMap,
        Map<Integer, RngTemplateActionModel> rtpaMap,
        Map<Integer, RngActionparamModel> actionParamMap,
        List<AddRngActionModel> checkActionModelList,
        Connection con) throws SQLException {

        if (matchConditionParamMap.isEmpty()) {
            return;
        }

        String templateFormJson = templateModel__.getRtpForm();

        RequestModel reqMdl = new RequestModel();
        reqMdl.setLocale(Locale.JAPANESE);
        RngTemplateActionFileBiz fileBiz = new RngTemplateActionFileBiz(reqMdl);

        for (Entry<Integer, Map<Integer, List<Integer>>> entry
            : matchConditionParamMap.entrySet()) {
            RngTemplateActionModel rtpaMdl = rtpaMap.get(entry.getKey());
            Map<Integer, List<Integer>> replaceMap = new HashMap<>();
            for (Entry<Integer, List<Integer>> idxEntry : entry.getValue().entrySet()) {
                int rapSid = idxEntry.getKey();
                RngActionparamModel actionParam = actionParamMap.get(rapSid);
                //全てのチェックを通過した後に、テンプレート側で問題がないかをチェック
                AddRngActionModel addRngMdl = checkActionModelList.stream()
                    .filter(mdl -> mdl.getIndex() == rtpaMdl.getRtpaSort())
                    .findFirst().orElse(null);
                if (rtpaMdl == null) {
                    //存在しない場合は、チェックができないため使用できないものとする
                    continue;
                }
                AddRngActionParamModel addParamMdl
                    = addRngMdl.getActionParamList().stream()
                    .filter(mdl -> mdl.getIndex() == actionParam.getRapSort())
                    .findFirst().orElse(null);
                if (addParamMdl == null) {
                    //存在しない場合は、チェックができないため使用できないものとする
                    continue;
                }
                fileBiz.checkActionParam(
                    addParamMdl, addRngMdl, templateFormJson, con);
                if (addParamMdl.getWarnFlg() == RngConst.ACTIONPARAM_WARN_FLG_YES) {
                    //チェックの結果、エラーがあった場合は実行対象から省く
                    continue;
                }
                replaceMap.put(rapSid, idxEntry.getValue());

                //条件にあった最初のアクションパラメータのみを実行
                break;
            }
            matchConditionParamMap.put(entry.getKey(), replaceMap);
        }
    }

    /**
     * <br>[機  能] 役職を使用した実行条件をチェックする
     * <br>[解  説]
     * <br>[備  考]
     * @param rngParamMdl 稟議アクションパラメータ情報
     * @param usrPosMap キー：ユーザSID, 値：役職SIDを保持したマップ
     * @param repeatFormId 繰り返し実行対象の表のフォームID
     * @param rowNo 繰り返し実行時の行番号
     * @return 0:全ての条件を満たしている，1:役職情報がOKであれば全て満たされる, 2:満たしていない
     */
    private boolean __checkPositionCondition(
        RngActionparamModel rngParamMdl,
        Map<Integer, Integer> usrPosMap, String repeatFormId, int rowNo) {

        JsonNode node;
        try {
            ObjectMapper mapper = new ObjectMapper();
            node = mapper.readTree(rngParamMdl.getRapConditionJson());
        } catch (JsonProcessingException e) {
            //JSON文字列が不正な場合は、条件のチェックが出来ない為使用不可能とする
            return false;
        }

        int conditionType = Integer.parseInt(__getJsonNode(node, "conditionType").asText());
        JsonNode conditionList = __getJsonNode(node, "conditionList");

        for (JsonNode condition : conditionList) {
            int paramKbn = Integer.parseInt(__getJsonNode(condition, "paramKbn").asText());
            int paramValue = Integer.parseInt(__getJsonNode(condition, "paramValue").asText());
            if (paramKbn != RngConst.API_PARAMKBN_FORM
                || paramValue != RngConst.API_COMPARE_PARAM_POSITION) {
                //フォーム情報_役職以外は事前にチェックしているためチェックしない
                continue;
            }
            int comparePosition = Integer.parseInt(
                __getJsonNode(condition, "compareTarget").asText());
            boolean result = false;
            String paramFormId = __getJsonNode(condition, "paramFormId").asText();
            List<String> inputList = new ArrayList<>();
            Map<Integer, List<String>> formValue = formValueMap__.get(paramFormId);
            if (formValue != null) {
                if (repeatFormId != null) {
                    inputList.addAll(formValue.getOrDefault(rowNo, new ArrayList<>()));
                } else {
                    for (Entry<Integer, List<String>> entry : formValue.entrySet()) {
                        inputList.addAll(entry.getValue());
                    }
                }
            }

            List<Integer> positionList = new ArrayList<>();
            for (String inputValue : inputList) {
                positionList.add(usrPosMap.get(Integer.parseInt(inputValue)));
            }
            int compareType = Integer.parseInt(__getJsonNode(condition, "compareType").asText());
            switch (compareType) {
                case RngConst.API_COMPARE_CONDITION_EQUAL:
                case RngConst.API_COMPARE_CONDITION_CONTAIN:
                    result = positionList.contains(comparePosition);
                    break;
                case RngConst.API_COMPARE_CONDITION_NOTEQUAL:
                case RngConst.API_COMPARE_CONDITION_NOTCONTAIN:
                    result = !positionList.contains(comparePosition);
                    break;
                default:
                    break;
            }

            if (conditionType == RngConst.EXECUTE_CONDITION_AND && !result) {
                //実行条件タイプがANDで、判定がfalseだったときは実行条件を満たしていない
                return false;
            }
            if (conditionType == RngConst.EXECUTE_CONDITION_OR && result) {
                //実行条件タイプがORで、判定がtrueだったときは実行条件を満たしている
                return true;
            }
        }
        if (conditionType == RngConst.EXECUTE_CONDITION_AND) {
            //実行条件がANDで実行条件をすべて満たしているため、実行可能
            return true;
        } else {
            //実行条件がORで、実行条件を1つも満たしていない為、実行不可能
            return false;
        }
    }

    /**
     * <br>[機  能] 連携API実行結果をDBに登録，オペレーションログに出力する際に必要な情報を保持するクラス
     * <br>[解  説]
     * <br>[備  考]
     */
    class ApiResult {
        /** 非繰り返し実行データ */
        private boolean success__ = false;
        /** 繰り返し実行(添付ファイル以外のフォーム要素) 行, 結果 */
        private Map<Integer, Boolean> repeatFormResultMap__ = new LinkedHashMap<>();
        /** 繰り返し実行 添付ファイル要素，確認時添付　何個目のファイルか，結果 */
        private List<SimpleEntry<String, Boolean>> repeatFileResultList__ = new ArrayList<>();

        /**
         * @return the success
         */
        public boolean isSuccess() {
            return success__;
        }

        /**
         * @param success the success to set
         */
        public void setSuccess(boolean success) {
            success__ = success;
        }

        /**
         * @return the repeatFormResultMap
         */
        public Map<Integer, Boolean> getRepeatFormResultMap() {
            return repeatFormResultMap__;
        }

        /**
         * @param repeatFormResultMap the repeatFormResultMap to set
         */
        public void setRepeatFormResultMap(Map<Integer, Boolean> repeatFormResultMap) {
            repeatFormResultMap__ = repeatFormResultMap;
        }

        /**
         * @return the repeatFileResultList
         */
        public List<SimpleEntry<String, Boolean>> getRepeatFileResultList() {
            return repeatFileResultList__;
        }

        /**
         * @param repeatFileResultList the repeatFileResultList to set
         */
        public void setRepeatFileResultList(
                List<SimpleEntry<String, Boolean>> repeatFileResultList) {
            repeatFileResultList__ = repeatFileResultList;
        }

        /**
         * <br>[機  能] コンストラクタ
         * <br>[解  説]
         * <br>[備  考]
         * @param success API実行結果 true:成功, false:失敗
         * @param repeatFormResultMap キー: 繰り返し実行した行数, 値：その行数でAPIが成功したか
         * @param repeatFileResultList キー: 繰り返し実行した添付ファイル名, 値：そのファイルでAPIが成功したか
         */
        public ApiResult(
            boolean success,
            Map<Integer, Boolean> repeatFormResultMap,
            List<SimpleEntry<String, Boolean>> repeatFileResultList) {
            success__ = success;
            repeatFormResultMap__ = repeatFormResultMap;
            repeatFileResultList__ = repeatFileResultList;
        }
    }

    /**
     * <br>[機  能] アクションパラメータの使用条件が満たされているかを確認する
     * <br>[解  説]
     * <br>[備  考]
     * @param rtpaMdl 決裁後アクション情報
     * @param rngParamMdl 稟議アクションパラメータ情報
     * @param repeatIndex 繰り返し実行対象の行番号一覧
     * @param cacMdl 連携APIモデル
     * @param cacParamList 連携APIパラメータ一覧
     * @param headerList 連携APIリクエストヘッダー一覧
     * @return 実行結果 true:レスポンスが200, false:レスポンスが200以外
     * @throws SQLException SQLException
     * @throws InterruptedException
     * @throws IOException
     * @throws EncryptionException
     * @throws TransformerException
     * @throws TempFileException
     */
    private ApiResult __sendApi(
        RngTemplateActionModel rtpaMdl, RngActionparamModel rngParamMdl,
        List<Integer> repeatIndex,
        CmnApiConnectModel cacMdl,
        List<CmnApiConnectParamModel> cacParamList,
        List<CmnApiConnectHeaderModel> headerList)
        throws SQLException, EncryptionException, IOException,
        InterruptedException, TransformerException, TempFileException {

        int method = cacMdl.getCacMethodKbn();
        Map<String, String> reqMap = new HashMap<>();
        if (cacMdl.getCacAuthKbn() == GSConstCommon.AUTH_KBN_TOKEN) {
            reqMap.put("Authorization", "Bearer " + cacMdl.getCacAuthToken());
        } else if (cacMdl.getCacAuthKbn() == GSConstCommon.AUTH_KBN_BASIC) {
            StringBuilder sb = new StringBuilder();
            sb.append(cacMdl.getCacAuthId());
            sb.append(":");
            sb.append(GSPassword.getDecryPassword(cacMdl.getCacAuthPass()));

            String authStr = sb.toString();
            authStr = new String(
                    Base64.encodeBase64(authStr.getBytes()), "UTF-8");
            reqMap.put("Authorization", "Basic " + authStr);
        }
        if (headerList != null) {
            reqMap.putAll(headerList.stream()
                .sorted(Comparator.comparingInt(CmnApiConnectHeaderModel::getCachSort))
                .collect(Collectors.toMap(mdl -> mdl.getCachKey(), mdl -> mdl.getCachValue())));
        }
        String contentType;
        if (cacMdl.getCacContentKbn() == EnumContentType.MANUAL.getValue()) {
            contentType = cacMdl.getCacContentManual();
        } else {
            contentType = EnumContentType.valueOf(cacMdl.getCacContentKbn()).getLabel();
        }

        List<HttpPart> partList = new ArrayList<>();
        List<ParamValue> paramList = null;
        List<Integer> rowNoList = new ArrayList<>();
        int repeatType = rtpaMdl.getRtpaRepeatType();
        String repeatFormId = null;
        if (rtpaMdl.getRtpaRepeatKbn() == 1) {
            if (repeatType == 1) {
                for (int rowNo = 0; rowNo < kakuninTempList__.size(); rowNo++) {
                    rowNoList.add(rowNo);
                }
            }
            if (repeatType == 0) {
                if (Objects.equals(15, formTypeMap__.get(rtpaMdl.getRftId()))) {
                    //繰り返し実行対象が添付要素の場合
                    for (int rowNo = 0; rowNo < formTempList__.size(); rowNo++) {
                        rowNoList.add(rowNo);
                    }
                } else {
                    //繰り返し実行対象が表の場合
                    rowNoList = repeatIndex;
                }
                repeatFormId = rtpaMdl.getRftId();
            }
        } else {
            rowNoList.add(-1);
        }

        //APIの実行結果保持用
        ApiResult ret = null;
        Map<Integer, Boolean> repeatFormResultMap = new LinkedHashMap<>();
        List<SimpleEntry<String, Boolean>> repeatFileResultList = new ArrayList<>();

        //一度でもAPIの実行結果が想定以外であったか
        boolean isError = false;
        JsonNode node;
        try {
            ObjectMapper mapper = new ObjectMapper();
            node = mapper.readTree(rngParamMdl.getRapParamJson());
        } catch (JsonProcessingException e) {
            //JSON文字列が不正な場合は処理を中断
            StringBuilder sb = new StringBuilder();
            sb.append("タイトル:" + rngMdl__.getRngTitle());
            sb.append("(SID:" + rngMdl__.getRngSid() + ")");
            sb.append("の決裁後アクションにて、");
            sb.append("アクションパラメータ:\"");
            sb.append(rngParamMdl.getRapName() + "\"");
            sb.append("のパラメータ値の取得中にエラーが発生したため、");
            sb.append("このアクションパラメータを実行しませんでした。");
            log__.warn(sb.toString(), e);
            ret = new ApiResult(false, repeatFormResultMap, repeatFileResultList);
            return ret;
        }
        ApiConnectBiz apiBiz = new ApiConnectBiz();
        for (int idx = 0; idx < rowNoList.size(); idx++) {
            int rowNo = rowNoList.get(idx);
            try {
                String cacBody = cacMdl.getCacBody();
                String cacUrl = cacMdl.getCacUrl();
                if (!StringUtil.isNullZeroString(rngParamMdl.getRapParamJson())
                    && !node.isEmpty()) {
                    cacUrl = __getApiUrl(node, cacUrl, repeatFormId, rowNo);
                    int contentKbn = cacMdl.getCacContentKbn();
                    paramList = __getParamList(
                        node.get("body"), repeatType, repeatFormId, rowNo);

                    //必須パラメータすべてに値が入力されているかをチェック
                    List<ParamValue> allParamValue = new ArrayList<>();
                    allParamValue.addAll(paramList);
                    allParamValue.addAll(__getParamList(
                        node.get("path"), repeatType, repeatFormId, rowNo));
                    allParamValue.addAll(__getParamList(
                        node.get("query"), repeatType, repeatFormId, rowNo));
                    if (contentKbn == EnumContentType.APPLICATION_JSON.getValue()) {
                        cacBody = __getJsonBody(paramList, cacBody);
                    } else if (contentKbn == EnumContentType.TEXT_XML.getValue()
                        || contentKbn == EnumContentType.APPLICATION_XML.getValue()) {
                        cacBody = __getXmlBody(paramList, cacBody);
                    } else if (contentKbn == EnumContentType.APPLICATION_FORM.getValue()
                        || contentKbn == EnumContentType.MANUAL.getValue()) {
                        cacBody = __getNormalBody(
                            paramList, cacBody, cacMdl.getCacContentKbn());
                    } else if (contentKbn == EnumContentType.MULTIPART_FORM_DATA.getValue()) {
                        partList = __getPartList(paramList, cacParamList);
                        cacBody = null;
                    }
                } else {
                    cacUrl = cacUrl.replaceAll("\\$\\{.+?\\}", "\"\"");
                    if (cacBody != null) {
                        cacBody = cacBody.replaceAll("\\$\\{.+?\\}", "\"\"");
                    }
                }

                ApiExecuter exe = new ApiExecuter(
                    cacUrl, method,
                    reqMap, contentType, partList, cacBody);
                HttpResponseModel resMdl = exe.execute();
                RequestModel reqMdl = new RequestModel();
                reqMdl.setDomain(domain__);
                reqMdl.setLocale(Locale.JAPANESE);

                String responseText = apiBiz.getApiResultText(resMdl, reqMdl);


                //レスポンスコードが200番台の場合は成功として扱う
                boolean isSuccess = resMdl.getStatusCode() >= 200 && resMdl.getStatusCode() <= 299;
                if (!isSuccess) {
                    isError = true;
                    //レスポンスコードが200以外の場合、APIの実行結果をログに出力
                    log__.warn("稟議承認時のAPI実行をした際に、エラーレスポンスを受け取りました。\r\n" + responseText);
                }
                __setResultMap(isSuccess, rtpaMdl,
                    rowNo, repeatFormResultMap, repeatFileResultList);
            } catch (Exception e) {
                isError = true;
                log__.warn("エラーが発生したため、稟議承認時のAPI実行に失敗しました。", e);
                __setResultMap(false, rtpaMdl, rowNo,
                    repeatFormResultMap, repeatFileResultList);
            }
        }
        ret = new ApiResult(!isError, repeatFormResultMap, repeatFileResultList);
        return ret;
    }

    /**
     * <br>[機  能] 実行条件などを判定ずみのアクションパラメータ等から、テスト実行用クラスを作成する
     * <br>[解  説]
     * <br>[備  考]
     * @param rtpaMdl 決裁後アクション情報
     * @param rngParamMdl 稟議アクションパラメータ情報
     * @param repeatIndex 繰り返し実行対象の行番号一覧
     * @param cacMdl 連携APIモデル
     * @param cacpList 連携APIパラメータ一覧
     * @param headerList 連携APIリクエストヘッダー一覧
     * @return テスト実行用クラス
     * @throws EncryptionException
     * @throws UnsupportedEncodingException
     * @throws SQLException
     * @throws TempFileException
     * @throws TransformerException
     */
    public List<ApiExecuter> getApiExecuter(
        RngTemplateActionModel rtpaMdl, RngActionparamModel rngParamMdl,
        List<Integer> repeatIndex, CmnApiConnectModel cacMdl,
        List<CmnApiConnectParamModel> cacpList, List<CmnApiConnectHeaderModel> headerList)
        throws EncryptionException, UnsupportedEncodingException,
            SQLException, TempFileException, TransformerException {

        List<ApiExecuter> ret = new ArrayList<>();
        int method = cacMdl.getCacMethodKbn();
        Map<String, String> reqMap = new HashMap<>();
        if (cacMdl.getCacAuthKbn() == GSConstCommon.AUTH_KBN_TOKEN) {
            reqMap.put("Authorization", "Bearer " + cacMdl.getCacAuthToken());
        } else if (cacMdl.getCacAuthKbn() == GSConstCommon.AUTH_KBN_BASIC) {
            StringBuilder sb = new StringBuilder();
            sb.append(cacMdl.getCacAuthId());
            sb.append(":");
            sb.append(GSPassword.getDecryPassword(cacMdl.getCacAuthPass()));
            String authStr = sb.toString();
            authStr = new String(
                    Base64.encodeBase64(authStr.getBytes()), "UTF-8");
            reqMap.put("Authorization", "Basic " + authStr);
        }
        if (headerList != null) {
            reqMap.putAll(headerList.stream()
                .sorted(Comparator.comparingInt(CmnApiConnectHeaderModel::getCachSort))
                .collect(Collectors.toMap(mdl -> mdl.getCachKey(), mdl -> mdl.getCachValue())));
        }
        String contentType;
        if (cacMdl.getCacContentKbn() == EnumContentType.MANUAL.getValue()) {
            contentType = cacMdl.getCacContentManual();
        } else {
            contentType = EnumContentType.valueOf(cacMdl.getCacContentKbn()).getLabel();
        }

        List<HttpPart> partList = new ArrayList<>();
        List<ParamValue> paramList = null;
        List<Integer> rowNoList = new ArrayList<>();
        int repeatType = rtpaMdl.getRtpaRepeatType();
        String repeatFormId = null;
        if (rtpaMdl.getRtpaRepeatKbn() == 1) {
            if (repeatType == 1) {
                for (int rowNo = 0; rowNo < kakuninTempList__.size(); rowNo++) {
                    rowNoList.add(rowNo);
                }
            }
            if (repeatType == 0) {
                if (Objects.equals(15, formTypeMap__.get(rtpaMdl.getRftId()))) {
                    //繰り返し実行対象が添付要素の場合
                    for (int rowNo = 0; rowNo < formTempList__.size(); rowNo++) {
                        rowNoList.add(rowNo);
                    }
                } else {
                    //繰り返し実行対象が表の場合
                    rowNoList = repeatIndex;
                }
                repeatFormId = rtpaMdl.getRftId();
            }
        } else {
            rowNoList.add(-1);
        }

        JsonNode node = null;
        if (!StringUtil.isNullZeroString(rngParamMdl.getRapParamJson())) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                node = mapper.readTree(rngParamMdl.getRapParamJson());
            } catch (JsonProcessingException e) {
                //JSON文字列が不正な場合は処理を中断
                return ret;
            }
        }
        for (int idx = 0; idx < rowNoList.size(); idx++) {
            int rowNo = rowNoList.get(idx);
            String cacBody = cacMdl.getCacBody();
            String cacUrl = cacMdl.getCacUrl();
            if (!StringUtil.isNullZeroString(rngParamMdl.getRapParamJson()) && !node.isEmpty()) {
                cacUrl = __getApiUrl(node, cacUrl, repeatFormId, rowNo);
                int contentKbn = cacMdl.getCacContentKbn();
                paramList = __getParamList(node.get("body"), repeatType, repeatFormId, rowNo);
                if (contentKbn == EnumContentType.APPLICATION_JSON.getValue()) {
                    cacBody = __getJsonBody(paramList, cacBody);
                } else if (contentKbn == EnumContentType.TEXT_XML.getValue()
                    || contentKbn == EnumContentType.APPLICATION_XML.getValue()) {
                    cacBody = __getXmlBody(paramList, cacBody);
                } else if (contentKbn == EnumContentType.APPLICATION_FORM.getValue()
                    || contentKbn == EnumContentType.MANUAL.getValue()) {
                    cacBody = __getNormalBody(paramList, cacBody, cacMdl.getCacContentKbn());
                } else if (contentKbn == EnumContentType.MULTIPART_FORM_DATA.getValue()) {
                    partList = __getPartList(paramList, cacpList);
                    cacBody = null;
                }
            } else {
                cacUrl = cacUrl.replaceAll("\\$\\{.+?\\}", "\"\"");
                if (cacBody != null) {
                    cacBody = cacBody.replaceAll("\\$\\{.+?\\}", "\"\"");
                }
            }

            ApiExecuter exe = new ApiExecuter(
                cacUrl, method,
                reqMap, contentType, partList, cacBody);
            ret.add(exe);
        }
        return ret;
    }

    /**
     * <br>[機  能] パラメータJSONから、URLを取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param node パラメータ情報を保持したJSON配列
     * @param url URL文字列
     * @param repeatFormId 繰り返し実行対象の表のフォームID
     * @param rowNo 繰り返し実行対象の行番号
     * @return API実行用URL
     * @throws SQLException SQLException
     */
    private String __getApiUrl(
        JsonNode node, String url, String repeatFormId, int rowNo) throws SQLException {

        String pathUrl = url;
        String queryUrl = null;
        if (url.indexOf("?") > -1) {
            pathUrl = url.substring(0, url.indexOf("?"));
            queryUrl = url.substring(url.indexOf("?"));
        }

        pathUrl = __replaceUrl(node, pathUrl, "path", repeatFormId, rowNo);
        if (queryUrl == null) {
            return pathUrl;
        }

        queryUrl = __replaceUrl(node, queryUrl, "query", repeatFormId, rowNo);
        return pathUrl + queryUrl;
    }

    /**
     * <br>[機  能] パラメータJSONから、URLを取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param node パラメータ情報を保持したJSON配列
     * @param url パスURLまたはクエリURL
     * @param paramCategory "path" または "query"
     * @param repeatFormId 繰り返し実行対象の表のフォームID
     * @param rowNo 繰り返し実行対象の行番号
     * @return パラメータ値を反映した後のURL
     * @throws SQLException SQLException
     */
    private String __replaceUrl(JsonNode node, String url,
        String paramCategory, String repeatFormId, int rowNo) throws SQLException {

        JsonNode categoryNode = node.get(paramCategory);
        if (categoryNode != null) {
            for (JsonNode param : categoryNode) {
                String name = __getJsonNode(param, "name").asText();
                int useKbn = Integer.parseInt(__getJsonNode(param, "useKbn").asText());
                if (useKbn == RngConst.API_PARAM_NOT_USE) {
                    String replaceTarget;
                    if (Objects.equals(paramCategory, "path")) {
                        replaceTarget = "${" + name + "}";
                    } else {
                        replaceTarget = name + "=${" + name + "}";
                    }

                    if (url.contains("?" + replaceTarget + "/")) {
                        replaceTarget = replaceTarget + "/";
                    } else if (url.contains("/" + replaceTarget + "/")) {
                        replaceTarget = replaceTarget + "/";
                    } else if (url.contains("/" + replaceTarget)) {
                        replaceTarget = "/" + replaceTarget;
                    }
                    url = url.replace(replaceTarget, "");
                    continue;
                }

                String paramType = __getJsonNode(param, "paramType").asText();
                StringBuilder sb = new StringBuilder();
                JsonNode paramList = __getJsonNode(param, "paramList");
                try {
                    if (Objects.equals(paramType, "parameter")) {
                        for (JsonNode paramInfo : paramList) {
                            String replaceStr = __getParamValue(
                                paramInfo, paramType, repeatFormId, rowNo).stream()
                                    .findFirst().orElse("");
                            sb.append(URLEncoder.encode(replaceStr, Encoding.UTF_8));
                        }
                    } else if (Objects.equals(paramType, "list")) {
                        boolean isFirst = true;
                        for (JsonNode paramArray : paramList) {
                            List<String> addList = new ArrayList<>();
                            StringBuilder addStr = new StringBuilder();
                            boolean addFlg = false;
                            for (JsonNode paramInfo : paramArray) {
                                if (paramArray.size() == 1) {
                                    addList.addAll(__getParamValue(
                                        paramInfo, paramType, repeatFormId, rowNo));
                                } else {
                                    addStr.append(__getParamValue(
                                        paramInfo, paramType, repeatFormId, rowNo).stream()
                                            .findFirst().orElse(""));
                                    addFlg = true;
                                }
                            }
                            if (addFlg) {
                                addList.add(addStr.toString());
                            }
                            for (String inputValue : addList) {
                                if (!isFirst) {
                                    sb.append("&");
                                    sb.append(name);
                                    sb.append("=");
                                }
                                sb.append(URLEncoder.encode(inputValue, Encoding.UTF_8));
                                isFirst = false;
                            }
                        }
                    }
                } catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }

                String replaceTarget = "${" + name + "}";
                url = url.replace(replaceTarget, sb.toString());
            }
        }
        //CMN_API_CONNECT_PARAM側に存在するが、アクションパラメータ側にはないパラメータは空文字とする
        url = url.replaceAll("\\$\\{.+?\\}", "");
        return url;
    }

    /**
     * <br>[機  能] パラメータJSONからファイル情報を取得し、パラメータ情報変数に格納します
     * <br>[解  説]
     * <br>[備  考]
     * @param param パラメータJSON
     * @param paramValue パラメータ情報変数
     * @param repeatType 繰り返し実行タイプ 0:フォーム要素, 1:確認時添付
     * @param repeatFormId 繰り返し実行対象の表のフォームID
     * @param rowNo 繰り返し実行対象の行番号
     * @throws JsonProcessingException
     * @throws JsonMappingException
     * @throws SQLException
     * @throws TempFileException
     */
    private void __setFileValue(
        JsonNode param, ParamValue paramValue,
        int repeatType, String repeatFormId, int rowNo) throws SQLException, TempFileException {
        int valueKbn = Integer.parseInt(__getJsonNode(param, "paramValue").asText());
        String formId = null;

        //入力値は存在しないためnullとする
        paramValue.setParamValue(null);
        if (Integer.parseInt(__getJsonNode(
            param, "paramKbn").asText()) == RngConst.API_PARAMKBN_FORM) {
            formId = __getJsonNode(param, "paramFormId").asText();
        }
        String paramType = paramValue.getParamType();
        Set<String> repeatChildForm =
            repeatChildFormMap__.getOrDefault(repeatFormId, new HashSet<>());
        List<CmnBinfModel> tempList = paramValue.getTempFile();
        if (StringUtil.isNullZeroString(formId)) {
            if (repeatType == 1 && rowNo > -1) {
                tempList.add(kakuninTempList__.get(rowNo));
            } else {
                tempList.addAll(kakuninTempList__);
            }
        } else if (Objects.equals(repeatFormId, formId)) {
            tempList.add(formTempList__.get(rowNo));
            paramValue.setTempFile(tempList);
            return;
        } else {
            Map<Integer, List<String>> formValue = formValueMap__.get(formId);
            if (formValue == null || formValue.isEmpty()) {
                paramValue.setTempFile(tempList);
                return;
            }
            int paramIndex = Integer.parseInt(__getJsonNode(param, "paramIndex").asText());
            List<String> inputValueList = new ArrayList<>();
            if (repeatChildForm.contains(formId)) {
                //繰り返し実行の対象の表の中にファイル添付フォームがある場合
                if (formValue.get(rowNo) == null
                    || formValue.get(rowNo).isEmpty()) {
                    return;
                }
                inputValueList = formValue.get(rowNo);
            } else if (paramIndex == 1) {
                inputValueList = formValue.get(0);
            } else if (paramIndex == 2) {
                inputValueList = formValue.get(formValue.size() - 1);
            } else {
                for (Entry<Integer, List<String>> entry: formValue.entrySet()) {
                    inputValueList.addAll(entry.getValue());
                }
            }

            for (CmnBinfModel formTempMdl : formTempList__) {
                if (inputValueList.contains(String.valueOf(formTempMdl.getBinSid()))) {
                    tempList.add(formTempMdl);
                }
            }
        }
        if (!tempList.isEmpty()) {
            tempList = tempList.stream()
            .sorted(Comparator.comparing(mdl -> mdl.getBinFileName().toLowerCase()))
            .collect(Collectors.toList());

            switch (valueKbn) {
                case RngConst.API_PARAMVALUE_FILE:
                    paramValue.setTempFile(tempList);
                    break;
                case RngConst.API_PARAMVALUE_FILE_FIRST:
                    paramValue.setTempFile(
                        Arrays.asList(new CmnBinfModel[] {tempList.get(0)}));
                    break;
                case RngConst.API_PARAMVALUE_FILE_LAST:
                    paramValue.setTempFile(Arrays.asList(
                        new CmnBinfModel[] {tempList.get(tempList.size() - 1)}));
                    break;
                //フォーム要素の添付ファイルの場合
                default:
                    if (Objects.equals(paramType, "list")) {
                        paramValue.setTempFile(tempList);
                    } else {
                        paramValue.setTempFile(
                            Arrays.asList(new CmnBinfModel[] {tempList.get(0)}));
                    }
                    break;
            }
        }
    }

    /**
     * <br>[機  能] パラメータJSONから値を取得します
     * <br>[解  説]
     * <br>[備  考] 単体パラメータであっても要素数が1のList<String>で返します
     * @param paramInfo パラメータJSON
     * @param paramType パラメータ区分 "parameter", "list"
     * @param repeatFormId 繰り返し実行対象の表のフォームID
     * @param rowNo 繰り返し実行対象の行番号
     * @return パラメータの値
     * @throws SQLException
     */
    private List<String> __getParamValue(
        JsonNode paramInfo, String paramType, String repeatFormId, int rowNo)
        throws SQLException {

        List<String> textList = new ArrayList<>();
        int paramKbn = Integer.parseInt(__getJsonNode(paramInfo, "paramKbn").asText());
        switch (paramKbn) {
            case RngConst.API_PARAMKBN_FORM:
                String paramFormId = __getJsonNode(paramInfo, "paramFormId").asText();
                Map<Integer, List<String>> formValue = formValueMap__.get(paramFormId);
                if (formValue == null || formValue.isEmpty()) {
                    break;
                }
                int paramIndex = -1;
                if (paramInfo.get("paramIndex") != null) {
                    paramIndex = Integer.parseInt(paramInfo.get("paramIndex").asText());
                }
                List<List<String>> inputValueList = new ArrayList<>();
                if (repeatChildFormMap__.getOrDefault(
                    repeatFormId, new HashSet<>()).contains(paramFormId)) {
                    //繰り返しの行で、このフォームが未入力の時は値を取得しない
                    if (formValue.get(rowNo) == null
                        || formValue.get(rowNo).isEmpty()) {
                        break;
                    }
                    inputValueList.add(formValue.get(rowNo));
                } else if (paramIndex == 0) {
                    for (Entry<Integer, List<String>> entry : formValue.entrySet()) {
                        inputValueList.add(entry.getValue());
                    }
                } else if (paramIndex == 1 || paramIndex == -1) {
                    inputValueList.add(formValue.get(0));
                } else if (paramIndex == 2) {
                    inputValueList.add(formValue.get(formValue.size() - 1));
                }

                int formType = formTypeMap__.get(paramFormId);
                List<List<String>> usrSidList = new ArrayList<>();
                List<List<String>> grpSidList = new ArrayList<>();
                List<List<String>> checkBoxInputList = new ArrayList<>();
                for (List<String> inputList : inputValueList) {
                    if (formType == 8) {
                        checkBoxInputList.add(inputList);
                        continue;
                    } else if (formType == 11) {
                        usrSidList.add(inputList);
                        continue;
                    } else if (formType == 12) {
                        grpSidList.add(inputList);
                        continue;
                    }
                    for (String inputValue : inputList) {
                        if (Objects.equals(inputValue, "")) {
                            textList.add("");
                            continue;
                        }
                        if (formType == 4) {
                            UDate date = new UDate();
                            date.setZeroDdHhMmSs();
                            date.setDate(inputValue.replaceAll("/", ""));
                            textList.add(__getDateParamValue(paramInfo, date));
                        } else if (formType == 16) {
                            UDate date = new UDate();
                            date.setZeroDdHhMmSs();
                            date.setHour(Integer.parseInt(inputValue.split(":")[0]));
                            date.setMinute(Integer.parseInt(inputValue.split(":")[1]));
                            textList.add(__getDateParamValue(paramInfo, date));
                        } else {
                            textList.add(inputValue);
                        }
                    }
                }

                if (!checkBoxInputList.isEmpty()) {
                    List<String> sortValueList = checkboxSortMap__.get(paramFormId);
                    Map<String, Integer> sortMap = IntStream.range(0, sortValueList.size())
                        .boxed()
                        .collect(Collectors.toMap(
                            sortValueList::get, idx -> idx));
                    //選択肢の順序になるように、入力値を結果に入れていく
                    for (List<String> list : checkBoxInputList) {
                        list = list.stream()
                            .sorted(Comparator.comparingInt(sortMap::get))
                            .collect(Collectors.toList());
                        for (String value : list) {
                            textList.add(value);
                        }
                    }
                }
                if (!usrSidList.isEmpty()) {
                    for (List<String> list : usrSidList) {
                        List<UserValue> addUsrValue = userValueList__.stream()
                            .filter(mdl -> list.contains(
                                String.valueOf(mdl.getUsrmInfMdl().getUsrSid())))
                            .collect(Collectors.toList());
                        if (!addUsrValue.isEmpty()) {
                            if (!Objects.equals(paramType, "list")) {
                                UserValue userValue = addUsrValue.get(0);
                                textList.add(__getUserParamValue(
                                    paramInfo, userValue.getUsrmInfMdl(),
                                    userValue.getUsrmMdl(), userValue.getBelongGroupMdl()));
                            } else {
                                for (UserValue userValue : addUsrValue) {
                                    textList.add(__getUserParamValue(
                                        paramInfo, userValue.getUsrmInfMdl(),
                                        userValue.getUsrmMdl(), userValue.getBelongGroupMdl()));
                                }
                            }
                        }
                    }
                }
                if (!grpSidList.isEmpty()) {
                    for (List<String> list : grpSidList) {
                        List<CmnGroupmModel> addGrpValue = groupValueList__.stream()
                            .filter(mdl -> list.contains(
                                String.valueOf(mdl.getGrpSid())))
                            .collect(Collectors.toList());
                        if (!addGrpValue.isEmpty()) {
                            if (!Objects.equals(paramType, "list")) {
                                CmnGroupmModel groupValue = addGrpValue.get(0);
                                textList.add(__getGroupParamValue(paramInfo, groupValue));
                            } else {
                                for (CmnGroupmModel groupValue : addGrpValue) {
                                    textList.add(__getGroupParamValue(paramInfo, groupValue));
                                }
                            }
                        }
                    }
                }
                break;
            case RngConst.API_PARAMKBN_ADDUSER:
                textList.add(__getUserParamValue(
                    paramInfo, sinseiUsrInfMdl__, sinseiUsrMdl__, groupMdl__));
                break;
            case RngConst.API_PARAMKBN_ADDDATE:
                //申請日時
                textList.add(__getDateParamValue(paramInfo, rngMdl__.getRngAdate()));
                break;
            case RngConst.API_PARAMKBN_LETUSER:
                //承認者
                textList.add(__getUserParamValue(
                    paramInfo, syouninUsrInfMdl__, syouninUsrMdl__, syouninGroupMdl__));
                break;
            case RngConst.API_PARAMKBN_LETDATE:
                //最終承認日時
                textList.add(__getDateParamValue(paramInfo, rngMdl__.getRngEdate()));
                break;
            case RngConst.API_PARAMKBN_RINGIINFO:
                //稟議情報
                textList.add(__getRingiInfoParamValue(paramInfo));
                break;
            case RngConst.API_PARAMKBN_MANUAL:
                //手入力
                textList.add(__getJsonNode(paramInfo, "paramValueManual").asText());
                break;
            default:
                break;
        }

        textList = textList.stream()
            .filter(text -> text != null)
            .collect(Collectors.toList());
        return textList;
    }

    /**
     * <br>[機  能] リクエストボディを作成する際に必要な情報を保持するクラス
     * <br>[解  説]
     * <br>[備  考]
     */
    class ParamValue {
        /** 使用区分 */
        private int useKbn__ = RngConst.API_PARAM_USE;
        /** パラメータ名 */
        private String paramName__ = "";
        /** パラメータタイプ */
        private String paramType__ = "parameter";
        /** パラメータに格納する値 */
        private List<String> paramValue__ = new ArrayList<>();
        /** 子要素の値 */
        private List<ParamValue> childValue__ = new ArrayList<>();
        /** 添付ファイルSID */
        private List<CmnBinfModel> tempFile__ = new ArrayList<>();
        /**
         * @return the useKbn
         */
        public int getUseKbn() {
            return useKbn__;
        }
        /**
         * @param useKbn the useKbn to set
         */
        public void setUseKbn(int useKbn) {
            useKbn__ = useKbn;
        }
        /**
         * @return the paramName
         */
        public String getParamName() {
            return paramName__;
        }
        /**
         * @param paramName the paramName to set
         */
        public void setParamName(String paramName) {
            paramName__ = paramName;
        }
        /**
         * @return the paramType
         */
        public String getParamType() {
            return paramType__;
        }
        /**
         * @param paramType the paramType to set
         */
        public void setParamType(String paramType) {
            paramType__ = paramType;
        }
        /**
         * @return the paramValue
         */
        public List<String> getParamValue() {
            return paramValue__;
        }
        /**
         * @param paramValue the paramValue to set
         */
        public void setParamValue(List<String> paramValue) {
            this.paramValue__ = paramValue;
        }
        /**
         * @return the childValue
         */
        public List<ParamValue> getChildValue() {
            return childValue__;
        }
        /**
         * @param childValue the childValue to set
         */
        public void setChildValue(List<ParamValue> childValue) {
            childValue__ = childValue;
        }
        /**
         * @return the tempFile
         */
        public List<CmnBinfModel> getTempFile() {
            return tempFile__;
        }
        /**
         * @param tempFile the tempFile to set
         */
        public void setTempFile(List<CmnBinfModel> tempFile) {
            this.tempFile__ = tempFile;
        }
    }

    /**
     * <br>[機  能] パラメータJSONから値を取得し、パラメータリストを作成する
     * <br>[解  説]
     * <br>[備  考]
     * @param bodyParamList ボディパラメータtJSON
     * @param repeatType 繰り返し実行タイプ 0:フォーム要素, 1:確認時添付
     * @param repeatFormId 繰り返し実行対象の表のフォームID
     * @param rowNo 繰り返し実行対象の行番号
     * @return パラメータリスト
     * @throws SQLException
     * @throws TempFileException
     */
    private List<ParamValue> __getParamList(
        JsonNode bodyParamList, int repeatType,
        String repeatFormId, int rowNo) throws SQLException, TempFileException {

        List<ParamValue> ret = new ArrayList<>();
        if (bodyParamList == null) {
            return ret;
        }

        int temprowNo = rowNo;
        for (JsonNode bodyParam : bodyParamList) {
            String name = __getJsonNode(bodyParam, "name").asText();
            int useKbn = Integer.parseInt(__getJsonNode(bodyParam, "useKbn").asText());
            ParamValue paramValue = new ParamValue();
            paramValue.setParamName(name);
            paramValue.setUseKbn(useKbn);
            if (useKbn == RngConst.API_PARAM_NOT_USE) {
                //未使用
                ret.add(paramValue);
            }
            String paramType = __getJsonNode(bodyParam, "paramType").asText();
            paramValue.setParamType(paramType);
            JsonNode paramList = __getJsonNode(bodyParam, "paramList");

            List<String> valueList = new ArrayList<>();
            if (Objects.equals(paramType, "parameter")) {
                StringBuilder sb = new StringBuilder();
                boolean isTextFormat = true;
                for (JsonNode param : paramList) {
                    int valueKbn = Integer.parseInt(__getJsonNode(param, "paramValue").asText());
                    String paramFormId = "";
                    if (Integer.parseInt(__getJsonNode(
                        param, "paramKbn").asText()) == RngConst.API_PARAMKBN_FORM) {
                        paramFormId = __getJsonNode(param, "paramFormId").asText();
                    }
                    if (valueKbn == RngConst.API_PARAMVALUE_FILE
                        || valueKbn == RngConst.API_PARAMVALUE_FILE_FIRST
                        || valueKbn == RngConst.API_PARAMVALUE_FILE_LAST
                        || formTypeMap__.getOrDefault(paramFormId, 0) == 15) {
                        //確認時添付 or 添付ファイルフォームを使用する場合
                        __setFileValue(param, paramValue, repeatType, repeatFormId, rowNo);
                        isTextFormat = false;
                    } else {
                        sb.append(__getParamValue(param, paramType, repeatFormId, rowNo).stream()
                            .findFirst().orElse(""));
                    }
                }
                if (isTextFormat) {
                    valueList.add(sb.toString());
                    paramValue.setParamValue(valueList);
                }
                ret.add(paramValue);
            } else if (Objects.equals(paramType, "list")) {
                boolean isTextFormat = true;
                for (JsonNode paramArray : paramList) {
                    List<JsonNode> targetNode = new ArrayList<>();
                    for (JsonNode arrayItem : paramArray) {
                        if (arrayItem.isArray()) {
                            targetNode.add(arrayItem);
                        } else {
                            targetNode.add(paramArray);
                            break;
                        }
                    }
                    for (JsonNode array : targetNode) {
                        List<String> addList = new ArrayList<>();
                        StringBuilder sb = new StringBuilder();
                        boolean addFlg = false;
                        for (JsonNode param : array) {
                            int valueKbn = Integer.parseInt(
                                __getJsonNode(param, "paramValue").asText());
                            String paramFormId = "";
                            if (Integer.parseInt(__getJsonNode(
                                param, "paramKbn").asText()) == RngConst.API_PARAMKBN_FORM) {
                                paramFormId = __getJsonNode(param, "paramFormId").asText();
                            }
                            if (valueKbn == RngConst.API_PARAMVALUE_FILE
                                || valueKbn == RngConst.API_PARAMVALUE_FILE_FIRST
                                || valueKbn == RngConst.API_PARAMVALUE_FILE_LAST
                                || formTypeMap__.getOrDefault(paramFormId, 0) == 15) {
                                __setFileValue(param, paramValue,
                                    repeatType, repeatFormId, temprowNo);
                                isTextFormat = false;
                            } else {
                                if (array.size() == 1) {
                                    addList.addAll(
                                        __getParamValue(param, paramType, repeatFormId, rowNo));
                                } else {
                                    sb.append(__getParamValue(
                                        param, paramType, repeatFormId, rowNo).stream()
                                            .findFirst().orElse(""));
                                    addFlg = true;
                                }
                            }
                        }
                        if (addFlg) {
                            addList.add(sb.toString());
                        }
                        valueList.addAll(addList);
                    }
                }
                if (isTextFormat) {
                    paramValue.setParamValue(valueList);
                }
                ret.add(paramValue);
            } else if (Objects.equals(paramType, "model")) {
                List<ParamValue> childValueList =
                        __getParamList(paramList, repeatType, repeatFormId, rowNo);
                paramValue.setChildValue(childValueList);
                ret.add(paramValue);
            }
        }
        return ret;
    }

    /**
     * <br>[機  能] パラメータJSONから、JSON形式のリクエストボディを取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param paramList パラメータ情報
     * @param body リクエストボディ文字列
     * @return JSON形式のリクエストボディ
     * @throws SQLException SQLException
     * @throws TempFileException
     */
    private String __getJsonBody(
        List<ParamValue> paramList, String body) throws SQLException, TempFileException {

        if (paramList == null || paramList.isEmpty()) {
            body = NullDefault.getString(body, "");
            body = body.replaceAll("\\$\\{.+?\\}", "\"\"");
            return body;
        }

        String apiBody = NullDefault.getString(body, "");
        apiBody = apiBody.replaceAll("\\$\\{.+?\\}", "\"\"");
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode bodyJson;
        try {
            if (mapper.readTree(apiBody) instanceof MissingNode) {
                return body;
            }
            bodyJson = (ObjectNode) mapper.readTree(apiBody);
        } catch (JsonProcessingException e) {
            //連携APIに設定されているJSON文字列が正しくない場合、置き換え前の情報を返す
            return body;
        }
        for (ParamValue paramValue : paramList) {
            String name = paramValue.getParamName();
            if (bodyJson.get(name) == null) {
                //CMN_API_CONNECT_PARAM側にだけ保持している場合は、ボディに含めない
                continue;
            }
            String paramType = paramValue.getParamType();
            int useKbn = paramValue.getUseKbn();
            if (useKbn == RngConst.API_PARAM_NOT_USE) {
                bodyJson.remove(name);
                continue;
            }
            if (Objects.equals(paramType, "parameter")) {
                bodyJson.put(name, paramValue.getParamValue().get(0));
            } else if (Objects.equals(paramType, "list")) {
                ArrayNode arrayNode = mapper.createArrayNode();
                for (String value : paramValue.getParamValue()) {
                    arrayNode.add(value);
                }
                bodyJson.set(name, arrayNode);
            } else if (Objects.equals(paramType, "model")) {
                for (ParamValue childParam : paramValue.getChildValue()) {
                    ObjectNode parentNode = (ObjectNode) bodyJson.get(paramValue.getParamName());
                    if (childParam.getUseKbn() == RngConst.API_PARAM_NOT_USE) {
                        parentNode.remove(childParam.getParamName());
                    }

                    String childParamType = childParam.getParamType();
                    String childParamName = childParam.getParamName();
                    if (parentNode.get(childParamName) == null) {
                        continue;
                    }
                    if (Objects.equals(childParamType, "parameter")) {
                        parentNode.put(childParamName, childParam.getParamValue().get(0));
                    } else if (Objects.equals(childParamType, "list")) {
                        ArrayNode arrayNode = mapper.createArrayNode();
                        for (String value : childParam.getParamValue()) {
                            arrayNode.add(value);
                        }
                        parentNode.set(childParamName, arrayNode);
                    }
                }
            }
        }
        return bodyJson.toPrettyString();
    }

    /**
     * <br>[機  能] パラメータJSONから、XML形式のリクエストボディを取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param paramList パラメータ情報
     * @param body リクエストボディ文字列
     * @return XML形式のリクエストボディ
     * @throws SQLException SQLException
     * @throws TransformerException
     * @throws TempFileException
     */
    private String __getXmlBody(List<ParamValue> paramList, String body)
        throws SQLException, TransformerException, TempFileException {

        body = NullDefault.getString(body, "");
        body = body.replaceAll("\\$\\{.+?\\}", "");
        if (paramList == null || paramList.isEmpty()) {
            return body;
        }

        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        Document doc;
        Element root;
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            body = body.trim();
            InputSource is = new InputSource(new StringReader(body));
            doc = dBuilder.parse(is);
            root = doc.getDocumentElement();
        } catch (ParserConfigurationException | SAXException | IOException e) {
            return body;
        }

        __setXmlBodyParam(paramList, root, doc);

        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        if (!body.contains("<?xml")) {
            transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "yes");
        }
        StringWriter writer = new StringWriter();
        transformer.transform(
            new DOMSource(root), new StreamResult(writer));
        return writer.getBuffer().toString();
    }

    /**
     * <br>[機  能] XMLパラメータに値を設定する
     * <br>[解  説]
     * <br>[備  考]
     * @param paramList パラメータ情報
     * @param root 値を設定するXML情報
     * @param doc ドキュメント
     * @throws ParserConfigurationException
     */
    private void __setXmlBodyParam(
        List<ParamValue> paramList, Element root, Document doc) {

        for (ParamValue paramValue : paramList) {
            String name = paramValue.getParamName();
            if (root.getElementsByTagName(name) == null
                || root.getElementsByTagName(name).getLength() == 0) {
                //CMN_API_CONNECT_PARAM側にないパラメータは含めない
                continue;
            }

            String paramType = paramValue.getParamType();
            int useKbn = paramValue.getUseKbn();
            if (useKbn == RngConst.API_PARAM_NOT_USE) {
                NodeList nodeList =  root.getElementsByTagName(name);
                for (int idx = 0; idx < nodeList.getLength(); idx++) {
                    root.removeChild(nodeList.item(idx));
                }
                continue;
            }

            if (Objects.equals(paramType, "parameter")) {
                Node paramNode = root.getElementsByTagName(name).item(0);
                paramNode.setTextContent(paramValue.getParamValue().get(0));
            } else if (Objects.equals(paramType, "list")) {
                Node paramNode = root.getElementsByTagName(name).item(0);
                Node nextNode = paramNode.getNextSibling();
                boolean isFirst = true;
                List<String> valueList = paramValue.getParamValue();
                if (valueList == null || valueList.isEmpty()) {
                    paramNode.setTextContent("");
                    continue;
                }
                for (String value : valueList) {
                    if (isFirst) {
                        paramNode.setTextContent(value);
                    } else {
                        Element arrayElement = doc.createElement(name);
                        arrayElement.setTextContent(value);
                        if (nextNode != null) {
                            root.insertBefore(arrayElement, nextNode);
                        } else {
                            root.appendChild(arrayElement);
                        }
                    }
                    isFirst = false;
                }
            } else if (Objects.equals(paramType, "model")) {
                List<ParamValue> childParamList = paramValue.getChildValue();
                Element parentElement = (Element) root.getElementsByTagName(name).item(0);
                __setXmlBodyParam(childParamList, parentElement, doc);
            }
        }
    }

    /**
     * <br>[機  能] パラメータJSONから、application/x-www-form-urlencoded形式または手入力形式のリクエストボディを取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param paramList パラメータ情報
     * @param body リクエストボディ文字列
     * @param contentType 4:application/x-www-form-urlencoded形式, 0:手入力形式
     * @return application/x-www-form-urlencoded形式または手入力形式のリクエストボディ
     * @throws SQLException SQLException
     * @throws TransformerException
     * @throws TempFileException
     */
    private String __getNormalBody(List<ParamValue> paramList, String body,
        int contentType) throws SQLException, TransformerException, TempFileException {

        if (paramList == null || paramList.isEmpty()) {
            return body;
        }

        body = NullDefault.getString(body, "");
        for (ParamValue paramValue : paramList) {
            String name = paramValue.getParamName();
            String paramType = paramValue.getParamType();
            int useKbn = paramValue.getUseKbn();
            if (useKbn == RngConst.API_PARAM_NOT_USE) {
                String replaceTarget;
                if (contentType == EnumContentType.APPLICATION_FORM.getValue()) {
                    replaceTarget = name + "=${" + name + "}";
                    if (body.contains("&" + replaceTarget)) {
                        replaceTarget = "&" + replaceTarget;
                    }
                } else {
                    replaceTarget = "${" + name + "}";
                }
                body = body.replace(replaceTarget, "");
                continue;
            }

            if (Objects.equals(paramType, "parameter")) {
                String replaceTarget = "${" + name + "}";
                body = body.replace(replaceTarget, paramValue.getParamValue().get(0));
            } else if (Objects.equals(paramType, "list")) {
                boolean isFirst = true;
                StringBuilder sb = new StringBuilder();
                for (String value : paramValue.getParamValue()) {
                    if (!isFirst) {
                        sb.append("&").append(name).append("=");
                    }
                    sb.append(value);
                    isFirst = false;
                }
                String replaceTarget = "${" + name + "}";
                body = body.replace(replaceTarget, sb.toString());
            }
        }
        //JSON側に存在しないパラメータは空文字として扱う
        body = body.replaceAll("\\$\\{.+?\\}", "");

        return body;
    }

    /**
     * <br>[機  能] パラメータJSONから、application/x-www-form-urlencoded形式または手入力形式のリクエストボディを取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param paramList パラメータ情報
     * @param cacParamList 連携API側に登録されているパラメータ情報
     * @return application/x-www-form-urlencoded形式または手入力形式のリクエストボディ
     * @throws SQLException SQLException
     * @throws TransformerException
     * @throws TempFileException
     */
    private List<HttpPart> __getPartList(
        List<ParamValue> paramList,
        List<CmnApiConnectParamModel> cacParamList)
        throws SQLException, TransformerException, TempFileException {

        List<HttpPart> partList = new ArrayList<>();
        if (cacParamList == null || cacParamList.isEmpty()) {
            return partList;
        }
        if (paramList == null) {
            paramList = new ArrayList<>();
        }
        cacParamList = cacParamList.stream()
            .filter(mdl -> mdl.getCacpKbn() == GSConstCommon.PARAM_KBN_BODY)
            .collect(Collectors.toList());
        ITempFileUtil tempUtil =
            (ITempFileUtil) GroupSession.getContext().get(GSContext.TEMP_FILE_UTIL);
        String appRootPath = (String) GroupSession.getContext().get(GSContext.APP_ROOT_PATH);

        for (CmnApiConnectParamModel cacpMdl : cacParamList) {
            String name = cacpMdl.getCacpName();
            int paramTypeKbn = cacpMdl.getCacpParamType();

            ParamValue paramValue = null;
            if (paramTypeKbn == GSConstCommon.PARAM_TYPE_FILE) {
                paramValue = paramList.stream()
                    .filter(mdl -> mdl.getParamValue() == null)
                    .filter(mdl -> Objects.equals(mdl.getParamName(), name))
                    .findFirst()
                    .orElse(null);
                if (paramValue == null) {
                    //稟議側JSONにファイル形式のパラメータが存在しない場合はリクエストボディから除外
                    continue;
                }
            } else {
                paramValue = paramList.stream()
                    .filter(mdl -> mdl.getParamValue() != null)
                    .filter(mdl -> Objects.equals(mdl.getParamName(), name))
                    .findFirst()
                    .orElse(null);
                if (paramValue == null) {
                    //稟議側JSONにテキスト形式のパラメータが存在しない場合は空文字とする
                    HttpPart part = new HttpPart();
                    part.setParamName(name);
                    part.setStrValue("");
                    partList.add(part);
                    continue;
                }
            }

            int useKbn = paramValue.getUseKbn();
            if (useKbn == RngConst.API_PARAM_NOT_USE) {
                continue;
            }

            //ファイル形式
            if (paramValue.getParamValue() == null) {
                for (CmnBinfModel binMdl : paramValue.getTempFile()) {
                    String filePath = tempUtil.getDownloadFile(binMdl, appRootPath).getPath();
                    HttpPart part = new HttpPart();
                    part.setParamName(name);
                    part.setFile(new File(filePath));
                    String fileName = binMdl.getBinFileName();
                    part.setFileName(fileName);
                    part.setFileContentType(getFileContentType(
                        fileName.substring(fileName.lastIndexOf("."))));
                    partList.add(part);
                }
                continue;
            }

            //テキスト形式
            String paramType = paramValue.getParamType();
            if (Objects.equals(paramType, "parameter")) {
                HttpPart part = new HttpPart();
                part.setParamName(name);
                part.setStrValue(paramValue.getParamValue().get(0));
                partList.add(part);
            } else if (Objects.equals(paramType, "list")) {
                if (paramValue.getParamValue().isEmpty()) {
                    //何も入力されていない時は空文字
                    HttpPart part = new HttpPart();
                    part.setParamName(name);
                    part.setStrValue("");
                    partList.add(part);
                    continue;
                }
                for (String value : paramValue.getParamValue()) {
                    HttpPart part = new HttpPart();
                    part.setParamName(name);
                    part.setStrValue(value);
                    partList.add(part);
                }
            }
        }
        return partList;
    }

    /**
     * <br>[機  能] 設定値区分に1:申請者, 3:承認者が指定されているパラメータJSONから、指定された値を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param paramNode パラメータ情報を保持したJSON配列
     * @param usrInfMdl ユーザ情報
     * @param usrMdl ユーザ情報
     * @param groupMdl ユーザが所属しているグループ情報
     * @return ユーザパラメータの値文字列
     */
    private String __getUserParamValue(
        JsonNode paramNode, CmnUsrmInfModel usrInfMdl,
        CmnUsrmModel usrMdl, CmnGroupmModel groupMdl) {

        int paramValue = Integer.parseInt(__getJsonNode(paramNode, "paramValue").asText());
        try {
            switch (paramValue) {
                case RngConst.API_PARAMVALUE_USER_SID:
                    return String.valueOf(usrInfMdl.getUsrSid());
                case RngConst.API_PARAMVALUE_USER_ID:
                    return usrMdl.getUsrLgid();
                case RngConst.API_PARAMVALUE_USER_SEI:
                    return usrInfMdl.getUsiSei();
                case RngConst.API_PARAMVALUE_USER_MEI:
                    return usrInfMdl.getUsiMei();
                case RngConst.API_PARAMVALUE_USER_SEIMEI:
                    return usrInfMdl.getUsiName();
                case RngConst.API_PARAMVALUE_USER_SEI_KANA:
                    return usrInfMdl.getUsiSeiKn();
                case RngConst.API_PARAMVALUE_USER_MEI_KANA:
                    return usrInfMdl.getUsiMeiKn();
                case RngConst.API_PARAMVALUE_USER_SEIMEI_KANA:
                    return usrInfMdl.getUsiSeiKn() + " " + usrInfMdl.getUsiMeiKn();
                case RngConst.API_PARAMVALUE_SYAIN_NO:
                    return NullDefault.getString(usrInfMdl.getUsiSyainNo(), "");
                case RngConst.API_PARAMVALUE_BELONG_GROUP_SID:
                    return String.valueOf(groupMdl.getGrpSid());
                case RngConst.API_PARAMVALUE_BELONG_GROUP_ID:
                    return groupMdl.getGrpId();
                case RngConst.API_PARAMVALUE_BELONG_GROUP_NAME:
                    return groupMdl.getGrpName();
                case RngConst.API_PARAMVALUE_BELONG_GROUP_NAME_KANA:
                    return NullDefault.getString(groupMdl.getGrpNameKn(), "");
                case RngConst.API_PARAMVALUE_MAILADDRESS1:
                    return NullDefault.getString(usrInfMdl.getUsiMail1(), "");
                case RngConst.API_PARAMVALUE_MAILADDRESS2:
                    return NullDefault.getString(usrInfMdl.getUsiMail2(), "");
                case RngConst.API_PARAMVALUE_MAILADDRESS3:
                    return NullDefault.getString(usrInfMdl.getUsiMail3(), "");
                default:
                    break;
            }
        } catch (NullPointerException e) {
            //稟議承認時には発生し得ない。実行テストにて入力されなかったときは空文字を返す
            return "";
        }
        return "";
    }

    /**
     * <br>[機  能] グループ情報がされているパラメータJSONから、指定された値を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param paramNode パラメータ情報を保持したJSON配列
     * @param groupMdl グループ情報
     * @return グループパラメータの値文字列
     */
    private String __getGroupParamValue(JsonNode paramNode, CmnGroupmModel groupMdl) {

        int paramValue = Integer.parseInt(__getJsonNode(paramNode, "paramValue").asText());
        if (groupMdl == null) {
            //実行テストにて入力されなかったときは空文字を返す
            return "";
        }
        switch (paramValue) {
            case RngConst.API_PARAMVALUE_GROUP_SID:
                return String.valueOf(groupMdl.getGrpSid());
            case RngConst.API_PARAMVALUE_GROUP_ID:
                return groupMdl.getGrpId();
            case RngConst.API_PARAMVALUE_GROUP_NAME:
                return groupMdl.getGrpName();
            case RngConst.API_PARAMVALUE_GROUP_NAME_KANA:
                return groupMdl.getGrpNameKn();
            default:
                break;
        }
        return "";
    }

    /**
     * <br>[機  能] 設定値区分に2:申請日時または4:最終承認日時が指定されているパラメータJSONから、指定された値を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param paramNode パラメータ情報を保持したJSON配列
     * @param date 日時情報
     * @return 日時パラメータの値文字列
     */
    private String __getDateParamValue(
        JsonNode paramNode, UDate date) {

        if (date == null) {
            //実行テストにて入力されなかったときは空文字を返す
            return "";
        }
        int paramValue = Integer.parseInt(__getJsonNode(paramNode, "paramValue").asText());
        RequestModel reqMdl = new RequestModel();
        reqMdl.setDomain(domain__);
        reqMdl.setLocale(Locale.JAPANESE);
        switch (paramValue) {
            case RngConst.API_PARAMVALUE_FULLDATE_SLASH:
                return UDateUtil.getSlashYYMD(date) + " " + UDateUtil.getSeparateHMS(date);
            case RngConst.API_PARAMVALUE_FULLDATE_HYPHEN:
                return UDateUtil.getHyphenYYMD(date) + " " + UDateUtil.getSeparateHMS(date);
            case RngConst.API_PARAMVALUE_FULLDATE_TEXT:
                return UDateUtil.getYymdJ(date, reqMdl)
                    + " " + UDateUtil.getSeparateHMSJ(date, reqMdl);
            case RngConst.API_PARAMVALUE_DATE_SLASH:
                return UDateUtil.getSlashYYMD(date);
            case RngConst.API_PARAMVALUE_DATE_HEPHEN:
                return UDateUtil.getHyphenYYMD(date);
            case RngConst.API_PARAMVALUE_DATE_TEXT:
                return UDateUtil.getYymdJ(date, reqMdl);
            case RngConst.API_PARAMVALUE_FULLTIME_COLON:
                return UDateUtil.getSeparateHMS(date);
            case RngConst.API_PARAMVALUE_FULLTIME_TEXT:
                return UDateUtil.getSeparateHMSJ(date, reqMdl);
            case RngConst.API_PARAMVALUE_HHMM_COLON:
                return UDateUtil.getSeparateHM(date);
            case RngConst.API_PARAMVALUE_HHMM_TEXT:
                return UDateUtil.getSeparateHM(date, reqMdl);
            case RngConst.API_PARAMVALUE_YEAR:
                return date.getStrYear();
            case RngConst.API_PARAMVALUE_MONTH:
                return date.getStrMonth();
            case RngConst.API_PARAMVALUE_DAY:
                return date.getStrDay();
            case RngConst.API_PARAMVALUE_HOUR:
                return date.getStrHour();
            case RngConst.API_PARAMVALUE_MINUTE:
                return date.getStrMinute();
            case RngConst.API_PARAMVALUE_SECOND:
                return date.getStrSecond();
            default:
                break;
        }
        return "";
    }

    /**
     * <br>[機  能] 設定値区分に5:稟議情報が指定されているパラメータJSONから、指定された値を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param paramNode パラメータ情報を保持したJSON配列
     * @return 稟議情報パラメータの値文字列
     * @throws SQLException SQLException
     */
    private String __getRingiInfoParamValue(JsonNode paramNode) throws SQLException {

        int paramValue = Integer.parseInt(__getJsonNode(paramNode, "paramValue").asText());
        switch (paramValue) {
            case RngConst.API_PARAMVALUE_TITLE:
                return rngMdl__.getRngTitle();
            case RngConst.API_PARAMVALUE_SINSEIID:
                return rngMdl__.getRngId();
            default:
                break;
        }
        return "";
    }

    /**
     * <br>[機  能] ファイルのコンテントタイプを取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param extension 拡張子文字列
     * @return コンテントタイプ文字列
     */
    public String getFileContentType(String extension) {
        String type;
        if (extension.equals(".css")) {
            type = "text/css";
        } else if (extension.equals(".csv")) {
            type = "text/csv";
        } else if (extension.equals(".doc")) {
            type = "application/msword";
        } else if (extension.equals(".gif")) {
            type = "image/gif";
        } else if (extension.equals(".html")) {
            type = "text/html";
        } else if (extension.equals(".ico")) {
            type = "image/vnd.microsoft.icon";
        } else if (extension.equals(".jpeg")) {
            type = "image/jpeg";
        } else if (extension.equals(".jpg")) {
            type = "image/jpeg";
        } else if (extension.equals(".js")) {
            type = "text/javascript";
        } else if (extension.equals(".json")) {
            type = "application/json";
        } else if (extension.equals(".png")) {
            type = "image/png";
        } else if (extension.equals(".pdf")) {
            type = "application/pdf";
        } else if (extension.equals(".ppt")) {
            type = "application/vnd.ms-powerpoint";
        } else if (extension.equals(".pptx")) {
            type = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
        } else if (extension.equals(".txt")) {
            type = "text/plain";
        } else if (extension.equals(".xls")) {
            type = "application/vnd.ms-excel";
        } else if (extension.equals(".xlsx")) {
            type = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        } else if (extension.equals(".xml")) {
            type = "text/xml";
        } else if (extension.equals(".zip")) {
            type = "application/zip";
        } else {
            type = "application/octet-stream";
        }
        return type;
    }

    /**
     * <br>[機  能] 決裁後アクションの実行結果をオペレーションログに出力する
     * <br>[解  説]
     * <br>[備  考]
     * @param apiResult 決裁後アクションの実行結果
     * @param rtpaMdl 稟議テンプレートアクション情報
     * @param doCount 実行回数
     * @param resultSortNo 何回目の実行か (1から始まる連番値)
     * @throws Exception
     * @throws SQLException
     * @throws DBConnectionException
     */
    private void __insertOperationLog(
        ApiResult apiResult, RngTemplateActionModel rtpaMdl, int doCount, int resultSortNo)
        throws DBConnectionException, SQLException, Exception {

        RequestModel reqMdl = new RequestModel();
        reqMdl.setDomain(domain__);
        reqMdl.setLocale(Locale.JAPANESE);
        Connection con = null;
        try {
            con = GroupSession.getConnection(reqMdl.getDomain(), 1000);

            RngBiz rngBiz = new RngBiz(con);
            GsMessage gsMsg = new GsMessage(reqMdl);
            ActionMapping map = new ActionMapping();
            map.setType("jp.groupsession.v2.rng.rng030.Rng030Action");
            StringBuilder sb = new StringBuilder();
            sb.append("[" + gsMsg.getMessage("rng.62") + gsMsg.getMessage("cmn.name3") + "]");
            sb.append("\r\n");
            sb.append(rngMdl__.getRngTitle());
            sb.append("\r\n");
            sb.append("[" + gsMsg.getMessage("rng.47") + "]");
            sb.append("\r\n");
            sb.append(sinseiUsrInfMdl__.getUsiName());
            sb.append("\r\n");
            sb.append("[" + "決裁後アクション" + "]");
            sb.append("\r\n");
            sb.append(rtpaMdl.getRtpaName());
            sb.append("\r\n");
            sb.append("[" + gsMsg.getMessage("cmn.run")
                + gsMsg.getMessage("cmn.results") + "]");
            sb.append("\r\n");

            RngActionResultModel rarMdl = new RngActionResultModel();
            rarMdl.setRngSid(rngMdl__.getRngSid());
            rarMdl.setRarsSort(resultSortNo);
            rarMdl.setRarsName(rtpaMdl.getRtpaName());
            if (apiResult.isSuccess()) {
                rarMdl.setRarsStatus(0);
                sb.append(gsMsg.getMessage("cmn.success"));
            } else {
                rarMdl.setRarsStatus(1);
                sb.append(gsMsg.getMessage("cmn.failure"));
            }
            //決裁後アクション実行結果情報の登録
            RngActionResultDao rarDao = new RngActionResultDao(con);
            rarDao.insert(rarMdl);

            //繰り返し実行の結果
            if (rtpaMdl.getRtpaRepeatKbn() == 1) {
                List<RngActionResultDataModel> rardMdlList = new ArrayList<>();
                sb.append("\r\n");
                int count = 1;
                if (!apiResult.getRepeatFormResultMap().isEmpty()) {
                    //フォームで繰り返し実行
                    for (Entry<Integer, Boolean> formResult
                        : apiResult.getRepeatFormResultMap().entrySet()) {
                        RngActionResultDataModel rardMdl = new RngActionResultDataModel();
                        rardMdl.setRngSid(rngMdl__.getRngSid());
                        rardMdl.setRarsSort(resultSortNo);
                        rardMdl.setRardCount(count);

                        boolean result = formResult.getValue();
                        if (result) {
                            rardMdl.setRardStatus(0);
                        } else {
                            rardMdl.setRardStatus(1);
                            String rowNoStr = String.valueOf(formResult.getKey());
                            sb.append("・" + gsMsg.getMessage(
                                "cmn.line", new String[]{rowNoStr}));
                            sb.append("\r\n");
                        }
                        count++;
                        rardMdlList.add(rardMdl);
                    }
                } else {
                    for (SimpleEntry<String, Boolean> fileResult
                        : apiResult.getRepeatFileResultList()) {
                        RngActionResultDataModel rardMdl = new RngActionResultDataModel();
                        rardMdl.setRngSid(rngMdl__.getRngSid());
                        rardMdl.setRarsSort(resultSortNo);
                        rardMdl.setRardCount(count);
                        boolean result = fileResult.getValue();
                        if (result) {
                            rardMdl.setRardStatus(0);
                        } else {
                            rardMdl.setRardStatus(1);
                            String fileName = String.valueOf(fileResult.getKey());
                            sb.append("・" + fileName);
                            sb.append("\r\n");
                        }
                        count++;
                        rardMdlList.add(rardMdl);
                    }
                }
                RngActionResultDataDao rardDao = new RngActionResultDataDao(con);
                rardDao.insert(rardMdlList);
            }

            String logLevel;
            if (apiResult.isSuccess()) {
                logLevel = GSConstLog.LEVEL_TRACE;
            } else {
                logLevel = GSConstLog.LEVEL_WARN;
            }
            rngBiz.outPutLog(map, gsMsg.getMessage("rng.approval.action"),
                logLevel, sb.toString(), reqMdl);

            con.commit();
        } finally {
            if (con != null) {
                //オペレーションログの登録が終わった時点でコネクションを破棄
                JDBCUtil.closeConnection(con);
                con = null;
            }
        }
    }

    /**
     * <br>[機  能] 入力必須のパラメータに値が入っているかを確認する
     * <br>[解  説]
     * <br>[備  考]
     * @param isSuccess APIの実行に成功したか true:成功, false:失敗
     * @param rtpaMdl 稟議テンプレートアクション情報
     * @param rowNo 繰り返し実行の行番号
     * @param repeatFormResultMap フォーム要素で繰り返し実行時の実行結果
     * @param repeatFileResultList 添付要素または確認時添付で繰り返し実行時の実行結果
     */
    private void __setResultMap(boolean isSuccess, RngTemplateActionModel rtpaMdl,
        int rowNo, Map<Integer, Boolean> repeatFormResultMap,
        List<SimpleEntry<String, Boolean>> repeatFileResultList) {

        String repeatFormId = rtpaMdl.getRftId();
        if (rtpaMdl.getRtpaRepeatKbn() == 1) {
            if (rtpaMdl.getRtpaRepeatType() == 0
                && formTypeMap__.get(repeatFormId) != 15) {
                //添付ファイル以外のフォーム要素
                //rowNoには0から始まる行番号が入っているため +1する
                repeatFormResultMap.put(rowNo + 1, isSuccess);
            } else if (rtpaMdl.getRtpaRepeatType() == 1) {
                //確認時添付の繰り返し処理
                CmnBinfModel tempMdl = kakuninTempList__.get(rowNo);
                repeatFileResultList.add(
                    new SimpleEntry<String, Boolean>(tempMdl.getBinFileName(), isSuccess));
            } else {
                //添付ファイルフォームの添付ファイルで繰り返し
                List<String> binSid = formValueMap__
                    .getOrDefault(repeatFormId, new HashMap<>())
                    .getOrDefault(rowNo, new ArrayList<>());
                StringBuilder tempNameSb = new StringBuilder();
                boolean isFirst = true;
                for (CmnBinfModel binMdl : formTempList__) {
                    if (isFirst) {
                        tempNameSb.append(", ");
                    }
                    if (binSid.contains(String.valueOf(binMdl.getBinSid()))) {
                        tempNameSb.append(binMdl.getBinFileName());
                    }
                }
                repeatFileResultList.add(
                    new SimpleEntry<String, Boolean>(
                        formTempList__.get(rowNo).getBinFileName(), isSuccess));
            }
        }
    }

    /**
     * <br>[機  能] 入力された情報から実行テストに必要なリクエスト情報を返す
     * <br>[解  説]
     * <br>[備  考]
     * @param con コネクション
     * @param reqMdl リクエスト情報
     * @param rtpaMdl 決裁後アクション
     * @param allParamList アクションパラメータ一覧
     * @param formList フォーム情報一覧
     * @param formTypeMap 各フォームのタイプを格納したマップ
     * @param repeatChildFormMap 繰り返し実行が有効になっている表の中の子要素フォームIDマップ
     * @return 実行テストに必要なリクエスト情報
     * @throws SQLException
     * @throws EncryptionException
     * @throws IOException
     * @throws InterruptedException
     * @throws TransformerException
     * @throws TempFileException
     */
    public List<ApiExecuter> getTestApiExecuter(
        Connection con,
        RequestModel reqMdl,
        RngTemplateActionModel rtpaMdl,
        List<RngActionparamModel> allParamList,
        List<RngFormdataModel> formList,
        Map<String, Integer> formTypeMap,
        Map<String, Set<String>> repeatChildFormMap)
        throws SQLException, EncryptionException,
            IOException, InterruptedException,
            TransformerException, TempFileException, IOToolsException {

        RngTemplateActionFileBiz fileBiz = new RngTemplateActionFileBiz(reqMdl);
        LinkedList<AddRngActionModel> checkActionModelList = fileBiz.getActionModelList();

        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(templateModel__.getRtpForm());
        Set<String> repeatFormIdSet = new HashSet<>();
        if (rtpaMdl.getRtpaRepeatType() == RngConst.API_REPEAT_KBN_ON
            && rtpaMdl.getRtpaRepeatType() == RngConst.API_REPEAT_TYPE_FORM) {
            repeatFormIdSet.add(rtpaMdl.getRftId());
        }
        __setTemplateInfo(node, repeatFormIdSet);

        List<RngTemplateActionModel> rtpaMdlList = new ArrayList<>();
        rtpaMdlList.add(rtpaMdl);

        ExecuteTargetApiInfo apiTarget = __getExecuteTarget(
            con, rtpaMdlList, allParamList,
            formList, formTypeMap, repeatChildFormMap, checkActionModelList);

        Map<Integer, Map<Integer, List<Integer>>> matchConditionParamMap
            = apiTarget.getMatchConditionParamMap();
        Map<Integer, RngActionparamModel> actionParamMap =  apiTarget.getActionParamList().stream()
            .collect(
                Collectors.toMap(
                    mdl -> mdl.getRapSid(),
                    mdl -> mdl,
                    (mdl1, mdl2) -> mdl2
                )
            );

        Map<Integer, CmnApiConnectModel> cacMap = apiTarget.getCacList().stream()
            .collect(
                Collectors.toMap(
                    mdl -> mdl.getCacSid(),
                    mdl -> mdl,
                    (mdl1, mdl2) -> mdl2)
            );
        Map<Integer, List<CmnApiConnectParamModel>> cacpMap = apiTarget.getCacParamList().stream()
            .collect(
                Collectors.groupingBy(
                    CmnApiConnectParamModel::getCacSid,
                    Collectors.mapping(mdl -> mdl, Collectors.toList())
                )
            );
        Map<Integer, List<CmnApiConnectHeaderModel>> headerMap = apiTarget.getHeaderList().stream()
            .collect(
                Collectors.groupingBy(
                    CmnApiConnectHeaderModel::getCacSid,
                    Collectors.mapping(mdl -> mdl, Collectors.toList())
                )
            );

        //連携APIの実行
        List<ApiExecuter> ret = new ArrayList<>();
        if (matchConditionParamMap.getOrDefault(rtpaMdl.getRtpaSid(), new HashMap<>()).isEmpty()) {
            return ret;
        }

        int cacSid = rtpaMdl.getCacSid();

        for (Entry<Integer, List<Integer>> idxEntry
            : matchConditionParamMap.get(rtpaMdl.getRtpaSid()).entrySet()) {
            int actionParamSid = idxEntry.getKey();
            RngActionparamModel actionParam = actionParamMap.get(actionParamSid);
            //実行対象の行番号(繰り返し実行ではないときは、-1のみが入る)
            List<Integer> rowNoList = idxEntry.getValue();
            List<CmnApiConnectParamModel> cacpList =
                cacpMap.getOrDefault(cacSid, new ArrayList<>()).stream()
                .filter(mdl -> mdl.getCacpKbn() == GSConstCommon.PARAM_KBN_BODY)
                .collect(Collectors.toList());
            ret.addAll(
                getApiExecuter(
                    rtpaMdl, actionParam, rowNoList,
                    cacMap.get(cacSid), cacpList, headerMap.get(cacSid)));
        }
        return ret;
    }

    /**
     * <br>[機  能] 要素名を指定し、JsonNodeから子要素を取得する
     * <br>[解  説]
     * <br>[備  考] 指定した要素が存在しなかったときに、例外を返す
     * @param node 親JSON
     * @param paramName 取得する子要素パラメータ名
     * @return 指定した子要素のJsonNode
     * @throws Exception
     */
    private JsonNode __getJsonNode(
        JsonNode node, String paramName) throws RngApiJsonFormatException {

        JsonNode ret = node.get(paramName);
        if (ret == null) {
            throw new RngApiJsonFormatException("連携API実行に使用されるJson文字列が意図していないフォーマットになっています。");
        }

        return ret;
    }
}