package jp.groupsession.v2.rng.apiconnect;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;
import jp.groupsession.v2.cmn.GSConst;

/**
 * <br>[機  能] 稟議承認時に実際にAPIを実行するスレッド
 * <br>[解  説]
 * <br>[備  考] ドメインごとに最大3つまでこのスレッドが作成されます
 *
 * @author JTS
 */
public class RngApiExecuteThread extends Thread {


    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(RngApiExecuteThread.class);
    /** リクエストモデル */
    private String domain__ = null;
    /** 稟議SID */
    private int rngSid__ = -1;

    /**
     * <br>[機  能] デフォルトコンストラクタ
     * <br>[解  説]
     * <br>[備  考]
     * @param domain ドメイン
     * @param rngSid 稟議SID
     */
    public RngApiExecuteThread(String domain, int rngSid) {
        domain__ = domain;
        rngSid__ = rngSid;
    }

    /**
     * <br>[機  能] API実行用スレッド処理
     * <br>[解  説] 実行予約リストから稟議SIDを取得し、実行スレッドにて連携APIを実行する
     * <br>[備  考]
     */
    public void run() {
        log__.info("稟議決裁時のAPI実行用スレッド処理開始"
            + " 稟議SID:" + rngSid__
            + " ドメイン:" + domain__
            + " スレッドID:" + Thread.currentThread().getId());
        try {
            ThreadContext.put(GSConst.KEY_LOGTHREADSTRAGE_DOMAIN, domain__);

            //スレッド名の設定
            Thread.currentThread().setName("RngApiExecuteThread"
                                            + "-" + System.currentTimeMillis()
                                            + "-" + domain__
                                            + "-" + Thread.currentThread().getId());
            RngApiExecuteBiz apiBiz = new RngApiExecuteBiz(domain__);
            
            apiBiz.doApi(rngSid__);
        } catch (Exception e) {
            log__.warn("稟議承認時のAPI実行時にシステムエラーが発生しました。\r\n", e);
        } finally {
            try {
                //スレッド名に"END-"を設定する
                Thread.currentThread().setName(
                        "END-" + Thread.currentThread().getName());
            } catch (Throwable e) {
            }
            synchronized (RngApiDomainThread.getDomainThreadCount()) {
                int threadCount =
                    RngApiDomainThread.getDomainThreadCount().getOrDefault(domain__, 0);
                threadCount--;
                RngApiDomainThread.getDomainThreadCount().put(domain__, threadCount);
            }
            synchronized (RngApiDomainThread.getDomainEndCount()) {
                int endCount =
                    RngApiDomainThread.getDomainEndCount().getOrDefault(domain__, 0);
                endCount++;
                RngApiDomainThread.getDomainEndCount().put(domain__, endCount);
            }
            log__.info("稟議決裁時のAPI実行用スレッド処理終了"
                + " 稟議SID:" + rngSid__
                + " ドメイン:" + domain__
                + " スレッドID:" + Thread.currentThread().getId());
        }
    }
}
