package jp.groupsession.v2.rng.apiconnect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.groupsession.v2.cmn.model.RequestModel;

/**
 * <br>[機  能] 稟議承認時のAPI用ドメインスレッドを操作するビジネスロジック
 * <br>[解  説] 承認された稟議をドメインごとに蓄え、API実行用のドメインスレッドを立ち上げる
 * <br>[備  考] APIの実行は、RngApiExecuteThread内のAPI実行ビジネスロジックで行う
 *
 * @author  JTS
 */
public class RngApiThreadBiz {

    /** ログ */
    private static Log log__ = LogFactory.getLog(RngApiThreadBiz.class);

    /** 連携API実行 キー：ドメイン，値：稟議SIDリストを格納したマップ */
    private static Map<String, List<Integer>> domainApiMap__ = new HashMap<>();
    /** 連携API実行 キー：ドメイン, 値：ドメインスレッドを格納したマップ */
    private static Map<String, RngApiDomainThread> domainThreadMap__ = new HashMap<>();
    /** 連携API実行 順番待ちのドメイン(順序を保持します) */
    private static Set<String> waitApiDomainSet__ = new LinkedHashSet<>();
    /**
     * @return the domainApiMap__
     */
    public static Map<String, List<Integer>> getDomainApiMap() {
        return domainApiMap__;
    }
    /**
     * @return the domainThreadMap__
     */
    public static Map<String, RngApiDomainThread> getDomainThreadMap() {
        return domainThreadMap__;
    }
    /**
     * @return the waitApiDomainSet__
     */
    public static Set<String> getWaitApiDomainSet() {
        return waitApiDomainSet__;
    }

    /**
     * <br>[機  能] コンストラクタ
     * <br>[解  説]
     * <br>[備  考]
     * @param reqMdl リクエストモデル
     * @param rngSid 稟議SID
     */
    public static void operateDomainThread(RequestModel reqMdl, int rngSid) {

        String domain = reqMdl.getDomain();
        synchronized (domainApiMap__) {
            List<Integer> rngSidList =
                domainApiMap__.getOrDefault(domain, new ArrayList<>());
            if (rngSidList.size() < 100) {
                log__.info("ドメイン：" + domain + "にて、稟議SID:" + rngSid + "を実行対象に追加");
                rngSidList.add(rngSid);
                domainApiMap__.put(domain, rngSidList);
            }
        }
        RngApiDomainThread domainThread = null;
        synchronized (domainThreadMap__) {
            domainThread = domainThreadMap__.get(domain);
            if (domainThread == null) {
                if (domainThreadMap__.size() < 3) {
                    //ドメインスレッドを立ち上げ
                    log__.info("ドメインスレッドを作成 domain:" + domain);
                    domainThread = new RngApiDomainThread(domain);
                    domainThreadMap__.put(domain, domainThread);
                    domainThread.start();
                } else {
                    //ドメインスレッドが3つ立ち上がっているときは、順番待ちに追加
                    log__.info("ドメインスレッドが既に3つ立ち上がっているため、ドメインスレッドの作成を保留 domain:" + domain);
                    waitApiDomainSet__.add(domain);
                }
            }
        }
    }
}
