package jp.groupsession.v2.rng.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.co.sjts.util.dao.AbstractDao;
import jp.co.sjts.util.jdbc.SqlBuffer;
import jp.groupsession.v2.rng.model.RngActionResultModel;

/**
 * <p>RNG_ACTION_RESULT Data Access Object
 *
 * @author JTS DaoGenerator version 0.5
 */
public class RngActionResultDao extends AbstractDao {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(RngActionResultDao.class);

    /**
     * <p>Default Constructor
     */
    public RngActionResultDao() {
    }

    /**
     * <p>Set Connection
     * @param con Connection
     */
    public RngActionResultDao(Connection con) {
        super(con);
    }

    /**
     * <p>Drop Table
     * @throws SQLException SQL実行例外
     */
    public void dropTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql("drop table RNG_ACTION_RESULT");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Create Table
     * @throws SQLException SQL実行例外
     */
    public void createTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" create table RNG_ACTION_RESULT (");
            sql.addSql("   RNG_SID integer not null,");
            sql.addSql("   RARS_SORT integer not null,");
            sql.addSql("   RARS_NAME varchar(100) not null,");
            sql.addSql("   RARS_STATUS integer not null,");
            sql.addSql("   primary key (RNG_SID,RARS_SORT)");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Insert RNG_ACTION_RESULT Data Bindding JavaBean
     * @param bean RNG_ACTION_RESULT Data Bindding JavaBean
     * @throws SQLException SQL実行例外
     */
    public void insert(RngActionResultModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" insert ");
            sql.addSql(" into ");
            sql.addSql(" RNG_ACTION_RESULT(");
            sql.addSql("   RNG_SID,");
            sql.addSql("   RARS_SORT,");
            sql.addSql("   RARS_NAME,");
            sql.addSql("   RARS_STATUS");
            sql.addSql(" )");
            sql.addSql(" values");
            sql.addSql(" (");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(bean.getRngSid());
            sql.addIntValue(bean.getRarsSort());
            sql.addStrValue(bean.getRarsName());
            sql.addIntValue(bean.getRarsStatus());
            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Update RNG_ACTION_RESULT Data Bindding JavaBean
     * @param bean RNG_ACTION_RESULT Data Bindding JavaBean
     * @return 更新件数
     * @throws SQLException SQL実行例外
     */
    public int update(RngActionResultModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" update");
            sql.addSql("   RNG_ACTION_RESULT");
            sql.addSql(" set ");
            sql.addSql("   RARS_NAME=?,");
            sql.addSql("   RARS_STATUS=?");
            sql.addSql(" where ");
            sql.addSql("   RNG_SID=?");
            sql.addSql(" and");
            sql.addSql("   RARS_SORT=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addStrValue(bean.getRarsName());
            sql.addIntValue(bean.getRarsStatus());
            //where
            sql.addIntValue(bean.getRngSid());
            sql.addIntValue(bean.getRarsSort());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Select RNG_ACTION_RESULT All Data
     * @return List in RNG_ACTION_RESULTModel
     * @throws SQLException SQL実行例外
     */
    public List<RngActionResultModel> select() throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<RngActionResultModel> ret = new ArrayList<>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   RNG_SID,");
            sql.addSql("   RARS_SORT,");
            sql.addSql("   RARS_NAME,");
            sql.addSql("   RARS_STATUS");
            sql.addSql(" from ");
            sql.addSql("   RNG_ACTION_RESULT");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getRngActionResultFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <br>[機  能] 稟議SIDを指定し、ソート順に実行結果一覧を取得します
     * <br>[解  説]
     * <br>[備  考]
     * @param rngSid RNG_SID
     * @return RNG_ACTION_RESULTModel
     * @throws SQLException SQL実行例外
     */
    public List<RngActionResultModel> select(int rngSid) throws SQLException {

        List<RngActionResultModel> ret = new ArrayList<>();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   RNG_SID,");
            sql.addSql("   RARS_SORT,");
            sql.addSql("   RARS_NAME,");
            sql.addSql("   RARS_STATUS");
            sql.addSql(" from");
            sql.addSql("   RNG_ACTION_RESULT");
            sql.addSql(" where ");
            sql.addSql("   RNG_SID=?");
            sql.addSql(" order by ");
            sql.addSql("   RARS_SORT");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(rngSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getRngActionResultFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Select RNG_ACTION_RESULT
     * @param rngSid RNG_SID
     * @param rarsSort RARS_SORT
     * @return RNG_ACTION_RESULTModel
     * @throws SQLException SQL実行例外
     */
    public RngActionResultModel select(int rngSid, int rarsSort) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        RngActionResultModel ret = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   RNG_SID,");
            sql.addSql("   RARS_SORT,");
            sql.addSql("   RARS_NAME,");
            sql.addSql("   RARS_STATUS");
            sql.addSql(" from");
            sql.addSql("   RNG_ACTION_RESULT");
            sql.addSql(" where ");
            sql.addSql("   RNG_SID=?");
            sql.addSql(" and");
            sql.addSql("   RARS_SORT=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(rngSid);
            sql.addIntValue(rarsSort);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ret = __getRngActionResultFromRs(rs);
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Delete RNG_ACTION_RESULT
     * @param rngSid RNG_SID
     * @return 削除件数
     * @throws SQLException SQL実行例外
     */
    public int delete(int rngSid) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   RNG_ACTION_RESULT");
            sql.addSql(" where ");
            sql.addSql("   RNG_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(rngSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Delete RNG_ACTION_RESULT
     * @param rngSid RNG_SID
     * @param rarsSort RARS_SORT
     * @return 削除件数
     * @throws SQLException SQL実行例外
     */
    public int delete(int rngSid, int rarsSort) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   RNG_ACTION_RESULT");
            sql.addSql(" where ");
            sql.addSql("   RNG_SID=?");
            sql.addSql(" and");
            sql.addSql("   RARS_SORT=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(rngSid);
            sql.addIntValue(rarsSort);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Create RNG_ACTION_RESULT Data Bindding JavaBean From ResultSet
     * @param rs ResultSet
     * @return created RngActionResultModel
     * @throws SQLException SQL実行例外
     */
    private RngActionResultModel __getRngActionResultFromRs(ResultSet rs) throws SQLException {
        RngActionResultModel bean = new RngActionResultModel();
        bean.setRngSid(rs.getInt("RNG_SID"));
        bean.setRarsSort(rs.getInt("RARS_SORT"));
        bean.setRarsName(rs.getString("RARS_NAME"));
        bean.setRarsStatus(rs.getInt("RARS_STATUS"));
        return bean;
    }
}
