package jp.groupsession.v2.rng.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.ArrayList;
import java.util.Arrays;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.co.sjts.util.dao.AbstractDao;
import jp.co.sjts.util.jdbc.SqlBuffer;
import jp.groupsession.v2.rng.model.RngActionResultDataModel;

/**
 * <p>RNG_ACTION_RESULT_DATA Data Access Object
 *
 * @author JTS DaoGenerator version 0.5
 */
public class RngActionResultDataDao extends AbstractDao {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(RngActionResultDataDao.class);

    /**
     * <p>Default Constructor
     */
    public RngActionResultDataDao() {
    }

    /**
     * <p>Set Connection
     * @param con Connection
     */
    public RngActionResultDataDao(Connection con) {
        super(con);
    }

    /**
     * <p>Drop Table
     * @throws SQLException SQL実行例外
     */
    public void dropTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql("drop table RNG_ACTION_RESULT_DATA");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Create Table
     * @throws SQLException SQL実行例外
     */
    public void createTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" create table RNG_ACTION_RESULT_DATA (");
            sql.addSql("   RNG_SID integer not null,");
            sql.addSql("   RARS_SORT integer not null,");
            sql.addSql("   RARD_COUNT integer not null,");
            sql.addSql("   RARD_STATUS integer not null,");
            sql.addSql("   primary key (RNG_SID,RARS_SORT,RARD_COUNT)");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Insert RNG_ACTION_RESULT_DATA Data Bindding JavaBean
     * @param bean RNG_ACTION_RESULT_DATA Data Bindding JavaBean
     * @throws SQLException SQL実行例外
     */
    public void insert(RngActionResultDataModel bean) throws SQLException {

        List<RngActionResultDataModel> beanList = Arrays.asList(bean);
        insert(beanList);
    }

    /**
     * <p>Insert RNG_ACTION_RESULT_DATA Data Bindding JavaBean
     * @param beanList RNG_ACTION_RESULT_DATA Data Bindding JavaBean
     * @throws SQLException SQL実行例外
     */
    public void insert(List<RngActionResultDataModel> beanList) throws SQLException {

        if (beanList == null || beanList.isEmpty()) {
            return;
        }
        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();
        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" insert ");
            sql.addSql(" into ");
            sql.addSql(" RNG_ACTION_RESULT_DATA(");
            sql.addSql("   RNG_SID,");
            sql.addSql("   RARS_SORT,");
            sql.addSql("   RARD_COUNT,");
            sql.addSql("   RARD_STATUS");
            sql.addSql(" )");
            sql.addSql(" values");
            sql.addSql(" (");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?");
            sql.addSql(" )");
            pstmt = con.prepareStatement(sql.toSqlString());
            for (int idx = 0; idx < beanList.size(); idx++) {
                RngActionResultDataModel bean = beanList.get(idx);
                sql.addIntValue(bean.getRngSid());
                sql.addIntValue(bean.getRarsSort());
                sql.addIntValue(bean.getRardCount());
                sql.addIntValue(bean.getRardStatus());
                log__.info(sql.toLogString());
                sql.setParameter(pstmt);
                pstmt.executeUpdate();
                sql.clearValue();
            }
            
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Update RNG_ACTION_RESULT_DATA Data Bindding JavaBean
     * @param bean RNG_ACTION_RESULT_DATA Data Bindding JavaBean
     * @return 更新件数
     * @throws SQLException SQL実行例外
     */
    public int update(RngActionResultDataModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" update");
            sql.addSql("   RNG_ACTION_RESULT_DATA");
            sql.addSql(" set ");
            sql.addSql("   RARD_STATUS=?");
            sql.addSql(" where ");
            sql.addSql("   RNG_SID=?");
            sql.addSql(" and");
            sql.addSql("   RARS_SORT=?");
            sql.addSql(" and");
            sql.addSql("   RARD_COUNT=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(bean.getRardStatus());
            //where
            sql.addIntValue(bean.getRngSid());
            sql.addIntValue(bean.getRarsSort());
            sql.addIntValue(bean.getRardCount());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Select RNG_ACTION_RESULT_DATA All Data
     * @return List in RNG_ACTION_RESULT_DATAModel
     * @throws SQLException SQL実行例外
     */
    public List<RngActionResultDataModel> select() throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<RngActionResultDataModel> ret = new ArrayList<>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   RNG_SID,");
            sql.addSql("   RARS_SORT,");
            sql.addSql("   RARD_COUNT,");
            sql.addSql("   RARD_STATUS");
            sql.addSql(" from ");
            sql.addSql("   RNG_ACTION_RESULT_DATA");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getRngActionResultDataFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <br>[機  能] 稟議SIDを指定し、ソート順,実行回数順に実行結果内訳一覧を取得します
     * <br>[解  説]
     * <br>[備  考]
     * @param rngSid RNG_SID
     * @return RNG_ACTION_RESULT_DATAModel
     * @throws SQLException SQL実行例外
     */
    public List<RngActionResultDataModel> select(int rngSid) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        List<RngActionResultDataModel> ret = new ArrayList<>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   RNG_SID,");
            sql.addSql("   RARS_SORT,");
            sql.addSql("   RARD_COUNT,");
            sql.addSql("   RARD_STATUS");
            sql.addSql(" from");
            sql.addSql("   RNG_ACTION_RESULT_DATA");
            sql.addSql(" where ");
            sql.addSql("   RNG_SID=?");
            sql.addSql(" order by ");
            sql.addSql("   RARS_SORT, RARD_COUNT");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(rngSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getRngActionResultDataFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Select RNG_ACTION_RESULT_DATA
     * @param rngSid RNG_SID
     * @param rarsSort RARS_SORT
     * @param rardCount RARD_COUNT
     * @return RNG_ACTION_RESULT_DATAModel
     * @throws SQLException SQL実行例外
     */
    public RngActionResultDataModel select(
        int rngSid, int rarsSort, int rardCount) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        RngActionResultDataModel ret = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   RNG_SID,");
            sql.addSql("   RARS_SORT,");
            sql.addSql("   RARD_COUNT,");
            sql.addSql("   RARD_STATUS");
            sql.addSql(" from");
            sql.addSql("   RNG_ACTION_RESULT_DATA");
            sql.addSql(" where ");
            sql.addSql("   RNG_SID=?");
            sql.addSql(" and");
            sql.addSql("   RARS_SORT=?");
            sql.addSql(" and");
            sql.addSql("   RARD_COUNT=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(rngSid);
            sql.addIntValue(rarsSort);
            sql.addIntValue(rardCount);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ret = __getRngActionResultDataFromRs(rs);
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <br>[機  能] 稟議SIDを指定し、実行結果内訳を削除します
     * <br>[解  説]
     * <br>[備  考]
     * @param rngSid RNG_SID
     * @return 削除件数
     * @throws SQLException SQL実行例外
     */
    public int delete(int rngSid) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   RNG_ACTION_RESULT_DATA");
            sql.addSql(" where ");
            sql.addSql("   RNG_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(rngSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Delete RNG_ACTION_RESULT_DATA
     * @param rngSid RNG_SID
     * @param rarsSort RARS_SORT
     * @param rardCount RARD_COUNT
     * @return 削除件数
     * @throws SQLException SQL実行例外
     */
    public int delete(int rngSid, int rarsSort, int rardCount) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   RNG_ACTION_RESULT_DATA");
            sql.addSql(" where ");
            sql.addSql("   RNG_SID=?");
            sql.addSql(" and");
            sql.addSql("   RARS_SORT=?");
            sql.addSql(" and");
            sql.addSql("   RARD_COUNT=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(rngSid);
            sql.addIntValue(rarsSort);
            sql.addIntValue(rardCount);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Create RNG_ACTION_RESULT_DATA Data Bindding JavaBean From ResultSet
     * @param rs ResultSet
     * @return created RngActionResultDataModel
     * @throws SQLException SQL実行例外
     */
    private RngActionResultDataModel
        __getRngActionResultDataFromRs(ResultSet rs) throws SQLException {
        RngActionResultDataModel bean = new RngActionResultDataModel();
        bean.setRngSid(rs.getInt("RNG_SID"));
        bean.setRarsSort(rs.getInt("RARS_SORT"));
        bean.setRardCount(rs.getInt("RARD_COUNT"));
        bean.setRardStatus(rs.getInt("RARD_STATUS"));
        return bean;
    }
}
