package jp.groupsession.v2.rng.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.co.sjts.util.dao.AbstractDao;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.co.sjts.util.jdbc.SqlBuffer;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.model.RngActionparamModel;
import jp.groupsession.v2.rng.model.RngTemplateModel;

/**
 * <p>RNG_ACTIONPARAM Data Access Object
 *
 * @author JTS DaoGenerator version 0.5
 */
public class RngActionparamDao extends AbstractDao {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(RngActionparamDao.class);

    /**
     * <p>Default Constructor
     */
    public RngActionparamDao() {
    }

    /**
     * <p>Set Connection
     * @param con Connection
     */
    public RngActionparamDao(Connection con) {
        super(con);
    }

    /**
     * <p>Drop Table
     * @throws SQLException SQL実行例外
     */
    public void dropTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql("drop table RNG_ACTIONPARAM");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Create Table
     * @throws SQLException SQL実行例外
     */
    public void createTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" create table RNG_ACTIONPARAM (");
            sql.addSql("   RAP_SID integer not null,");
            sql.addSql("   RTPA_SID integer not null,");
            sql.addSql("   RAP_SORT integer not null,");
            sql.addSql("   RAP_NAME varchar(100) not null,");
            sql.addSql("   RAP_USE_KBN integer not null,");
            sql.addSql("   RAP_CONDITION_JSON clob not null,");
            sql.addSql("   RAP_PARAM_JSON clob not null,");
            sql.addSql("   primary key (RAP_SID,RTPA_SID)");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Insert RNG_ACTIONPARAM Data Bindding JavaBean
     * @param bean RNG_ACTIONPARAM Data Bindding JavaBean
     * @throws SQLException SQL実行例外
     */
    public void insert(RngActionparamModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" insert ");
            sql.addSql(" into ");
            sql.addSql(" RNG_ACTIONPARAM(");
            sql.addSql("   RAP_SID,");
            sql.addSql("   RTPA_SID,");
            sql.addSql("   RAP_SORT,");
            sql.addSql("   RAP_NAME,");
            sql.addSql("   RAP_USE_KBN,");
            sql.addSql("   RAP_CONDITION_JSON,");
            sql.addSql("   RAP_PARAM_JSON");
            sql.addSql(" )");
            sql.addSql(" values");
            sql.addSql(" (");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(bean.getRapSid());
            sql.addIntValue(bean.getRtpaSid());
            sql.addIntValue(bean.getRapSort());
            sql.addStrValue(bean.getRapName());
            sql.addIntValue(bean.getRapUseKbn());
            sql.addStrValue(bean.getRapConditionJson());
            sql.addStrValue(bean.getRapParamJson());
            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Update RNG_ACTIONPARAM Data Bindding JavaBean
     * @param bean RNG_ACTIONPARAM Data Bindding JavaBean
     * @return 更新件数
     * @throws SQLException SQL実行例外
     */
    public int update(RngActionparamModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" update");
            sql.addSql("   RNG_ACTIONPARAM");
            sql.addSql(" set ");
            sql.addSql("   RAP_SORT=?,");
            sql.addSql("   RAP_NAME=?,");
            sql.addSql("   RAP_USE_KBN=?,");
            sql.addSql("   RAP_CONDITION_JSON=?,");
            sql.addSql("   RAP_PARAM_JSON=?");
            sql.addSql(" where ");
            sql.addSql("   RAP_SID=?");
            sql.addSql(" and");
            sql.addSql("   RTPA_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(bean.getRapSort());
            sql.addStrValue(bean.getRapName());
            sql.addIntValue(bean.getRapUseKbn());
            sql.addStrValue(bean.getRapConditionJson());
            sql.addStrValue(bean.getRapParamJson());
            //where
            sql.addIntValue(bean.getRapSid());
            sql.addIntValue(bean.getRtpaSid());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Select RNG_ACTIONPARAM All Data
     * @return List in RNG_ACTIONPARAMModel
     * @throws SQLException SQL実行例外
     */
    public List<RngActionparamModel> select() throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<RngActionparamModel> ret = new ArrayList<RngActionparamModel>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   RAP_SID,");
            sql.addSql("   RTPA_SID,");
            sql.addSql("   RAP_SORT,");
            sql.addSql("   RAP_NAME,");
            sql.addSql("   RAP_USE_KBN,");
            sql.addSql("   RAP_CONDITION_JSON,");
            sql.addSql("   RAP_PARAM_JSON");
            sql.addSql(" from ");
            sql.addSql("   RNG_ACTIONPARAM");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getRngActionparamFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <br>[機  能] 稟議情報Modelを作成する
     * <br>[解  説]
     * <br>[備  考] RAP_SORTの昇順で取得する
     * @param rtpaSid 稟議テンプレートアクションSID
     * @return List in RNG_ACTIONPARAMModel
     * @throws SQLException SQL実行例外
     */
    public List<RngActionparamModel> select(int rtpaSid) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<RngActionparamModel> ret = new ArrayList<RngActionparamModel>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   RAP_SID,");
            sql.addSql("   RTPA_SID,");
            sql.addSql("   RAP_SORT,");
            sql.addSql("   RAP_NAME,");
            sql.addSql("   RAP_USE_KBN,");
            sql.addSql("   RAP_CONDITION_JSON,");
            sql.addSql("   RAP_PARAM_JSON");
            sql.addSql(" from ");
            sql.addSql("   RNG_ACTIONPARAM");
            sql.addSql(" where ");
            sql.addSql("   RTPA_SID=?");
            sql.addSql(" order by ");
            sql.addSql("   RAP_SORT");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(rtpaSid);
            sql.setParameter(pstmt);
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getRngActionparamFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <br>[機  能] 稟議情報Modelを作成する
     * <br>[解  説]
     * <br>[備  考]
     * @param rtpaSidList 稟議テンプレートアクションSIDリスト
     * @return List in RNG_ACTIONPARAMModel
     * @throws SQLException SQL実行例外
     */
    public List<RngActionparamModel> select(List<Integer> rtpaSidList) throws SQLException {
        ArrayList<RngActionparamModel> ret = new ArrayList<RngActionparamModel>();
        if (rtpaSidList == null || rtpaSidList.isEmpty()) {
            return ret;
        }
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   RAP_SID,");
            sql.addSql("   RTPA_SID,");
            sql.addSql("   RAP_SORT,");
            sql.addSql("   RAP_NAME,");
            sql.addSql("   RAP_USE_KBN,");
            sql.addSql("   RAP_CONDITION_JSON,");
            sql.addSql("   RAP_PARAM_JSON");
            sql.addSql(" from ");
            sql.addSql("   RNG_ACTIONPARAM");
            sql.addSql(" where ");
            sql.addSql("   RTPA_SID in (");
            for (int idx = 0; idx < rtpaSidList.size(); idx++) {
                if (idx != 0) {
                    sql.addSql(", ");
                }
                sql.addSql("?");
                sql.addIntValue(rtpaSidList.get(idx));
            }
            sql.addSql("   )");
            sql.addSql(" and ");
            sql.addSql("   RAP_USE_KBN = ?");
            sql.addIntValue(RngConst.API_PARAM_USE);
            pstmt = con.prepareStatement(sql.toSqlString());
            sql.setParameter(pstmt);
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getRngActionparamFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Select RNG_ACTIONPARAM
     * @param rapSid RAP_SID
     * @param rtpaSid RTPA_SID
     * @return RNG_ACTIONPARAMModel
     * @throws SQLException SQL実行例外
     */
    public RngActionparamModel select(int rapSid, int rtpaSid) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        RngActionparamModel ret = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   RAP_SID,");
            sql.addSql("   RTPA_SID,");
            sql.addSql("   RAP_SORT,");
            sql.addSql("   RAP_NAME,");
            sql.addSql("   RAP_USE_KBN,");
            sql.addSql("   RAP_CONDITION_JSON,");
            sql.addSql("   RAP_PARAM_JSON");
            sql.addSql(" from");
            sql.addSql("   RNG_ACTIONPARAM");
            sql.addSql(" where ");
            sql.addSql("   RAP_SID=?");
            sql.addSql(" and");
            sql.addSql("   RTPA_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(rapSid);
            sql.addIntValue(rtpaSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ret = __getRngActionparamFromRs(rs);
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Delete RNG_ACTIONPARAM
     * @param rapSid RAP_SID
     * @param rtpaSid RTPA_SID
     * @return 削除件数
     * @throws SQLException SQL実行例外
     */
    public int delete(int rapSid, int rtpaSid) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   RNG_ACTIONPARAM");
            sql.addSql(" where ");
            sql.addSql("   RAP_SID=?");
            sql.addSql(" and");
            sql.addSql("   RTPA_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(rapSid);
            sql.addIntValue(rtpaSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Delete RNG_ACTIONPARAM
     * @param rtpaSid RTPA_SID
     * @return 削除件数
     * @throws SQLException SQL実行例外
     */
    public int delete(int rtpaSid) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   RNG_ACTIONPARAM");
            sql.addSql(" where ");
            sql.addSql("   RTPA_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(rtpaSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Create RNG_ACTIONPARAM Data Bindding JavaBean From ResultSet
     * @param rs ResultSet
     * @return created RngActionparamModel
     * @throws SQLException SQL実行例外
     */
    private RngActionparamModel __getRngActionparamFromRs(ResultSet rs) throws SQLException {
        RngActionparamModel bean = new RngActionparamModel();
        bean.setRapSid(rs.getInt("RAP_SID"));
        bean.setRtpaSid(rs.getInt("RTPA_SID"));
        bean.setRapSort(rs.getInt("RAP_SORT"));
        bean.setRapName(rs.getString("RAP_NAME"));
        bean.setRapUseKbn(rs.getInt("RAP_USE_KBN"));
        bean.setRapConditionJson(rs.getString("RAP_CONDITION_JSON"));
        bean.setRapParamJson(rs.getString("RAP_PARAM_JSON"));
        return bean;
    }

    /**
     * <br>[機  能] 指定したアクションパラメータのデータサイズ合計
     * <br>[解  説]
     * <br>[備  考]
     * @param rtpList 稟議テンプレート情報
     * @return データサイズ合計
     * @throws SQLException SQL実行時例外
     */
    public long getTotalJsonDataSize(List<RngTemplateModel> rtpList) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        long dataSize = 0;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   sum(octet_length(RNG_ACTIONPARAM.RAP_NAME)) as RAP_NAME,");
            sql.addSql("   sum(octet_length(RNG_ACTIONPARAM.RAP_CONDITION_JSON))");
            sql.addSql("             as RAP_CONDITION_JSON,");
            sql.addSql("   sum(octet_length(RNG_ACTIONPARAM.RAP_PARAM_JSON)) as RAP_PARAM_JSON");
            sql.addSql(" from");
            sql.addSql("   RNG_ACTIONPARAM");
            sql.addSql("   left join");
            sql.addSql("     RNG_TEMPLATE_ACTION");
            sql.addSql("   ON");
            sql.addSql("     RNG_ACTIONPARAM.RTPA_SID = RNG_TEMPLATE_ACTION.RTPA_SID");
            sql.addSql(" where");
            sql.addSql("    RNG_TEMPLATE_ACTION.RTP_SID=?");
            sql.addSql("  and");
            sql.addSql("    RNG_TEMPLATE_ACTION.RTP_VER=?");
            pstmt = con.prepareStatement(sql.toSqlString());

            for (RngTemplateModel rtpMdl : rtpList) {
                sql.addIntValue(rtpMdl.getRtpSid());
                sql.addIntValue(rtpMdl.getRtpVer());
                sql.setParameter(pstmt);
                log__.info(sql.toLogString());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    dataSize += rs.getLong("RAP_NAME");
                    dataSize += rs.getLong("RAP_CONDITION_JSON");
                    dataSize += rs.getLong("RAP_PARAM_JSON");
                }
                JDBCUtil.closeResultSet(rs);
                sql.clearValue();
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return dataSize;
    }
}
