package jp.groupsession.v2.rng.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.co.sjts.util.dao.AbstractDao;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.co.sjts.util.jdbc.SqlBuffer;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.model.RngTemplateActionModel;
import jp.groupsession.v2.rng.model.RngTemplateModel;

/**
 * <p>RNG_TEMPLATE_ACTION Data Access Object
 *
 * @author JTS DaoGenerator version 0.5
 */
public class RngTemplateActionDao extends AbstractDao {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(RngTemplateActionDao.class);

    /**
     * <p>Default Constructor
     */
    public RngTemplateActionDao() {
    }

    /**
     * <p>Set Connection
     * @param con Connection
     */
    public RngTemplateActionDao(Connection con) {
        super(con);
    }

    /**
     * <p>Drop Table
     * @throws SQLException SQL実行例外
     */
    public void dropTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql("drop table RNG_TEMPLATE_ACTION");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Create Table
     * @throws SQLException SQL実行例外
     */
    public void createTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" create table RNG_TEMPLATE_ACTION (");
            sql.addSql("   RTPA_SID integer not null,");
            sql.addSql("   RTP_SID integer not null,");
            sql.addSql("   RTP_VER integer not null,");
            sql.addSql("   RTPA_SORT integer not null,");
            sql.addSql("   CAC_SID integer not null,");
            sql.addSql("   RTPA_NAME varchar(100),");
            sql.addSql("   RTPA_REPEAT_KBN integer not null,");
            sql.addSql("   RTPA_REPEAT_TYPE integer not null,");
            sql.addSql("   RFT_ID varchar(100),");
            sql.addSql("   RTPA_USE_KBN integer not null,");
            sql.addSql("   primary key (RTPA_SID)");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Insert RNG_TEMPLATE_ACTION Data Bindding JavaBean
     * @param bean RNG_TEMPLATE_ACTION Data Bindding JavaBean
     * @throws SQLException SQL実行例外
     */
    public void insert(RngTemplateActionModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" insert ");
            sql.addSql(" into ");
            sql.addSql(" RNG_TEMPLATE_ACTION(");
            sql.addSql("   RTPA_SID,");
            sql.addSql("   RTP_SID,");
            sql.addSql("   RTP_VER,");
            sql.addSql("   RTPA_SORT,");
            sql.addSql("   CAC_SID,");
            sql.addSql("   RTPA_NAME,");
            sql.addSql("   RTPA_REPEAT_KBN,");
            sql.addSql("   RTPA_REPEAT_TYPE,");
            sql.addSql("   RFT_ID,");
            sql.addSql("   RTPA_USE_KBN");
            sql.addSql(" )");
            sql.addSql(" values");
            sql.addSql(" (");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(bean.getRtpaSid());
            sql.addIntValue(bean.getRtpSid());
            sql.addIntValue(bean.getRtpVer());
            sql.addIntValue(bean.getRtpaSort());
            sql.addIntValue(bean.getCacSid());
            sql.addStrValue(bean.getRtpaName());
            sql.addIntValue(bean.getRtpaRepeatKbn());
            sql.addIntValue(bean.getRtpaRepeatType());
            sql.addStrValue(bean.getRftId());
            sql.addIntValue(bean.getRtpaUseKbn());
            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Update RNG_TEMPLATE_ACTION Data Bindding JavaBean
     * @param bean RNG_TEMPLATE_ACTION Data Bindding JavaBean
     * @return 更新件数
     * @throws SQLException SQL実行例外
     */
    public int update(RngTemplateActionModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" update");
            sql.addSql("   RNG_TEMPLATE_ACTION");
            sql.addSql(" set ");
            sql.addSql("   RTP_SID=?,");
            sql.addSql("   RTP_VER=?,");
            sql.addSql("   RTPA_SORT=?,");
            sql.addSql("   CAC_SID=?,");
            sql.addSql("   RTPA_NAME=?,");
            sql.addSql("   RTPA_REPEAT_KBN=?,");
            sql.addSql("   RTPA_REPEAT_TYPE=?,");
            sql.addSql("   RFT_ID=?,");
            sql.addSql("   RTPA_USE_KBN=?");
            sql.addSql(" where ");
            sql.addSql("   RTPA_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(bean.getRtpSid());
            sql.addIntValue(bean.getRtpVer());
            sql.addIntValue(bean.getRtpaSort());
            sql.addIntValue(bean.getCacSid());
            sql.addStrValue(bean.getRtpaName());
            sql.addIntValue(bean.getRtpaRepeatKbn());
            sql.addIntValue(bean.getRtpaRepeatType());
            sql.addStrValue(bean.getRftId());
            sql.addIntValue(bean.getRtpaUseKbn());
            //where
            sql.addIntValue(bean.getRtpaSid());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Select RNG_TEMPLATE_ACTION All Data
     * @return List in RNG_TEMPLATE_ACTIONModel
     * @throws SQLException SQL実行例外
     */
    public List<RngTemplateActionModel> select() throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<RngTemplateActionModel> ret = new ArrayList<RngTemplateActionModel>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   RTPA_SID,");
            sql.addSql("   RTP_SID,");
            sql.addSql("   RTP_VER,");
            sql.addSql("   RTPA_SORT,");
            sql.addSql("   CAC_SID,");
            sql.addSql("   RTPA_NAME,");
            sql.addSql("   RTPA_REPEAT_KBN,");
            sql.addSql("   RTPA_REPEAT_TYPE,");
            sql.addSql("   RFT_ID,");
            sql.addSql("   RTPA_USE_KBN");
            sql.addSql(" from ");
            sql.addSql("   RNG_TEMPLATE_ACTION");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getRngTemplateActionFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Select RNG_TEMPLATE_ACTION
     * @param rtpaSidList RTPA_SID
     * @return RNG_TEMPLATE_ACTIONModel
     * @throws SQLException SQL実行例外
     */
    public List<RngTemplateActionModel> select(List<Integer> rtpaSidList) throws SQLException {

        List<RngTemplateActionModel> ret = new ArrayList<>();
        if (rtpaSidList == null || rtpaSidList.isEmpty()) {
            return ret;
        }
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   RTPA_SID,");
            sql.addSql("   RTP_SID,");
            sql.addSql("   RTP_VER,");
            sql.addSql("   RTPA_SORT,");
            sql.addSql("   CAC_SID,");
            sql.addSql("   RTPA_NAME,");
            sql.addSql("   RTPA_REPEAT_KBN,");
            sql.addSql("   RTPA_REPEAT_TYPE,");
            sql.addSql("   RFT_ID,");
            sql.addSql("   RTPA_USE_KBN");
            sql.addSql(" from");
            sql.addSql("   RNG_TEMPLATE_ACTION");
            sql.addSql(" where ");
            sql.addSql("   RTPA_SID in (");
            for (int idx = 0; idx < rtpaSidList.size(); idx++) {
                if (idx != 0) {
                    sql.addSql(", ");
                }
                sql.addSql("?");
                sql.addIntValue(rtpaSidList.get(idx));
            }
            sql.addSql("   )");

            pstmt = con.prepareStatement(sql.toSqlString());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getRngTemplateActionFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <br>[機  能] 稟議テンプレート情報から決裁後アクション情報を取得する
     * <br>[解  説]
     * <br>[備  考] RTPA_SORTの昇順で取得する
     * @param rtpSid 稟議テンプレートSID
     * @param rtpVer 稟議テンプレートバージョン
     * @return RNG_TEMPLATE_ACTIONModel
     * @throws SQLException SQL実行例外
     */
    public List<RngTemplateActionModel> select(int rtpSid, int rtpVer) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        List<RngTemplateActionModel> ret = new ArrayList<RngTemplateActionModel>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   RTPA_SID,");
            sql.addSql("   RTP_SID,");
            sql.addSql("   RTP_VER,");
            sql.addSql("   RTPA_SORT,");
            sql.addSql("   CAC_SID,");
            sql.addSql("   RTPA_NAME,");
            sql.addSql("   RTPA_REPEAT_KBN,");
            sql.addSql("   RTPA_REPEAT_TYPE,");
            sql.addSql("   RFT_ID,");
            sql.addSql("   RTPA_USE_KBN");
            sql.addSql(" from");
            sql.addSql("   RNG_TEMPLATE_ACTION");
            sql.addSql(" where ");
            sql.addSql("   RTP_SID=?");
            sql.addSql(" and ");
            sql.addSql("   RTP_VER=?");
            sql.addSql(" order by ");
            sql.addSql("   RTPA_SORT");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(rtpSid);
            sql.addIntValue(rtpVer);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getRngTemplateActionFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <br>[機  能] 連携APIに紐づくテンプレートアクションを取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param rtpSid テンプレートSID
     * @param rtpVer テンプレートバージョン
     * @return RNG_TEMPLATE_ACTIONModel
     * @throws SQLException SQL実行例外
     */
    public List<RngTemplateActionModel> selectApi(int rtpSid, int rtpVer) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        List<RngTemplateActionModel> ret = new ArrayList<RngTemplateActionModel>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   RNG_TEMPLATE_ACTION.RTPA_SID,");
            sql.addSql("   RNG_TEMPLATE_ACTION.RTP_SID,");
            sql.addSql("   RNG_TEMPLATE_ACTION.RTP_VER,");
            sql.addSql("   RNG_TEMPLATE_ACTION.RTPA_SORT,");
            sql.addSql("   RNG_TEMPLATE_ACTION.CAC_SID,");
            sql.addSql("   RNG_TEMPLATE_ACTION.RTPA_NAME,");
            sql.addSql("   RNG_TEMPLATE_ACTION.RTPA_REPEAT_KBN,");
            sql.addSql("   RNG_TEMPLATE_ACTION.RTPA_REPEAT_TYPE,");
            sql.addSql("   RNG_TEMPLATE_ACTION.RFT_ID,");
            sql.addSql("   RNG_TEMPLATE_ACTION.RTPA_USE_KBN");
            sql.addSql(" from");
            sql.addSql("   RNG_TEMPLATE_ACTION,");
            sql.addSql("   CMN_API_CONNECT");
            sql.addSql(" where ");
            sql.addSql("   RNG_TEMPLATE_ACTION.RTPA_USE_KBN = ?");
            sql.addIntValue(RngConst.API_PARAM_USE);
            sql.addSql(" and ");
            sql.addSql("   RNG_TEMPLATE_ACTION.RTP_SID = ?");
            sql.addIntValue(rtpSid);
            sql.addSql(" and ");
            sql.addSql("   RNG_TEMPLATE_ACTION.RTP_VER = ?");
            sql.addIntValue(rtpVer);
            sql.addSql(" and ");
            sql.addSql("   RNG_TEMPLATE_ACTION.CAC_SID = CMN_API_CONNECT.CAC_SID");
            sql.addSql(" and ");
            sql.addSql("   CMN_API_CONNECT.CAC_JKBN = 0");
            sql.addSql(" and (");
            sql.addSql("   CMN_API_CONNECT.CAG_SID = 0");
            sql.addSql("   or");
            sql.addSql("   exists (");
            sql.addSql("     select 1");
            sql.addSql("     from");
            sql.addSql("       CMN_API_CONNECT_GSAPI");
            sql.addSql("     where");
            sql.addSql("       CMN_API_CONNECT_GSAPI.CAG_SID = CMN_API_CONNECT.CAG_SID");
            sql.addSql("     and");
            sql.addSql("       CMN_API_CONNECT_GSAPI.CAG_VERSION = CMN_API_CONNECT.CAG_VERSION");
            sql.addSql("   )");
            sql.addSql(" )");
            sql.addSql(" order by ");
            sql.addSql("   RTPA_SORT");
            pstmt = con.prepareStatement(sql.toSqlString());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getRngTemplateActionFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Delete RNG_TEMPLATE_ACTION
     * @param rtpaSid RTPA_SID
     * @return 削除件数
     * @throws SQLException SQL実行例外
     */
    public int delete(int rtpaSid) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   RNG_TEMPLATE_ACTION");
            sql.addSql(" where ");
            sql.addSql("   RTPA_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(rtpaSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Create RNG_TEMPLATE_ACTION Data Bindding JavaBean From ResultSet
     * @param rs ResultSet
     * @return created RngTemplateActionModel
     * @throws SQLException SQL実行例外
     */
    private RngTemplateActionModel __getRngTemplateActionFromRs(ResultSet rs) throws SQLException {
        RngTemplateActionModel bean = new RngTemplateActionModel();
        bean.setRtpaSid(rs.getInt("RTPA_SID"));
        bean.setRtpSid(rs.getInt("RTP_SID"));
        bean.setRtpVer(rs.getInt("RTP_VER"));
        bean.setRtpaSort(rs.getInt("RTPA_SORT"));
        bean.setCacSid(rs.getInt("CAC_SID"));
        bean.setRtpaName(rs.getString("RTPA_NAME"));
        bean.setRtpaRepeatKbn(rs.getInt("RTPA_REPEAT_KBN"));
        bean.setRtpaRepeatType(rs.getInt("RTPA_REPEAT_TYPE"));
        bean.setRftId(rs.getString("RFT_ID"));
        bean.setRtpaUseKbn(rs.getInt("RTPA_USE_KBN"));
        return bean;
    }

    /**
     * <br>[機  能] 指定した決裁後アクションのデータサイズ合計
     * <br>[解  説]
     * <br>[備  考]
     * @param rtpList 稟議テンプレート情報
     * @return データサイズ合計
     * @throws SQLException SQL実行時例外
     */
    public long getTotalDataSize(List<RngTemplateModel> rtpList) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        long dataSize = 0;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   sum(octet_length(RTPA_NAME)) as RTPA_NAME");
            sql.addSql(" from");
            sql.addSql("   RNG_TEMPLATE_ACTION");
            sql.addSql(" where");
            sql.addSql("    RTP_SID=?");
            sql.addSql("  and");
            sql.addSql("    RTP_VER=?");
            pstmt = con.prepareStatement(sql.toSqlString());

            for (RngTemplateModel rtpMdl : rtpList) {
                sql.addIntValue(rtpMdl.getRtpSid());
                sql.addIntValue(rtpMdl.getRtpVer());
                sql.setParameter(pstmt);
                log__.info(sql.toLogString());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    dataSize += rs.getLong("RTPA_NAME");
                }
                JDBCUtil.closeResultSet(rs);
                sql.clearValue();
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return dataSize;
    }
}
