package jp.groupsession.v2.rng.model;

import java.util.TreeMap;

import jp.groupsession.v2.cmn.model.AbstractModel;
import jp.groupsession.v2.rng.RngConst;

/**
 * <br>[機  能] 稟議 パラメータ情報を格納するModelクラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class RngRapParamModel extends AbstractModel {

    /** パラメータ名 */
    private String name__ = "";
    /** 使用区分 */
    private int useKbn__ = RngConst.API_PARAM_NOT_USE;
    /** パラメータタイプ */
    private String paramType__ = "";
    /** パラメータMAP */
    private TreeMap<Integer, ParamInfoModel> paramInfoMap__ = new TreeMap<>();
    /** 配列パラメータ情報MAP */
    private TreeMap<Integer, ListParamInfoModel> listParamInfoMap__ = new TreeMap<>();
    /** 子パラメータ情報MAP */
    private TreeMap<Integer, ChildParamInfoModel> childParamInfoMap__ = new TreeMap<>();

    /**
     * <p>param[index] を取得します。
     * @param index 添字
     * @return param[index]
     */
    public ParamInfoModel getParamInfo(int index) {
        if (!paramInfoMap__.containsKey(index)) {
            paramInfoMap__.put(index, new ParamInfoModel());
        }
        return paramInfoMap__.get(index);
    }

    /**
     * <p>listParam[index] を取得します。
     * @param index 添字
     * @return listParam[index]
     */
    public ListParamInfoModel getListParamInfo(int index) {
        if (!listParamInfoMap__.containsKey(index)) {
            listParamInfoMap__.put(index, new ListParamInfoModel());
        }
        return listParamInfoMap__.get(index);
    }

    /**
     * <p>modelParam[index] を取得します。
     * @param index 添字
     * @return modelParam[index]
     */
    public ChildParamInfoModel getChildParamInfo(int index) {
        if (!childParamInfoMap__.containsKey(index)) {
            childParamInfoMap__.put(index, new ChildParamInfoModel());
        }
        return childParamInfoMap__.get(index);
    }

    /**
     * @return the name
     */
    public String getName() {
        return name__;
    }

    /**
     * @param name the name to set
     */
    public void setName(String name) {
        name__ = name;
    }

    /**
     * @return the useKbn
     */
    public int getUseKbn() {
        return useKbn__;
    }

    /**
     * @param useKbn the useKbn to set
     */
    public void setUseKbn(int useKbn) {
        useKbn__ = useKbn;
    }

    /**
     * @return the paramType
     */
    public String getParamType() {
        return paramType__;
    }

    /**
     * @param paramType the paramType to set
     */
    public void setParamType(String paramType) {
        paramType__ = paramType;
    }

    /**
     * @return the paramInfoMap
     */
    public TreeMap<Integer, ParamInfoModel> getParamInfoMap() {
        return paramInfoMap__;
    }

    /**
     * @param paramInfoMap the paramInfoMap to set
     */
    public void setParamInfoMap(TreeMap<Integer, ParamInfoModel> paramInfoMap) {
        paramInfoMap__ = paramInfoMap;
    }

    /**
     * @return the listParamInfoMap
     */
    public TreeMap<Integer, ListParamInfoModel> getListParamInfoMap() {
        return listParamInfoMap__;
    }

    /**
     * @param listParamInfoMap the listParamInfoMap to set
     */
    public void setListParamInfoMap(
            TreeMap<Integer, ListParamInfoModel> listParamInfoMap) {
        listParamInfoMap__ = listParamInfoMap;
    }

    /**
     * @return the childParamInfoMap
     */
    public TreeMap<Integer, ChildParamInfoModel> getChildParamInfoMap() {
        return childParamInfoMap__;
    }

    /**
     * @param childParamInfoMap the childParamInfoMap to set
     */
    public void setChildParamInfoMap(
            TreeMap<Integer, ChildParamInfoModel> childParamInfoMap) {
        childParamInfoMap__ = childParamInfoMap;
    }
}
