package jp.groupsession.v2.rng.restapi;

import jp.groupsession.v2.restapi.exception.IReasonCode;

/**
 *
 * <br>[機  能] 稟議 RESTAPI エラーコード列挙型
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public enum RngEnumReasonCode implements IReasonCode {

    /** 対象の稟議アカウントへアクセスできない */
    @ReasonCodeString("RINGI-101")
    RESOURCE_CANT_ACCESS_ACCOUNT,

    /** 対象の稟議情報へアクセスできない */
    @ReasonCodeString("RINGI-102")
    RESOURCE_CANT_ACCESS_RINGI,

    /** 対象稟議の添付ファイルへアクセスできない */
    @ReasonCodeString("RINGI-103")
    RESOURCE_CANT_ACCESS_FILE,

    /** 対象経路へアクセスできない */
    @ReasonCodeString("RINGI-104")
    RESOURCE_CANT_ACCESS_KEIRO,

    /** 対象フォルダへアクセスできない */
    @ReasonCodeString("RINGI-105")
    RESOURCE_CANT_ACCESS_FOLDER,

    /** 対象稟議テンプレートへアクセスできない */
    @ReasonCodeString("RINGI-106")
    RESOURCE_CANT_ACCESS_TEMPLATE,

    /** 対象稟議テンプレートの添付ファイルへアクセスできない */
    @ReasonCodeString("RINGI-107")
    RESOURCE_CANT_ACCESS_TEMPLATE_FILE,

    /** 対象稟議テンプレートの添付ファイルへアクセスできない */
    @ReasonCodeString("RINGI-108")
    RESOURCE_CANT_ACCESS_FORMID,

    /** 対象稟議テンプレートの経路へアクセスできない */
    @ReasonCodeString("RINGI-112")
    RESOURCE_CANT_ACCESS_TEMPLATE_KEIRO,

    /** 入力パラメータで指定した稟議アクションができない */
    @ReasonCodeString("RINGI-201")
    RESOURCE_CANT_ACTION,

    /** 対象稟議の種別が想定と異なる */
    @ReasonCodeString("RINGI-202")
    RESOURCE_DIF_TYPE_RINGI,

    /** 指定したグループに所属する利用可能なユーザが存在しない */
    @ReasonCodeString("RINGI-203")
    RESOURCE_GROUP_EMPTY,

    /** 指定した稟議カテゴリへアクセスできない */
    @ReasonCodeString("RINGI-204")
    PARAM_CANT_ACCESS_CATEGORY,

    /** 指定した稟議テンプレートにアクセスできない */
    @ReasonCodeString("RINGI-205")
    PARAM_CANT_ACCESS_TEMPLATE,

    /** 参照元の稟議にアクセスできない */
    @ReasonCodeString("RINGI-207")
    PARAM_CANT_ACCESS_REFERENCE_RINGI,

    /** 申請内容の入力値に誤りがある */
    @ReasonCodeString("RINGI-208")
    PARAM_INPUT_ERROR_ENTRY_PARAM,

    /** 承認経路の入力値に誤りがある */
    @ReasonCodeString("RINGI-209")
    PARAM_INPUT_ERROR_SYOUNIN_KEIRO,

    /** 確認経路の入力値に誤りがある */
    @ReasonCodeString("RINGI-210")
    PARAM_INPUT_ERROR_KAKUNIN_KEIRO,

    /** 対象の稟議を削除できない */
    @ReasonCodeString("RINGI-211")
    RESOURCE_CANT_DELETE_RINGI,

    /** 確認経路側で問題が発生しており、確認経路を使用できない */
    @ReasonCodeString("RINGI-212")
    PARAM_CANT_USE_KAKUNIN_KEIRO,

    /** 承認を行うユーザが存在しないなどの理由で、承認経路が使用できない */
    @ReasonCodeString("RINGI-213")
    PARAM_CANT_USE_SYOUNIN_KEIRO,

    /** 入力が必須な申請内容に入力できるユーザ，グループが存在しない */
    @ReasonCodeString("RINGI-214")
    PARAM_CANT_USE_FORM,

    /** セッションユーザが該当の稟議を再申請できない */
    @ReasonCodeString("RINGI-215")
    PARAM_CANT_REAPPLICATION,

    /** 稟議の承認経路に削除済みではないユーザが存在しないため、稟議を再申請できない */
    @ReasonCodeString("RINGI-216")
    PARAM_NOTHING_USER_REAPPLICATION,

    /** 個人テンプレートの使用が制限されている */
    @ReasonCodeString("RINGI-217")
    PARAM_CANT_USE_PRIVATE_TEMPLATE,

    /** 申請内容の種別に誤りがある */
    @ReasonCodeString("RINGI-218")
    PARAM_SELECT_ERROR_FORM_TYPE;
}
