package jp.groupsession.v2.rng.restapi;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

import jp.co.sjts.util.NullDefault;
import jp.co.sjts.util.StringUtil;
import jp.co.sjts.util.io.IOToolsException;
import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.cmn.GSConstApi;
import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.biz.UserBiz;
import jp.groupsession.v2.cmn.dao.base.CmnBinfDao;
import jp.groupsession.v2.cmn.dao.base.CmnGroupmDao;
import jp.groupsession.v2.cmn.dao.base.CmnUsrmDao;
import jp.groupsession.v2.cmn.formbuilder.EnumFormModelKbn;
import jp.groupsession.v2.cmn.formbuilder.FormCell;
import jp.groupsession.v2.cmn.formbuilder.FormInputBuilder;
import jp.groupsession.v2.cmn.formmodel.AbstractFormModel;
import jp.groupsession.v2.cmn.formmodel.Block;
import jp.groupsession.v2.cmn.formmodel.BlockList;
import jp.groupsession.v2.cmn.formmodel.Calc;
import jp.groupsession.v2.cmn.formmodel.CheckBox;
import jp.groupsession.v2.cmn.formmodel.ComboBox;
import jp.groupsession.v2.cmn.formmodel.Comment;
import jp.groupsession.v2.cmn.formmodel.DateBox;
import jp.groupsession.v2.cmn.formmodel.GroupComboModel;
import jp.groupsession.v2.cmn.formmodel.NumberBox;
import jp.groupsession.v2.cmn.formmodel.RadioButton;
import jp.groupsession.v2.cmn.formmodel.SimpleUserSelect;
import jp.groupsession.v2.cmn.formmodel.Sum;
import jp.groupsession.v2.cmn.formmodel.Temp;
import jp.groupsession.v2.cmn.formmodel.TextInput;
import jp.groupsession.v2.cmn.formmodel.Textarea;
import jp.groupsession.v2.cmn.formmodel.TimeBox;
import jp.groupsession.v2.cmn.model.TempFileModel;
import jp.groupsession.v2.cmn.model.base.CmnBinfModel;
import jp.groupsession.v2.cmn.model.base.CmnGroupmModel;
import jp.groupsession.v2.cmn.model.base.CmnUsrmInfModel;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.RtpNotfoundException;
import jp.groupsession.v2.rng.restapi.model.content.RngRestapiRingiBodyContentModel;
import jp.groupsession.v2.rng.restapi.model.content.RngRestapiRingiBodyDetailModel;
import jp.groupsession.v2.rng.restapi.model.content.RngRestapiRingiBodyModel;
import jp.groupsession.v2.rng.restapi.model.content.RngRestapiRingiBodyRowModel;
import jp.groupsession.v2.rng.restapi.model.content.RngRestapiRingiBodySimpleModel;
import jp.groupsession.v2.rng.restapi.model.content.block.RngRestapiRingiBlockBodyRowArrayModel;
import jp.groupsession.v2.rng.restapi.model.content.block.RngRestapiRingiBlockRowArrayModel;
import jp.groupsession.v2.usr.GSConstUser;

/**
 * <br>[機  能] 稟議申請内容を取得するビジネスロジック
 * <br>[解  説]
 * <br>[備  考] 詳細情報用と、申請経路情報，申請確認情報用で添付ファイル取得処理が異なる
 *
 * @author  JTS
 */
public class RngRestApiDetailModelBiz {

    /** 詳細情報用か */
    private boolean isSyousai__ = false;

    /**
     * <br>[機  能] コンストラクタ
     * <br>[解  説]
     * <br>[備  考]
     * @param isSyousai 詳細情報用か
     */
    public RngRestApiDetailModelBiz(boolean isSyousai) {
        isSyousai__ = isSyousai;
    }

    /**
     * <p>指定した稟議の申請内容情報を取得する
     * @param formBuilder 申請内容情報
     * @param con コネクション
     * @return 稟議申請情報
     * @throws IOToolsException
     * @throws SQLException SQL実行時例外
     * @throws RtpNotfoundException 対象の稟議テンプレートが存在しない
     */
    public List<RngRestapiRingiBodyRowModel> getRingiDetailBodyList(
        FormInputBuilder formBuilder, Connection con)
        throws SQLException, RtpNotfoundException, IOToolsException {

        List<RngRestapiRingiBodyRowModel> bodyList
            = new ArrayList<RngRestapiRingiBodyRowModel>();
        for (List<FormCell> cellList : formBuilder.getFormTable()) {
            RngRestapiRingiBodyRowModel rowMdl = new RngRestapiRingiBodyRowModel();
            rowMdl.setRowArray(
                __createRingiBodyDataModel(
                    con,
                    cellList,
                    0)
            );
            bodyList.add(rowMdl);
        }
        return bodyList;
    }

    /**
     * <p>指定した稟議の申請内容情報を取得する
     * @param con コネクション
     * @param cellList List<FormCell>
     * @param rowNo 行番号
     * @return 稟議申請情報
     * @throws SQLException SQL実行時例外
     * @throws RtpNotfoundException 対象の稟議テンプレートが存在しない
     *
     */
    private List<RngRestapiRingiBodyModel> __createRingiBodyDataModel(
                            Connection con,
                            List<FormCell> cellList,
                            int rowNo)
        throws SQLException, RtpNotfoundException, IOToolsException {

        List<RngRestapiRingiBodyModel> bodyList
            = new ArrayList<RngRestapiRingiBodyModel>();

        for (FormCell cell : cellList) {
            int cellType = cell.getType().getValue();

            RngRestapiRingiBodyModel bodyMdl = null;
            if (__isDetailContent(cellType)) {
                bodyMdl = new RngRestapiRingiBodyDetailModel();
            } else {
                bodyMdl = new RngRestapiRingiBodySimpleModel();
            }
            bodyMdl.setFormId(cell.getFormID());
            bodyMdl.setType(cellType);
            bodyMdl.setName(cell.getTitle());

            __setContentArray(con, cell, bodyMdl, rowNo);

            bodyList.add(bodyMdl);
        }

        return bodyList;
    }

    /**
     * <p>「contentArrayにフォーム特有の情報を設定する」フォーム種別かを判定する
     * @param type フォーム種別
     * @return true: 「フォーム特有の情報を設定する」対象
     */
    private boolean __isDetailContent(int type) {
        return type == EnumFormModelKbn.user.getValue()
            || type == EnumFormModelKbn.group.getValue()
            || type == EnumFormModelKbn.file.getValue()
            || type == EnumFormModelKbn.block.getValue()
            || type == EnumFormModelKbn.blocklist.getValue();
    }

    /**
     * <p>稟議申請内容からcontentArrayを生成する
     * @param con コネクション
     * @param cell FormCell
     * @param parentBodyMdl RngRestapiRingiBodyModel
     * @param rowNo 行番号
     * @throws SQLException SQL実行時例外
     * @throws RtpNotfoundException 対象の稟議テンプレートが存在しない
     * @throws IOToolsException 添付ファイル情報の取得に失敗
     */
    private void __setContentArray(
                            Connection con,
                            FormCell cell,
                            RngRestapiRingiBodyModel parentBodyMdl,
                            int rowNo)
        throws SQLException, RtpNotfoundException, IOToolsException {

        List<RngRestapiRingiBodyContentModel> contentArray
            = new ArrayList<RngRestapiRingiBodyContentModel>();
        List<String> contentArrayString = new ArrayList<String>();

        AbstractFormModel bodyObj = cell.getBody();
        int cellType = cell.getType().getValue();
        switch (cell.getType()) {
            case label:
                __addContentArrayString(contentArrayString,
                                ((Comment) bodyObj).getValue());
                if (((Comment) bodyObj).getNotitle() == RngConst.RNG_COMMENT_TITLE_HIDDEN) {
                    parentBodyMdl.setName("");
                }
                break;
            case textbox:
                __addContentArrayString(contentArrayString,
                                ((TextInput) bodyObj).getValue());
                break;
            case textarea:
                __addContentArrayString(contentArrayString,
                                ((Textarea) bodyObj).getValue());
                break;
            case date:
                __addContentArrayString(contentArrayString,
                            ((DateBox) bodyObj).getValue());
                break;
            case time:
                __addContentArrayString(contentArrayString,
                            ((TimeBox) bodyObj).getValue());
                break;
            case number:
                __addNumberToContentArray(contentArrayString,
                            ((NumberBox) bodyObj).getValue(),
                            ((NumberBox) bodyObj).getTanni());
                break;
            case radio:
                contentArrayString.add(
                    ((RadioButton) bodyObj).getSelected());
                break;
            case combo:
                contentArrayString.add(
                    ((ComboBox) bodyObj).getSelected());
                break;
            case check:
                CheckBox checkBox = (CheckBox) bodyObj;
                for (String selected : checkBox.getSelected()) {
                    contentArrayString.add(
                        selected);
                }
                break;
            case sum:
                __addNumberToContentArray(
                    contentArrayString,
                    ((Sum) bodyObj).getValue(),
                    ((Sum) bodyObj).getTanni());
                break;
            case calc:
                __addNumberToContentArray(
                    contentArrayString,
                    ((Calc) bodyObj).getValue(),
                    ((Calc) bodyObj).getTanni());
                break;
            case user:
                String[] selectUser = ((SimpleUserSelect) bodyObj).getSelected();

                //ユーザ情報を取得
                UserBiz userBiz = new UserBiz();
                ArrayList<CmnUsrmInfModel> userList
                    = userBiz.getUserList(con, selectUser,
                                        GSConstUser.USER_JTKBN_ALL);

                //ユーザSIDとログインIDのMappingを取得
                CmnUsrmDao usrmDao = new CmnUsrmDao(con);
                Map<Integer, String> userIdMap = usrmDao.getUserIdMap(selectUser);
                for (CmnUsrmInfModel usrMdl : userList) {
                    RngRestapiRingiBodyContentModel contentMdl
                        = new RngRestapiRingiBodyContentModel(cellType);
                    contentMdl.setUserId(userIdMap.get(usrMdl.getUsrSid()));
                    contentMdl.setUserName(usrMdl.getUsiName());
                    contentMdl.setUserDeleteFlg(__formatJkbn(usrMdl.getUsrJkbn()));
                    contentMdl.setLoginStopFlg(usrMdl.getUsrUkoFlg());
                    contentArray.add(contentMdl);
                }

                break;
            case group:
                //グループ情報を取得
                String[] selectGroup = ((GroupComboModel) bodyObj).getSelected();
                int[] selctGroupSidList = new int[0];
                List<CmnGroupmModel> groupList = new ArrayList<CmnGroupmModel>();
                if (selectGroup != null && selectGroup.length > 0) {
                    selctGroupSidList =
                        Stream.of(selectGroup)
                            .mapToInt(Integer::parseInt)
                            .toArray();
                    CmnGroupmDao grpmDao = new CmnGroupmDao(con);
                    groupList = grpmDao.selectAllFromSid(selctGroupSidList);
                }

                for (CmnGroupmModel grpMdl : groupList) {
                    RngRestapiRingiBodyContentModel contentMdl
                        = new RngRestapiRingiBodyContentModel(cellType);
                    contentMdl.setGroupId(grpMdl.getGrpId());
                    contentMdl.setGroupName(grpMdl.getGrpName());
                    contentMdl.setGroupDeleteFlg(__formatJkbn(grpMdl.getGrpJkbn()));
                    contentArray.add(contentMdl);
                }

                break;
            case file:
                CmnBinfDao binDao = new CmnBinfDao(con);
                Temp temp = (Temp) bodyObj;

                if (temp.getBinSids() != null && !temp.getBinSids().isEmpty()) {
                    String[] binSidList =
                        temp.getBinSids().stream()
                        .map(s -> String.valueOf(s))
                        .toArray(String[]::new);

                    List<CmnBinfModel> binMdlList = binDao.select(binSidList);
                    for (CmnBinfModel binMdl : binMdlList) {
                        RngRestapiRingiBodyContentModel contentMdl
                            = new RngRestapiRingiBodyContentModel(cellType);
                        if (!isSyousai__) {
                            contentMdl = new RngRestapiRingiBodyContentModel(
                                    cellType, false, true);
                            contentMdl.setIndexNum(-1);
                        }
                        contentMdl.setBinSid(binMdl.getBinSid());
                        contentMdl.setFileName(binMdl.getBinFileName());
                        contentMdl.setFileSizeByteNum(binMdl.getBinFileSize());
                        contentArray.add(contentMdl);
                    }
                }
                if (!isSyousai__) {
                    String tempDir = temp.getTempPath().getTempPath();
                    CommonBiz cmnBiz = new CommonBiz();
                    @SuppressWarnings("deprecation")
                    List<TempFileModel> tempFileList = cmnBiz.getTempFiles(tempDir);

                    for (int i = 0; i < tempFileList.size(); i++) {
                        RngRestapiRingiBodyContentModel contentMdl =
                            new RngRestapiRingiBodyContentModel(cellType, false, true);
                        TempFileModel mdl = tempFileList.get(i);
                        contentMdl.setBinSid(-1);
                        contentMdl.setFileName(mdl.getFileName());
                        contentMdl.setFileSizeByteNum(mdl.getFile().length());
                        contentArray.add(contentMdl);
                        contentMdl.setIndexNum(i);
                    }
                }

                break;
            case block:
                RngRestapiRingiBodyContentModel blockContentMdl
                    = new RngRestapiRingiBodyContentModel(cellType);
                blockContentMdl.setBlockRowArray(
                    __createRowArrayModel(con, ((Block) bodyObj).getFormTable(), 0)
                );
                contentArray.add(blockContentMdl);
                break;
            case blocklist:
                BlockList blockList = (BlockList) bodyObj;
                RngRestapiRingiBodyContentModel contentMdl
                    = new RngRestapiRingiBodyContentModel(cellType);
                //ヘッダー
                contentMdl.setHeaderArray(
                    __createRowArrayModel(con, blockList.getHeader().getFormTable(), 0)
                );

                //ボディ
                List<RngRestapiRingiBlockBodyRowArrayModel> bodyBlockList =
                    new ArrayList<RngRestapiRingiBlockBodyRowArrayModel>();
                for (Block bodyBlock : blockList.getBodyList()) {
                    RngRestapiRingiBlockBodyRowArrayModel bodyBlockMdl
                        = new RngRestapiRingiBlockBodyRowArrayModel();
                    bodyBlockMdl.setBlockRowArray(
                        __createRowArrayModel(con, bodyBlock.getFormTable(), bodyBlock.getRowNo())
                    );
                    bodyBlockList.add(bodyBlockMdl);
                }
                contentMdl.setBodyArray(bodyBlockList);

                //フッター
                contentMdl.setFooterArray(
                    __createRowArrayModel(con, blockList.getFooter().getFormTable(), 0)
                );

                contentArray.add(contentMdl);
                break;
            default:
                break;
        }

        if (__isDetailContent(parentBodyMdl.getType())) {
            ((RngRestapiRingiBodyDetailModel) parentBodyMdl).setContentArray(contentArray);
        } else {
            ((RngRestapiRingiBodySimpleModel) parentBodyMdl).setContentArray(contentArrayString);
        }
    }

    /**
     * <p>稟議申請内容から「ブロック要素Model」を生成する
     * @param con コネクション
     * @param formCellList 稟議申請内容
     * @param rowNo 行番号
     * @return contentArray 表要素情報Model
     * @throws SQLException SQL実行時例外
     * @throws RtpNotfoundException 対象の稟議テンプレートが存在しない
     * @throws IOToolsException 添付ファイル情報の取得に失敗
     */
    private List<RngRestapiRingiBlockRowArrayModel> __createRowArrayModel(
                            Connection con,
                            List<List<FormCell>> formCellList,
                            int rowNo)
        throws SQLException, RtpNotfoundException, IOToolsException {

        List<RngRestapiRingiBlockRowArrayModel> result
            = new ArrayList<RngRestapiRingiBlockRowArrayModel>();
        for (List<FormCell> cellList : formCellList) {
            RngRestapiRingiBlockRowArrayModel rowArrayMdl =
                new RngRestapiRingiBlockRowArrayModel();
            rowArrayMdl.setRowArray(
                __createRingiBodyDataModel(con, cellList, rowNo));

            result.add(rowArrayMdl);
        }

        return result;
    }

    /**
     * 「値が入力されている場合のみ」出力配列に追加する
     * @param contentArrayString 出力配列
     * @param value 値
     */
    private void __addContentArrayString(List<String> contentArrayString, String value) {
        if (!StringUtil.isNullZeroString(value)) {
            contentArrayString.add(value);
        }
    }

    /**
     * 「数値形式の値」を出力配列に追加する
     * @param contentArrayString 出力配列
     * @param value 値
     * @param tani 単位
     */
    private void __addNumberToContentArray(List<String> contentArrayString,
                                        String value, String tani) {

        String content = StringUtil.toCommaFormat(value);
        content = NullDefault.getString(content, "")
                + NullDefault.getString(tani, "");
        if (!StringUtil.isNullZeroString(content)) {
            contentArrayString.add(content);
        }
    }

    /**
     * <p>ユーザ・グループの状態区分をレスポンスの設定値に変換する
     * @param jkbn 状態区分
     * @return 状態区分
     */
    private int __formatJkbn(int jkbn) {
        if (jkbn == GSConst.JTKBN_DELETE) {
            return GSConstApi.JKBN_DELETE;
        }
        return GSConstApi.JKBN_NORMAL;
    }
}
