package jp.groupsession.v2.rng.restapi;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.co.sjts.util.StringUtil;
import jp.co.sjts.util.io.IOToolsException;
import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.cmn.GSConstApi;
import jp.groupsession.v2.cmn.biz.UserBiz;
import jp.groupsession.v2.cmn.dao.base.CmnBinfDao;
import jp.groupsession.v2.cmn.dao.base.CmnGroupmDao;
import jp.groupsession.v2.cmn.dao.base.CmnUsrmDao;
import jp.groupsession.v2.cmn.formbuilder.EnumFormModelKbn;
import jp.groupsession.v2.cmn.formbuilder.FormCell;
import jp.groupsession.v2.cmn.formbuilder.FormInputBuilder;
import jp.groupsession.v2.cmn.formmodel.AbstractFormModel;
import jp.groupsession.v2.cmn.formmodel.Block;
import jp.groupsession.v2.cmn.formmodel.BlockList;
import jp.groupsession.v2.cmn.formmodel.Calc;
import jp.groupsession.v2.cmn.formmodel.CheckBox;
import jp.groupsession.v2.cmn.formmodel.ComboBox;
import jp.groupsession.v2.cmn.formmodel.Comment;
import jp.groupsession.v2.cmn.formmodel.DateBox;
import jp.groupsession.v2.cmn.formmodel.GroupComboModel;
import jp.groupsession.v2.cmn.formmodel.NumberBox;
import jp.groupsession.v2.cmn.formmodel.RadioButton;
import jp.groupsession.v2.cmn.formmodel.SimpleUserSelect;
import jp.groupsession.v2.cmn.formmodel.Sum;
import jp.groupsession.v2.cmn.formmodel.Temp;
import jp.groupsession.v2.cmn.formmodel.TextInput;
import jp.groupsession.v2.cmn.formmodel.Textarea;
import jp.groupsession.v2.cmn.formmodel.TimeBox;
import jp.groupsession.v2.cmn.model.base.CmnBinfModel;
import jp.groupsession.v2.cmn.model.base.CmnGroupmModel;
import jp.groupsession.v2.cmn.model.base.CmnUsrmInfModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.RtpNotfoundException;
import jp.groupsession.v2.rng.restapi.model.content.RngRestapiRingiBodyContentModel;
import jp.groupsession.v2.rng.restapi.model.content.RngRestapiRingiBodyModel;
import jp.groupsession.v2.rng.restapi.model.content.RngRestapiRingiBodyRowModel;
import jp.groupsession.v2.rng.restapi.model.content.RngRestapiRingiBodySinseiModel;
import jp.groupsession.v2.rng.restapi.model.content.block.RngRestapiRingiBlockBodyRowArrayModel;
import jp.groupsession.v2.rng.restapi.model.content.block.RngRestapiRingiBlockRowArrayModel;
import jp.groupsession.v2.usr.GSConstUser;

/**
 * <br>[機  能] 稟議申請情報を取得する際の、申請内容を取得するビジネスロジック
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author  JTS
 */
public class RngRestApiSinseiModelBiz {
    /** ログ */
    Log log__ = LogFactory.getLog(getClass());

    /** RESTAPIコンテキスト */
    private RestApiContext ctx__ = null;
    /** 初期値情報(表に使用) */
    private FormInputBuilder initFormBuilder__ = null;

    /**
     * <br>[機  能] コンストラクタ
     * <br>[解  説]
     * <br>[備  考]
     * @param ctx RESTAPIコンテキスト
     * @param initFormBuilder 申請内容初期値情報
     */
    public RngRestApiSinseiModelBiz(RestApiContext ctx, FormInputBuilder initFormBuilder) {
        ctx__ = ctx;
        initFormBuilder__ = initFormBuilder;
    }

    /**
     * <br>[機  能] 申請情報のレスポンスに設定するbodyListを取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param formBuilder 申請内容
     * @return 申請情報のレスポンスに設定するbodyList
     */
    public List<RngRestapiRingiBodyRowModel> getSinseiBodyList(
        FormInputBuilder formBuilder) throws SQLException, RtpNotfoundException, IOToolsException {

        List<RngRestapiRingiBodyRowModel> bodyList
            = new ArrayList<RngRestapiRingiBodyRowModel>();

        Connection con = ctx__.getCon();
        for (List<FormCell> cellList : formBuilder.getFormTable()) {
            RngRestapiRingiBodyRowModel rowMdl = new RngRestapiRingiBodyRowModel();
            rowMdl.setRowArray(
                __createRingiBodySinseiModel(
                    con,
                    cellList)
            );
            bodyList.add(rowMdl);
        }

        return bodyList;
    }

    /**
     * <p>指定した稟議の申請内容情報(申請用)を取得する
     * @param con コネクション
     * @param cellList List<FormCell>
     * @return 稟議申請情報
     * @throws SQLException SQL実行時例外
     * @throws RtpNotfoundException 対象の稟議テンプレートが存在しない
     *
     */
    private List<RngRestapiRingiBodyModel> __createRingiBodySinseiModel(
        Connection con, List<FormCell> cellList)
        throws SQLException, RtpNotfoundException, IOToolsException {

        List<RngRestapiRingiBodyModel> bodyList
            = new ArrayList<RngRestapiRingiBodyModel>();

        for (FormCell cell : cellList) {
            int cellType = cell.getType().getValue();

            RngRestapiRingiBodySinseiModel bodyMdl = new RngRestapiRingiBodySinseiModel();
            bodyMdl.setFormId(cell.getFormID());
            bodyMdl.setType(cellType);
            bodyMdl.setName(cell.getTitle());

            __setSinseiNaiyouArray(con, cell, bodyMdl);

            bodyList.add(bodyMdl);
        }

        return bodyList;
    }

    /**
     * <p>入力された申請内容から、レスポンスに返す申請内容を取得しモデルに設定する。
     * @param con コネクション
     * @param cell FormCell
     * @param parentBodyMdl RngRestapiRingiBodySinseiModel
     * @throws SQLException SQL実行時例外
     * @throws RtpNotfoundException 対象の稟議テンプレートが存在しない
     * @throws IOToolsException 添付ファイル情報の取得に失敗
     */
    private void __setSinseiNaiyouArray(
        Connection con,
        FormCell cell,
        RngRestapiRingiBodySinseiModel parentBodyMdl)
        throws SQLException, RtpNotfoundException, IOToolsException {

        AbstractFormModel bodyObj = cell.getBody();

        int cellType = cell.getType().getValue();
        switch (cell.getType()) {
            case label:
                Comment comment = (Comment) bodyObj;
                parentBodyMdl.setValueText(comment.getValue());
                if (comment.getNotitle() == RngConst.RNG_COMMENT_TITLE_HIDDEN) {
                    parentBodyMdl.setName("");
                }
                break;
            case textbox:
                parentBodyMdl.setRequireFlg(cell.getRequire());
                TextInput textInput = (TextInput) bodyObj;
                parentBodyMdl.setValueText(textInput.getValue());
                parentBodyMdl.setMaxLengthNum(Integer.valueOf(textInput.getMaxlength()));
                break;
            case textarea:
                parentBodyMdl.setRequireFlg(cell.getRequire());
                Textarea textArea = (Textarea) bodyObj;
                parentBodyMdl.setValueText(textArea.getValue());
                parentBodyMdl.setMaxLengthNum(Integer.valueOf(textArea.getMaxlength()));
                break;
            case date:
                parentBodyMdl.setRequireFlg(cell.getRequire());
                parentBodyMdl.setValueText(((DateBox) bodyObj).getValue());
                break;
            case time:
                parentBodyMdl.setRequireFlg(cell.getRequire());
                parentBodyMdl.setValueText(((TimeBox) bodyObj).getValue());
                break;
            case number:
                parentBodyMdl.setRequireFlg(cell.getRequire());
                NumberBox numberBox = (NumberBox) bodyObj;
                parentBodyMdl.setValueText(numberBox.getValue());
                parentBodyMdl.setMaxLengthNum(Integer.valueOf(numberBox.getMaxlength()));
                parentBodyMdl.setUnitText(numberBox.getTanni());
                break;
            case radio:
                RadioButton radioButton = (RadioButton) bodyObj;
                String radioValue = radioButton.getSelected();
                if (radioButton.getList() != null && !radioButton.getList().contains(radioValue)) {
                    radioValue = null;
                }
                parentBodyMdl.setValueText(radioValue);
                parentBodyMdl.setSelectTargetArray(radioButton.getList());
                break;
            case combo:
                ComboBox comboBox = (ComboBox) bodyObj;
                String comboValue = comboBox.getSelected();
                if (comboBox.getList() != null && !comboBox.getList().contains(comboValue)) {
                    comboValue = null;
                }
                parentBodyMdl.setValueText(comboValue);
                parentBodyMdl.setSelectTargetArray(comboBox.getList());
                break;
            case check:
                CheckBox checkBox = (CheckBox) bodyObj;
                parentBodyMdl.setRequireFlg(cell.getRequire());
                if (checkBox.getSelected() != null) {
                    List<String> selectedList = Arrays.asList(checkBox.getSelected());
                    parentBodyMdl.setValueTextArray(selectedList);
                } else {
                    parentBodyMdl.setValueTextArray(new ArrayList<String>());
                }
                parentBodyMdl.setSelectTargetArray(checkBox.getList());
                break;
            case sum:
                Sum sum = (Sum) bodyObj;
                parentBodyMdl.setValueText(__getTanniText(sum.getValue(), sum.getTanni()));
                break;
            case calc:
                Calc calc = (Calc) bodyObj;
                parentBodyMdl.setValueText(__getTanniText(calc.getValue(), calc.getTanni()));
                break;
            case user:
                parentBodyMdl.setRequireFlg(cell.getRequire());
                SimpleUserSelect userSelect = (SimpleUserSelect) bodyObj;
                parentBodyMdl.setMultiFlg(userSelect.getMultiFlg());

                List<RngRestapiRingiBodyContentModel> selectUserArray
                    = new ArrayList<RngRestapiRingiBodyContentModel>();

                String[] selectUser = ((SimpleUserSelect) bodyObj).getSelected();
                if (selectUser == null || selectUser.length == 0
                    || Arrays.stream(selectUser).allMatch(String::isEmpty)) {
                    break;
                }

                //ユーザ情報を取得
                UserBiz userBiz = new UserBiz();
                ArrayList<CmnUsrmInfModel> userList
                    = userBiz.getUserList(con, selectUser,
                                        GSConstUser.USER_JTKBN_ALL);

                //ユーザSIDとログインIDのMappingを取得
                CmnUsrmDao usrmDao = new CmnUsrmDao(con);
                Map<Integer, String> userIdMap = usrmDao.getUserIdMap(selectUser);
                for (CmnUsrmInfModel usrMdl : userList) {
                    RngRestapiRingiBodyContentModel contentMdl
                        = new RngRestapiRingiBodyContentModel(cellType);
                    contentMdl.setUserId(userIdMap.get(usrMdl.getUsrSid()));
                    contentMdl.setUserName(usrMdl.getUsiName());
                    contentMdl.setUserDeleteFlg(__formatJkbn(usrMdl.getUsrJkbn()));
                    contentMdl.setLoginStopFlg(usrMdl.getUsrUkoFlg());
                    selectUserArray.add(contentMdl);
                }
                parentBodyMdl.setSelectUserArray(selectUserArray);

                break;
            case group:
                parentBodyMdl.setRequireFlg(cell.getRequire());
                GroupComboModel groupSelect = (GroupComboModel) bodyObj;
                parentBodyMdl.setMultiFlg(groupSelect.getMultiFlg());

                //グループ情報を取得
                String[] selectGroup = ((GroupComboModel) bodyObj).getSelected();
                int[] selctGroupSidList = new int[0];
                List<CmnGroupmModel> groupList = new ArrayList<CmnGroupmModel>();
                if (selectGroup != null && selectGroup.length > 0) {
                    selctGroupSidList =
                        Stream.of(selectGroup)
                            .mapToInt(Integer::parseInt)
                            .toArray();
                    CmnGroupmDao grpmDao = new CmnGroupmDao(con);
                    groupList = grpmDao.selectAllFromSid(selctGroupSidList);
                }

                List<RngRestapiRingiBodyContentModel> selectGroupArray
                    = new ArrayList<RngRestapiRingiBodyContentModel>();

                for (CmnGroupmModel grpMdl : groupList) {
                    RngRestapiRingiBodyContentModel contentMdl
                        = new RngRestapiRingiBodyContentModel(cellType);
                    contentMdl.setGroupId(grpMdl.getGrpId());
                    contentMdl.setGroupName(grpMdl.getGrpName());
                    contentMdl.setGroupDeleteFlg(__formatJkbn(grpMdl.getGrpJkbn()));
                    selectGroupArray.add(contentMdl);
                }
                parentBodyMdl.setSelectGroupArray(selectGroupArray);
                break;
            case file:
                parentBodyMdl.setRequireFlg(cell.getRequire());
                CmnBinfDao binDao = new CmnBinfDao(con);
                Temp temp = (Temp) bodyObj;

                List<RngRestapiRingiBodyContentModel> displayFileArray
                    = new ArrayList<RngRestapiRingiBodyContentModel>();
                String[] sampleFileBinSids = temp.getSample();
                if (sampleFileBinSids != null && sampleFileBinSids.length > 0) {
                    List<CmnBinfModel> binMdlList = binDao.select(sampleFileBinSids);
                    for (CmnBinfModel binMdl : binMdlList) {
                        RngRestapiRingiBodyContentModel contentMdl
                            = new RngRestapiRingiBodyContentModel(cellType);
                        contentMdl.setBinSid(binMdl.getBinSid());
                        contentMdl.setFileName(binMdl.getBinFileName());
                        contentMdl.setFileSizeByteNum(binMdl.getBinFileSize());
                        displayFileArray.add(contentMdl);
                    }
                }
                parentBodyMdl.setDisplayFileArray(displayFileArray);

                List<RngRestapiRingiBodyContentModel> tmpFileArray
                    = new ArrayList<RngRestapiRingiBodyContentModel>();
                if (temp.getBinSids() != null && !temp.getBinSids().isEmpty()) {
                    String[] binSidList =
                        temp.getBinSids().stream()
                        .map(s -> String.valueOf(s))
                        .toArray(String[]::new);
                    List<CmnBinfModel> binMdlList = binDao.select(binSidList);
                    for (CmnBinfModel binMdl : binMdlList) {
                        RngRestapiRingiBodyContentModel contentMdl
                            = new RngRestapiRingiBodyContentModel(cellType);
                        contentMdl.setBinSid(binMdl.getBinSid());
                        contentMdl.setFileName(binMdl.getBinFileName());
                        contentMdl.setFileSizeByteNum(binMdl.getBinFileSize());
                        tmpFileArray.add(contentMdl);
                    }
                }
                parentBodyMdl.setTmpFileArray(tmpFileArray);

                break;
            case block:
                parentBodyMdl.setBlockRowArray(
                    __createRowArraySinseiModel(con, ((Block) bodyObj).getFormTable())
                );
                break;
            case blocklist:
                BlockList blockList = (BlockList) bodyObj;
                RngRestapiRingiBodyContentModel contentMdl
                    = new RngRestapiRingiBodyContentModel(cellType);
                //ヘッダー
                contentMdl.setHeaderArray(
                    __createRowArraySinseiModel(con, blockList.getHeader().getFormTable())
                );

                //ボディ
                List<RngRestapiRingiBlockBodyRowArrayModel> bodyBlockList =
                    new ArrayList<RngRestapiRingiBlockBodyRowArrayModel>();
                for (Block bodyBlock : blockList.getBodyList()) {
                    RngRestapiRingiBlockBodyRowArrayModel bodyBlockMdl
                        = new RngRestapiRingiBlockBodyRowArrayModel();
                    bodyBlockMdl.setBlockRowArray(
                        __createRowArraySinseiModel(con, bodyBlock.getFormTable())
                    );
                    bodyBlockList.add(bodyBlockMdl);
                }
                __removeDisplayFileArray(bodyBlockList);
                contentMdl.setBodyArray(bodyBlockList);

                RngRestapiRingiBodyContentModel initContentInfo
                    = new RngRestapiRingiBodyContentModel(cellType, true, false);
                FormCell initCell = initFormBuilder__.getFormTable()
                    .stream()
                    .flatMap(List::stream)
                    .filter(c -> c.getFormID().equals(cell.getFormID()))
                    .findFirst()
                    .orElse(null);
                List<RngRestapiRingiBlockBodyRowArrayModel> initBodyBlockList =
                    new ArrayList<RngRestapiRingiBlockBodyRowArrayModel>();
                BlockList initBlockList = (BlockList) initCell.getBody();
                for (Block bodyBlock : initBlockList.getBodyList()) {
                    RngRestapiRingiBlockBodyRowArrayModel bodyBlockMdl
                        = new RngRestapiRingiBlockBodyRowArrayModel();
                    bodyBlockMdl.setBlockRowArray(
                        __createRowArraySinseiModel(con, bodyBlock.getFormTable())
                    );
                    initBodyBlockList.add(bodyBlockMdl);
                }
                initContentInfo.setBodyArray(initBodyBlockList);
                parentBodyMdl.setInitContentInfo(initContentInfo);

                //フッター
                contentMdl.setFooterArray(
                    __createRowArraySinseiModel(con, blockList.getFooter().getFormTable())
                );
                parentBodyMdl.setContentInfo(contentMdl);
                break;
            default:
                break;
        }
    }

    /**
     * <p>表要素のボディ行にある、2行目以降の添付ファイル要素の中から表示用添付ファイル情報を削除する
     * @param bodyBlockList 表要素のボディ情報
     */
    private void __removeDisplayFileArray(
        List<RngRestapiRingiBlockBodyRowArrayModel> bodyBlockList) {

        if (bodyBlockList == null || bodyBlockList.isEmpty()) {
            return;
        }
        boolean isFirst = true;
        for (RngRestapiRingiBlockBodyRowArrayModel bodyBlockMdl : bodyBlockList) {
            if (bodyBlockMdl.getBlockRowArray() == null) {
                isFirst = false;
                continue;
            }
            for (RngRestapiRingiBlockRowArrayModel rowMdl : bodyBlockMdl.getBlockRowArray()) {
                if (rowMdl.getRowArray() == null) {
                    continue;
                }
                for (RngRestapiRingiBodyModel bodyMdl : rowMdl.getRowArray()) {
                    RngRestapiRingiBodySinseiModel sinseiBodyMdl
                        = (RngRestapiRingiBodySinseiModel) bodyMdl;
                    if (sinseiBodyMdl.getType() != EnumFormModelKbn.file.getValue()) {
                        continue;
                    }
                    if (!isFirst) {
                        sinseiBodyMdl.setDisplayFileArray(null);
                    }
                }
            }
            isFirst = false;
        }
    }

    /**
     * <p>自動計算(合計), 自動計算(その他)要素の表示内容(単位付き)を取得する
     * @param value 計算値
     * @param tanni 単位
     * @return 表示内容(単位付き)
     */
    private String __getTanniText(String value, String tanni) {

        StringBuilder sb = new StringBuilder();
        sb.append(value);
        if (!StringUtil.isNullZeroString(tanni)) {
            sb.append(" ");
            sb.append(tanni);
        }

        return sb.toString();
    }

    /**
     * <p>ユーザ・グループの状態区分をレスポンスの設定値に変換する
     * @param jkbn 状態区分
     * @return 状態区分
     */
    private int __formatJkbn(int jkbn) {
        if (jkbn == GSConst.JTKBN_DELETE) {
            return GSConstApi.JKBN_DELETE;
        }
        return GSConstApi.JKBN_NORMAL;
    }

    /**
     * <p>稟議申請内容から「ブロック要素Model」を生成する
     * @param con コネクション
     * @param formCellList 稟議申請内容
     * @return contentArray 表要素情報Model
     * @throws SQLException SQL実行時例外
     * @throws RtpNotfoundException 対象の稟議テンプレートが存在しない
     * @throws IOToolsException 添付ファイル情報の取得に失敗
     */
    private List<RngRestapiRingiBlockRowArrayModel> __createRowArraySinseiModel(
        Connection con, List<List<FormCell>> formCellList)
        throws SQLException, RtpNotfoundException, IOToolsException {

        List<RngRestapiRingiBlockRowArrayModel> result
            = new ArrayList<RngRestapiRingiBlockRowArrayModel>();
        for (List<FormCell> cellList : formCellList) {
            RngRestapiRingiBlockRowArrayModel rowArrayMdl =
                new RngRestapiRingiBlockRowArrayModel();
            rowArrayMdl.setRowArray(
                __createRingiBodySinseiModel(con, cellList));

            result.add(rowArrayMdl);
        }

        return result;
    }
}
