package jp.groupsession.v2.rng.restapi;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.util.MessageResources;

import jp.co.sjts.util.EnumUtil.EnumOutRangeException;
import jp.co.sjts.util.NullDefault;
import jp.co.sjts.util.StringUtil;
import jp.co.sjts.util.date.UDate;
import jp.co.sjts.util.date.UDateUtil;
import jp.co.sjts.util.encryption.Blowfish;
import jp.co.sjts.util.encryption.EncryptionException;
import jp.co.sjts.util.io.IOTools;
import jp.co.sjts.util.io.IOToolsException;
import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.cmn.GSConstApi;
import jp.groupsession.v2.cmn.GSConstCommon;
import jp.groupsession.v2.cmn.GSTemporaryPathUtil;
import jp.groupsession.v2.cmn.biz.ActionMessageBiz;
import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.biz.GroupBiz;
import jp.groupsession.v2.cmn.biz.LoggingBiz;
import jp.groupsession.v2.cmn.biz.UserGroupSelectBiz;
import jp.groupsession.v2.cmn.dao.UserSearchDao;
import jp.groupsession.v2.cmn.dao.base.CmnFileConfDao;
import jp.groupsession.v2.cmn.dao.base.CmnGroupmDao;
import jp.groupsession.v2.cmn.dao.base.CmnUsrmDao;
import jp.groupsession.v2.cmn.exception.TempFileException;
import jp.groupsession.v2.cmn.formbuilder.EnumFormModelKbn;
import jp.groupsession.v2.cmn.formbuilder.FormAccesser;
import jp.groupsession.v2.cmn.formbuilder.FormCell;
import jp.groupsession.v2.cmn.formbuilder.FormInputBuilder;
import jp.groupsession.v2.cmn.formbuilder.FormInputInitPrefarence;
import jp.groupsession.v2.cmn.formbuilder.ValidateInfo;
import jp.groupsession.v2.cmn.formmodel.Block;
import jp.groupsession.v2.cmn.formmodel.BlockList;
import jp.groupsession.v2.cmn.formmodel.CheckBox;
import jp.groupsession.v2.cmn.formmodel.ComboBox;
import jp.groupsession.v2.cmn.formmodel.DateBox;
import jp.groupsession.v2.cmn.formmodel.GroupComboModel;
import jp.groupsession.v2.cmn.formmodel.NumberBox;
import jp.groupsession.v2.cmn.formmodel.RadioButton;
import jp.groupsession.v2.cmn.formmodel.SimpleUserSelect;
import jp.groupsession.v2.cmn.formmodel.Temp;
import jp.groupsession.v2.cmn.formmodel.TextInput;
import jp.groupsession.v2.cmn.formmodel.Textarea;
import jp.groupsession.v2.cmn.formmodel.TimeBox;
import jp.groupsession.v2.cmn.formmodel.UserGroupSelectModel;
import jp.groupsession.v2.cmn.model.ActionMessageModel;
import jp.groupsession.v2.cmn.model.CmnUserModel;
import jp.groupsession.v2.cmn.model.GSTemporaryPathModel;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.cmn.model.base.CmnBinfModel;
import jp.groupsession.v2.cmn.model.base.CmnFileConfModel;
import jp.groupsession.v2.cmn.model.base.CmnGroupmModel;
import jp.groupsession.v2.cmn.model.base.CmnLogModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.RestApiValidateException;
import jp.groupsession.v2.restapi.msg.RestapiMessageResources;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.RtpNotfoundException;
import jp.groupsession.v2.rng.biz.RngBiz;
import jp.groupsession.v2.rng.biz.RngFormBuildBiz;
import jp.groupsession.v2.rng.biz.RngTemplateBiz;
import jp.groupsession.v2.rng.dao.RingiDao;
import jp.groupsession.v2.rng.dao.RngBinDao;
import jp.groupsession.v2.rng.dao.RngCopyKeiroStepDao;
import jp.groupsession.v2.rng.dao.RngCopyKeirostepSelectDao;
import jp.groupsession.v2.rng.dao.RngKeiroStepDao;
import jp.groupsession.v2.rng.dao.RngKeiroStepDao.SearchModel;
import jp.groupsession.v2.rng.dao.RngKeirostepSelectDao;
import jp.groupsession.v2.rng.dao.RngRndataDao;
import jp.groupsession.v2.rng.dao.RngTemplateDao;
import jp.groupsession.v2.rng.dao.RngTemplateFormDao;
import jp.groupsession.v2.rng.dao.RngTemplateKeiroDao;
import jp.groupsession.v2.rng.dao.RngTemplateKeiroDao.SearchParamForRTP;
import jp.groupsession.v2.rng.dao.RngTemplateKeiroUserDao;
import jp.groupsession.v2.rng.model.RingiDataModel;
import jp.groupsession.v2.rng.model.RingiIdModel;
import jp.groupsession.v2.rng.model.RngCopyKeiroStepModel;
import jp.groupsession.v2.rng.model.RngCopyKeirostepSelectModel;
import jp.groupsession.v2.rng.model.RngKeiroStepModel;
import jp.groupsession.v2.rng.model.RngKeirostepSelectModel;
import jp.groupsession.v2.rng.model.RngRndataModel;
import jp.groupsession.v2.rng.model.RngTemplateFormModel;
import jp.groupsession.v2.rng.model.RngTemplateKeiroModel;
import jp.groupsession.v2.rng.model.RngTemplateKeiroUserModel;
import jp.groupsession.v2.rng.model.RngTemplateModel;
import jp.groupsession.v2.rng.restapi.entities.EnumRngEntitiesType;
import jp.groupsession.v2.rng.restapi.entities.IRngEntitiesGetParam;
import jp.groupsession.v2.rng.restapi.model.RngRestApiRingiSinseiModel;
import jp.groupsession.v2.rng.restapi.model.RngRestApiSinseiKeiroModel;
import jp.groupsession.v2.rng.restapi.model.RngRestapiRingiFileModel;
import jp.groupsession.v2.rng.restapi.model.RngRestapiRingiModel;
import jp.groupsession.v2.rng.restapi.model.content.RngRestApiSinseiKeiroGroupModel;
import jp.groupsession.v2.rng.restapi.model.content.RngRestApiSinseiKeiroTargetModel;
import jp.groupsession.v2.rng.restapi.model.content.RngRestApiSinseiKeiroTargetPostModel;
import jp.groupsession.v2.rng.restapi.model.content.RngRestapiRingiBodyRowModel;
import jp.groupsession.v2.rng.restapi.model.route.RngRestapiRingiApprovalRouteModel;
import jp.groupsession.v2.rng.restapi.model.route.RngRestapiRingiCheckRouteModel;
import jp.groupsession.v2.rng.restapi.model.route.member.RngRestapiRingiRouteMemberModel;
import jp.groupsession.v2.rng.restapi.parammodel.RngRestApiRingiBlockListParamModel;
import jp.groupsession.v2.rng.restapi.parammodel.RngRestApiRingiBodyParamModel;
import jp.groupsession.v2.rng.restapi.parammodel.RngRestApiRingiBodyRowParamModel;
import jp.groupsession.v2.rng.restapi.parammodel.RngRestApiRingiContentParamModel;
import jp.groupsession.v2.rng.restapi.parammodel.RngRestApiRingiRouteParamModel;
import jp.groupsession.v2.rng.restapi.parammodel.RngRestApiRingiTargetParamModel;
import jp.groupsession.v2.rng.restapi.templates.steps.groups.query.RngTemplatesStepsGroupsQueryResultModel;
import jp.groupsession.v2.rng.restapi.templates.steps.users.query.RngTemplatesStepsUsersQueryResultModel;
import jp.groupsession.v2.rng.rng020.Rng020Biz;
import jp.groupsession.v2.rng.rng020.Rng020Keiro;
import jp.groupsession.v2.rng.rng020.Rng020KeiroBlock;
import jp.groupsession.v2.rng.rng020.Rng020KeiroKakuninDsp;
import jp.groupsession.v2.rng.rng020kn.Rng020knBiz;
import jp.groupsession.v2.rng.rng030.Rng030Biz;
import jp.groupsession.v2.rng.rng030.Rng030KeiroAddBiz;
import jp.groupsession.v2.rng.rng030.Rng030KeiroParam;
import jp.groupsession.v2.rng.rng030.Rng030SingiParam;
import jp.groupsession.v2.rng.rng110keiro.EnumKeiroKbn;
import jp.groupsession.v2.rng.rng110keiro.Rng110KeiroDialogForm.TargetPosSel;
import jp.groupsession.v2.rng.rng110keiro.Rng110KeiroDialogParamModel;
import jp.groupsession.v2.rng.rng110keiro.RngTemplateKeiroSave;
import jp.groupsession.v2.struts.msg.GsMessage;
import jp.groupsession.v2.usr.model.UsrLabelValueBean;

/**
 * <br>[機  能] 稟議 RestAPIに関するビジネスロジッククラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author  JTS
 */
public class RngRestapiBiz {

    /** ログ */
    Log log__ = LogFactory.getLog(RngRestapiBiz.class);

    /**
     * <p>指定した稟議の詳細情報を取得する
     * @param ctx コンテキスト
     * @param rngSid 稟議SID
     * @param accountUsrSid 稟議アカウント ユーザSID
     * @param tempPathModel GSTemporaryPathModel
     * @return 稟議詳細情報
     * @throws SQLException SQL実行時例外
     * @throws RtpNotfoundException 対象の稟議テンプレートが存在しない
     * @throws IOToolsException 稟議フォーム情報生成時に例外発生
     */
    public RngRestapiRingiModel getRingiDetailModel(
                            RestApiContext ctx,
                            int rngSid,
                            int accountUsrSid,
                            GSTemporaryPathModel tempPathModel)
        throws SQLException, RtpNotfoundException, IOToolsException {

        RngRestapiRingiModel result = new RngRestapiRingiModel();

        Connection con = ctx.getCon();
        RequestModel reqMdl = ctx.getRequestModel();

        RngRndataDao rnDataDao = new RngRndataDao(con);
        RngRndataModel rnDataMdl = rnDataDao.select(rngSid);
        int procType = RngConst.RNG_MODE_SINSEI;
        if (rnDataMdl.getRngApplicate() == accountUsrSid) {
            procType = RngConst.RNG_MODE_JYUSIN;
        } else if (rnDataMdl.getRngCompflg() == RngConst.RNG_COMPFLG_COMPLETE) {
            procType = RngConst.RNG_MODE_KANRYO;
        }
        //経路SIDを取得
        Rng030Biz biz030 = new Rng030Biz(con, reqMdl);
        int viewKeiroSid = biz030.viewKeiroSid(rngSid, accountUsrSid, procType);

        //稟議情報を取得
        RingiDao ringiDao = new RingiDao(con);
        RingiDataModel ringiData = ringiDao.getRingiData(rngSid, accountUsrSid, viewKeiroSid);

        //稟議SID
        result.setSid(rngSid);

        //稟議状態 完了状態
        result.setStatusType(ringiData.getRngStatus());
        result.setCompKbn(ringiData.getRngCompflg());

        //削除可能フラグ
        RngBiz rngBiz = new RngBiz(con);
        if (rngBiz.canDeleteRingi(
            ringiData,
            accountUsrSid,
            ctx.getRequestUserModel())) {
            result.setDeleteKanouFlg(RngConst.RNG_DEL_OK);
        } else {
            result.setDeleteKanouFlg(RngConst.RNG_DEL_NG);
        }

        //タイトル
        result.setTitleText(ringiData.getRngTitle());

        //申請者情報
        result.setUserId(ringiData.getApprUserId());
        result.setUserName(ringiData.getApprUser());
        result.setLoginStopFlg(ringiData.getUsrUkoFlg());
        if (ringiData.isApprUserDelFlg()) {
            result.setUserDeleteFlg(GSConstApi.JKBN_DELETE);
        } else {
            result.setUserDeleteFlg(GSConstApi.JKBN_NORMAL);
        }

        //申請日時
        result.setEntryDateTime(
            UDateUtil.createDateTimeString(ringiData.getRngAppldate()));

        //最終更新日時
        result.setLastDateTime(
            UDateUtil.createDateTimeString(ringiData.getRngEdate()));

        //申請ID
        result.setEntryIdText(ringiData.getRngId());

        //フォーム入力ビルダーに申請情報をロード
        FormInputBuilder formBuilder = new FormInputBuilder();
        RngFormBuildBiz rngFormBiz = new RngFormBuildBiz(reqMdl);
        rngFormBiz.loadInputData(con, formBuilder, ringiData);

        //フォーム入力ビルダーに稟議テンプレート情報をロード
        int rtpSid = ringiData.getRtpSid();
        int rtpVer = ringiData.getRtpVer();
        rngFormBiz.loadTenplateData(con,  formBuilder, rtpSid, rtpVer);

        //フォーム入力ビルダーを描画設定
        FormInputInitPrefarence pref = new FormInputInitPrefarence();
        pref.setAppRoot(ctx.getAppRootPath());
        pref.setLoad(false);
        pref.setMode(FormInputBuilder.INITMODE_DSP);
        pref.setTempDir(tempPathModel);
        formBuilder.setInitPrefarence(pref);
        pref.setMode(FormInputBuilder.INITMODE_DSP);
        formBuilder.dspInit(reqMdl, con);

        //決裁後アクション 表示コメントを設定
        RngTemplateModel rtpMdl = rngFormBiz.getRtpModel(
            con, ringiData.getRtpSid(), ringiData.getRtpVer());
        if (rtpMdl != null) {
            result.setActionCommentText(rtpMdl.getRtpActionComment());
        }

        //申請内容の出力
        RngRestApiDetailModelBiz radBiz = new RngRestApiDetailModelBiz(true);
        List<RngRestapiRingiBodyRowModel> bodyList
            = radBiz.getRingiDetailBodyList(formBuilder, con);
        result.setBodyArray(bodyList);

        //承認経路情報、確認経路情報
        int currentStepSid =
            __setRingiRouteData(result, con, ringiData, reqMdl, accountUsrSid,
                                formBuilder);

        //審議中経路ステップSID
        result.setCurrentStepSid(currentStepSid);

        return result;
    }

    /**
     * <p>指定した稟議の確認経路情報を取得する
     * @param result 稟議詳細情報(Rest API レスポンスModel)
     * @param con コネクション
     * @param rngDataMdl 稟議情報Model稟議SID
     * @param reqMdl リクエスト情報
     * @param accountUsrSid 稟議アカウント ユーザSID
     * @param formBuilder FormInputBuilder
     * @return 審議中経路ステップSID
     * @throws SQLException SQL実行時例外
     */
    private int __setRingiRouteData(
                            RngRestapiRingiModel result,
                            Connection con,
                            RingiDataModel rngDataMdl,
                            RequestModel reqMdl,
                            int accountUsrSid,
                            FormInputBuilder formBuilder)
        throws SQLException {

        int currentStepSid = -1;

        //稟議経路情報を設定
        int rngSid = rngDataMdl.getRngSid();
        Rng030Biz biz030 = new Rng030Biz(con, reqMdl);
        RingiDao ringiDao = new RingiDao(con);
        List<Rng030KeiroParam> keiroList = biz030.getKerio(ringiDao, rngSid);

        //経路追加可能判定クラスの生成
        Rng030KeiroAddBiz keiroAddBiz = null;
        keiroAddBiz = new Rng030KeiroAddBiz(
                con, reqMdl, rngDataMdl.getRtpSid(), rngDataMdl.getRtpVer(),
                formBuilder);

        //経路別に経路追加可能かの判定を行う
        int singedFlg = RngConst.RNG_RNCSTATUS_APPR;
        boolean singiUserFlg = false;
        for (Rng030KeiroParam kMdl : keiroList) {
            if (singedFlg == RngConst.RNG_RNCSTATUS_CONFIRM) {
                singedFlg = RngConst.RNG_RNCSTATUS_NOSET;
            }
            if (kMdl.getKeiroStatus() == RngConst.RNG_RNCSTATUS_CONFIRM) {
                singedFlg = RngConst.RNG_RNCSTATUS_CONFIRM;
            }

            //「審議中」経路の経路ステップSIDを取得
            if (kMdl.getKeiroStatus() == RngConst.RNG_RNCSTATUS_CONFIRM) {
                //後閲指示先初期位置
                currentStepSid = kMdl.getKeiroStepSid();

                //「審議中」経路にパスパラメータで指定したアカウントが含まれるかを確認
                singiUserFlg
                    = kMdl.getSingiList().stream()
                        .filter(mdl -> mdl.getUserSid() == accountUsrSid)
                        .count() > 0;
            }

            //経路追加可能フラグ設定
            if (kMdl.getKeiroSingi() == RngConst.RNG_RNCSTATUS_NOSET) {
                keiroAddBiz.prefStepAddibleFlag(
                        kMdl, singedFlg);
            }

        }

        //経路情報を設定
        List<RngRestapiRingiApprovalRouteModel> apprRouteList
            = new ArrayList<RngRestapiRingiApprovalRouteModel>();
        List<RngRestapiRingiCheckRouteModel> checkRouteList
            = new ArrayList<RngRestapiRingiCheckRouteModel>();
        for (Rng030KeiroParam kMdl : keiroList) {
            if (kMdl.getKeiroSingi() == RngConst.RNG_RNCTYPE_CONFIRM) {
                //確認経路
                checkRouteList.add(__createCheckRouteModel(kMdl));
            } else {
                //承認経路
                apprRouteList.add(
                    __createApprRouteModel(kMdl));
            }
        }

        //承認経路情報に経路追加可能フラグ、後閲可能フラグを設定する
        int addStepFlg = 0, kouetuFlg = 0, apprStepSid = 0;
        for (int idx = 0; idx < apprRouteList.size(); idx++) {
            apprStepSid = apprRouteList.get(idx).getStepSid();
            //経路追加可能フラグを設定
            if (apprRouteList.get(idx).getAddStepFlg() == 1) {
                //審議中経路にパスパラメータのアカウント(ユーザ)が含まれる
                //かつ、審議中経路より後の経路の場合は経路追加可能
                if (singiUserFlg && keiroAddBiz.getAddRowTemplateMap().containsKey(apprStepSid)) {
                    addStepFlg = 1;
                } else {
                    addStepFlg = 0;
                }
                apprRouteList.get(idx).setAddStepFlg(addStepFlg);
            }

            //後閲可能フラグを設定
            if (apprRouteList.get(idx).getKoetsuFlg() == 1) {
                if (biz030.koetuBtnConf(
                        rngDataMdl, apprStepSid, accountUsrSid)) {
                    kouetuFlg = 1;
                } else {
                    kouetuFlg = 0;
                }
                apprRouteList.get(idx).setKoetsuFlg(kouetuFlg);
            }
        }

        result.setApprovalRouteArray(apprRouteList);
        result.setCheckRouteArray(checkRouteList);

        return currentStepSid;
    }

    /**
     * バイナリ情報(CMN_BINF)から確認時添付(checkFileArray)を生成する
     * @param binList バイナリ情報
     * @return 確認時添付
     */
    private List<RngRestapiRingiFileModel> __createFileArray(List<CmnBinfModel> binList) {

        if (binList == null || binList.isEmpty()) {
            return new ArrayList<RngRestapiRingiFileModel>();
        }

        List<RngRestapiRingiFileModel> fileArray = new ArrayList<RngRestapiRingiFileModel>();
        for (CmnBinfModel binMdl : binList) {
            RngRestapiRingiFileModel fileMdl = new RngRestapiRingiFileModel();
            fileMdl.setBinSid(binMdl.getBinSid());
            fileMdl.setFileName(binMdl.getBinFileName());
            fileMdl.setFileSizeByteNum(binMdl.getBinFileSize());
            fileArray.add(fileMdl);
        }

        return fileArray;
    }

    /**
    /**
     * 承認経路情報Modelを生成する
     * @param kMdl 経路情報
     * @return 承認経路情報Model
     */
    private RngRestapiRingiApprovalRouteModel __createApprRouteModel(
        Rng030KeiroParam kMdl) {
        RngRestapiRingiApprovalRouteModel routeMdl = new RngRestapiRingiApprovalRouteModel();

        //ステップSID
        routeMdl.setStepSid(kMdl.getKeiroStepSid());

        //審議状態
        routeMdl.setStatusType(kMdl.getKeiroStatus());

        //グループ情報
        if (!StringUtil.isNullZeroString(kMdl.getKeiroName())) {
            routeMdl.setGroupName(kMdl.getKeiroName());
            routeMdl.setGroupDeleteFlg(__formatJkbn(kMdl.getGroupDelFlg()));
        }

        //後閲実行ユーザ名
        routeMdl.setKoetsuUserName(kMdl.getKeiroKoetuMei());

        //後閲可能フラグ
        if (kMdl.getKeiroKoetu() == RngConst.RNG_KOETU_YES) {
            routeMdl.setKoetsuFlg(1);
        } else {
            routeMdl.setKoetsuFlg(0);
        }

        //経路追加可能フラグ
        routeMdl.setAddStepFlg(kMdl.getKeiroAddible());

        //承認条件種別
        int conditionType = kMdl.getKeiroProgress();
        routeMdl.setApprovalConditionType(conditionType);
        //承認条件値
        if (conditionType == RngConst.RNG_OUT_CONDITION_NUMBER
            || conditionType == RngConst.RNG_OUT_CONDITION_RATE) {
            routeMdl.setApprovalConditionNum(kMdl.getKeiroLimit());
        }

        //審議者情報
        routeMdl.setMemberArray(__createMemberArray(kMdl));

        return routeMdl;
    }

    /**
     * 確認経路情報Modelを生成する
     * @param kMdl 経路情報
     * @return 確認経路情報Model
     */
    private RngRestapiRingiCheckRouteModel __createCheckRouteModel(Rng030KeiroParam kMdl) {
        RngRestapiRingiCheckRouteModel routeMdl = new RngRestapiRingiCheckRouteModel();

        //ステップSID
        routeMdl.setStepSid(kMdl.getKeiroStepSid());

        //審議者情報
        routeMdl.setMemberArray(__createMemberArray(kMdl));

        return routeMdl;
    }

    /**
     * <p>審議者情報を生成する
     * @param kMdl Rng030KeiroParam
     * @return 審議者情報
     */
    private List<RngRestapiRingiRouteMemberModel> __createMemberArray(Rng030KeiroParam kMdl) {
        //審議者情報
        List<RngRestapiRingiRouteMemberModel> memberArray
            = new ArrayList<RngRestapiRingiRouteMemberModel>();
        for (Rng030SingiParam singiMdl : kMdl.getSingiList()) {
            memberArray.add(__createMemberModel(singiMdl));
        }
        return memberArray;
    }

    /**
     * 審議者情報を生成する
     * @param singiMdl 経路情報
     * @return 審議者情報
     */
    private RngRestapiRingiRouteMemberModel __createMemberModel(Rng030SingiParam singiMdl) {
        RngRestapiRingiRouteMemberModel memMdl = new RngRestapiRingiRouteMemberModel();

        //審議状態
        memMdl.setStatusType(singiMdl.getSingiStatus());

        //審議者ユーザ情報
        memMdl.setUserId(singiMdl.getUserId());
        memMdl.setUserName(singiMdl.getSingiName());
        memMdl.setLoginStopFlg(singiMdl.getUserUkoFlg());
        memMdl.setUserDeleteFlg(__formatJkbn(singiMdl.getUserJkbn()));

        //審議者ユーザ役職名
        memMdl.setUserYakusyokuName(singiMdl.getSingiPosition());

        //代理ユーザ情報
        memMdl.setDairiUserId(singiMdl.getDairiUserId());
        memMdl.setDairiUserName(singiMdl.getSingiDairi());
        if (!StringUtil.isNullZeroString(singiMdl.getDairiUserId())) {
            memMdl.setDairiUserLoginStopFlg(singiMdl.getDairiUkoFlg());
            memMdl.setDairiUserDeleteFlg(__formatJkbn(singiMdl.getDairiJkbn()));
        }

        //確認日時
        memMdl.setCheckDateTime(singiMdl.getSingiDateTime());
        //確認時コメント
        memMdl.setCheckCommentText(singiMdl.getSingiComment());
        //確認時添付
        memMdl.setCheckFileArray(__createFileArray(singiMdl.getTmpFileList()));

        return memMdl;
    }

    /**
     * <p>ユーザ・グループの状態区分をレスポンスの設定値に変換する
     * @param jkbn 状態区分
     * @return 状態区分
     */
    private int __formatJkbn(int jkbn) {
        if (jkbn == GSConst.JTKBN_DELETE) {
            return GSConstApi.JKBN_DELETE;
        }
        return GSConstApi.JKBN_NORMAL;
    }

    /**
　   * <br>[機  能] 草稿フォルダのアクセス権限チェックを行う
     * <br>[解  説] 草稿フォルダは自分自身からしかアクセスできない（代理人も不可）
     * <br>[備  考] このメソッドを使用する前に、アカウント権限チェックを行う事。
     * @param reqMdl リクエストモデル
     * @param accountId アカウントID（ユーザID)
     * @param procMode プロセスモード
     * @return アクセス可否
     */
    public boolean isAccessSokouFolder(RequestModel reqMdl, String accountId, int procMode) {

        //プロセスモードが草稿でなければ、アクセス可
        if (procMode != RngConst.RNG_MODE_SOUKOU) {
            return true;
        }

        //プロセスモードが草稿かつ、指定したアカウントIDとセッションユーザIDが一致している場合のみ
        if (reqMdl.getSmodel().getLgid().equals(accountId)
            && procMode == RngConst.RNG_MODE_SOUKOU) {
            return true;
        }

        return false;
    }

    /**
     * フォルダ名からプロセスモードに変換する
     * @param folderName フォルダ名
     * @return プロセスモード
     */
    public int getProcMode(String folderName) {
        //フォルダー名をプロセスモードに変換
        int procMode;
        switch (folderName) {
            case "jyusin":
                procMode = RngConst.RNG_MODE_JYUSIN;
                break;
            case "sinsei":
                procMode = RngConst.RNG_MODE_SINSEI;
                break;
            case "kanryo":
                procMode = RngConst.RNG_MODE_KANRYO;
                break;
            case "soukou":
                procMode = RngConst.RNG_MODE_SOUKOU;
                break;
            case "koetu":
                procMode = RngConst.RNG_MODE_KOETU;
                break;
            default:
                procMode = RngConst.RNG_MODE_JYUSIN;
                break;
        }
        return procMode;
    }

    /**
     * <br>[機  能] 草稿フォルダのアクセス権限チェックを行う
     * <br>[解  説] 草稿フォルダは自分自身からしかアクセスできない（代理人も不可）
     * <br>[備  考] このメソッドを使用する前に、アカウント権限チェックを行う事。
     * @param ctx コンテキスト
     * @param actionType 実行種別 0：草稿から編集, 1：複写申請, 2：再申請
     * @param rngData 稟議情報
     * @param rtpMdl テンプレート情報
     * @param formBuilder フォーム情報
     * @param tempPathModel GSTemporaryPathModel
     * @return 稟議申請情報
     * @throws SQLException
     * @throws RtpNotfoundException
     * @throws IOToolsException
     */
    public RngRestApiRingiSinseiModel getRingiSinseiModel(
        RestApiContext ctx,
        int actionType,
        RngRndataModel rngData,
        RngTemplateModel rtpMdl,
        FormInputBuilder formBuilder,
        GSTemporaryPathModel tempPathModel)
        throws SQLException, RtpNotfoundException, IOToolsException {

        RngRestApiRingiSinseiModel result = new RngRestApiRingiSinseiModel();
        __setRingiBasicData(ctx, actionType, rngData, rtpMdl, result);

        //フォーム入力ビルダーに申請情報をロード
        FormInputBuilder initFormBuilder;
        if (actionType == -1) {
            initFormBuilder = formBuilder;
        } else {
            initFormBuilder = new FormInputBuilder();
            initFormBuilder.setFormTable(rtpMdl.getRtpForm());
            setFormDspData(ctx, initFormBuilder, tempPathModel, true, true);
        }

        //申請内容の出力
        RngRestApiSinseiModelBiz rasmBiz = new RngRestApiSinseiModelBiz(ctx, initFormBuilder);
        List<RngRestapiRingiBodyRowModel> bodyList = rasmBiz.getSinseiBodyList(formBuilder);
        result.setBodyArray(bodyList);
        result.setApprovalRouteArray(new ArrayList<>());
        result.setCheckRouteArray(new ArrayList<>());

        return result;
    }

    /**
     * <p> 稟議SIDやタイトルなど稟議の基本情報を設定する
     * @param ctx コンテキスト
     * @param actionType 実行種別 0：草稿から編集, 1：複写申請, 2：再申請
     * @param rngData 稟議情報
     * @param rtpMdl テンプレート情報
     * @param sinseiMdl 稟議申請情報
     * @throws SQLException
     */
    private void __setRingiBasicData(
        RestApiContext ctx,
        int actionType,
        RngRndataModel rngData,
        RngTemplateModel rtpMdl,
        RngRestApiRingiSinseiModel sinseiMdl) throws SQLException {

        Connection con = ctx.getCon();

        RngBiz rngBiz = new RngBiz(con);
        RingiIdModel idModel = rngBiz.getRngidModel(rtpMdl.getRtpIdformatSid());

        int rngSid = 0;
        int templateSid = 0;
        int statusType = 0;
        String titleText = "";
        String entryId = __getSinseiPlanId(ctx, idModel);
        String entryIdInputText = null;
        int sinseiIdInputKanouFlg = getSinseiIdInputKanouFlg(idModel, rtpMdl);
        String entryIdText = null;
        String actionCommentText = rtpMdl.getRtpActionComment();

        if (actionType == -1) {
            //新規申請
            rngSid = -1;
            templateSid = rtpMdl.getRtpSid();
            statusType = -1;
            titleText = rtpMdl.getRtpRngTitle();
        } else if (actionType == RngConst.RNG_API_SINSEI_GET_MODE_DRAFT) {
            //草稿
            rngSid = rngData.getRngSid();
            templateSid = rtpMdl.getRtpSid();
            statusType = rngData.getRngStatus();
            titleText = rngData.getRngTitle();
            if (sinseiIdInputKanouFlg == RngConst.RNG_API_SINSEI_MANUAL_KYOKA) {
                entryIdInputText = rngData.getRngId();
            }
        } else if (actionType == RngConst.RNG_API_SINSEI_GET_MODE_COPY) {
            //複写申請
            rngSid = -1;
            templateSid = rtpMdl.getRtpSid();
            statusType = -1;
            titleText = rngData.getRngTitle();
        } else if (actionType == RngConst.RNG_API_SINSEI_GET_MODE_REAPPLY) {
            //再申請
            rngSid = rngData.getRngSid();
            templateSid = rtpMdl.getRtpSid();
            statusType = rngData.getRngStatus();
            titleText = rngData.getRngTitle();
            entryId = null;
            entryIdText = rngData.getRngId();
            sinseiIdInputKanouFlg = 0;
        }

        sinseiMdl.setSid(rngSid);
        sinseiMdl.setTemplateSid(templateSid);
        sinseiMdl.setStatusType(statusType);
        sinseiMdl.setTitleText(titleText);
        sinseiMdl.setEntryId(entryId);
        sinseiMdl.setEntryIdInputText(entryIdInputText);
        sinseiMdl.setEntryIdInputKanouFlg(sinseiIdInputKanouFlg);
        sinseiMdl.setEntryIdText(entryIdText);
        sinseiMdl.setActionCommentText(actionCommentText);
    }

    /**
     * <br>[機  能] テンプレート情報，入力された申請内容から、申請内容情報，経路情報を保持したモデルを返す
     * <br>[解  説]
     * <br>[備  考]
     * @param ctx コンテキスト
     * @param rtpMdl テンプレート情報
     * @param formBuilder フォーム情報
     * @param isKakunin true:申請確認時，false:申請確認時以外(申請経路情報を取得するAPIなど)
     * @param isKeiroInput true:経路を入力する，false:経路を入力しない
     * @param approvalRouteArray 承認経路情報
     * @param checkRouteArray 確認経路情報
     * @return 稟議申請情報
     * @throws SQLException
     * @throws RtpNotfoundException
     * @throws IOToolsException
     * @throws EnumOutRangeException
     */
    public RngRestApiRingiSinseiModel getRingiSinseiModelFromInput(
        RestApiContext ctx,
        RngTemplateModel rtpMdl,
        FormInputBuilder formBuilder,
        boolean isKakunin,
        boolean isKeiroInput,
        RngRestApiRingiRouteParamModel[] approvalRouteArray,
        RngRestApiRingiRouteParamModel[] checkRouteArray)
        throws SQLException, RtpNotfoundException, IOToolsException, EnumOutRangeException {

        RngRestApiRingiSinseiModel result = new RngRestApiRingiSinseiModel();
        Connection con = ctx.getCon();

        //申請内容の取得
        RngRestApiDetailModelBiz radBiz = new RngRestApiDetailModelBiz(false);
        List<RngRestapiRingiBodyRowModel> bodyList
            = radBiz.getRingiDetailBodyList(formBuilder, con);
        result.setBodyArray(bodyList);

        //経路情報の取得
        Map<Integer, Rng020KeiroBlock> syouninKeiroBlockMap = new HashMap<>();
        Map<Integer, Rng020KeiroBlock> kakuninKeiroBlockMap = new HashMap<>();

        RequestModel reqMdl = ctx.getRequestModel();
        Rng020Biz biz = new Rng020Biz(con, reqMdl);
        if (isKeiroInput) {
            createKeiroInfoMap(
                rtpMdl.getRtpSid(),
                approvalRouteArray,
                checkRouteArray,
                syouninKeiroBlockMap,
                kakuninKeiroBlockMap,
                formBuilder,
                ctx);
        } else {
            setKeiroData(ctx, rtpMdl, syouninKeiroBlockMap, kakuninKeiroBlockMap, false);
            biz.dspKeiroTpl(formBuilder, syouninKeiroBlockMap,
                kakuninKeiroBlockMap, false, true, false);
        }

        //経路のスキップ情報を設定
        biz.keiroSkip(syouninKeiroBlockMap, String.valueOf(ctx.getRequestUserSid()));

        List<RngRestApiSinseiKeiroModel> syouninKeiroList;
        if (isKakunin) {
            syouninKeiroList =
                __getKeiroListKakunin(new ArrayList<>(syouninKeiroBlockMap.values()), true, ctx);
        } else {
            syouninKeiroList =
                __getKeiroList(new ArrayList<>(syouninKeiroBlockMap.values()), ctx);
        }
        result.setApprovalRouteArray(syouninKeiroList);

        List<RngRestApiSinseiKeiroModel> kakuninKeiroList;
        if (isKakunin) {
            kakuninKeiroList =
                __getKeiroListKakunin(new ArrayList<>(kakuninKeiroBlockMap.values()), false, ctx);
        } else {
            kakuninKeiroList = __getKeiroList(new ArrayList<>(kakuninKeiroBlockMap.values()), ctx);
        }
        result.setCheckRouteArray(kakuninKeiroList);

        return result;
    }
    /**
     * <br>[機  能] 稟議情報，テンプレート情報，入力された申請内容から、申請内容情報，経路情報を保持したモデルを返す
     * <br>[解  説]
     * <br>[備  考] 稟議情報からは既に登録されている経路情報を取得する
     * @param ctx コンテキスト
     * @param param リクエスト情報
     * @param rngData 稟議情報
     * @param rtpMdl テンプレート情報
     * @param formBuilder フォーム情報
     * @param isKakunin true:申請確認時，false:申請確認時以外(申請経路情報を取得するAPIなど)
     * @param isCopy true:複写申請，false:複写申請以外
     * @return 稟議申請情報
     * @throws SQLException
     * @throws RtpNotfoundException
     * @throws IOToolsException
     * @throws EnumOutRangeException
     */
    public RngRestApiRingiSinseiModel getRingiSinseiModelFromRng(
        RestApiContext ctx,
        IRngEntitiesGetParam param,
        RngRndataModel rngData,
        RngTemplateModel rtpMdl,
        FormInputBuilder formBuilder,
        boolean isKakunin,
        boolean isCopy)
        throws SQLException, RtpNotfoundException, IOToolsException, EnumOutRangeException {

        RngRestApiRingiSinseiModel result = new RngRestApiRingiSinseiModel();
        Connection con = ctx.getCon();
        //申請内容の取得
        RngRestApiDetailModelBiz radBiz =
            new RngRestApiDetailModelBiz(false);
        List<RngRestapiRingiBodyRowModel> bodyList
            = radBiz.getRingiDetailBodyList(formBuilder, con);
        result.setBodyArray(bodyList);

        if (isKakunin) {
            //稟議から経路情報を取得していて申請確認を行うのは、再申請時のみ
            //再申請時は経路情報を返さない仕様のため、ここで処理を中断
            return result;
        }

        //経路情報の取得
        Map<Integer, Rng020KeiroBlock> syouninKeiroBlockMap = new HashMap<>();
        Map<Integer, Rng020KeiroBlock> kakuninKeiroBlockMap = new HashMap<>();

        int rngSid = rngData.getRngSid();
        int oldRtpVer = rngData.getRtpVer();
        if (oldRtpVer == rtpMdl.getRtpVer()) {
            //再申請時(確認時にこのメソッドを呼ぶのは再申請だけになっている)，またはテンプレートのバージョンが古くない場合は過去のバージョン情報は必要ない
            oldRtpVer = -1;
        }

        RngFormBuildBiz rngFormBiz = new RngFormBuildBiz(ctx.getRequestModel());
        RngTemplateModel oldRtpMdl =
            rngFormBiz.getRtpModel(con, rngData.getRtpSid(), rngData.getRtpVer());
        if (__canLoadKeiro(rngData, oldRtpMdl, rtpMdl)) {
            loadKeiro(ctx, rngSid, rtpMdl, oldRtpVer,
                syouninKeiroBlockMap, kakuninKeiroBlockMap, isCopy);
            setKeiroData(ctx, rtpMdl, syouninKeiroBlockMap, kakuninKeiroBlockMap, true);
        } else {
            setKeiroData(ctx, rtpMdl, syouninKeiroBlockMap, kakuninKeiroBlockMap, false);
        }

        RequestModel reqMdl = ctx.getRequestModel();
        Rng020Biz biz = new Rng020Biz(con, reqMdl);
        biz.dspKeiroTpl(formBuilder, syouninKeiroBlockMap,
            kakuninKeiroBlockMap, false, true, false);

        List<RngRestApiSinseiKeiroModel> syouninKeiroList;
        syouninKeiroList = __getKeiroList(new ArrayList<>(syouninKeiroBlockMap.values()), ctx);
        result.setApprovalRouteArray(syouninKeiroList);

        List<RngRestApiSinseiKeiroModel> kakuninKeiroList;
        kakuninKeiroList = __getKeiroList(new ArrayList<>(kakuninKeiroBlockMap.values()), ctx);
        result.setCheckRouteArray(kakuninKeiroList);

        return result;
    }

    /**
     * <br>[機  能] 経路情報の基本的なデータを設定する
     * <br>[解  説]
     * <br>[備  考]
     * @param keiroModel 経路情報を設定する対象になっているモデル
     * @param block 経路ブロック
     * @param ctx コンテキスト
     */
    private void __setKeiroBasicData(
        RngRestApiSinseiKeiroModel keiroModel, Rng020KeiroBlock block, RestApiContext ctx) {

        int rtkSid = block.getRtkSid();
        if (rtkSid < 0) {
            rtkSid = 0;
        }
        keiroModel.setTemplateStepSid(rtkSid);
        if (block.getSkipKyoka() == RngConst.RNG_ABLE_SKIP) {
            GsMessage gsMsg = new GsMessage(ctx.getRequestModel());
            keiroModel.setNoticeText(gsMsg.getMessage("rng.rng020kn.03"));
        }
        Rng110KeiroDialogParamModel pref = block.getPref();
        int approvalConditionType = pref.getOutcondition();
        keiroModel.setApprovalConditionType(approvalConditionType);
        if (approvalConditionType == RngConst.RNG_OUT_CONDITION_NUMBER
            || approvalConditionType == RngConst.RNG_OUT_CONDITION_RATE) {
            keiroModel.setApprovalConditionNum(Integer.parseInt(pref.getOutcond_threshold()));
        } else {
            keiroModel.setApprovalConditionNum(-1);
        }

        int keiroKbn = block.getKeiroKbn();
        keiroModel.setSelectType(keiroKbn);
        if (keiroKbn == EnumKeiroKbn.USERSEL_VAL
            || keiroKbn == EnumKeiroKbn.GROUPSEL_VAL) {
            keiroModel.setMultiFlg(pref.getMultisel());
        } else {
            keiroModel.setMultiFlg(-1);
        }
        keiroModel.setComment(pref.getKeiroComment());
    }

    /**
     * <br>[機  能] 経路ブロックから、レスポンスに設定する経路情報を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param keiroBlockList 経路ブロックリスト
     * @param ctx コンテキスト
     * @return レスポンスに設定する経路情報
     * @throws SQLException
     * @throws EnumOutRangeException
     */
    public List<RngRestApiSinseiKeiroModel> __getKeiroList(
        List<Rng020KeiroBlock> keiroBlockList,
        RestApiContext ctx) throws SQLException, EnumOutRangeException {

        if (keiroBlockList == null || keiroBlockList.isEmpty()) {
            return new ArrayList<>();
        }
        Connection con = ctx.getCon();
        List<RngRestApiSinseiKeiroModel> keiroList = new ArrayList<>();
        for (Rng020KeiroBlock block : keiroBlockList) {
            if (block.getHidden() == 1) {
                //非表示の経路を除外
                continue;
            }

            int keiroKbn = block.getKeiroKbn();
            Rng110KeiroDialogParamModel pref = block.getPref();

            //申請確認ではない場合(申請経路情報を取得など)は経路の対象ユーザ，グループ，役職を取得
            RngRestApiSinseiKeiroModel keiroModel = new RngRestApiSinseiKeiroModel();
            __setKeiroBasicData(keiroModel, block, ctx);
            List<RngRestApiSinseiKeiroTargetModel> targetList = new ArrayList<>();
            if (keiroKbn == EnumKeiroKbn.FREESET_VAL) {
                for (Rng020Keiro keiro : block.getKeiroMap().values()) {
                    if (keiro.getWithGroup() != null) {
                        List<String[]> usrGrpList = keiro.getWithGroup().getSelected().values()
                            .stream()
                            .collect((Collectors.toList()));
                        __setTargetArray(usrGrpList, targetList, ctx);
                    }
                }
            }

            RngRestApiSinseiKeiroTargetModel mdl = new RngRestApiSinseiKeiroTargetModel();
            if (keiroKbn == EnumKeiroKbn.USERTARGET_VAL
                || keiroKbn == EnumKeiroKbn.USERSEL_VAL) {
                for (Rng020Keiro keiro : block.getKeiroMap().values()) {
                    if (keiro.getUsrgrpSel() != null) {
                        List<String[]> usrGrpList = keiro.getUsrgrpSel().getSelected().values()
                            .stream()
                            .collect((Collectors.toList()));
                        __setTargetArray(usrGrpList, targetList, ctx);
                    }
                }
            }

            if (keiroKbn == EnumKeiroKbn.GROUPSEL_VAL
                || keiroKbn == EnumKeiroKbn.BOSSTARGET_VAL) {
                for (Rng020Keiro keiro : block.getKeiroMap().values()) {
                    if (keiro.getGrpSel() != null) {
                        List<String[]> usrGrpList = new ArrayList<>();
                        usrGrpList.add(keiro.getGrpSel().getSelected());
                        RngRestApiSinseiKeiroTargetModel targetMdl
                            = new RngRestApiSinseiKeiroTargetModel();
                        List<Integer> groupSidList = Stream.of(keiro.getGrpSel().getSelected())
                            .map(sid -> Integer.parseInt(sid))
                            .collect(Collectors.toList());
                        List<RngTemplatesStepsGroupsQueryResultModel> groupArray
                            = __getGroupArray(groupSidList, ctx.getRequestUserSid(), ctx.getCon());
                        targetMdl.setGroupArray(groupArray);
                        targetList.add(targetMdl);
                    }
                }
            }

            if (keiroKbn == EnumKeiroKbn.POSTARGET_VAL) {
                if (pref.getTargetposMap() != null) {
                    List<RngRestApiSinseiKeiroTargetPostModel> posList = new ArrayList<>();
                    int idx = 0;
                    Map<Integer, Integer> groupSidMap = new HashMap<>();
                    for (TargetPosSel targetPos : pref.getTargetposMap().values()) {
                        RngRestApiSinseiKeiroTargetPostModel posMdl
                            = new RngRestApiSinseiKeiroTargetPostModel();
                        posMdl.setPostSid(
                            Integer.parseInt(targetPos.getPosSel().getSelected()));
                        posMdl.setPostName(targetPos.getPosSel().getSelectedLabel());
                        if (Objects.equals(targetPos.getGrpSel().getSelected(), "-1")) {
                            posMdl.setGroupId(null);
                            posMdl.setGroupName(null);
                        } else {
                            groupSidMap.put(
                                idx, Integer.parseInt(targetPos.getGrpSel().getSelected()));
                        }
                        posList.add(posMdl);
                        idx++;
                    }
                    List<Integer> groupSidList = new ArrayList<>(groupSidMap.values());
                    List<RngTemplatesStepsGroupsQueryResultModel> groupList
                        = __getGroupArray(groupSidList, ctx.getRequestUserSid(), con);
                    for (Entry<Integer, Integer> entry : groupSidMap.entrySet()) {
                        int key = entry.getKey();
                        RngRestApiSinseiKeiroTargetPostModel posMdl = posList.get(key);
                        RngTemplatesStepsGroupsQueryResultModel groupMdl = groupList.stream()
                            .filter(group -> group.getGroupSid() == entry.getValue())
                            .findFirst()
                            .orElse(null);
                        if (groupMdl != null) {
                            posMdl.setGroupId(groupMdl.getId());
                            posMdl.setGroupName(groupMdl.getName());
                        }
                    }
                    mdl.setPostArray(posList);
                }
                targetList.add(mdl);
            }

            keiroModel.setTargetArray(targetList);
            keiroModel.setGroupInfo(null);
            keiroModel.setMemberArray(null);
            keiroList.add(keiroModel);
        }
        return keiroList;
    }

    /**
     * <br>[機  能] 経路ブロックから、レスポンスに設定する確認経路情報を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param keiroBlockList 経路ブロックリスト
     * @param isSyouninKeiro true:承認経路，false:確認経路
     * @param ctx コンテキスト
     * @return レスポンスに設定する経路情報
     * @throws SQLException
     * @throws EnumOutRangeException
     */
    public List<RngRestApiSinseiKeiroModel> __getKeiroListKakunin(
        List<Rng020KeiroBlock> keiroBlockList,
        boolean isSyouninKeiro,
        RestApiContext ctx) throws SQLException, EnumOutRangeException {

        if (keiroBlockList == null || keiroBlockList.isEmpty()) {
            return new ArrayList<>();
        }
        Connection con = ctx.getCon();
        List<RngRestApiSinseiKeiroModel> keiroList = new ArrayList<>();
        if (!isSyouninKeiro) {
            Rng020knBiz biz = new Rng020knBiz(con, ctx.getRequestModel());
            List<UsrLabelValueBean> selectedList =
                biz.getKakuninSelectedList(keiroBlockList);
            if (selectedList.isEmpty()) {
                return new ArrayList<>();
            }
            RngRestApiSinseiKeiroModel keiroModel = new RngRestApiSinseiKeiroModel();
            keiroModel.setTemplateStepSid(-1);
            keiroModel.setApprovalConditionType(-1);
            keiroModel.setApprovalConditionNum(-1);
            keiroModel.setSelectType(-1);
            keiroModel.setMultiFlg(-1);

            List<Integer> keiroUserSid = selectedList.stream()
                .map(usrLabelBean -> Integer.parseInt(usrLabelBean.getValue()))
                .collect(Collectors.toList());
            List<RngTemplatesStepsUsersQueryResultModel> userArray
                = __getUserArray(keiroUserSid, con);
            keiroModel.setMemberArray(userArray);
            keiroModel.setTargetArray(null);
            keiroList.add(keiroModel);

            return keiroList;
        }

        for (Rng020KeiroBlock block : keiroBlockList) {
            if (block.getHidden() == 1) {
                //非表示の経路を除外
                continue;
            }

            int keiroKbn = block.getKeiroKbn();
            for (Rng020Keiro keiro : block.getKeiroMap().values()) {
                List<Rng020KeiroKakuninDsp> singiList = keiro.getDspSingiList();
                if (singiList != null) {
                    for (Rng020KeiroKakuninDsp singiMdl : singiList) {
                        RngRestApiSinseiKeiroModel keiroModel = new RngRestApiSinseiKeiroModel();
                        __setKeiroBasicData(keiroModel, block, ctx);
                        RngRestApiSinseiKeiroGroupModel groupModel = null;
                        if (keiroKbn == EnumKeiroKbn.FREESET_VAL) {
                            groupModel = __getFreeSetGroupInfo(keiro);
                        } else if (!StringUtil.isNullZeroString(singiMdl.getName())) {
                            groupModel = new RngRestApiSinseiKeiroGroupModel();
                            groupModel.setGroupName(singiMdl.getName());
                        }
                        keiroModel.setGroupInfo(groupModel);

                        List<Integer> keiroUserSid = singiMdl.getSingi().stream()
                            .map(usrLabelBean -> Integer.parseInt(usrLabelBean.getValue()))
                            .collect(Collectors.toList());
                        List<RngTemplatesStepsUsersQueryResultModel> userArray
                            = __getUserArray(keiroUserSid, con);
                        keiroModel.setMemberArray(userArray);
                        keiroModel.setTargetArray(null);
                        keiroList.add(keiroModel);
                    }
                } else {
                    RngRestApiSinseiKeiroModel keiroModel = new RngRestApiSinseiKeiroModel();
                    keiroModel.setGroupInfo(null);
                    keiroModel.setMemberArray(null);
                    keiroModel.setTargetArray(null);
                    keiroList.add(keiroModel);
                }
            }
        }
        return keiroList;
    }

    /**
     * <br>[機  能] 経路から、レスポンスに設定するグループ情報を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param keiro 経路情報
     * @return レスポンスに設定するグループ情報
     */
    private RngRestApiSinseiKeiroGroupModel __getFreeSetGroupInfo(Rng020Keiro keiro) {

        RngRestApiSinseiKeiroGroupModel groupModel = null;
        List<UsrLabelValueBean> selectGroup = keiro.getUsrgrpSel().getSelectedListAll();

        if (selectGroup != null && selectGroup.size() == 1) {
            UsrLabelValueBean groupInfo = selectGroup.get(0);
            if (groupInfo.getValue().startsWith("G")) {
                groupModel = new RngRestApiSinseiKeiroGroupModel();
                groupModel.setGroupName(groupInfo.getLabel());
                groupModel.setGroupDeleteFlg(groupInfo.getUsrUkoFlg());
            }
        }

        return groupModel;
    }

    /**
     * <br>[機  能] ユーザ, グループSID一覧から、対象情報を取得しリストにセットする
     * <br>[解  説]
     * <br>[備  考]
     * @param usrGrpList ユーザ, グループSID一覧
     * @param targetList セット対象の対象情報リスト
     * @param ctx RESTAPIコンテキスト
     * @throws SQLException
     */
    private void __setTargetArray(
        List<String[]> usrGrpList,
        List<RngRestApiSinseiKeiroTargetModel> targetList,
        RestApiContext ctx) throws SQLException {

        List<Integer> userSidList = new ArrayList<>();
        List<Integer> groupSidList = new ArrayList<>();
        if (usrGrpList.isEmpty()) {
            RngRestApiSinseiKeiroTargetModel mdl = new RngRestApiSinseiKeiroTargetModel();
            targetList.add(mdl);
            return;
        }
        for (String[] userGroupIdArray : usrGrpList) {
            for (String userGroupId : userGroupIdArray) {
                if (userGroupId.startsWith("G")) {
                    groupSidList.add(Integer.parseInt(userGroupId.substring(1)));
                } else {
                    userSidList.add(Integer.parseInt(userGroupId));
                }
            }

            RngRestApiSinseiKeiroTargetModel mdl = new RngRestApiSinseiKeiroTargetModel();
            List<RngTemplatesStepsUsersQueryResultModel> userArray
                = __getUserArray(userSidList, ctx.getCon());
            mdl.setUserArray(userArray);

            List<RngTemplatesStepsGroupsQueryResultModel> groupArray
                = __getGroupArray(groupSidList, ctx.getRequestUserSid(), ctx.getCon());
            mdl.setGroupArray(groupArray);

            targetList.add(mdl);
        }
    }

    /**
     * <br>[機  能] ユーザSID一覧から、申請経路入力用情報のユーザ一覧を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param userSidList ユーザSID一覧
     * @param con コネクション
     * @return 申請経路入力用情報のユーザ一覧
     * @throws SQLException
     */
    private List<RngTemplatesStepsUsersQueryResultModel> __getUserArray(
        List<Integer> userSidList, Connection con) throws SQLException {

        List<RngTemplatesStepsUsersQueryResultModel> userArray = new ArrayList<>();
        UserSearchDao usDao = new UserSearchDao(con);
        List<CmnUserModel> usrList
            = usDao.getUsersDataList(userSidList, true);

        //結果モデルにセット
        for (CmnUserModel cuMdl : usrList) {
            RngTemplatesStepsUsersQueryResultModel userMdl
                = new RngTemplatesStepsUsersQueryResultModel();
            userMdl.setUserId(cuMdl.getUsrLgid());
            userMdl.setUserName(cuMdl.getUsiName());
            userMdl.setLoginStopFlg(cuMdl.getUsrUkoFlg());
            if (cuMdl.getUsrJkbn() == GSConst.JTKBN_TOROKU) {
                userMdl.setUserDeleteFlg(0);
            } else {
                userMdl.setUserDeleteFlg(1);
            }
            userArray.add(userMdl);
        }
        return userArray;
    }

    /**
     * <br>[機  能] グループSID一覧から、申請経路入力用情報のグループ一覧を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param groupSidList グループSID一覧
     * @param sessionUsrSid セッションユーザSID
     * @param con コネクション
     * @return 申請経路入力用情報のユーザ一覧
     * @throws SQLException
     */
    private List<RngTemplatesStepsGroupsQueryResultModel> __getGroupArray(
        List<Integer> groupSidList, int sessionUsrSid, Connection con) throws SQLException {

        List<RngTemplatesStepsGroupsQueryResultModel> groupArray
            = new ArrayList<>();

        //セッションユーザのデフォルトグループを取得
        GroupBiz grpBiz = new GroupBiz();
        int defGrpSid = grpBiz.getDefaultGroupSid(sessionUsrSid, con);

        //グループ一覧を結果モデルにセット
        int[] grpSids = groupSidList.stream()
                        .mapToInt(Integer::intValue)
                        .toArray();
        List<CmnGroupmModel> grpMdlList
            = grpBiz.getGroupTreeList(con, grpSids);
        for (CmnGroupmModel cgMdl : grpMdlList) {
            RngTemplatesStepsGroupsQueryResultModel groupMdl
                = new RngTemplatesStepsGroupsQueryResultModel();
            groupMdl.setGroupSid(cgMdl.getGrpSid());
            groupMdl.setId(cgMdl.getGrpId());
            groupMdl.setName(cgMdl.getGrpName());
            if (cgMdl.getGrpSid() == defGrpSid) {
                groupMdl.setDefaultGrpFlg(
                    GSConstCommon.RESTAPI_GROUPS_DEFAULTGROUP_YES);
            } else {
                groupMdl.setDefaultGrpFlg(
                    GSConstCommon.RESTAPI_GROUPS_DEFAULTGROUP_NO);
            }
            groupArray.add(groupMdl);
        }
        return groupArray;
    }

    /**
     * <p> 稟議SIDやタイトルなど稟議の基本情報を設定する
     * @param ctx コンテキスト
     * @param rtpMdl テンプレート情報
     * @param param リクエスト情報
     * @param sinseiMdl 稟議申請情報
     * @throws SQLException
     */
    public void setRingiBasicDataFromInput(
        RestApiContext ctx,
        IRngEntitiesGetParam param,
        RngTemplateModel rtpMdl,
        RngRestApiRingiSinseiModel sinseiMdl) throws SQLException {

        sinseiMdl.setSid(-1);
        sinseiMdl.setTemplateSid(rtpMdl.getRtpSid());
        sinseiMdl.setStatusType(-1);
        sinseiMdl.setTitleText(param.getTitleText());

        setRingiIdData(ctx, rtpMdl,
            param.getEntryIdInputKanouFlg(), param.getEntryIdText(), sinseiMdl);
        sinseiMdl.setEntryIdInputText(null);
        sinseiMdl.setEntryIdInputKanouFlg(-1);
        sinseiMdl.setEntryIdText(null);

        sinseiMdl.setActionCommentText(rtpMdl.getRtpActionComment());
    }

    /**
     * <p> entryIdを設定する
     * @param ctx コンテキスト
     * @param rtpMdl テンプレート情報
     * @param idInputKanouFlg リクエストボディで入力された申請ID入力フラグ
     * @param entryIdText 手入力した申請ID
     * @param sinseiMdl 稟議申請情報
     * @throws SQLException
     */
    public void setRingiIdData(
        RestApiContext ctx, RngTemplateModel rtpMdl,
        int idInputKanouFlg, String entryIdText,
        RngRestApiRingiSinseiModel sinseiMdl) throws SQLException {

        RngBiz rngBiz = new RngBiz(ctx.getCon());
        RingiIdModel idModel = rngBiz.getRngidModel(rtpMdl.getRtpIdformatSid());
        String entryId = __getSinseiPlanId(ctx, idModel);

        //入力値側で申請IDが"手入力する"になっており、テンプレート設定側で手入力が可能になっている場合に申請IDに指定された値を使用
        int sinseiIdInputKanouFlg = getSinseiIdInputKanouFlg(idModel, rtpMdl);
        if (sinseiIdInputKanouFlg == RngConst.RNG_API_SINSEI_MANUAL_KYOKA
            && idInputKanouFlg == RngConst.RNG_API_SINSEI_MANUAL_KYOKA) {
            entryId = entryIdText;
        }
        sinseiMdl.setEntryId(entryId);
    }

    /**
     * <br>[機  能] テンプレート情報から、申請ID，申請ID入力可能フラグをレスポンスに設定する
     * <br>[解  説]
     * <br>[備  考]
     * @param idModel 稟議IDモデル
     * @param rtpMdl テンプレート情報
     * @return 申請ID入力可能フラグ
     * @throws SQLException SQL実行時例外
     * @throws RtpNotfoundException
     * @throws IOToolsException
     */
    public int getSinseiIdInputKanouFlg(
        RingiIdModel idModel, RngTemplateModel rtpMdl) throws SQLException {

        if (idModel == null) {
            return -1;
        } else {
            int idEditable = idModel.getRngManual();
            if (idEditable == RngConst.RAR_SINSEI_MANUAL_KYOKA) {
                return RngConst.RNG_API_SINSEI_MANUAL_KYOKA;
            } else if (idEditable == RngConst.RAR_SINSEI_MANUAL_TEMPLATE) {
                if (rtpMdl.getRtpIdmanual() == RngConst.RAR_SINSEI_MANUAL_KYOKA) {
                    return RngConst.RNG_API_SINSEI_MANUAL_KYOKA;
                } else {
                    return RngConst.RNG_API_SINSEI_MANUAL_NOT_KYOKA;
                }
            } else {
                return RngConst.RNG_API_SINSEI_MANUAL_NOT_KYOKA;
            }
        }
    }

    /**
     * <br>[機  能] テンプレート情報から、申請ID，申請ID入力可能フラグをレスポンスに設定する
     * <br>[解  説]
     * <br>[備  考]
     * @param ctx コンテキスト
     * @param idModel 稟議IDモデル
     * @return 発行予定の申請ID
     * @throws SQLException SQL実行時例外
     */
    private String __getSinseiPlanId(
        RestApiContext ctx, RingiIdModel idModel) throws SQLException {

        if (idModel == null) {
            return null;
        }

        RequestModel reqMdl = ctx.getRequestModel();
        Connection con = ctx.getCon();
        RngBiz rngBiz = new RngBiz(con);
        String planId = rngBiz.getNewRngid(
            idModel, null, false, -1, reqMdl);

        return planId;
    }

    /**
     * <br>[機  能] テンプレートから申請内容を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param ctx コンテキスト
     * @param templateSid テンプレートSID
     * @param templateVer テンプレートバージョン
     * @param tempPathModel GSTemporaryPathModel
     * @return 申請内容
     * @throws SQLException SQL実行時例外
     * @throws RtpNotfoundException
     * @throws IOToolsException
     */
    public FormInputBuilder getFormInputBuilderFromTemplate(
        RestApiContext ctx,
        int templateSid,
        int templateVer,
        GSTemporaryPathModel tempPathModel)
        throws SQLException, RtpNotfoundException, IOToolsException {

        RequestModel reqMdl = ctx.getRequestModel();
        Connection con = ctx.getCon();
        FormInputBuilder fb = new FormInputBuilder();
        RngFormBuildBiz formBiz = new RngFormBuildBiz(reqMdl);
        formBiz.loadTenplateData(con, fb, templateSid, templateVer);

        return fb;
    }

    /**
     * <br>[機  能] 稟議情報から申請内容を取得する
     * <br>[解  説]
     * <br>[備  考] 初期値の設定なども行う
     * @param ctx コンテキスト
     * @param actionType 実行種別 0：草稿から編集, 1：複写申請, 2：再申請
     * @param rngData 稟議情報
     * @param rtpMdl テンプレート情報
     * @return 申請内容
     * @throws SQLException SQL実行時例外
     * @throws RtpNotfoundException
     * @throws IOToolsException
     */
    public FormInputBuilder getFormInputBuilderFromRng(
        RestApiContext ctx, int actionType, RngRndataModel rngData,
        RngTemplateModel rtpMdl) throws SQLException, RtpNotfoundException {

        RequestModel reqMdl = ctx.getRequestModel();
        RngFormBuildBiz rngFormBiz = new RngFormBuildBiz(reqMdl);
        int rtpSid = rtpMdl.getRtpSid();
        int rtpVer = rtpMdl.getRtpVer();

        boolean isCopy = rngData.getRtpVer() != rtpMdl.getRtpVer();
        if (actionType == RngConst.RNG_API_SINSEI_GET_MODE_REAPPLY) {
            rtpSid = rngData.getRtpSid();
            rtpVer = rngData.getRtpVer();
            isCopy = false;
        }

        Connection con = ctx.getCon();
        FormInputBuilder fb = new FormInputBuilder();
        rngFormBiz.loadInputData(con, fb,
                rngData.getRngSid(), rngData.getRtpVer(), isCopy,
                rtpSid,
                rtpVer);
        rngFormBiz.loadTenplateData(con, fb, rtpSid, rtpVer);
        return fb;
    }


    /**
     * <br>[機  能] 表示用データをFormInputBuilderにセットする
     * <br>[解  説]
     * <br>[備  考]
     * @param ctx コンテキスト
     * @param fb 申請内容
     * @param tempPathModel 添付ファイルパス情報
     * @param isLoad ロードフラグ
     * @param defaultInitFlg 初期値セットフラグ
     * @throws SQLException
     * @throws RtpNotfoundException
     * @throws IOToolsException
     */
    public void setFormDspData(
        RestApiContext ctx,
        FormInputBuilder fb,
        GSTemporaryPathModel tempPathModel,
        boolean isLoad,
        boolean defaultInitFlg)
        throws SQLException, RtpNotfoundException, IOToolsException {

        RequestModel reqMdl = ctx.getRequestModel();
        Connection con = ctx.getCon();

        FormInputInitPrefarence pref = new FormInputInitPrefarence();
        pref.setAppRoot(ctx.getAppRootPath());
        pref.setMode(FormInputBuilder.INITMODE_INPUT_API);
        pref.setUrl("");
        pref.setTempDir(tempPathModel);
        pref.setLoad(isLoad);
        fb.setInitPrefarence(pref);
        if (defaultInitFlg) {
            fb.defaultInit();
        }
        fb.dspInit(reqMdl, con);
    }

    /**
     * <br>[機  能] 稟議テンプレートSIDからフォーム情報リストを取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param rtpSid 稟議テンプレートSID
     * @param rtpVer 稟議テンプレートバージョン(最新バージョンを指定する場合は-1を設定)
     * @param con コネクション
     * @return フォーム情報リスト
     * @throws SQLException
     */
    private List<RngTemplateFormModel> __getFormInfoList(
        int rtpSid,
        int rtpVer,
        Connection con) throws SQLException {

        List<RngTemplateFormModel> ret = new ArrayList<RngTemplateFormModel>();
        if (rtpSid > 0) {
            //共有/個人テンプレート
            RngTemplateFormDao rtfDao = new RngTemplateFormDao(con);
            ret = rtfDao.select(rtpSid, rtpVer);

            //v4.7.2以前の共有テンプレートの場合、フォーム情報に添付ファイル要素を追加
            RngTemplateDao rtpDao = new RngTemplateDao(con);
            RngTemplateModel rtpMdl = rtpDao.select(rtpSid, rtpVer);
            if (rtpMdl.getRtpSpecVer() == RngConst.RNG_RTP_SPEC_VER_INIT) {
                RngTemplateFormModel tempMdl = new RngTemplateFormModel();
                tempMdl.setRtfId("file_1");
                tempMdl.setRtfSid(1);
                tempMdl.setRtfType(EnumFormModelKbn.file.getValue());
                ret.add(tempMdl);
            }
        } else {
            //汎用稟議テンプレート
            RngTemplateFormModel naiyoMdl = new RngTemplateFormModel();
            naiyoMdl.setRtfId(RngConst.RNG_FORMID_HANYOU_NAIYO);
            naiyoMdl.setRtfSid(0);
            ret.add(naiyoMdl);
            RngTemplateFormModel tempMdl = new RngTemplateFormModel();
            tempMdl.setRtfId(RngConst.RNG_FORMID_HANYOU_TEMP);
            tempMdl.setRtfSid(1);
            tempMdl.setRtfType(EnumFormModelKbn.file.getValue());
            ret.add(tempMdl);
        }
        return ret;
    }

    /**
     * <br>[機  能] 申請内容モデルからFormInputBuilderクラスを作成する
     * <br>[解  説]
     * <br>[備  考]
     * @param rtpSid 稟議テンプレートSID
     * @param rtpVer 稟議テンプレートバージョン
     * @param bodyArray 申請内容モデルリスト
     * @param tempPathMdl テンポラリパスモデル
     * @param ctx RESTAPIコンテキスト
     * @return FormInputBuilder
     * @throws SQLException
     * @throws RtpNotfoundException
     * @throws IOToolsException
     * @throws EncryptionException
     */
    public FormInputBuilder createFormInputBuilder(
        int rtpSid,
        int rtpVer,
        RngRestApiRingiBodyParamModel[] bodyArray,
        GSTemporaryPathModel tempPathMdl,
        RestApiContext ctx)
        throws SQLException, RtpNotfoundException, IOToolsException, EncryptionException {

        FormInputBuilder fb = getFormInputBuilderFromTemplate(ctx, rtpSid, rtpVer, tempPathMdl);
        List<RngTemplateFormModel> rtfMdlList = __getFormInfoList(rtpSid, rtpVer, ctx.getCon());

        //ブロック要素以外
        for (RngTemplateFormModel rtfMdl : rtfMdlList) {
            for (RngRestApiRingiBodyParamModel bodyMdl : bodyArray) {
                if (Objects.equals(rtfMdl.getRtfId(), bodyMdl.getFormId())) {
                    FormAccesser fa = new FormAccesser(rtfMdl.getRtfSid(), 0);
                    FormCell cell = fb.getFormCell(fa);
                    if (cell != null) {
                        __setInputValue(
                            cell,
                            bodyMdl.getContentInfo(),
                            ctx,
                            tempPathMdl);
                    }
                    break;
                }
            }
        }

        //ブロック要素
        List<RngTemplateFormModel> blockMdlList
            = rtfMdlList.stream()
                .filter(mdl -> mdl.getRtfId() != null && mdl.getRtfId().isEmpty())
                .collect(Collectors.toList());
        for (RngTemplateFormModel blockMdl : blockMdlList) {
            FormAccesser fa = new FormAccesser(blockMdl.getRtfSid(), 0);
            FormCell cell = fb.getFormCell(fa);
            if (cell != null) {
                for (RngTemplateFormModel rtfMdl : rtfMdlList) {
                    for (RngRestApiRingiBodyParamModel bodyMdl : bodyArray) {
                        if (Objects.equals(rtfMdl.getRtfId(), bodyMdl.getFormId())) {
                            FormAccesser blockFa = new FormAccesser(rtfMdl.getRtfSid(), 0);
                            FormCell blockCell = ((Block) cell.getBody()).getFormCell(blockFa);
                            if (blockCell != null) {
                                __setInputValue(
                                    blockCell,
                                    bodyMdl.getContentInfo(),
                                    ctx,
                                    tempPathMdl);
                            }
                            break;
                        }
                    }
                }
            }
        }

        //フォーム要素の表示設定
        setFormDspData(ctx, fb, tempPathMdl, false, false);

        return fb;
    }

    /**
     * <br>[機  能] 申請内容モデルからFormInputBuilderクラスを作成する
     * <br>[解  説]
     * <br>[備  考]
     * @param rtpSid 稟議テンプレートSID
     * @param bodyArray 申請内容モデルリスト
     * @param tempPathMdl テンポラリパスモデル
     * @param ctx RESTAPIコンテキスト
     * @return FormInputBuilder
     * @throws SQLException
     * @throws RtpNotfoundException
     * @throws IOToolsException
     * @throws EncryptionException
     */
    public FormInputBuilder createFormInputBuilder(
        int rtpSid,
        RngRestApiRingiBodyParamModel[] bodyArray,
        GSTemporaryPathModel tempPathMdl,
        RestApiContext ctx)
        throws SQLException, RtpNotfoundException, IOToolsException, EncryptionException {

        return createFormInputBuilder(rtpSid, -1, bodyArray, tempPathMdl, ctx);
    }

    /**
     * <br>[機  能] 入力値情報をFormCell（フォーム情報）にセットする
     * <br>[解  説]
     * <br>[備  考]
     * @param cell FormCell（フォーム情報）
     * @param contentMdl RngRestApiRingiContentParamModel（入力値情報）
     * @param ctx RESTAPIコンテキスト
     * @param tempPathMdl テンポラリディレクトリパスモデル
     * @throws IOToolsException
     * @throws SQLException
     * @throws EncryptionException
     */
    private void __setInputValue(
        FormCell cell,
        RngRestApiRingiContentParamModel contentMdl,
        RestApiContext ctx,
        GSTemporaryPathModel tempPathMdl)
        throws SQLException, IOToolsException, EncryptionException {

        switch (cell.getType()) {
            case textbox:
                ((TextInput) cell.getBody()).setValue(__getSingleValue(contentMdl));
                break;
            case textarea:
                ((Textarea) cell.getBody()).setValue(__getSingleValue(contentMdl));
                break;
            case date:
                ((DateBox) cell.getBody()).setValue(__getSingleValue(contentMdl));
                break;
            case time:
                ((TimeBox) cell.getBody()).setValue(__getSingleValue(contentMdl));
                break;
            case number:
                ((NumberBox) cell.getBody()).setValue(__getSingleValue(contentMdl));
                break;
            case radio:
                ((RadioButton) cell.getBody()).setSelected(__getSingleValue(contentMdl));
                break;
            case combo:
                ((ComboBox) cell.getBody()).setSelected(__getSingleValue(contentMdl));
                break;
            case check:
                ((CheckBox) cell.getBody()).setSelected(__getMultiValue(contentMdl));
                break;
            case user:
                __setUserInfo(cell, contentMdl, ctx.getCon());
                break;
            case group:
                __setGroupInfo(cell, contentMdl, ctx.getCon());
                break;
            case blocklist:
                __setBlockListInfo(
                    cell,
                    contentMdl.getBlockListInfo(),
                    ctx,
                    tempPathMdl);
                break;
            case file:
                __setFileInfo(cell, contentMdl, ctx, tempPathMdl);
                break;
            default:
                break;
        }
    }

    /**
     * <br>[機  能] 単一入力値を返す
     * <br>[解  説]
     * <br>[備  考] 入力値が存在しない場合、空を返す。
     * @param contentMdl RngRestApiRingiContentParamModel（入力値情報）
     * @return 入力値
     * @throws IOToolsException
     * @throws SQLException
     */
    private String __getSingleValue(RngRestApiRingiContentParamModel contentMdl) {

        if (contentMdl == null) {
            return "";
        }
        return __getSingleValue(contentMdl.getValueArray());
    }

    /**
     * <br>[機  能] 単一入力値を返す
     * <br>[解  説]
     * <br>[備  考] 入力値が存在しない場合、空を返す。
     * @param valueArray 入力値配列
     * @return 入力値
     * @throws IOToolsException
     * @throws SQLException
     */
    private String __getSingleValue(String[] valueArray) {

        if (valueArray == null) {
            return "";
        }
        if (valueArray.length <= 0) {
            return "";
        }
        if (valueArray[0].isEmpty()) {
            return "";
        }
        return valueArray[0];
    }

    /**
     * <br>[機  能] 複数入力値を返す
     * <br>[解  説]
     * <br>[備  考] 入力値が存在しない場合、NULLを返す。
     * @param contentMdl RngRestApiRingiContentParamModel（入力値情報）
     * @return 入力値
     * @throws IOToolsException
     * @throws SQLException
     */
    private String[] __getMultiValue(RngRestApiRingiContentParamModel contentMdl) {

        if (contentMdl == null) {
            return null;
        }
        return __getMultiValue(contentMdl.getValueArray());
    }

    /**
     * <br>[機  能] 複数入力値を返す
     * <br>[解  説]
     * <br>[備  考] 入力値が存在しない場合、NULLを返す。
     * @param valueArray 入力値配列
     * @return 入力値
     * @throws IOToolsException
     * @throws SQLException
     */
    private String[] __getMultiValue(String[] valueArray) {

        if (valueArray == null) {
            return null;
        }
        if (valueArray.length <= 0) {
            return null;
        }
        if (valueArray.length == 1
            && valueArray[0].isEmpty()) {
            return null;
        }
        return valueArray;
    }

    /**
     * <br>[機  能] ユーザ情報をFormCell（フォーム情報）にセットする
     * <br>[解  説]
     * <br>[備  考]
     * @param cell FormCell（フォーム情報）
     * @param contentMdl RngRestApiRingiContentParamModel（入力値情報）
     * @param con コネクション
     * @throws SQLException
     * @throws IOToolsException
     */
    private void __setUserInfo(
        FormCell cell,
        RngRestApiRingiContentParamModel contentMdl,
        Connection con) throws SQLException, IOToolsException {

        CmnUsrmDao cumDao = new CmnUsrmDao(con);
        List<String> usrSidStrList = new ArrayList<String>();
        if (((SimpleUserSelect) cell.getBody()).getMultiFlg()
            == UserGroupSelectModel.FLG_MULTI_OFF) {
            //単一選択
            if (!__getSingleValue(contentMdl).isEmpty()) {
                int usrSid = cumDao.selectLoginId(__getSingleValue(contentMdl));
                usrSidStrList.add(String.valueOf(usrSid));
            }
        } else if (((SimpleUserSelect) cell.getBody()).getMultiFlg()
            == UserGroupSelectModel.FLG_MULTI_ON) {
            //複数選択
            if (__getMultiValue(contentMdl) != null) {
                List<Integer> usrSidList = cumDao.selectLoginId(__getMultiValue(contentMdl));
                if (__getMultiValue(contentMdl).length > usrSidList.size()) {
                    int cnt = __getMultiValue(contentMdl).length - usrSidList.size();
                    for (int i = 0; i < cnt; i++) {
                        usrSidList.add(-1);
                    }
                }
                usrSidStrList = usrSidList.stream()
                                    .map(sid -> String.valueOf(sid))
                                    .collect(Collectors.toList());
            }
        }
        ((SimpleUserSelect) cell.getBody()).setSelected(usrSidStrList.toArray(String[]::new));
    }

    /**
     * <br>[機  能] グループ情報をFormCell（フォーム情報）にセットする
     * <br>[解  説]
     * <br>[備  考]
     * @param cell FormCell（フォーム情報）
     * @param contentMdl RngRestApiRingiContentParamModel（入力値情報）
     * @param con コネクション
     * @throws SQLException
     */
    private void __setGroupInfo(
        FormCell cell,
        RngRestApiRingiContentParamModel contentMdl,
        Connection con) throws SQLException {

        CmnGroupmDao cgmDao = new CmnGroupmDao(con);
        List<String> grpSidList = new ArrayList<String>();
        if (((GroupComboModel) cell.getBody()).getMultiFlg()
            == UserGroupSelectModel.FLG_MULTI_OFF) {
            //単一選択
            if (!__getSingleValue(contentMdl).isEmpty()) {
                CmnGroupmModel grpMdl = cgmDao.getGroupInf(__getSingleValue(contentMdl));
                if (grpMdl != null) {
                    grpSidList.add(String.valueOf(grpMdl.getGrpSid()));
                } else {
                    grpSidList.add("-2"); //必須ではない場合、-1は「指定なし」として扱われる
                }
            }

        } else if (((GroupComboModel) cell.getBody()).getMultiFlg()
            == UserGroupSelectModel.FLG_MULTI_ON) {
            //複数選択
            if (__getMultiValue(contentMdl) != null) {

                List<CmnGroupmModel> cgmMdlList
                    = cgmDao.selectGrpData(__getMultiValue(contentMdl), GSConst.JTKBN_TOROKU);
                grpSidList = cgmMdlList.stream()
                                .map(mdl -> String.valueOf(mdl.getGrpSid()))
                                .collect(Collectors.toList());
                if (__getMultiValue(contentMdl).length > grpSidList.size()) {
                    int cnt = __getMultiValue(contentMdl).length - grpSidList.size();
                    for (int i = 0; i < cnt; i++) {
                        grpSidList.add("-1");
                    }
                }
            }
        }
        ((GroupComboModel) cell.getBody()).setSelected(grpSidList.toArray(String[]::new));
    }

    /**
     * <br>[機  能] 表要素情報をFormCell（フォーム情報）にセットする
     * <br>[解  説]
     * <br>[備  考]
     * @param cell FormCell（フォーム情報）
     * @param blockListMdl 表要素モデル
     * @param ctx RESTAPIコンテキスト
     * @param tempPathMdl テンポラリディレクトリパスモデル
     * @throws IOToolsException
     * @throws SQLException
     * @throws EncryptionException
     */
    private void __setBlockListInfo(
        FormCell cell,
        RngRestApiRingiBlockListParamModel blockListMdl,
        RestApiContext ctx,
        GSTemporaryPathModel tempPathMdl)
        throws SQLException, IOToolsException, EncryptionException {

        BlockList blockList = (BlockList) cell.getBody();
        //ヘッダー
        for (List<FormCell> headerCellList : blockList.getHeader().getFormTable()) {
            for (FormCell headerCell : headerCellList) {
                for (RngRestApiRingiBodyParamModel headerMdl : blockListMdl.getHeaderArray()) {
                    if (Objects.equals(headerCell.getFormID(), headerMdl.getFormId())) {
                        __setInputValue(
                            headerCell,
                            headerMdl.getContentInfo(),
                            ctx,
                            tempPathMdl);
                        break;
                    }
                }
            }
        }
        //ボディ
        int bodyRowIndex = 0;
        for (RngRestApiRingiBodyRowParamModel bodyRowMdl : blockListMdl.getBodyArray()) {
            //ボディ行数をセット
            blockList.getBody(bodyRowIndex).setBlockIdx(bodyRowIndex);
            blockList.getBody(bodyRowIndex).dspInit(ctx.getRequestModel(), ctx.getCon());
            for (List<FormCell> bodyCellList : blockList.getBody(bodyRowIndex).getFormTable()) {
                for (FormCell bodyCell : bodyCellList) {
                    for (RngRestApiRingiBodyParamModel bodyMdl : bodyRowMdl.getBlockRowArray()) {
                        if (Objects.equals(bodyCell.getFormID(), bodyMdl.getFormId())) {
                            __setInputValue(
                                bodyCell,
                                bodyMdl.getContentInfo(),
                                ctx,
                                tempPathMdl);
                            break;
                        }
                    }
                }
            }
            bodyRowIndex++;
        }

        //フッター
        for (List<FormCell> footerCellList : blockList.getFooter().getFormTable()) {
            for (FormCell footerCell : footerCellList) {
                for (RngRestApiRingiBodyParamModel footerMdl : blockListMdl.getFooterArray()) {
                    if (Objects.equals(footerCell.getFormID(), footerMdl.getFormId())) {
                        __setInputValue(
                            footerCell,
                            footerMdl.getContentInfo(),
                            ctx,
                            tempPathMdl);
                        break;
                    }
                }
            }
        }
    }

    /**
     * <br>[機  能] 添付ファイル情報をFormCell（フォーム情報）にセットする
     * <br>[解  説]
     * <br>[備  考]
     * @param cell FormCell（フォーム情報）
     * @param contentMdl RngRestApiRingiContentParamModel（入力値情報）
     * @param ctx RESTAPIコンテキスト
     * @param tempPathMdl テンポラリディレクトリパスモデル
     * @throws EncryptionException
     * @throws IOToolsException
     * @throws SQLException
     */
    private void __setFileInfo(
        FormCell cell,
        RngRestApiRingiContentParamModel contentMdl,
        RestApiContext ctx,
        GSTemporaryPathModel tempPathMdl)
        throws EncryptionException, SQLException, IOToolsException {

        //参照元稟議のバイナリSIDをセット
        if (__getMultiValue(contentMdl) != null) {
            List<Long> binSidList = Arrays.asList(__getMultiValue(contentMdl))
                                    .stream()
                                    .map(sid -> NullDefault.getLong(sid, 0))
                                    .collect(Collectors.toList());
            ((Temp) cell.getBody()).setBinSids(binSidList);
        }

        //新規アップロード用テンポラリディレクトリパスをセット
        String dirCode = contentMdl.getDirectoryCodeText();
        if (dirCode != null && !dirCode.isEmpty()) {
            String subDir = null;
            try {
                byte[] decBytes = Base64.decodeBase64(dirCode);
                subDir = Blowfish.decrypt("gsFileDirMake", decBytes);
            } catch (Exception e) {
                throw new EncryptionException("ディレクトリの指定に失敗", e);
            }
            ((Temp) cell.getBody()).setUploadTempPath(
                new GSTemporaryPathModel(tempPathMdl, subDir));
        }
    }

    /**
     * <br>[機  能] 経路情報モデルから経路情報MAPを作成する
     * <br>[解  説]
     * <br>[備  考]
     * @param rtpSid 稟議テンプレートSID
     * @param approvalRouteArray 承認経路情報
     * @param checkRouteArray 確認経路情報
     * @param syouninKeiroBlockMap 承認経路情報MAP
     * @param kakuninKeiroBlockMap 確認経路情報MAP
     * @param formInputBuilder 申請内容モデル
     * @param ctx RESTAPIコンテキスト
     * @throws SQLException
     * @throws RtpNotfoundException
     * @throws EnumOutRangeException
     */
    public void createKeiroInfoMap(
        int rtpSid,
        RngRestApiRingiRouteParamModel[] approvalRouteArray,
        RngRestApiRingiRouteParamModel[] checkRouteArray,
        Map<Integer, Rng020KeiroBlock> syouninKeiroBlockMap,
        Map<Integer, Rng020KeiroBlock> kakuninKeiroBlockMap,
        FormInputBuilder formInputBuilder,
        RestApiContext ctx) throws SQLException, RtpNotfoundException, EnumOutRangeException {

        Connection con = ctx.getCon();
        RngTemplateDao rtpDao = new RngTemplateDao(con);
        RngTemplateModel rtpMdl = rtpDao.select(rtpSid);

        //承認/確認経路情報を取得する
        if (rtpMdl != null) {
            setKeiroData(ctx, rtpMdl, syouninKeiroBlockMap, kakuninKeiroBlockMap, false);
        } else {
            RngTemplateBiz rtpBiz = new RngTemplateBiz();
            rtpBiz.initKeiroTpl(
                syouninKeiroBlockMap,
                kakuninKeiroBlockMap,
                null,
                null,
                true,
                false);
        }

        //表示用情報をセット
        Rng020Biz biz = new Rng020Biz(con, ctx.getRequestModel());
        biz.dspKeiroTpl(formInputBuilder, syouninKeiroBlockMap,
            kakuninKeiroBlockMap, true, false, false);

        //審議者情報をセット
        //承認経路
        syouninKeiroBlockMap = __setKeiroInfo(syouninKeiroBlockMap, approvalRouteArray, ctx);
        //確認経路
        kakuninKeiroBlockMap = __setKeiroInfo(kakuninKeiroBlockMap, checkRouteArray, ctx);
        //表示用情報をセット
        //isKeiroFirstをtrueにすることで、最終確認経路にある任意設定経路(初期選択に"セッションユーザ"のみが選択されている)が消えないようにする
        biz.dspKeiroTpl(formInputBuilder, syouninKeiroBlockMap,
            kakuninKeiroBlockMap, false, true, false);
    }

    /**
     * <br>[機  能] 経路情報を経路情報MAPにセットする
     * <br>[解  説]
     * <br>[備  考]
     * @param keiroBlockMap 経路情報MAP
     * @param routeArray 経路情報
     * @param ctx RESTAPIコンテキスト
     * @return 経路情報MAP
     * @throws SQLException
     * @throws RtpNotfoundException
     * @throws EnumOutRangeException
     */
    private Map<Integer, Rng020KeiroBlock> __setKeiroInfo(
        Map<Integer, Rng020KeiroBlock> keiroBlockMap,
        RngRestApiRingiRouteParamModel[] routeArray,
        RestApiContext ctx) throws SQLException, EnumOutRangeException {

        Connection con = ctx.getCon();
        CmnUsrmDao cumDao = new CmnUsrmDao(con);
        CmnGroupmDao cgmDao = new CmnGroupmDao(con);
        RngTemplateKeiroUserDao rtkuDao = new RngTemplateKeiroUserDao(con);

        Map<Integer, Rng020KeiroBlock> ret = keiroBlockMap;
        int resultKey = 0;
        for (Rng020KeiroBlock keiroBlock : keiroBlockMap.values()) {

            //テンプレートに経路情報が登録されていない場合、任意設定経路に審議者情報をセットする
            boolean notSetFlg = false;
            if (keiroBlockMap.size() > 0 && keiroBlockMap.get(0).getRtkSid() == 0) {
                notSetFlg = true;
                keiroBlockMap.get(0).setKeiroKbn(EnumKeiroKbn.FREESET_VAL);
                keiroBlockMap.get(0).getKeiroSingle().setKeiroKbn(EnumKeiroKbn.FREESET_VAL);
            }

            //任意設定経路用MAP
            //任意設定経路が連続する場合、1つの経路ブロックに複数経路情報がセットされる
            //任意設定経路は経路追加可能なため、経路情報を一旦下記MAPにセットしておき、最後に経路ブロック情報に下記MAPをセットする
            int freeKeiroKey = 0;
            Map<Integer, Rng020Keiro> freeKeiroMap = new HashMap<Integer, Rng020Keiro>();


            //経路に審議者情報をセット
            for (Rng020Keiro keiro : keiroBlock.getKeiroMap().values()) {

                if (keiro.getKeiroKbn() == EnumKeiroKbn.USERTARGET_VAL) {
                    //「ユーザ指定」の場合、テンプレートで指定した審議者情報をセット
                    List<String> selSidList = new ArrayList<String>();
                    List<RngTemplateKeiroUserModel> rtkuList
                            = rtkuDao.select(keiro.getRtkSid());
                    for (RngTemplateKeiroUserModel rtkuMdl : rtkuList) {
                        if (rtkuMdl.getGrpSid() > -1) {
                            selSidList.add(UserGroupSelectBiz.GROUP_PREFIX
                                    + String.valueOf(rtkuMdl.getGrpSid()));
                        } else if (rtkuMdl.getUsrSid() > -1) {
                            selSidList.add(String.valueOf(rtkuMdl.getUsrSid()));
                        }
                    }
                    ret.get(resultKey).getKeiroSingle()
                        .getUsrgrpSel().setSelectedSimple(selSidList.toArray(String[]::new));

                } else {
                    //「任意設定」「ユーザ選択」「グループ選択」「上長指定」の場合、リクエスト情報で指定した審議者情報をセット
                    for (RngRestApiRingiRouteParamModel routeMdl : routeArray) {
                        if (routeMdl.getTemplateStepSid() == keiro.getRtkSid()
                            || (routeMdl.getTemplateStepSid() == 0 && notSetFlg)) {

                            switch (keiro.getKeiroKbn()) {
                                case EnumKeiroKbn.FREESET_VAL:
                                    //任意設定

                                    //リクエスト情報に指定した行数分の経路を追加
                                    for (RngRestApiRingiTargetParamModel targetMdl
                                        : routeMdl.getTargetArray()) {

                                        List<String> selSidList = new ArrayList<String>();
                                        //ユーザID配列からユーザSIDリストを取得
                                        if (targetMdl.getUserIdArray() != null
                                            && targetMdl.getUserIdArray().length > 0) {
                                            List<Integer> usrSidList
                                                = cumDao.selectLoginId(targetMdl.getUserIdArray());
                                            selSidList.addAll(usrSidList.stream()
                                                                    .map(sid -> String.valueOf(sid))
                                                                    .collect(Collectors.toList()));
                                        }
                                        //グループID配列からグループSIDリストを取得（G + グループSID）
                                        if (targetMdl.getGroupIdArray() != null
                                            && targetMdl.getGroupIdArray().length > 0) {
                                            List<CmnGroupmModel> cgmMdlList
                                                    = cgmDao.selectGrpData(
                                                        targetMdl.getGroupIdArray(),
                                                        GSConst.JTKBN_TOROKU);
                                            selSidList.addAll(cgmMdlList.stream()
                                                .map(mdl -> "G" + String.valueOf(mdl.getGrpSid()))
                                                .collect(Collectors.toList()));
                                        }
                                        //上記2つのSIDリストを1つにしたものをセット
                                        Rng020Keiro freeKeiro = new Rng020Keiro();
                                        freeKeiro.getUsrgrpSel().setSelectedSimple(
                                            selSidList.toArray(String[]::new));
                                        //審議情報を設定
                                        freeKeiro.dspInitSingiList(
                                            ctx.getRequestUserSid(), keiroBlock, con);
                                        freeKeiroMap.put(freeKeiroKey, freeKeiro);
                                        freeKeiroKey++;
                                    }
                                    break;

                                case EnumKeiroKbn.USERSEL_VAL:
                                    //ユーザ選択
                                    __setUserKeiroInfo(
                                        ret.get(resultKey),
                                        routeMdl.getTargetArray()[0].getUserIdArray(),
                                        con);
                                    break;

                                case EnumKeiroKbn.GROUPSEL_VAL:
                                    //グループ選択
                                    __setGroupKeiroInfo(
                                        ret.get(resultKey),
                                        routeMdl.getTargetArray()[0].getGroupIdArray(),
                                        con);
                                    break;

                                case EnumKeiroKbn.BOSSTARGET_VAL:
                                    //上長指定
                                    __setJochoKeiroInfo(
                                        ret.get(resultKey),
                                        routeMdl.getTargetArray()[0].getJochoGroupId(),
                                        con);
                                    break;

                                default:
                                    break;
                            }
                            break;
                        }
                    }
                }
                if (keiroBlock.getKeiroKbn() == EnumKeiroKbn.FREESET_VAL) {
                    //任意設定経路情報をセットする
                    ret.get(resultKey).setKeiroMap(freeKeiroMap);
                } else {
                    //審議情報を設定する
                    ret.get(resultKey).getKeiroSingle().dspInitSingiList(
                        ctx.getRequestUserSid(), keiroBlock, con);
                }
            }
            resultKey++;
        }
        return ret;
    }

    /**
     * <br>[機  能] ユーザ選択経路に審議者情報をセットする
     * <br>[解  説]
     * <br>[備  考]
     * @param keiroBlock 経路ブロック情報
     * @param userIdArray ユーザID配列
     * @param con コネクション
     * @throws SQLException
     */
    private void __setUserKeiroInfo(
        Rng020KeiroBlock keiroBlock,
        String[] userIdArray,
        Connection con) throws SQLException {

        CmnUsrmDao cumDao = new CmnUsrmDao(con);
        List<String> usrSidStrList = new ArrayList<String>();
        if (keiroBlock.getKeiroSingle().getUsrgrpSel().getMultiFlg()
            == UserGroupSelectModel.FLG_MULTI_OFF) {
            //単一選択
            if (!__getSingleValue(userIdArray).isEmpty()) {
                int usrSid = cumDao.selectLoginId(userIdArray[0]);
                usrSidStrList.add(String.valueOf(usrSid));
            } else {
                usrSidStrList.add("-1");
            }
        } else if (keiroBlock.getKeiroSingle().getUsrgrpSel().getMultiFlg()
            == UserGroupSelectModel.FLG_MULTI_ON) {
            //複数選択
            if (__getMultiValue(userIdArray) != null) {
                List<Integer> usrSidList = cumDao.selectLoginId(userIdArray);
                while (userIdArray.length > usrSidList.size()) {
                    usrSidList.add(-1);
                }
                usrSidStrList = usrSidList.stream()
                                .map(sid -> String.valueOf(sid))
                                .collect(Collectors.toList());
            } else {
                usrSidStrList.add("-1");
            }
        }
        keiroBlock.getKeiroSingle().getUsrgrpSel()
            .setSelectedSimple(usrSidStrList.toArray(String[]::new));
    }

    /**
     * <br>[機  能] グループ選択経路に審議者情報をセットする
     * <br>[解  説]
     * <br>[備  考]
     * @param keiroBlock 経路ブロック情報
     * @param groupIdArray グループID配列
     * @param con コネクション
     * @throws SQLException
     */
    private void __setGroupKeiroInfo(
        Rng020KeiroBlock keiroBlock,
        String[] groupIdArray,
        Connection con) throws SQLException {

        CmnGroupmDao cgmDao = new CmnGroupmDao(con);
        List<String> grpSidList = new ArrayList<String>();
        if (keiroBlock.getKeiroSingle().getGrpSel().getMultiFlg()
            == UserGroupSelectModel.FLG_MULTI_OFF) {
            //単一選択
            if (!__getSingleValue(groupIdArray).isEmpty()) {
                CmnGroupmModel grpMdl = cgmDao.getGroupInf(groupIdArray[0]);
                if (grpMdl != null) {
                    grpSidList.add(String.valueOf(grpMdl.getGrpSid()));
                } else {
                    grpSidList.add("-1");
                }
            } else {
                grpSidList.add("-1");
            }
        } else if (keiroBlock.getKeiroSingle().getGrpSel().getMultiFlg()
            == UserGroupSelectModel.FLG_MULTI_ON) {
            //複数選択
            if (__getMultiValue(groupIdArray) != null) {
                List<CmnGroupmModel> grpMdlList
                    = cgmDao.selectGrpData(groupIdArray, GSConst.JTKBN_TOROKU);
                grpSidList = grpMdlList.stream()
                                            .map(mdl -> String.valueOf(mdl.getGrpSid()))
                                            .collect(Collectors.toList());
                while (groupIdArray.length > grpSidList.size()) {
                    grpSidList.add("-1");
                }
            } else {
                grpSidList.add("-1");
            }
        }
        keiroBlock.getKeiroSingle().getGrpSel().getMultiselect()
            .setSelected(grpSidList.toArray(String[]::new));
    }

    /**
     * <br>[機  能] 上長指定経路に審議者情報をセットする
     * <br>[解  説]
     * <br>[備  考]
     * @param keiroBlock 経路ブロック情報
     * @param jochoGrpId 上長指定グループID
     * @param con コネクション
     * @throws SQLException
     */
    private void __setJochoKeiroInfo(
        Rng020KeiroBlock keiroBlock,
        String jochoGrpId,
        Connection con) throws SQLException {

        List<String> jochoGrpSidList = new ArrayList<String>();
        if (jochoGrpId != null && !jochoGrpId.isEmpty()) {
            CmnGroupmDao cgmDao = new CmnGroupmDao(con);
            CmnGroupmModel grpMdl = cgmDao.getGroupInf(jochoGrpId);
            if (grpMdl != null) {
                jochoGrpSidList.add(String.valueOf(grpMdl.getGrpSid()));
            } else {
                jochoGrpSidList.add("-1");
            }
        } else {
            jochoGrpSidList.add("-1");
        }
        keiroBlock.getKeiroSingle().getGrpSel().getMultiselect()
            .setSelected(jochoGrpSidList.toArray(String[]::new));
    }

    /**
     * <br>[機  能] 添付ファイル要素に指定された添付ファイルをテンポラリディレクトリに保管する
     * <br>[解  説]
     * <br>[備  考]
     * @param rtpSid 稟議テンプレートSID
     * @param rtpVer 稟議テンプレートバージョン(最新バージョンを指定する場合は-1を設定)
     * @param fb フォーム情報
     * @param ctx RestApiコンテキスト
     * @return 参照元稟議添付ファイルMAP
     * @throws SQLException
     */
    public Map<GSTemporaryPathModel, List<String>> setFileTempDir(
        int rtpSid,
        int rtpVer,
        FormInputBuilder fb,
        RestApiContext ctx) throws SQLException {

        Map<GSTemporaryPathModel, List<String>> ret
            = new HashMap<GSTemporaryPathModel, List<String>>();
        List<RngTemplateFormModel> rtfMdlList = __getFormInfoList(rtpSid, rtpVer, ctx.getCon());
        List<String> tmpFormIdList = rtfMdlList.stream()
            .filter(mdl -> mdl.getRtfType() == EnumFormModelKbn.file.getValue())
            .map(mdl -> mdl.getRtfId())
            .collect(Collectors.toList());
        Map<FormAccesser, FormCell> tempFormMap = fb.getFormMapFromID(tmpFormIdList);
        for (Entry<FormAccesser, FormCell> tempFormMapEntry : tempFormMap.entrySet()) {
            FormCell cell = tempFormMapEntry.getValue();

            //テンポラリディレクトリパスを取得
            GSTemporaryPathModel tempPathMdl = ((Temp) cell.getBody()).getTempPath();
            if (tempPathMdl == null) {
                continue;
            }
            String tempDir = tempPathMdl.getTempPath();

            //バイナリSIDに指定した添付ファイルをテンポラリディレクトリに保管する
            List<Long> binSidList = ((Temp) cell.getBody()).getBinSids();
            if (binSidList != null && binSidList.size() > 0) {
                String dateStr = new UDate().getDateString();
                String domain = ctx.getRequestModel().getDomain();

                //既に登録されているファイルが存在する場合、ファイル番号を最新からにする
                int num = 1;
                List<String> fileList = IOTools.getFileNames(tempDir);
                List<String> initFile = new ArrayList<String>();
                if (fileList != null) {
                    num += fileList.size();
                    initFile.addAll(fileList);
                }
                try {
                    CommonBiz cmnBiz = new CommonBiz();
                    for (long binSid : binSidList) {
                        CmnBinfModel binMdl
                            = cmnBiz.getBinInfo(
                                ctx.getCon(),
                                binSid,
                                domain);
                        if (binMdl != null) {
                            //添付ファイルをテンポラリディレクトリに保管する
                            cmnBiz.saveTempFile(
                                dateStr,
                                binMdl,
                                ctx.getAppRootPath(),
                                tempDir,
                                num);
                            num++;
                        }
                    }
                } catch (TempFileException | IOException | IOToolsException e) {
                    throw new RuntimeException("添付ファイルの保管に失敗", e);
                }

                //参照元稟議添付ファイルMAPにセット
                List<String> tempDirFileList = IOTools.getFileNames(tempDir);
                if (tempDirFileList != null) {
                    ret.put(
                        ((Temp) cell.getBody()).getTempPath(),
                        tempDirFileList.stream()
                            .filter(file -> !initFile.contains(file))
                            .map(file -> file.substring(0, 11))
                            .distinct()
                            .collect(Collectors.toList()));
                }
            }
        }
        return ret;
    }

    /**
     * <br>[機  能] 入力が必須な申請内容に値が入力可能かをチェックする
     * <br>[解  説]
     * <br>[備  考] 入力が必須になっているユーザ選択やグループ選択で、選択可能なユーザが存在するかを確認
     * @param ctx RestApiコンテキスト
     * @param fb フォーム情報
     * @param isTemplate true:テンプレートに対するチェック false:稟議情報に対するチェック
     * @param textValue エラーメッセージに表示する値
     * @throws SQLException
     */
    public void checkUseForm(
        RestApiContext ctx, FormInputBuilder fb, boolean isTemplate, String textValue) {
        ActionErrors errors = fb.chkUnuseableInput(ctx.getRequestModel());
        if (!errors.isEmpty()) {
            RestapiMessageResources msgRes
                = new RestapiMessageResources(ctx.getMessageResources());
            ActionMessageBiz biz = new ActionMessageBiz();
            List<ActionMessageModel> msgList = biz.getMessageKeyValue(errors);
            StringBuilder sb = new StringBuilder();
            for (ActionMessageModel mdl : msgList) {
                String errorMsgText = msgRes.getMessage(mdl.getKey(), mdl.getValues());
                if (sb.length() > 0) {
                    sb.append("\r\n");
                }
                sb.append(errorMsgText);
            }

            if (isTemplate) {
                throw new RestApiValidateException(
                    RngEnumReasonCode.PARAM_CANT_USE_FORM,
                    "restapi.error.form.unuseable.soukatu.template",
                    sb.toString());
            } else {
                throw new RestApiValidateException(
                    RngEnumReasonCode.PARAM_CANT_USE_FORM,
                    "restapi.error.form.unuseable.soukatu.ringi",
                    textValue,
                    sb.toString());
            }

        }
    }
    /**
     * <br>[機  能] 経路情報をチェックする
     * <br>[解  説]
     * <br>[備  考] 利用可能な承認経路があるかなどをチェックし、エラーがあれば例外をスローする
     * @param ctx RestApiコンテキスト
     * @param rtpMdl テンプレート情報
     * @param fb フォーム情報
     * @param isTemplate true:テンプレートに対するチェック false:稟議情報に対するチェック
     * @param textValue エラーメッセージに表示する値
     * @throws SQLException
     */
    public void checkUseKeiro(
        RestApiContext ctx, RngTemplateModel rtpMdl, FormInputBuilder fb,
        boolean isTemplate, String textValue) throws SQLException, RtpNotfoundException {

        checkUseKeiro(ctx, rtpMdl, fb, isTemplate, true, textValue);
    }

    /**
     * <br>[機  能] 経路情報をチェックする
     * <br>[解  説]
     * <br>[備  考] 利用可能な承認経路があるかなどをチェックし、エラーがあれば例外をスローする
     * @param ctx RestApiコンテキスト
     * @param rtpMdl テンプレート情報
     * @param fb フォーム情報
     * @param isTemplate true:テンプレートに対するチェック false:稟議情報に対するチェック
     * @param isFirst true:初回描画 false:初回描画ではない(申請を行う時など)
     * @param textValue エラーメッセージに表示する値
     * @throws SQLException
     */
    public void checkUseKeiro(
        RestApiContext ctx, RngTemplateModel rtpMdl, FormInputBuilder fb,
        boolean isTemplate, boolean isFirst,
        String textValue) throws SQLException, RtpNotfoundException {

        Map<Integer, Rng020KeiroBlock> syouninKeiroBlockMap = new HashMap<>();
        Map<Integer, Rng020KeiroBlock> kakuninKeiroBlockMap = new HashMap<>();
        RequestModel reqMdl = ctx.getRequestModel();
        Connection con = ctx.getCon();

        setKeiroData(ctx, rtpMdl, syouninKeiroBlockMap, kakuninKeiroBlockMap, false);
        Rng020Biz biz = new Rng020Biz(con, reqMdl);
        biz.dspKeiroTpl(fb, syouninKeiroBlockMap, kakuninKeiroBlockMap, isFirst, false);

        ActionErrors errors = biz.chkRTKuseable(syouninKeiroBlockMap, RngConst.RNG_RNCTYPE_APPR);
        String messageKey = "restapi.error.keiro.unuseable.soukatu.ringi";
        if (isTemplate) {
            messageKey = "restapi.error.keiro.unuseable.soukatu.template";
        }

        ActionMessageBiz messageBiz = new ActionMessageBiz();
        if (errors.size() > 0) {
            RestapiMessageResources msgRes
                = new RestapiMessageResources(ctx.getMessageResources());
            List<ActionMessageModel> msgList = messageBiz.getMessageKeyValue(errors);
            StringBuilder sb = new StringBuilder();
            for (ActionMessageModel mdl : msgList) {
                String errorMsgText = msgRes.getMessage(mdl.getKey(), mdl.getValues());
                if (sb.length() > 0) {
                    sb.append("\r\n");
                }
                sb.append(errorMsgText);
            }

            if (isTemplate) {
                throw new RestApiValidateException(
                    RngEnumReasonCode.PARAM_CANT_USE_SYOUNIN_KEIRO,
                    messageKey,
                    sb.toString());
            } else {
                throw new RestApiValidateException(
                    RngEnumReasonCode.PARAM_CANT_USE_SYOUNIN_KEIRO,
                    messageKey,
                    textValue,
                    sb.toString()
                );
            }
        }

        errors = biz.chkRTKuseable(kakuninKeiroBlockMap, RngConst.RNG_RNCTYPE_CONFIRM);
        if (errors.size() > 0) {
            RestapiMessageResources msgRes
                = new RestapiMessageResources(ctx.getMessageResources());
            List<ActionMessageModel> msgList = messageBiz.getMessageKeyValue(errors);
            StringBuilder sb = new StringBuilder();
            for (ActionMessageModel mdl : msgList) {
                String errorMsgText = msgRes.getMessage(mdl.getKey(), mdl.getValues());
                if (sb.length() > 0) {
                    sb.append("\r\n");
                }
                sb.append(errorMsgText);
            }
            if (isTemplate) {
                throw new RestApiValidateException(
                    RngEnumReasonCode.PARAM_CANT_USE_KAKUNIN_KEIRO,
                    messageKey,
                    sb.toString());
            } else {
                throw new RestApiValidateException(
                    RngEnumReasonCode.PARAM_CANT_USE_KAKUNIN_KEIRO,
                    messageKey,
                    textValue,
                    sb.toString()
                );
            }
        }
    }

    /**
     * <br>[機  能] 既存の稟議から、経路情報を読み込むことができるかをチェックする
     * <br>[解  説]
     * <br>[備  考]
     * @param rngData 稟議情報
     * @param oldModel 旧テンプレート情報
     * @param model 現在のテンプレート情報
     * @return true:棄損の稟議から経路情報を読み込める false:棄損の稟議から経路情報を読み込めない
     */
    private boolean __canLoadKeiro(
        RngRndataModel rngData, RngTemplateModel oldModel, RngTemplateModel model) {

        if (rngData.getRtpSid() <= 0) {
            return true;
        }

        boolean isUseCopy = false;
        if (model != null && model.getRtpSid() > 0                  // 汎用テンプレート以外
            && model.getRtpSpecVer() == RngConst.RNG_RTP_SPEC_VER_A480  // v4.8.0以降のテンプレート
            && model.getRtpType() == RngConst.RNG_TEMPLATE_SHARE) {     // 共有テンプレート
            isUseCopy = true;
        }
        // テンプレート情報から取得
        int rctSid = model.getRctSid(); // テンプレートで使用している経路テンプレートSID
        int rctVer = model.getRctVer();

        // 複写時のテンプレート経路変更判定(共有テンプレートのみ)
        boolean isKeiroChange = false;
        if (isUseCopy) {
            if (oldModel == null
                || rctSid != oldModel.getRctSid()      // 使用する経路テンプレート変更あり
                || rctVer != rngData.getRctVer()) {    // 経路バージョン変更あり
                isKeiroChange = true;
            }
        }

        if (isKeiroChange) {
            return false;
        }
        return true;
    }

    /**
     *
     * <br>[機  能] 経路情報をDBから取得し、パラメータに設定する
     * <br>[解  説]
     * <br>[備  考] 草稿から編集，複写申請の際に使用する
     * @param ctx RestApiコンテキスト
     * @param rngSid 稟議SID
     * @param rtpMdl テンプレート情報
     * @param oldVer   旧テンプレートのバージョン番号(テンプレート更新がない場合 = -1)
     * @param syouninKeiroMap 承認経路情報
     * @param kakuninKeiroMap 確認経路情報
     * @param isCopy true:複写申請, false:複写申請ではない
     * @throws SQLException SQL実行時例外
     * @throws RtpNotfoundException
     */
    public void loadKeiro(RestApiContext ctx, int rngSid, RngTemplateModel rtpMdl, int oldVer,
        Map<Integer, Rng020KeiroBlock> syouninKeiroMap,
        Map<Integer, Rng020KeiroBlock> kakuninKeiroMap,
        boolean isCopy) throws SQLException, RtpNotfoundException {
        boolean isUseCopy = false;
        if (rtpMdl != null && rtpMdl.getRtpSid() > 0                  // 汎用テンプレート以外
            && rtpMdl.getRtpSpecVer() == RngConst.RNG_RTP_SPEC_VER_A480  // v4.8.0以降のテンプレート
            && rtpMdl.getRtpType() == RngConst.RNG_TEMPLATE_SHARE
            && isCopy) {     // 共有テンプレート
            isUseCopy = true;
        }
        int rtpSid = rtpMdl.getRtpSid();
        int rtpVer = rtpMdl.getRtpVer();

        Map<Integer, Rng020Keiro> rksSidMap = new HashMap<Integer, Rng020Keiro>();
        Connection con = ctx.getCon();
        RngKeiroStepDao rksDao = new RngKeiroStepDao(con);
        RngKeiroStepDao.SearchModel search = new SearchModel();
        search.setRngSid(rngSid);
        /**関連経路マップ*/
        Map<Integer, Rng020KeiroBlock> belongMapAppr = new HashMap<Integer, Rng020KeiroBlock>();
        Map<Integer, Rng020KeiroBlock> belongMapConfirm = new HashMap<Integer, Rng020KeiroBlock>();
        List<RngKeiroStepModel> rksList = rksDao.select(search);

        Map<Integer, RngKeiroStepModel> confirmMap = new HashMap<Integer, RngKeiroStepModel>();
        List<Integer> checkList = new ArrayList<Integer>();

        // 旧バージョンがある場合、取得した経路ステップ一覧を最新バージョンへ書き換える
        HashMap<Integer, Integer> convtRtkSidMap = new HashMap<Integer, Integer>();
        if (oldVer >= 0) {
            // 新バージョンと旧バージョンのテンプレート経路SID
            SearchParamForRTP tplSerach = new SearchParamForRTP(rtpSid, oldVer);
            RngTemplateKeiroDao rtkDao = new RngTemplateKeiroDao(con);
            List<RngTemplateKeiroModel> oldRtkList = rtkDao.select(tplSerach, RngConst.JKBN_ALL);

            tplSerach.setRtpVer(rtpVer);
            List<RngTemplateKeiroModel> newRtkList = rtkDao.select(tplSerach, RngConst.JKBN_ALL);

            for (RngTemplateKeiroModel newRtk : newRtkList) {
                for (RngTemplateKeiroModel oldRtk : oldRtkList) {
                    // 経路役割とソート番号が一致している場合、同一の経路として判定
                    if (newRtk.getRtkRollType() == oldRtk.getRtkRollType()
                        && newRtk.getRtkSort()     == oldRtk.getRtkSort()) {
                        convtRtkSidMap.put(oldRtk.getRtkSid(), newRtk.getRtkSid());
                        oldRtkList.remove(oldRtk); // 使用済みのデータは除去
                        break;
                    }
                }
            }
        }

        for (RngKeiroStepModel rksMdl : rksList) {

            // テンプレート更新があった場合にテンプレート経路SIDを更新
            if (convtRtkSidMap.size() > 0) {
                int rtkSid    = rksMdl.getRtkSid();
                int belongSid = rksMdl.getRksBelongSid();

                if (rtkSid > 0 && convtRtkSidMap.containsKey(rtkSid)) {
                    rksMdl.setRtkSid(convtRtkSidMap.get(rtkSid));
                }
                if (belongSid > 0 && convtRtkSidMap.containsKey(belongSid)) {
                    rksMdl.setRksBelongSid(convtRtkSidMap.get(belongSid));
                }
            }

            if (rksMdl.getRtkSid() > 0) {
                if (checkList.contains(rksMdl.getRtkSid())) {
                    continue; // 重複する稟議テンプレートステップSIDはスキップする
                }
                checkList.add(rksMdl.getRtkSid()); // 重複チェック用に追加
            }

            Rng020Keiro keiro = null;
            Rng020KeiroBlock keiroBlock = new Rng020KeiroBlock();
            keiro = keiroBlock.getKeiroSingle();
            if (keiro != null) {
                rksSidMap.put(rksMdl.getRksSid(), keiro);
                keiro.setStep(rksMdl);
                keiro.setRtkSid(rksMdl.getRtkSid());
                keiroBlock.setRtkSid(rksMdl.getRtkSid());
            }

            //経路が任意経路内経路ではない場合
            if (rksMdl.getRksBelongSid() < 0) {
                if (rksMdl.getRksRollType() == RngConst.RNG_RNCTYPE_APPR) {
                    __putKeiro(syouninKeiroMap, keiroBlock);
                }
                if (rksMdl.getRksRollType() == RngConst.RNG_RNCTYPE_CONFIRM) {
                    if (isUseCopy) {
                        // 複写用経路データ使用する場合、一旦配列へ格納する
                        confirmMap.put(rksMdl.getRksSid(), rksMdl);
                    } else {
                        // 複写用経路データ使用しない場合、そのまま取得する
                        __putKeiro(kakuninKeiroMap, keiroBlock);
                    }
                }
            } else {
                keiroBlock.setRtkSid(rksMdl.getRksBelongSid()); // 経路に親経路が存在する場合、親経路SIDをセット

                Map<Integer, Rng020KeiroBlock> belongMap;
                if (rksMdl.getRksRollType() == RngConst.RNG_RNCTYPE_APPR) {
                    belongMap = belongMapAppr;
                } else  {
                    belongMap = belongMapConfirm;
                }
                if (!belongMap.containsKey(rksMdl.getRksBelongSid())) {
                    belongMap.put(rksMdl.getRksBelongSid(), keiroBlock);
                    if (rksMdl.getRksRollType() == RngConst.RNG_RNCTYPE_APPR) {
                        __putKeiro(syouninKeiroMap, keiroBlock);
                    }
                    if (rksMdl.getRksRollType() == RngConst.RNG_RNCTYPE_CONFIRM) {
                        if (isUseCopy) {
                            // 複写用経路データ使用する場合、一旦配列へ格納する
                            confirmMap.put(rksMdl.getRksSid(), rksMdl);
                        } else {
                            // 複写用経路データ使用しない場合、そのまま取得する
                            __putKeiro(kakuninKeiroMap, keiroBlock);
                        }
                    }
                } else {
                    //任意設定経路の先頭以降の場合、関連経路マップの経路ブロックに経路ステップを追加
                    keiroBlock = belongMap.get(rksMdl.getRksBelongSid());
                    keiroBlock.setKeiro(keiroBlock.getKeiroMap().size(), keiro);
                }
            }
        }
        RngKeirostepSelectDao rssDao = new RngKeirostepSelectDao(con);

        List<RngKeirostepSelectModel> rssList = rssDao.select(rngSid);
        for (RngKeirostepSelectModel rssMdl : rssList) {
            Rng020Keiro keiro = rksSidMap.get(rssMdl.getRksSid());
            if (keiro != null) {
                List<RngKeirostepSelectModel> select = keiro.getInitSelect();
                if (select == null) {
                    select = new ArrayList<RngKeirostepSelectModel>();
                    keiro.setInitSelect(select);
                }
                select.add(rssMdl);
            }
        }

        // -----------------------------------------------------
        //  複写用の経路データから画面に表示する経路情報作成
        // -----------------------------------------------------
        if (confirmMap.size() > 0) {
            rksSidMap = new HashMap<Integer, Rng020Keiro>();
            List<Integer> sidList = new ArrayList<Integer>(confirmMap.keySet());

            // 経路ステップ選択情報を作成
            RngCopyKeirostepSelectDao rcsDao = new RngCopyKeirostepSelectDao(con);
            ArrayList<RngCopyKeirostepSelectModel> rcsList = rcsDao.selectByRksSid(sidList);
            Map<String, List<RngKeirostepSelectModel>> rcsMap =
                    new HashMap<String, List<RngKeirostepSelectModel>>();
            for (RngCopyKeirostepSelectModel rcsMdl : rcsList) {
                Integer rksSid  = Integer.valueOf(rcsMdl.getRksSid());
                Integer rckSort = Integer.valueOf(rcsMdl.getRckSort());
                String key = rksSid + "-" + rckSort;
                List<RngKeirostepSelectModel> select = rcsMap.get(key);
                if (select == null) {
                    select = new ArrayList<RngKeirostepSelectModel>();
                    rcsMap.put(key, select);
                }
                select.add(rcsMdl.getRssMdl());
            }

            // 経路ステップ情報を作成
            RngCopyKeiroStepDao rckDao = new RngCopyKeiroStepDao(con);
            ArrayList<RngCopyKeiroStepModel> rckList = rckDao.select(sidList);
            for (RngCopyKeiroStepModel rckMdl : rckList) {
                Rng020KeiroBlock keiroBlock = new Rng020KeiroBlock();
                Rng020Keiro keiro = keiroBlock.getKeiroSingle();
                Integer rksSid  = Integer.valueOf(rckMdl.getRksSid());
                RngKeiroStepModel rksMdl = null;

                // テンプレート更新があった場合にテンプレート経路SIDを更新
                if (convtRtkSidMap.size() > 0) {
                    int rtkSid    = rckMdl.getRtkSid();
                    int belongSid = rckMdl.getRksBelongSid();

                    if (rtkSid > 0 && convtRtkSidMap.containsKey(rtkSid)) {
                        rckMdl.setRtkSid(convtRtkSidMap.get(rtkSid));
                    }
                    if (belongSid > 0 && convtRtkSidMap.containsKey(belongSid)) {
                        rckMdl.setRksBelongSid(convtRtkSidMap.get(belongSid));
                    }
                }

                if (rckMdl.getRtkSid() > 0) {
                    if (checkList.contains(rckMdl.getRtkSid())) {
                        continue; // 重複する稟議テンプレートステップSIDはスキップする
                    }
                    checkList.add(rckMdl.getRtkSid()); // 重複チェック用に追加
                }

                if (keiro != null) {
                    rksMdl = rckMdl.margeRksMdl(confirmMap.get(rksSid));
                }

                if (rksMdl != null) {
                    keiro.setStep(rksMdl);
                    keiro.setRtkSid(rckMdl.getRtkSid());
                    keiroBlock.setRtkSid(rksMdl.getRtkSid());

                    Integer rckSort = Integer.valueOf(rckMdl.getRckSort());
                    String key = rksSid + "-" + rckSort;
                    List<RngKeirostepSelectModel> select = rcsMap.get(key);
                    if (select != null) {
                        keiro.setInitSelect(select);
                    }

                    if (rksMdl.getRksBelongSid() >= 0) {
                        // 経路に親経路が存在する場合、親経路SIDをセット
                        keiroBlock.setRtkSid(rksMdl.getRksBelongSid());

                        if (!belongMapConfirm.containsKey(rksMdl.getRksBelongSid())) {
                            belongMapConfirm.put(rksMdl.getRksBelongSid(), keiroBlock);
                        } else {
                            //任意設定経路の先頭以降の場合、関連経路マップの経路ブロックに経路ステップを追加
                            keiroBlock = belongMapConfirm.get(rksMdl.getRksBelongSid());
                            keiroBlock.setKeiro(keiroBlock.getKeiroMap().size(), keiro);
                            continue;
                        }
                    }
                }
                // 複写データから作成した経路情報を最終確認経路へ追加
                __putKeiro(kakuninKeiroMap, keiroBlock);
            }
        }
    }

    /**
     * <br>[機  能] 経路情報をMapに追加する
     * <br>[解  説]
     * <br>[備  考]
     * @param keiroBlockMap 経路情報
     * @param keiroBlock 経路ブロック
     */
    private void __putKeiro(
        Map<Integer, Rng020KeiroBlock> keiroBlockMap, Rng020KeiroBlock keiroBlock) {
        int max = 0;
        if (keiroBlockMap.size() > 0) {
            //最終要素のキー値を取得する
            max = new ArrayList<Integer>(keiroBlockMap.keySet()).get(keiroBlockMap.size() - 1);
            max++;
        }
        keiroBlockMap.put(max, keiroBlock);
    }

    /**
     * <br>[機  能] 承認経路情報，確認経路情報を取得し、パラメータに設定する
     * <br>[解  説]
     * <br>[備  考]
     * @param ctx RestApiコンテキスト
     * @param rtpMdl テンプレート情報
     * @param syouninKeiroBlockMap 承認経路情報
     * @param kakuninKeiroBlockMap 確認経路情報
     * @param isLoaded true:ロード済み, false:ロード済みではない
     * @throws SQLException
     * @throws RtpNotfoundException
     */
    public void setKeiroData(
        RestApiContext ctx, RngTemplateModel rtpMdl,
        Map<Integer, Rng020KeiroBlock> syouninKeiroBlockMap,
        Map<Integer, Rng020KeiroBlock> kakuninKeiroBlockMap,
        boolean isLoaded)
        throws SQLException, RtpNotfoundException {

        RequestModel reqMdl = ctx.getRequestModel();
        Connection con = ctx.getCon();

        RngTemplateKeiroSave keiroSave = null;
        if (rtpMdl.getRctSid() > 0) {
            keiroSave = RngTemplateKeiroSave.createInstanceForRCT(
                rtpMdl.getRctSid(), rtpMdl.getRctUsrSid(), reqMdl, con);
        } else if (rtpMdl.getRtpSid() > 0) {
            keiroSave = RngTemplateKeiroSave.createInstanceForRTP(rtpMdl.getRtpSid(),
            rtpMdl.getRtpVer(), reqMdl, con);
        }

        Map<Integer, Rng110KeiroDialogParamModel> keiroTplMap = null;
        Map<Integer, Rng110KeiroDialogParamModel> finalKeiroTplMap = null;
        if (keiroSave != null) {
            keiroSave.load();
            keiroTplMap      = keiroSave.getKeiro();
            finalKeiroTplMap = keiroSave.getFinalKeiro();
        }

        RngTemplateBiz rtpBiz = new RngTemplateBiz();
        rtpBiz.initKeiroTpl(
            syouninKeiroBlockMap, kakuninKeiroBlockMap, keiroTplMap,
            finalKeiroTplMap, true, isLoaded);
    }

    /**
     * <br>[機  能] 申請内容の入力チェックを行う
     * <br>[解  説]
     * <br>[備  考]
     * @param formInputBuilder 申請内容モデル
     * @param bodyArray 申請内容リクエストモデル
     * @param rngSid 稟議SID
     * @param rtpMdl 稟議テンプレートモデル
     * @param tempPathMdl テンポラリディレクトリパスモデル
     * @param type 申請タイプ
     * @param isSoukouTouroku true:草稿登録 false:草稿登録ではない
     * @param ctx RESTAPIコンテキスト
     * @throws SQLException
     * @throws IOToolsException
     */
    public void checkBodyInfo(
        FormInputBuilder formInputBuilder,
        RngRestApiRingiBodyParamModel[] bodyArray,
        int rngSid,
        RngTemplateModel rtpMdl,
        GSTemporaryPathModel tempPathMdl,
        EnumRngEntitiesType type,
        boolean isSoukouTouroku,
        RestApiContext ctx) throws SQLException, IOToolsException {

        ActionErrors errors = new ActionErrors();
        MessageResources msgRes = ctx.getMessageResources();
        ActionMessageBiz messageBiz = new ActionMessageBiz();
        GsMessage gsMsg = new GsMessage(ctx.getRequestModel());

        //添付ファイル要素 参照元稟議のバイナリ情報を指定時、参照可能かチェックする
        List<FormCell> tempCellList = formInputBuilder.getFormMap().values().stream()
                                        .filter(m -> m.getType() == EnumFormModelKbn.file)
                                        .collect(Collectors.toList());
        boolean fileReferenceError = false;
        RngBinDao rngBinDao = new RngBinDao(ctx.getCon());
        ArrayList<String> binList = new ArrayList<String>();
        if (rngSid > 0) {
            binList = rngBinDao.selectBinList(rngSid);
        }
        for (FormCell cell : tempCellList) {
            Temp tempCell = (Temp) cell.getBody();
            for (Long binSid : tempCell.getBinSids()) {
                if (!binList.contains(String.valueOf(binSid))) {
                    fileReferenceError = true;
                    break;
                }
            }
            if (fileReferenceError) {
                break;
            }
        }

        //添付ファイル要素 ディレクトリ識別文字列を指定時
        //・ディレクトリの存在チェックと重複チェック
        //・新規アップロードファイルのサイズ制限チェックを行う
        boolean dirCodeExistError = false;
        boolean dirCodeDoubleError = false;
        boolean fileSizeError = false;

        //ディレクトリ識別文字列を取得
        List<String> tempFormIdList = tempCellList.stream()
                                    .map(cell -> cell.getFormID())
                                    .collect(Collectors.toList());

        //表要素以外
        List<String> dirCodeList = Arrays.asList(bodyArray).stream()
            .filter(m -> tempFormIdList.contains(m.getFormId()))
            .map(m -> m.getContentInfo().getDirectoryCodeText())
            .filter(str -> str != null && !str.isEmpty())
            .collect(Collectors.toList());

        //表要素
        List<String> blCellList = formInputBuilder.getFormMap().values().stream()
                                    .filter(m -> m.getType() == EnumFormModelKbn.blocklist)
                                    .map(m -> m.getFormID())
                                    .collect(Collectors.toList());

        List<RngRestApiRingiBodyParamModel> blMdlList = Arrays.asList(bodyArray).stream()
                                    .filter(m -> blCellList.contains(m.getFormId()))
                                    .collect(Collectors.toList());

        for (RngRestApiRingiBodyParamModel blMdl : blMdlList) {
            //ヘッダー
            dirCodeList.addAll(
                Arrays.asList(blMdl.getContentInfo().getBlockListInfo().getHeaderArray())
                    .stream()
                    .map(m -> m.getContentInfo().getDirectoryCodeText())
                    .filter(str -> str != null && !str.isEmpty())
                    .collect(Collectors.toList()));
            //ボディ
            for (RngRestApiRingiBodyRowParamModel bodyRowMdl
                : blMdl.getContentInfo().getBlockListInfo().getBodyArray()) {
                dirCodeList.addAll(
                    Arrays.asList(bodyRowMdl.getBlockRowArray())
                        .stream()
                        .map(m -> m.getContentInfo().getDirectoryCodeText())
                        .filter(str -> str != null && !str.isEmpty())
                        .collect(Collectors.toList()));
            }
            //フッター
            dirCodeList.addAll(
                Arrays.asList(blMdl.getContentInfo().getBlockListInfo().getFooterArray())
                    .stream()
                    .map(m -> m.getContentInfo().getDirectoryCodeText())
                    .filter(str -> str != null && !str.isEmpty())
                    .collect(Collectors.toList()));
        }

        //テンポラリディレクトリパスリスト（重複チェック用）
        List<String> tempDirList = new ArrayList<String>();

        //添付ファイル最大容量取得
        CmnFileConfDao cfcDao = new CmnFileConfDao(ctx.getCon());
        CmnFileConfModel cfcMdl = cfcDao.select();
        int maxSize = cfcMdl.getFicMaxSize();
        int maxSizeMb = maxSize * GSConstCommon.FILE_SIZE_1MB;

        for (String dirCode : dirCodeList) {

            //ディレクトリ存在チェック
            String tempDir = "";
            if (!dirCodeExistError) {
                try {
                    byte[] codeByte = Base64.decodeBase64(dirCode);
                    String dirName = Blowfish.decrypt("gsFileDirMake", codeByte);
                    tempDir = tempPathMdl.getTempPath() + dirName + "/";
                    File useDir = new File(tempDir);
                    if (!useDir.exists()) {
                        //指定したディレクトリが存在しない
                        dirCodeExistError = true;
                    }
                } catch (Exception e) {
                    //ディレクトリの指定に失敗
                    dirCodeExistError = true;
                }

                //ディレクトリにファイルが存在しない
                if (!dirCodeExistError) {
                    List<String> fileNameList = IOTools.getFileNames(tempDir);
                    if (fileNameList == null || fileNameList.isEmpty()) {
                        dirCodeExistError = true;
                    }
                }
            }

            //重複チェック
            if (!dirCodeDoubleError) {
                if (tempDirList.contains(tempDir)) {
                    dirCodeDoubleError = true;
                } else {
                    tempDirList.add(tempDir);
                }
            }

            //ファイルサイズ制限チェック
            if (!fileSizeError) {
                Enumeration<File> fileList = IOTools.getFiles(tempDir);
                if (fileList != null) {
                    //ファイルサイズ制限を超えたファイルが存在する
                    while (fileList.hasMoreElements()) {
                        File file = fileList.nextElement();
                        if (maxSizeMb < file.length()) {
                            fileSizeError = true;
                        }
                    }
                }
            }
        }

        //リクエストボディに指定した参照元稟議の添付ファイルをテンポラリディレクトリに展開
        Map<GSTemporaryPathModel, List<String>> referenceBinMap
            = new HashMap<GSTemporaryPathModel, List<String>>();
        if (rngSid > 0) {
            if (type == EnumRngEntitiesType.entry) {
                //草稿から申請/複写申請
                referenceBinMap = setFileTempDir(
                    rtpMdl.getRtpSid(), -1, formInputBuilder, ctx);
            } else {
                //再申請
                referenceBinMap = setFileTempDir(
                    rtpMdl.getRtpSid(), rtpMdl.getRtpVer(), formInputBuilder, ctx);
            }
        }

        //申請内容チェック
        ValidateInfo validateInfo = new ValidateInfo();
        if (isSoukouTouroku) {
            validateInfo.setSokoMode(1);
        }
        formInputBuilder.validateCheck(errors, ctx.getRequestModel(), validateInfo);

        //申請内容の入力チェック後、リクエストボディに指定した添付ファイルをテンポラリディレクトリから削除
        deleteReferenceBin(referenceBinMap);

        if (errors.size() > 0
            || fileReferenceError
            || dirCodeExistError
            || dirCodeDoubleError
            || fileSizeError) {
            //申請内容の入力に誤りがある
            List<ActionMessageModel> messageModelList = messageBiz.getMessageKeyValue(errors);
            StringBuilder sb = new StringBuilder();
            for (ActionMessageModel messageModel : messageModelList) {
                if (sb.length() > 0) {
                    sb.append("\r\n");
                }
                sb.append(msgRes.getMessage(messageModel.getKey(), messageModel.getValues()));
            }

            if (fileReferenceError) {
                //参照できないバイナリSIDが指定されていた場合
                if (sb.length() > 0) {
                    sb.append("\r\n");
                }
                sb.append(msgRes.getMessage("restapi.error.param.data.reference",
                    "bodyArray",
                    gsMsg.getMessage("cmn.bin.sid")));
            }

            if (dirCodeExistError) {
                //存在しないディレクトリが指定されていた場合
                if (sb.length() > 0) {
                    sb.append("\r\n");
                }
                sb.append(msgRes.getMessage("restapi.error.param.data.access",
                    "bodyArray",
                    gsMsg.getMessage("fil.fil080.9")));
            }
            if (dirCodeDoubleError) {
                //ディレクトリが重複していた場合
                if (sb.length() > 0) {
                    sb.append("\r\n");
                }
                sb.append(msgRes.getMessage("error.select.dup.list",
                    gsMsg.getMessage("fil.fil080.9")));
            }
            if (fileSizeError) {
                //ファイルサイズ制限を超えるファイルが新規アップロードされていた場合
                sb.append(msgRes.getMessage("restapi.error.file.size.error",
                    "bodyArray",
                    String.valueOf(maxSize), ""));
            }

            throw new RestApiValidateException(
                RngEnumReasonCode.PARAM_INPUT_ERROR_ENTRY_PARAM,
                    "error.input.messages",
                    "bodyArray",
                    sb.toString()
            );
        }
    }

    /**
     * <br>[機  能] 参照元稟議の添付ファイルをテンポラリディレクトリから削除する
     * <br>[解  説]
     * <br>[備  考]
     * @param binMap 参照元稟議添付ファイルMAP
     * @throws IOToolsException
     */
    public void deleteReferenceBin(
        Map<GSTemporaryPathModel, List<String>> binMap) throws IOToolsException {

        GSTemporaryPathUtil tempPathUtil = GSTemporaryPathUtil.getInstance();
        for (Entry<GSTemporaryPathModel, List<String>> entry :  binMap.entrySet()) {
            GSTemporaryPathModel tempPathMdl = entry.getKey();
            List<String> files = entry.getValue();
            List<String> fileList = IOTools.getFileNames(tempPathMdl.getTempPath());
            //ディレクトリ内のファイルを全て削除する場合、ディレクトリも削除する。
            if (fileList.size() == files.size() * 2) {
                tempPathUtil.deleteTempPath(tempPathMdl);
            } else {
                tempPathUtil.deleteFile(files.toArray(String[]::new), tempPathMdl);
            }
        }
    }

    /**
     * <br>[機  能] 稟議APIのログ出力を行う
     * <br>[解  説]
     * <br>[備  考]
     * @param ctx コンテキスト
     * @param level ログレベル
     * @param opCode 操作コード
     * @param value 内容
     * @param logCode 操作コード(内部)
     */
    public void outPutLog(
            RestApiContext ctx,
            String level,
            String opCode,
            String value,
            String logCode) {

        outPutLog(ctx, null, level, opCode, value, logCode);
    }

    /**
     * <br>[機  能] 稟議APIのログ出力を行う
     * <br>[解  説]
     * <br>[備  考]
     * @param ctx コンテキスト
     * @param action アクション
     * @param level ログレベル
     * @param opCode 操作コード
     * @param value 内容
     * @param logCode 操作コード(内部)
     */
    public void outPutLog(
            RestApiContext ctx,
            String action,
            String level,
            String opCode,
            String value,
            String logCode) {

        RequestModel reqMdl = ctx.getRequestModel();
        GsMessage gsMsg = new GsMessage(reqMdl);
        String msg = gsMsg.getMessage("rng.62");
        String pgId = ctx.getMap().getType();

        CmnLogModel logMdl = new CmnLogModel();
        logMdl.setLogDate(new UDate());
        logMdl.setUsrSid(ctx.getRequestUserSid());
        logMdl.setLogLevel(level);
        logMdl.setLogPlugin(RngConst.PLUGIN_ID_RINGI);
        logMdl.setLogPluginName(msg);
        logMdl.setLogPgId(pgId);
        logMdl.setLogPgName(__getlogPgName(pgId, ctx, action));
        logMdl.setLogOpCode(opCode);
        logMdl.setLogOpValue(value);
        logMdl.setLogIp(reqMdl.getRemoteAddr());
        logMdl.setVerVersion(GSConst.VERSION);
        logMdl.setLogCode(logCode);

        LoggingBiz logBiz = new LoggingBiz(ctx.getCon());
        String domain = reqMdl.getDomain();
        logBiz.outPutLog(logMdl, domain);
    }

    /**
     * <br>[機  能] プログラムIDからAPI名を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param pgId プログラムID
     * @param ctx コンテキスト
     * @param action アクション
     * @return 画面名
     */
    private String __getlogPgName(String pgId, RestApiContext ctx, String action) {

        String ret = null;
        GsMessage gsMsg = new GsMessage(ctx.getRequestModel());
        String method = ctx.getMethod();

        switch (pgId) {
            case "jp.groupsession.v2.rng.restapi.users.entities.RngUsersEntitiesAction":
                //稟議にアクションする
                if (method.equals("POST")) {
                    ret = gsMsg.getMessage("rng.restapi.users.entities.action");
                } else {
                    //その他：想定無し
                    ret = method;
                }
                break;

            //稟議の承認経路を追加する
            case "jp.groupsession.v2.rng.restapi.users."
                + "entities.steps.keiro.RngUsersEntitiesStepsKeiroAction":
                ret = gsMsg.getMessage("rng.restapi.users.entities.steps.keiro");
                break;

            //稟議の確認時コメントを編集する
            case "jp.groupsession.v2.rng.restapi.users."
                + "entities.steps.comment.RngUsersEntitiesStepsCommentAction":
                ret = gsMsg.getMessage("rng.restapi.users.entities.steps.comment");
                break;

            //稟議の添付ファイルをダウンロードする
            case "jp.groupsession.v2.rng.restapi.entities.files.RngEntitiesFilesAction":
                ret = gsMsg.getMessage("rng.restapi.entities.files");
                break;
            //稟議を申請・削除する
            case "jp.groupsession.v2.rng.restapi.entities.RngEntitiesAction":
                if (method.equals("POST")) {
                    if (Objects.equals(action, "entry")) {
                        //稟議を申請する
                        ret = gsMsg.getMessage("rng.restapi.entities.entry");
                    } else if (Objects.equals(action, "retry")) {
                        //稟議を再申請する
                        ret = gsMsg.getMessage("rng.restapi.entities.retry");
                    } else if (Objects.equals(action, "draft")) {
                        //稟議を草稿保存する
                        ret = gsMsg.getMessage("rng.restapi.entities.draft");
                    }
                } else if (method.equals("DELETE")) {
                    //稟議を削除する
                    ret = gsMsg.getMessage("rng.restapi.entities.delete");
                }
                break;

            //稟議テンプレートの添付ファイルをダウンロードする
            case "jp.groupsession.v2.rng.restapi.templates.files.RngTemplatesFilesAction":
                ret = gsMsg.getMessage("rng.restapi.templates.files");
                break;

            default:
                ret = "未定義";
                break;
        }


        return "[WEBAPI] " + ret;
    }

}
