package jp.groupsession.v2.rng.restapi.accounts.query;

import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.restapi.controller.AbstractRestApiAction;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.controller.annotation.Get;
import jp.groupsession.v2.restapi.controller.annotation.Plugin;
import jp.groupsession.v2.restapi.response.RestApiResponseWriter;

/**
 * アカウント情報を一覧取得するAPI アクションクラス
 *
 */
@Plugin(GSConst.PLUGIN_ID_RINGI)
public class RngAccountsAction extends AbstractRestApiAction {

    /**
     * GETメソッド
     *
     * @param req
     * @param res
     * @param ctx
     * @throws SQLException
     */
    @Get
    public void doGet(
        HttpServletRequest req,
        HttpServletResponse res,
        RestApiContext ctx) throws SQLException {

        RngAccountsBiz biz = new RngAccountsBiz(ctx);
        biz.execute();

        RestApiResponseWriter.builder(res, ctx)
        .addResultList(biz.getResult())
        .build().execute();
    }
}
