package jp.groupsession.v2.rng.restapi.accounts.query;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.co.sjts.util.date.UDate;
import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.dao.RingiDao;
import jp.groupsession.v2.rng.dao.RngDairiUserDao;
import jp.groupsession.v2.rng.model.AccountDataModel;

/**
 * <br>[機  能] アカウント情報を一覧取得するAPI ビジネスロジック
 * <br>[解  説]
 * <br>[備  考]
 */
public class RngAccountsBiz {

    /** 実行結果*/
    private List<RngAccountsResultModel> result__ = new ArrayList<>();
    /** コンテキスト */
    private RestApiContext ctx__;
    /** DBコネクション */
    private Connection con__;

    /** 代理人フラグ 無効 */
    private static final int RNG_DAIRI_NO = 0;
    /** 代理人フラグ 有効 */
    private static final int RNG_DAIRI_YES = 1;

    /**
     * コンストラクタ
     * @param ctx コンテキスト
     */
    public RngAccountsBiz(RestApiContext ctx) {
        ctx__ = ctx;
        con__ = ctx__.getCon();
    }

    /**
     *
     * <br>[機  能] アカウント情報を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @throws SQLException SQL実行時例外
     */
    public void execute() throws SQLException {

        RngDairiUserDao dairiDao = new RngDairiUserDao(con__);
        RingiDao dao = new RingiDao(con__);

        //セッションユーザのアカウント情報を取得する
        //受信件数を取得
        int jusinCnt = dao.getRingiDataCount(ctx__.getRequestUserSid(), RngConst.RNG_MODE_JYUSIN);

        RngAccountsResultModel tmdl = new RngAccountsResultModel();
        tmdl.setUserId(ctx__.getRequestUserModel().getLgid());
        tmdl.setUserName(
            ctx__.getRequestUserModel().getUsisei() + " "
            + ctx__.getRequestUserModel().getUsimei());
        tmdl.setLoginStopFlg(GSConst.YUKOMUKO_YUKO);
        tmdl.setReceiveCount(jusinCnt);
        tmdl.setDairiFlg(RNG_DAIRI_NO);

        result__.add(tmdl);

        //使用可能代理人アカウントを取得する
        UDate now = new UDate();
        List<AccountDataModel> dairiList = dairiDao.select(ctx__.getRequestUserSid(), now, now);

        //レスポンスモデルに変換
        for (AccountDataModel fmdl : dairiList) {

            tmdl = new RngAccountsResultModel();
            tmdl.setUserId(fmdl.getAccountId());
            tmdl.setUserName(fmdl.getAccountName());
            tmdl.setLoginStopFlg(fmdl.getUsrUkoFlg());
            tmdl.setReceiveCount(fmdl.getAccountCount());
            tmdl.setDairiFlg(
                (fmdl.getAccountSid() == ctx__.getRequestUserSid()) ? RNG_DAIRI_NO : RNG_DAIRI_YES);

            result__.add(tmdl);
        }
    }


        /**
     *
     * <br>[機  能] 実行結果の取得
     * <br>[解  説]
     * <br>[備  考]
     * @return 実行結果
     */
    public List<RngAccountsResultModel> getResult() {
        return result__;
    }
}
