package jp.groupsession.v2.rng.restapi.categories.query;

import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.restapi.controller.AbstractRestApiAction;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.controller.annotation.Get;
import jp.groupsession.v2.restapi.controller.annotation.Plugin;
import jp.groupsession.v2.restapi.response.RestApiResponseWriter;

/**
 * <br>[機  能] 稟議 稟議カテゴリを一覧取得するAPI アクションクラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
@Plugin(GSConst.PLUGIN_ID_RINGI)
public class RngCategoriesQueryAction extends AbstractRestApiAction {
    /**
     *
     * <br>[機  能] 稟議カテゴリを一覧取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param res レスポンス
     * @param req リクエスト
     * @param param パラメータ
     * @param ctx コンテキスト
     */
    @Get
    public void doGet(
        HttpServletRequest req,
        HttpServletResponse res,
        RngCategoriesQueryParamModel param,
        RestApiContext ctx) throws SQLException {

        RngCategoriesQueryBiz biz = new RngCategoriesQueryBiz(ctx, param);
        biz.execute();

        RestApiResponseWriter.builder(res, ctx)
        .addResultList(biz.getResult())
        .build().execute();
    }

}
