package jp.groupsession.v2.rng.restapi.categories.query;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.biz.RngBiz;
import jp.groupsession.v2.rng.model.RngAconfModel;
import jp.groupsession.v2.rng.model.RngTemplateCategoryModel;

/**
 * <br>[機  能] 稟議 稟議カテゴリを一覧取得するAPI ビジネスロジック
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class RngCategoriesQueryBiz {

    /** 実行結果*/
    private List<RngCategoriesQueryResultModel> result__ = new ArrayList<>();
    /** コンテキスト */
    private RestApiContext ctx__;
    /** DBコネクション */
    private Connection con__;
    /** パラメータモデル */
    private RngCategoriesQueryParamModel param__;

    /**
     * コンストラクタ
     * @param ctx コンテキスト
     * @param param パラメータモデル
     */
    public RngCategoriesQueryBiz(RestApiContext ctx, RngCategoriesQueryParamModel param) {
        ctx__ = ctx;
        con__ = ctx__.getCon();
        param__ = param;
    }

    /**
     *
     * <br>[機  能] 稟議カテゴリを一覧取得する
     * <br>[解  説]
     * <br>[備  考]
     * @throws SQLException SQL実行時例外
     */
    public void execute() throws SQLException {

        RngBiz biz = new RngBiz(con__);
        ArrayList<RngTemplateCategoryModel> categoryList = null;
        RngAconfModel aconfMdl = biz.getRngAconf(con__);

        //管理者権限を取得
        CommonBiz cmnBiz = new CommonBiz();
        boolean isAdmin
            = cmnBiz.isPluginAdmin(con__, ctx__.getRequestUserModel(), RngConst.PLUGIN_ID_RINGI);

        //共有カテゴリ
        if (param__.getCategoryType() == RngConst.RNG_API_RTC_ALL
                || param__.getCategoryType() == RngConst.RNG_API_RTC_SHARE) {
            //共有カテゴリを取得する
            categoryList = biz.getTemplateCategoryList(RngConst.RNG_TEMPLATE_SHARE,
                                                    ctx__.getRequestUserSid(),
                                                    isAdmin, RngConst.RTPLIST_MOKUTEKI_USE);
            //リザルト追加
            addResult(categoryList);
        }

        //個人カテゴリ
        if (aconfMdl.getRarTemplatePersonalFlg() == RngConst.RAR_TEMPLATE_PERSONAL_FLG_YES
                && (param__.getCategoryType() == RngConst.RNG_API_RTC_ALL
                || param__.getCategoryType() == RngConst.RNG_API_RTC_PRIVATE)) {
            //個人カテゴリを取得する
            categoryList = biz.getTemplateCategoryList(RngConst.RNG_TEMPLATE_PRIVATE,
                                                    ctx__.getRequestUserSid(),
                                                    true, RngConst.RTPLIST_MOKUTEKI_USE);
            //リザルト追加
            addResult(categoryList);
        }
    }

    /**
     *
     * <br>[機  能] リザルト追加
     * <br>[解  説]
     * <br>[備  考]
     * @param categoryList カテゴリリスト
     */
    public void addResult(ArrayList<RngTemplateCategoryModel> categoryList) {
        for (RngTemplateCategoryModel categoryModel : categoryList) {
            RngCategoriesQueryResultModel resultModel = new RngCategoriesQueryResultModel();
            resultModel.setSid(categoryModel.getRtcSid());
            resultModel.setType(categoryModel.getRtcType());
            resultModel.setName(categoryModel.getRtcName());
            result__.add(resultModel);
        }
    }

    /**
     *
     * <br>[機  能] 実行結果の取得
     * <br>[解  説]
     * <br>[備  考]
     * @return 実行結果
     */
    public List<RngCategoriesQueryResultModel> getResult() {
        return result__;
    }

}
