package jp.groupsession.v2.rng.restapi.categories.query;

import java.sql.SQLException;

import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.RestApiValidateException;
import jp.groupsession.v2.restapi.parameter.annotation.ParamModel;
import jp.groupsession.v2.restapi.parameter.annotation.Selectable;
import jp.groupsession.v2.restapi.parameter.annotation.Validator;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.biz.RngBiz;
import jp.groupsession.v2.rng.model.RngAconfModel;
import jp.groupsession.v2.rng.restapi.RngEnumReasonCode;
import jp.groupsession.v2.struts.msg.GsMessage;

/**
 * <br>[機  能] 稟議 稟議カテゴリを一覧取得するAPI パラメータモデル
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
@ParamModel
public class RngCategoriesQueryParamModel {

    /** 稟議カテゴリ対象種別 */
    @Selectable({"0", "1", "2"})
    private int categoryType__ = 0;
    /**
     * @return the categoryType
     */
    public int getCategoryType() {
        return categoryType__;
    }
    /**
     * @param categoryType the categoryType to set
     */
    public void setCategoryType(int categoryType) {
        categoryType__ = categoryType;
    }

    /**
     * <br>[機  能] 入力チェックを実行する
     * <br>[解  説]
     * <br>[備  考]
     * @param ctx RestApiコンテキスト
     */
    @Validator
    public void validate(RestApiContext ctx) throws SQLException {

        RngBiz biz = new RngBiz(ctx.getCon());
        RngAconfModel aconfMdl = biz.getRngAconf(ctx.getCon());

        // [RINGI-217] 個人カテゴリを指定時、個人テンプレートが制限されている
        if (categoryType__ == RngConst.RNG_API_RTC_PRIVATE
                && aconfMdl.getRarTemplatePersonalFlg()
                    == RngConst.RAR_TEMPLATE_PERSONAL_FLG_NO) {
            throw new RestApiValidateException(
                RngEnumReasonCode.PARAM_CANT_USE_PRIVATE_TEMPLATE,
                    "error.select.limit",
                    new GsMessage(ctx.getRequestModel())
                    .getMessage("cmn.personal.template"));
        }
    }
}
