package jp.groupsession.v2.rng.restapi.entities;

import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.co.sjts.util.io.IOToolsException;
import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.cmn.model.GSTemporaryPathModel;
import jp.groupsession.v2.restapi.controller.AbstractRestApiAction;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.controller.annotation.Delete;
import jp.groupsession.v2.restapi.controller.annotation.Get;
import jp.groupsession.v2.restapi.controller.annotation.Parameter;
import jp.groupsession.v2.restapi.controller.annotation.Plugin;
import jp.groupsession.v2.restapi.controller.annotation.Post;
import jp.groupsession.v2.restapi.response.RestApiResponseWriter;
import jp.groupsession.v2.rng.RtpNotfoundException;

/**
 * <br>[機  能] 稟議 申請関連API アクションクラス
 * <br>[解  説] 申請・再申請・削除・申請情報の取得・申請確認情報の取得を行う
 * <br>[備  考]
 *
 * @author  JTS
 */
@Plugin(GSConst.PLUGIN_ID_RINGI)
public class RngEntitiesAction extends AbstractRestApiAction {

    /**
     * GETメソッド
     *
     * @param req リクエスト
     * @param res レスポンス
     * @param ctx コンテキスト
     * @param param リクエストパラメータ
     * @param tempPath GSTemporaryPathModel
     * @throws SQLException
     * @throws IOToolsException
     * @throws RtpNotfoundException
     */
    @Get
    public void doGet(
        HttpServletRequest req,
        HttpServletResponse res,
        RngEntitiesGetParamModel param,
        RestApiContext ctx,
        GSTemporaryPathModel tempPath)
        throws SQLException, RtpNotfoundException, IOToolsException {

        //稟議申請情報を取得する
        RngEntitiesGetBiz biz = new RngEntitiesGetBiz(param, ctx, tempPath);
        biz.execute();

        RestApiResponseWriter.builder(res, ctx)
            .addResult(biz.getResult())
            .build().execute();
    }

    /**
     * DELETEメソッド
     * @param req リクエスト
     * @param res レスポンス
     * @param ctx コンテキスト
     * @param param リクエストパラメータ
     * @throws SQLException
     */
    @Delete
    public void doDelete(
        HttpServletRequest req,
        HttpServletResponse res,
        RngEntitiesDeleteParamModel param,
        RestApiContext ctx) throws SQLException {

        //稟議を削除する
        RngEntitiesDeleteBiz biz = new RngEntitiesDeleteBiz(param, ctx);
        biz.execute();

        RestApiResponseWriter.builder(res, ctx)
        .addResult("OK")
        .build().execute();
    }

    /**
     * POSTメソッド
     * @param req リクエスト
     * @param res レスポンス
     * @param ctx コンテキスト
     * @param param リクエストパラメータ
     * @param tempPathMdl テンポラリディレクトリパスモデル
     * @throws Exception
     */
    @Post
    @Parameter(name = "action", value = "entry")
    public void doPostEntry(
        HttpServletRequest req,
        HttpServletResponse res,
        RngEntitiesPostParamModel param,
        RestApiContext ctx,
        GSTemporaryPathModel tempPathMdl) throws Exception {

        //稟議を申請する
        RngEntitiesPostBiz biz = new RngEntitiesPostBiz(param, ctx, tempPathMdl);
        biz.executeEntry();

        RestApiResponseWriter.builder(res, ctx)
        .addResult(biz.getResult())
        .build().execute();
    }

    /**
     * POSTメソッド(申請確認)
     * @param req リクエスト
     * @param res レスポンス
     * @param ctx コンテキスト
     * @param param リクエストパラメータ
     * @param tempPathMdl テンポラリディレクトリパスモデル
     * @throws Exception
     */
    @Post
    @Parameter(name = "action", value = "check")
    public void doPostCheck(
        HttpServletRequest req,
        HttpServletResponse res,
        RngEntitiesPostParamModel param,
        RestApiContext ctx,
        GSTemporaryPathModel tempPathMdl) throws Exception {

        //稟議申請確認情報を取得する
        RngEntitiesPostBiz biz = new RngEntitiesPostBiz(param, ctx, tempPathMdl);
        biz.executeSinseiKakunin();

        RestApiResponseWriter.builder(res, ctx)
        .addResult(biz.getResultSinseiModel())
        .build().execute();
    }

    /**
     * POSTメソッド(再申請)
     * @param req リクエスト
     * @param res レスポンス
     * @param ctx コンテキスト
     * @param param リクエストパラメータ
     * @param tempPathMdl テンポラリディレクトリパスモデル
     * @throws Exception
     */
    @Post
    @Parameter(name = "action", value = "retry")
    public void doPostRetry(
        HttpServletRequest req,
        HttpServletResponse res,
        RngEntitiesPostParamModel param,
        RestApiContext ctx,
        GSTemporaryPathModel tempPathMdl) throws Exception {

        //稟議を再申請する
        RngEntitiesPostBiz biz = new RngEntitiesPostBiz(param, ctx, tempPathMdl);
        biz.executeRetry();

        RestApiResponseWriter.builder(res, ctx)
        .addResult(biz.getResult())
        .build().execute();
    }

    /**
     * POSTメソッド(草稿保存)
     * @param req リクエスト
     * @param res レスポンス
     * @param ctx コンテキスト
     * @param param リクエストパラメータ
     * @param tempPathMdl テンポラリディレクトリパスモデル
     * @throws Exception
     */
    @Post
    @Parameter(name = "action", value = "draft")
    public void doPostDraft(
        HttpServletRequest req,
        HttpServletResponse res,
        RngEntitiesPostParamModel param,
        RestApiContext ctx,
        GSTemporaryPathModel tempPathMdl) throws Exception {

        //稟議を草稿保存する
        RngEntitiesPostBiz biz = new RngEntitiesPostBiz(param, ctx, tempPathMdl);
        biz.executeDraft();

        RestApiResponseWriter.builder(res, ctx)
        .addResult(biz.getResultSinseiModel())
        .build().execute();
    }
}
