package jp.groupsession.v2.rng.restapi.entities;

import java.sql.Connection;
import java.sql.SQLException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.co.sjts.util.NullDefault;
import jp.groupsession.v2.cmn.GSConstLog;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.biz.RngBiz;
import jp.groupsession.v2.rng.dao.RngRndataDao;
import jp.groupsession.v2.rng.model.RngRndataModel;
import jp.groupsession.v2.rng.restapi.RngRestapiBiz;
import jp.groupsession.v2.struts.msg.GsMessage;

/**
 * <br>[機  能] 稟議 稟議を削除するAPI ビジネスロジック
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author  JTS
 */
public class RngEntitiesDeleteBiz {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(RngEntitiesDeleteBiz.class);

    /** リクエストパラメータ */
    private RngEntitiesDeleteParamModel param__;

    /** コンテキスト */
    private RestApiContext ctx__;
    /** DBコネクション */
    private Connection con__;

    /**
     * コンストラクタ
     * @param param リクエストパラメータ
     * @param ctx コンテキスト
     */
    public RngEntitiesDeleteBiz(
        RngEntitiesDeleteParamModel param,
        RestApiContext ctx) {
        param__ = param;
        ctx__ = ctx;
        con__ = ctx__.getCon();
    }

    /**
     *
     * <br>[機  能] 稟議を削除する
     * <br>[解  説]
     * <br>[備  考]
     * @throws SQLException SQL実行時例外
     */
    public void execute() throws SQLException {

        log__.info("稟議を削除するAPI execute");

        //削除対象稟議を取得（ログ出力用）
        RngRndataDao rndataDao = new RngRndataDao(con__);
        RngRndataModel rnDataMdl = rndataDao.select(param__.getRingiSid());

        //稟議を削除
        RngBiz rngBiz = new RngBiz(con__);
        rngBiz.deleteRngData(con__, param__.getRingiSid(), ctx__.getRequestUserSid(), true);

        //オペレーションログを出力
        __outPutOpLog(rnDataMdl);
    }

    /**
     * <br>[機  能] オペレーションログを出力する
     * <br>[解  説]
     * <br>[備  考]
     * @param rnDataMdl 稟議情報
     */
    private void __outPutOpLog(
        RngRndataModel rnDataMdl) {

        GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());

        int rngSid = param__.getRingiSid();

        //操作
        String opCode = "";
        if (rnDataMdl.getRngStatus() == RngConst.RNG_STATUS_DRAFT) {
            opCode = gsMsg.getMessage("cmn.draft") + gsMsg.getMessage("cmn.delete");
        } else {
            opCode = gsMsg.getMessage("rng.62") + gsMsg.getMessage("cmn.delete");
        }

        //内容
        StringBuilder sb = new StringBuilder();
        sb.append("[" + gsMsg.getMessage("cmn.account") + "] "
            + ctx__.getRequestUserModel().getUsisei()
            + " " + ctx__.getRequestUserModel().getUsimei());
        sb.append("\n");
        sb.append("[" + gsMsg.getMessage("cmn.title") + "] " + rnDataMdl.getRngTitle());
        sb.append("\n");
        //申請済みの場合、申請IDを表示する
        if (rnDataMdl.getRngStatus() != RngConst.RNG_STATUS_DRAFT) {
            sb.append("[" + gsMsg.getMessage("rng.rng180.04") + "] "
                + NullDefault.getString(rnDataMdl.getRngId(), ""));
        }

        //LOG_CODE
        String logCode = "rngSid: " + rngSid;

        //オペレーションログ出力
        RngRestapiBiz biz = new RngRestapiBiz();
        biz.outPutLog(ctx__, GSConstLog.LEVEL_TRACE, opCode, sb.toString(), logCode);
    }
}
