package jp.groupsession.v2.rng.restapi.entities;

import java.sql.SQLException;

import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.RestApiPermissionException;
import jp.groupsession.v2.restapi.exception.RestApiValidateException;
import jp.groupsession.v2.restapi.parameter.annotation.ParamModel;
import jp.groupsession.v2.restapi.parameter.annotation.Validator;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.biz.RngBiz;
import jp.groupsession.v2.rng.dao.RngRndataDao;
import jp.groupsession.v2.rng.model.RngRndataModel;
import jp.groupsession.v2.rng.restapi.RngEnumReasonCode;
import jp.groupsession.v2.rng.rng030.Rng030Biz;
import jp.groupsession.v2.struts.msg.GsMessage;

/**
 * <br>[機  能] 稟議 稟議を削除するAPI パラメータモデル
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author  JTS
 */
@ParamModel
public class RngEntitiesDeleteParamModel {

    /** 稟議SID */
    private int ringiSid__ = 0;

    /**
     * @return the ringiSid
     */
    public int getRingiSid() {
        return ringiSid__;
    }

    /**
     * @param ringiSid the ringiSid to set
     */
    public void setRingiSid(int ringiSid) {
        ringiSid__ = ringiSid;
    }

    /**
     * <br>[機  能] 入力チェックを実行する
     * <br>[解  説]
     * <br>[備  考]
     * @param ctx RestApiコンテキスト
     */
    @Validator
    public void validate(RestApiContext ctx) throws SQLException {

        //指定した稟議を参照可能かをチェック
        Rng030Biz rng030Biz = new Rng030Biz(ctx.getCon(), ctx.getRequestModel());
        RngRndataDao rndataDao = new RngRndataDao(ctx.getCon());
        RngRndataModel rngDataMdl = rndataDao.select(ringiSid__);

        //稟議が存在しない
        if (rngDataMdl == null) {
            throw new RestApiPermissionException(
                RngEnumReasonCode.RESOURCE_CANT_ACCESS_RINGI,
                    "error.no.access.data",
                    new GsMessage(ctx.getRequestModel())
                    .getMessage("main.useddisk.rng.rndata")
            );
        }

        //草稿 作成者とセッションユーザが一致しない
        if (rngDataMdl.getRngStatus() == RngConst.RNG_STATUS_DRAFT
            && rngDataMdl.getRngAuid() != ctx.getRequestUserSid()) {
            throw new RestApiPermissionException(
            RngEnumReasonCode.RESOURCE_CANT_ACCESS_RINGI,
                "error.no.access.data",
                new GsMessage(ctx.getRequestModel())
                .getMessage("main.useddisk.rng.rndata")
            );
        }

        //申請済み 稟議へのアクセス権限がない
        if (rngDataMdl.getRngStatus() != RngConst.RNG_STATUS_DRAFT
            && !rng030Biz.chkViewRingi(ctx.getRequestUserSid(), ringiSid__)) {
            throw new RestApiPermissionException(
                RngEnumReasonCode.RESOURCE_CANT_ACCESS_RINGI,
                    "error.no.access.data",
                    new GsMessage(ctx.getRequestModel())
                    .getMessage("main.useddisk.rng.rndata")
            );
        }

        //指定した稟議が削除可能かをチェック
        RngBiz rngBiz = new RngBiz(ctx.getCon());
        if (!rngBiz.canDeleteRingi(
            rngDataMdl, ctx.getRequestUserSid(), ctx.getRequestUserModel())) {
            throw new RestApiValidateException(
                RngEnumReasonCode.RESOURCE_CANT_DELETE_RINGI,
                    "cant.delete.data",
                    new GsMessage(ctx.getRequestModel())
                    .getMessage("main.useddisk.rng.rndata")
            );
        }
    }
}
