package jp.groupsession.v2.rng.restapi.entities;

import java.sql.Connection;
import java.sql.SQLException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.co.sjts.util.io.IOToolsException;
import jp.groupsession.v2.cmn.formbuilder.FormInputBuilder;
import jp.groupsession.v2.cmn.model.GSTemporaryPathModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.RtpNotfoundException;
import jp.groupsession.v2.rng.biz.RngFormBuildBiz;
import jp.groupsession.v2.rng.dao.RngRndataDao;
import jp.groupsession.v2.rng.model.RngRndataModel;
import jp.groupsession.v2.rng.model.RngTemplateModel;
import jp.groupsession.v2.rng.restapi.RngRestapiBiz;
import jp.groupsession.v2.rng.restapi.model.RngRestApiRingiSinseiModel;
import jp.groupsession.v2.struts.msg.GsMessage;

/**
 * <br>[機  能] 稟議 稟議申請情報を取得するAPI ビジネスロジック
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author  JTS
 */
public class RngEntitiesGetBiz {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(RngEntitiesGetBiz.class);

    /** 実行結果*/
    private RngRestApiRingiSinseiModel result__ = null;
    /**
     * @return the result
     */
    public RngRestApiRingiSinseiModel getResult() {
        return result__;
    }
    /**
     * @param result the result to set
     */
    public void setResult(RngRestApiRingiSinseiModel result) {
        result__ = result;
    }

    /** リクエストパラメータ */
    private RngEntitiesGetParamModel param__;
    /** コンテキスト */
    private RestApiContext ctx__;
    /** テンポラリディレクトリ */
    GSTemporaryPathModel tempPathModel__;

    /**
     * コンストラクタ
     * @param param リクエストパラメータ
     * @param ctx コンテキスト
     * @param tempPathModel テンポラリディレクトリ
     */
    public RngEntitiesGetBiz(
        RngEntitiesGetParamModel param,
        RestApiContext ctx,
        GSTemporaryPathModel tempPathModel) {
        param__ = param;
        ctx__ = ctx;
        tempPathModel__ = tempPathModel;
    }

    /**
     *
     * <br>[機  能] 稟議を削除する
     * <br>[解  説]
     * <br>[備  考]
     * @throws SQLException SQL実行時例外
     * @throws IOToolsException
     * @throws RtpNotfoundException
     */
    public void execute() throws SQLException, RtpNotfoundException, IOToolsException {

        log__.info("稟議申請情報を取得するAPI(草稿から編集, 複写申請, 再申請) 実行");

        Connection con = ctx__.getCon();
        RngRndataDao rngDao = new RngRndataDao(con);
        RngRndataModel rngData = rngDao.select(param__.getRingiSid());

        RngFormBuildBiz formBiz = new RngFormBuildBiz(ctx__.getRequestModel());
        int mode = param__.getMode();
        RngTemplateModel rtpMdl;
        if (mode == RngConst.RNG_API_SINSEI_GET_MODE_REAPPLY) {
            rtpMdl = formBiz.getRtpModel(con, rngData.getRtpSid(), rngData.getRtpVer());
        } else {
            rtpMdl = formBiz.getRtpModelMaxVer(con, rngData.getRtpSid());
        }

        RngRestapiBiz restapiBiz = new RngRestapiBiz();
        FormInputBuilder formBuilder = restapiBiz.getFormInputBuilderFromRng(
            ctx__, param__.getMode(), rngData, rtpMdl);
        restapiBiz.setFormDspData(ctx__, formBuilder, tempPathModel__, true, true);

        restapiBiz.checkUseForm(ctx__, formBuilder, false, "ringiSid");
        if (param__.getMode() != RngConst.RNG_API_SINSEI_GET_MODE_REAPPLY) {
            restapiBiz.checkUseKeiro(ctx__, rtpMdl, formBuilder, false, "ringiSid");
        }

        result__ = restapiBiz.getRingiSinseiModel(
            ctx__, param__.getMode(), rngData, rtpMdl, formBuilder, tempPathModel__);

        if (mode != RngConst.RNG_API_SINSEI_GET_MODE_REAPPLY
            && rngData.getRtpVer() != rtpMdl.getRtpVer()) {
            String text = null;
            GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());
            switch (param__.getMode()) {
                case RngConst.RNG_API_SINSEI_GET_MODE_DRAFT:
                    text = gsMsg.getMessage("cmn.draft");
                    break;
                case RngConst.RNG_API_SINSEI_GET_MODE_COPY:
                    text = gsMsg.getMessage("rng.rng020.09");
                    break;
                default:
                    break;
            }
            String message = ctx__.getMessageResources().getMessage(
                "error.open.update.template", text);
            result__.setTemplateVersionNoticeText(message);
        }
    }
}
