package jp.groupsession.v2.rng.restapi.entities;

import java.sql.Connection;
import java.sql.SQLException;

import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.RestApiPermissionException;
import jp.groupsession.v2.restapi.exception.RestApiValidateException;
import jp.groupsession.v2.restapi.msg.RestApiGsMessage;
import jp.groupsession.v2.restapi.parameter.annotation.NotBlank;
import jp.groupsession.v2.restapi.parameter.annotation.ParamModel;
import jp.groupsession.v2.restapi.parameter.annotation.Selectable;
import jp.groupsession.v2.restapi.parameter.annotation.Validator;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.biz.RngBiz;
import jp.groupsession.v2.rng.dao.RingiDao;
import jp.groupsession.v2.rng.dao.RngRndataDao;
import jp.groupsession.v2.rng.model.RingiDataModel;
import jp.groupsession.v2.rng.model.RngRndataModel;
import jp.groupsession.v2.rng.restapi.RngEnumReasonCode;
import jp.groupsession.v2.rng.rng030.Rng030Biz;

/**
 * <br>[機  能] 稟議 稟議を削除するAPI パラメータモデル
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author  JTS
 */
@ParamModel
public class RngEntitiesGetParamModel {

    //パスパラメータ
    /** 稟議SID */
    private int ringiSid__ = 0;

    //クエリパラメータ
    /** アクション */
    @NotBlank
    @Selectable({"0", "1", "2"})
    private Integer mode__;

    /**
     * @return the ringiSid
     */
    public int getRingiSid() {
        return ringiSid__;
    }

    /**
     * @param ringiSid the ringiSid to set
     */
    public void setRingiSid(int ringiSid) {
        ringiSid__ = ringiSid;
    }

    /**
     * @return the mode
     */
    public int getMode() {
        return mode__;
    }
    /**
     * @param mode the mode to set
     */
    public void setMode(int mode) {
        mode__ = mode;
    }

    /**
     * <br>[機  能] 入力チェックを実行する
     * <br>[解  説]
     * <br>[備  考]
     * @param ctx RestApiコンテキスト
     */
    @Validator
    public void validate(RestApiContext ctx) throws SQLException {

        //指定した稟議を参照可能かをチェック
        Rng030Biz rng030Biz = new Rng030Biz(ctx.getCon(), ctx.getRequestModel());
        RngRndataDao rndataDao = new RngRndataDao(ctx.getCon());
        RngRndataModel rngDataMdl = rndataDao.select(ringiSid__);

        //稟議が存在しない
        if (rngDataMdl == null) {
            throw new RestApiPermissionException(
                RngEnumReasonCode.RESOURCE_CANT_ACCESS_RINGI,
                    "error.no.access.data",
                    new RestApiGsMessage()
                        .getMessage("main.useddisk.rng.rndata")
            );
        }

        //草稿 作成者とセッションユーザが一致しない
        if (mode__ == RngConst.RNG_API_SINSEI_GET_MODE_DRAFT) {
            if (rngDataMdl.getRngStatus() != RngConst.RNG_STATUS_DRAFT
                || rngDataMdl.getRngAuid() != ctx.getRequestUserSid()) {
                throw new RestApiPermissionException(
                    RngEnumReasonCode.RESOURCE_CANT_ACCESS_RINGI,
                        "error.no.access.data",
                        new RestApiGsMessage()
                            .getMessage("main.useddisk.rng.rndata")
                );
            }
        }

        //申請済み 稟議へのアクセス権限がない
        if (mode__ == RngConst.RNG_API_SINSEI_GET_MODE_COPY
            || mode__ == RngConst.RNG_API_SINSEI_GET_MODE_REAPPLY) {

            if (rngDataMdl.getRngStatus() == RngConst.RNG_STATUS_DRAFT
                || !rng030Biz.chkViewRingi(ctx.getRequestUserSid(), ringiSid__)) {
                throw new RestApiPermissionException(
                    RngEnumReasonCode.RESOURCE_CANT_ACCESS_RINGI,
                        "error.no.access.data",
                        new RestApiGsMessage()
                            .getMessage("main.useddisk.rng.rndata")
                );
            }
        }

        __validateSaisinsei(ctx);
    }

    /**
     * <br>[機  能] 再申請が可能かをチェックする
     * <br>[解  説]
     * <br>[備  考]
     * @param ctx RestApiコンテキスト
     */
    private void __validateSaisinsei(RestApiContext ctx) throws SQLException {
        if (mode__ != RngConst.RNG_API_SINSEI_GET_MODE_REAPPLY) {
            return;
        }

        Connection con = ctx.getCon();
        RingiDao ringiDao = new RingiDao(con);

        RingiDataModel ringiMdl = ringiDao.getRingiData(ringiSid__, ctx.getRequestUserSid());
        //申請者が再申請ボタンを押しているかなど、再申請を行えるかを確認
        RngBiz rngBiz = new RngBiz(con);
        if (!rngBiz.canReApplicate(ringiMdl)) {
            throw new RestApiValidateException(
                RngEnumReasonCode.PARAM_CANT_REAPPLICATION,
                "restapi.error.cant.saisinsei",
                "ringiSid"
            );
        }
        //再申請対象の稟議内の承認経路に削除済みではないユーザが存在するか確認
        if (!rngBiz.isUserInSyouninKerio(ringiMdl.getRngSid())) {
            throw new RestApiValidateException(
                RngEnumReasonCode.PARAM_NOTHING_USER_REAPPLICATION,
                "restapi.error.saisinsei.keiro",
                "ringiSid"
            );
        }
    }
}
