package jp.groupsession.v2.rng.restapi.entities;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.co.sjts.util.NullDefault;
import jp.groupsession.v2.cmn.GSConstLog;
import jp.groupsession.v2.cmn.GSTemporaryPathUtil;
import jp.groupsession.v2.cmn.GroupSession;
import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.config.PluginConfig;
import jp.groupsession.v2.cmn.dao.MlCountMtController;
import jp.groupsession.v2.cmn.formbuilder.FormInputBuilder;
import jp.groupsession.v2.cmn.model.GSTemporaryPathModel;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.man.GSConstMain;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.biz.RngBiz;
import jp.groupsession.v2.rng.biz.RngFormBuildBiz;
import jp.groupsession.v2.rng.dao.RngRndataDao;
import jp.groupsession.v2.rng.dao.RngTemplateDao;
import jp.groupsession.v2.rng.model.RingiIdModel;
import jp.groupsession.v2.rng.model.RingiRequestModel;
import jp.groupsession.v2.rng.model.RngRndataModel;
import jp.groupsession.v2.rng.model.RngTemplateModel;
import jp.groupsession.v2.rng.restapi.RngRestapiBiz;
import jp.groupsession.v2.rng.restapi.model.RngRestApiRingiSinseiModel;
import jp.groupsession.v2.rng.restapi.model.RngRestapiRingiEntryModel;
import jp.groupsession.v2.rng.restapi.model.RngRestapiRingiModel;
import jp.groupsession.v2.rng.rng020.Rng020Biz;
import jp.groupsession.v2.rng.rng020.Rng020KeiroBlock;
import jp.groupsession.v2.rng.rng020kn.Rng020knBiz;
import jp.groupsession.v2.rng.rng030.Rng030Biz;
import jp.groupsession.v2.rng.rng030.RngApprovalModel;
import jp.groupsession.v2.struts.msg.GsMessage;

/**
 * <br>[機  能] 稟議 稟議を申請するAPI ビジネスロジック
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author  JTS
 */
public class RngEntitiesPostBiz {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(RngEntitiesPostBiz.class);

    /** リクエストパラメータ */
    private RngEntitiesPostParamModel param__;
    /** 実行結果*/
    private RngRestapiRingiModel result__ = null;

    /** 実行結果(申請確認) */
    private RngRestApiRingiSinseiModel resultSinseiModel__ = null;

    /** コンテキスト */
    private RestApiContext ctx__;
    /** DBコネクション */
    private Connection con__;
    /** リクエストモデル */
    private RequestModel reqMdl__;
    /** テンポラリディレクトリパスモデル */
    private GSTemporaryPathModel tempPathMdl__;


    /**
     * コンストラクタ
     * @param param リクエストパラメータ
     * @param ctx コンテキスト
     * @param tempPathMdl テンポラリディレクトリパスモデル
     */
    public RngEntitiesPostBiz(
        RngEntitiesPostParamModel param,
        RestApiContext ctx,
        GSTemporaryPathModel tempPathMdl) {
        param__ = param;
        ctx__ = ctx;
        con__ = ctx__.getCon();
        reqMdl__ = ctx__.getRequestModel();
        tempPathMdl__ = tempPathMdl;
    }

    /**
     * <br>[機  能] 稟議を申請する
     * <br>[解  説]
     * <br>[備  考]
     * @throws Exception
     */
    public void executeEntry() throws Exception {

        log__.info("稟議を申請するAPI execute");

        RngRestapiBiz rngRestapiBiz = new RngRestapiBiz();
        int rtpSid = param__.getTemplateSid();

        //登録用モデルを作成
        RngRestapiRingiEntryModel entryMdl = new RngRestapiRingiEntryModel();
        entryMdl.setRng020requestUserId(String.valueOf(ctx__.getRequestUserSid()));
        entryMdl.setRng020Title(param__.getTitleText());
        entryMdl.setRng020rtpSid(rtpSid);
        if (param__.getReferenceSid() > 0) {
            entryMdl.setRngSid(param__.getReferenceSid());
            RngRndataDao rngDao = new RngRndataDao(con__);
            RngRndataModel rngMdl = rngDao.select(param__.getReferenceSid());
            if (rngMdl != null && rngMdl.getRngStatus() == RngConst.RNG_STATUS_DRAFT) {
                entryMdl.setRngCmdMode(RngConst.RNG_CMDMODE_EDIT);
            }
        }

        //テンプレート情報を取得
        RngTemplateDao rtpDao = new RngTemplateDao(con__);
        RngTemplateModel rtpMdl = rtpDao.select(rtpSid);
        if (rtpMdl != null) {
            //バージョン情報をセット
            entryMdl.setRng020rtpVer(rtpMdl.getRtpVer());
            entryMdl.setRng020rtpKeiroVersion(rtpMdl.getRctVer());
            //複写用経路データ使用フラグをセット
            if (rtpMdl.getRtpType() == RngConst.RNG_TEMPLATE_SHARE
                && rtpMdl.getRtpSpecVer() == RngConst.RNG_RTP_SPEC_VER_A480) {
                entryMdl.setRng020useCopyKeiro(true);
            }
            //申請ID情報をセット
            RngBiz rngBiz = new RngBiz(con__, null);
            RingiIdModel rngIdMdl = rngBiz.getRngidModel(rtpMdl.getRtpIdformatSid());
            if (rngIdMdl != null) {
                entryMdl.setIdUseFlg(RngConst.RNG_SINSEI_ID_USE);
                //手入力可能フラグをセット
                entryMdl.setIdPrefManualEditable(
                    rngRestapiBiz.getSinseiIdInputKanouFlg(rngIdMdl, rtpMdl));
                entryMdl.setRng020IdPrefManual(param__.getEntryIdInputKanouFlg());
                entryMdl.setRng020ID(param__.getEntryIdText());
            }
        }

        //申請内容モデルを作成
        FormInputBuilder formInputBuilder = rngRestapiBiz.createFormInputBuilder(
            rtpSid, param__.getBodyArray(), tempPathMdl__, ctx__);
        entryMdl.setRng020input(formInputBuilder);

        //リクエストボディに指定した添付ファイルをテンポラリディレクトリに展開
        rngRestapiBiz.setFileTempDir(rtpSid, -1, formInputBuilder, ctx__);

        //経路情報MAPを生成する
        Map<Integer, Rng020KeiroBlock> syouninKeiroBlockMap
            = new HashMap<Integer, Rng020KeiroBlock>();
        Map<Integer, Rng020KeiroBlock> kakuninKeiroBlockMap
            = new HashMap<Integer, Rng020KeiroBlock>();
        rngRestapiBiz.createKeiroInfoMap(
            rtpSid,
            param__.getApprovalRouteArray(),
            param__.getCheckRouteArray(),
            syouninKeiroBlockMap,
            kakuninKeiroBlockMap,
            formInputBuilder,
            ctx__);
        entryMdl.setRng020keiroMap(syouninKeiroBlockMap);
        entryMdl.setRng020kakuninKeiroMap(kakuninKeiroBlockMap);

        //「審議者 = 申請者」の場合、経路をスキップする
        Rng020Biz rng020Biz = new Rng020Biz(con__, reqMdl__);
        rng020Biz.keiroSkip(entryMdl.getRng020keiroMap(), entryMdl.getRng020requestUserId());


        //共有テンプレートの場合、最終確認経路をデータ保持用の配列にコピー
        Rng020knBiz rng020knBiz = new Rng020knBiz(con__, reqMdl__);
        if (entryMdl.isRng020useCopyKeiro()) {
            entryMdl.setRng020kakuninSvKeiroMap(
                    rng020knBiz.getSvCopyKakuninKeiro(entryMdl.getRng020kakuninKeiroMap()));
        }

        //最終確認経路を単一経路に変換
        entryMdl.setRng020kakuninKeiroMap(
            rng020knBiz.changeOneKakuninKeiro(entryMdl.getRng020kakuninKeiroMap()));

        //採番コントローラを取得
        MlCountMtController mlCnt
            = GroupSession.getResourceManager().getCountController(reqMdl__);

        //ショートメールプラグインが使用可能か判定
        PluginConfig pconfig = ctx__.getPluginConfig();
        CommonBiz cmnBiz = new CommonBiz();
        boolean smailPluginUseFlg
            = cmnBiz.isCanUsePlugin(GSConstMain.PLUGIN_ID_SMAIL, pconfig);

        boolean commit = false;
        try {
            //稟議を申請
            RingiRequestModel ringiMdl = rng020Biz.entryRingiData(
                                            entryMdl,
                                            mlCnt,
                                            ctx__.getAppRootPath(),
                                            tempPathMdl__.getTempPath(),
                                            RngBiz.ENTRYMODE_SINSEI,
                                            pconfig,
                                            smailPluginUseFlg,
                                            reqMdl__);

            //スキップされたユーザにショートメール通知を送る（「審議者 = 申請者」の場合の後閲指示によるスキップ）
            rng020knBiz.executeSendSmail(
                mlCnt, entryMdl, ctx__.getAppRootPath(), pconfig, smailPluginUseFlg);

            //レスポンスを生成
            result__ = rngRestapiBiz.getRingiDetailModel(ctx__,
                        ringiMdl.getRngSid(),
                        ctx__.getRequestUserSid(),
                        tempPathMdl__);

            //オペレーションログを出力
            __outPutOpLog(result__, "entry");

            con__.commit();
            commit = true;

            //テンポラリディレクトリを削除
            GSTemporaryPathUtil.getInstance().deleteTempPath(tempPathMdl__);

        } catch (Exception e) {
            log__.error("稟議情報の登録に失敗", e);
            throw e;
        } finally {
            if (!commit) {
                con__.rollback();
            }
        }
    }

    /**
     * <br>[機  能] 稟議申請確認情報を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @throws Exception
     */
    public void executeSinseiKakunin() throws Exception {

        log__.info("稟議申請確認情報を取得するAPI execute");

        RngRestapiBiz rngRestapiBiz = new RngRestapiBiz();

        //テンプレート情報を取得
        RngTemplateModel rtpMdl;

        RngFormBuildBiz formBiz = new RngFormBuildBiz(reqMdl__);
        if (param__.getType() == EnumRngEntitiesType.retry) {
            RngRndataDao rngDao = new RngRndataDao(con__);
            RngRndataModel rngData = rngDao.select(param__.getRingiSid());

            FormInputBuilder formInputBuilder = rngRestapiBiz.createFormInputBuilder(
                rngData.getRtpSid(), rngData.getRtpVer(),
                param__.getBodyArray(), tempPathMdl__, ctx__);

            rtpMdl = formBiz.getRtpModel(con__, rngData.getRtpSid(), rngData.getRtpVer());
            resultSinseiModel__ = rngRestapiBiz.getRingiSinseiModelFromRng(
                ctx__, param__, rngData, rtpMdl, formInputBuilder, true, false);
            resultSinseiModel__.setSid(rngData.getRngSid());
            resultSinseiModel__.setStatusType(RngConst.RNG_STATUS_REJECT);
            resultSinseiModel__.setEntryId(null);
            resultSinseiModel__.setEntryIdText(rngData.getRngId());
            resultSinseiModel__.setApprovalRouteArray(null);
            resultSinseiModel__.setCheckRouteArray(null);
        } else {
            FormInputBuilder formInputBuilder = rngRestapiBiz.createFormInputBuilder(
                param__.getTemplateSid(), param__.getBodyArray(), tempPathMdl__, ctx__);

            rtpMdl = formBiz.getRtpModelMaxVer(con__, param__.getTemplateSid());
            resultSinseiModel__ =
                rngRestapiBiz.getRingiSinseiModelFromInput(ctx__, rtpMdl, formInputBuilder, true,
                true, param__.getApprovalRouteArray(), param__.getCheckRouteArray());
            int refarenceSid = -1;
            if (param__.getReferenceSid() > 0) {
                RngRndataDao rngDao = new RngRndataDao(con__);
                RngRndataModel rngMdl = rngDao.select(param__.getReferenceSid());
                if (rngMdl != null && rngMdl.getRngStatus() == RngConst.RNG_STATUS_DRAFT) {
                    refarenceSid = param__.getReferenceSid();
                }
            }
            resultSinseiModel__.setSid(refarenceSid);

            resultSinseiModel__.setStatusType(-1);
            rngRestapiBiz.setRingiIdData(ctx__, rtpMdl,
                param__.getEntryIdInputKanouFlg(), param__.getEntryIdText(), resultSinseiModel__);
            resultSinseiModel__.setEntryIdText(null);
        }
        resultSinseiModel__.setEntryIdInputText(null);
        resultSinseiModel__.setEntryIdInputKanouFlg(-1);

        resultSinseiModel__.setTemplateSid(rtpMdl.getRtpSid());
        resultSinseiModel__.setTitleText(param__.getTitleText());
        resultSinseiModel__.setActionCommentText(rtpMdl.getRtpActionComment());
    }

    /**
     * <br>[機  能] 稟議を再申請する
     * <br>[解  説]
     * <br>[備  考]
     * @throws Exception
     */
    public void executeRetry() throws Exception {

        log__.info("稟議を再申請するAPI execute");

        //稟議SID
        int rngSid = param__.getRingiSid();

        //経路ステップSID
        Rng030Biz rng030Biz = new Rng030Biz(con__, reqMdl__);
        int rksSid = rng030Biz.viewKeiroSid(
            rngSid, ctx__.getRequestUserSid(), RngConst.RNG_MODE_JYUSIN);

        //申請内容モデルを生成
        RngRndataDao rngDao = new RngRndataDao(con__);
        RngRndataModel rngData = rngDao.select(param__.getRingiSid());
        int rtpSid = rngData.getRtpSid();
        int rtpVer = rngData.getRtpVer();

        RngRestapiBiz rngRestapiBiz = new RngRestapiBiz();
        FormInputBuilder formInputBuilder = rngRestapiBiz.createFormInputBuilder(
            rtpSid, rtpVer, param__.getBodyArray(), tempPathMdl__, ctx__);

        //リクエストボディに指定した添付ファイルをテンポラリディレクトリに展開
        rngRestapiBiz.setFileTempDir(
            rtpSid, rtpVer, formInputBuilder, ctx__);

        //稟議再申請モデルを生成
        RngApprovalModel appMdl = new RngApprovalModel();
        appMdl.setRngSid(rngSid);
        appMdl.setRksSid(rksSid);
        appMdl.setTitle(param__.getTitleText());
        appMdl.setFormInputBuilder(formInputBuilder);

        //採番コントローラを取得
        MlCountMtController mlCnt
            = GroupSession.getResourceManager().getCountController(reqMdl__);

        //ショートメールプラグインが使用可能か判定
        PluginConfig pconfig = ctx__.getPluginConfig();
        CommonBiz cmnBiz = new CommonBiz();
        boolean smailPluginUseFlg
            = cmnBiz.isCanUsePlugin(GSConstMain.PLUGIN_ID_SMAIL, pconfig);

        boolean commit = false;
        try {
            //稟議を再申請する
            rng030Biz.applicateRingi(
                appMdl,
                mlCnt,
                ctx__.getRequestUserSid(),
                ctx__.getAppRootPath(),
                tempPathMdl__.getTempPath(),
                pconfig,
                smailPluginUseFlg);

            //レスポンスを生成
            result__ = rngRestapiBiz.getRingiDetailModel(ctx__,
                        appMdl.getRngSid(),
                        ctx__.getRequestUserSid(),
                        tempPathMdl__);

            //オペレーションログを出力
            __outPutOpLog(result__, "retry");

            con__.commit();
            commit = true;

            //テンポラリディレクトリを削除
            GSTemporaryPathUtil.getInstance().deleteTempPath(tempPathMdl__);

        } catch (Exception e) {
            log__.error("稟議情報の登録に失敗", e);
            throw e;
        } finally {
            if (!commit) {
                con__.rollback();
            }
        }
    }

    /**
     * <br>[機  能] 稟議申請確認情報を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @throws Exception
     */
    public void executeDraft() throws Exception {

        log__.info("稟議を草稿保存するAPI execute");

        RngRestapiBiz rngRestapiBiz = new RngRestapiBiz();
        int rtpSid = param__.getTemplateSid();

        //登録用モデルを作成
        RngRestapiRingiEntryModel entryMdl = new RngRestapiRingiEntryModel();
        entryMdl.setRng020requestUserId(String.valueOf(ctx__.getRequestUserSid()));
        entryMdl.setRng020Title(param__.getTitleText());
        entryMdl.setRng020rtpSid(rtpSid);
        if (param__.getReferenceSid() > 0) {
            entryMdl.setRngSid(param__.getReferenceSid());
            RngRndataDao rngDao = new RngRndataDao(con__);
            RngRndataModel rngMdl = rngDao.select(param__.getReferenceSid());
            if (rngMdl != null && rngMdl.getRngStatus() == RngConst.RNG_STATUS_DRAFT) {
                entryMdl.setRngCmdMode(RngConst.RNG_CMDMODE_EDIT);
            }
        }

        //テンプレート情報を取得
        RngFormBuildBiz formBiz = new RngFormBuildBiz(reqMdl__);
        RngTemplateModel rtpMdl = formBiz.getRtpModelMaxVer(con__, rtpSid);
        if (rtpMdl.getRtpSid() > 0) {
            //バージョン情報をセット
            entryMdl.setRng020rtpVer(rtpMdl.getRtpVer());
            entryMdl.setRng020rtpKeiroVersion(rtpMdl.getRctVer());
            //複写用経路データ使用フラグをセット
            if (rtpMdl.getRtpType() == RngConst.RNG_TEMPLATE_SHARE
                && rtpMdl.getRtpSpecVer() == RngConst.RNG_RTP_SPEC_VER_A480) {
                entryMdl.setRng020useCopyKeiro(true);
            }
            //申請ID情報をセット
            RngBiz rngBiz = new RngBiz(con__, null);
            RingiIdModel rngIdMdl = rngBiz.getRngidModel(rtpMdl.getRtpIdformatSid());
            if (rngIdMdl != null) {
                entryMdl.setIdUseFlg(RngConst.RNG_SINSEI_ID_USE);
                //手入力可能フラグをセット
                entryMdl.setIdPrefManualEditable(
                    rngRestapiBiz.getSinseiIdInputKanouFlg(rngIdMdl, rtpMdl));
                entryMdl.setRng020IdPrefManual(param__.getEntryIdInputKanouFlg());
                entryMdl.setRng020ID(param__.getEntryIdText());
            }
        }

        //申請内容モデルを作成
        FormInputBuilder formInputBuilder = rngRestapiBiz.createFormInputBuilder(
            rtpSid, param__.getBodyArray(), tempPathMdl__, ctx__);
        entryMdl.setRng020input(formInputBuilder);

        //リクエストボディに指定した添付ファイルをテンポラリディレクトリに展開
        Map<GSTemporaryPathModel, List<String>> referenceBinMap
            = rngRestapiBiz.setFileTempDir(rtpSid, -1, formInputBuilder, ctx__);

        //経路情報MAPを生成する
        Map<Integer, Rng020KeiroBlock> syouninKeiroBlockMap
            = new HashMap<Integer, Rng020KeiroBlock>();
        Map<Integer, Rng020KeiroBlock> kakuninKeiroBlockMap
            = new HashMap<Integer, Rng020KeiroBlock>();
        rngRestapiBiz.createKeiroInfoMap(
            rtpSid,
            param__.getApprovalRouteArray(),
            param__.getCheckRouteArray(),
            syouninKeiroBlockMap,
            kakuninKeiroBlockMap,
            formInputBuilder,
            ctx__);
        entryMdl.setRng020keiroMap(syouninKeiroBlockMap);
        entryMdl.setRng020kakuninKeiroMap(kakuninKeiroBlockMap);

        //「審議者 = 申請者」の場合、経路をスキップする
        Rng020Biz rng020Biz = new Rng020Biz(con__, reqMdl__);
        rng020Biz.keiroSkip(entryMdl.getRng020keiroMap(), entryMdl.getRng020requestUserId());


        //共有テンプレートの場合、最終確認経路をデータ保持用の配列にコピー
        Rng020knBiz rng020knBiz = new Rng020knBiz(con__, reqMdl__);
        if (entryMdl.isRng020useCopyKeiro()) {
            entryMdl.setRng020kakuninSvKeiroMap(
                    rng020knBiz.getSvCopyKakuninKeiro(entryMdl.getRng020kakuninKeiroMap()));
        }

        //採番コントローラを取得
        MlCountMtController mlCnt
            = GroupSession.getResourceManager().getCountController(reqMdl__);

        //ショートメールプラグインが使用可能か判定
        PluginConfig pconfig = ctx__.getPluginConfig();
        CommonBiz cmnBiz = new CommonBiz();
        boolean smailPluginUseFlg
            = cmnBiz.isCanUsePlugin(GSConstMain.PLUGIN_ID_SMAIL, pconfig);

        boolean commit = false;
        try {
            //稟議を申請
            RingiRequestModel ringiMdl = rng020Biz.entryRingiData(
                                            entryMdl,
                                            mlCnt,
                                            ctx__.getAppRootPath(),
                                            tempPathMdl__.getTempPath(),
                                            RngBiz.ENTRYMODE_SOUKOU,
                                            pconfig,
                                            smailPluginUseFlg,
                                            reqMdl__);
            rngRestapiBiz.deleteReferenceBin(referenceBinMap);

            //レスポンスを生成
            resultSinseiModel__ =
                rngRestapiBiz.getRingiSinseiModelFromInput(ctx__, rtpMdl, formInputBuilder, false,
                    true, param__.getApprovalRouteArray(), param__.getCheckRouteArray());
            resultSinseiModel__.setSid(ringiMdl.getRngSid());
            resultSinseiModel__.setStatusType(RngConst.RNG_STATUS_DRAFT);

            RngBiz rngBiz = new RngBiz(ctx__.getCon());
            RingiIdModel idModel = rngBiz.getRngidModel(rtpMdl.getRtpIdformatSid());

            //入力値側で申請IDが"手入力する"になっており、テンプレート設定側で手入力が可能になっている場合に申請IDに指定された値を使用
            int sinseiIdInputKanouFlg = rngRestapiBiz.getSinseiIdInputKanouFlg(idModel, rtpMdl);
            String entryId = null;
            if (sinseiIdInputKanouFlg == RngConst.RNG_API_SINSEI_MANUAL_KYOKA
                && param__.getEntryIdInputKanouFlg() == RngConst.RNG_API_SINSEI_MANUAL_KYOKA) {
                entryId = param__.getEntryIdText();
            }
            resultSinseiModel__.setEntryId(entryId);

            resultSinseiModel__.setEntryIdText(null);
            resultSinseiModel__.setEntryIdInputText(null);
            resultSinseiModel__.setEntryIdInputKanouFlg(-1);

            resultSinseiModel__.setTemplateSid(rtpMdl.getRtpSid());
            resultSinseiModel__.setTitleText(param__.getTitleText());
            resultSinseiModel__.setActionCommentText(rtpMdl.getRtpActionComment());

            //オペレーションログを出力
            RngRestapiRingiModel ringiLogMdl = new RngRestapiRingiModel();
            ringiLogMdl.setSid(ringiMdl.getRngSid());
            ringiLogMdl.setTitleText(ringiMdl.getRngTitle());
            ringiLogMdl.setEntryIdText(null);
            __outPutOpLogDraft(ringiLogMdl);

            con__.commit();
            commit = true;

            //テンポラリディレクトリを削除
            GSTemporaryPathUtil.getInstance().deleteTempPath(tempPathMdl__);

        } catch (Exception e) {
            log__.error("稟議情報の登録に失敗", e);
            throw e;
        } finally {
            if (!commit) {
                con__.rollback();
            }
        }
    }

    /**
     * <br>[機  能] オペレーションログを出力する
     * <br>[解  説]
     * <br>[備  考]
     * @param ringiMdl 稟議情報
     * @param action アクション
     * @throws SQLException
     */
    private void __outPutOpLog(
        RngRestapiRingiModel ringiMdl, String action) throws SQLException {

        GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());

        int rngSid = ringiMdl.getSid();

        //操作
        String opCode = "";
        if (param__.getType() == EnumRngEntitiesType.entry) {
            opCode = gsMsg.getMessage("rng.63");
        } else if (param__.getType() == EnumRngEntitiesType.retry) {
            opCode = gsMsg.getMessage("rng.62")
                + gsMsg.getMessage("rng.rng030.09");
        }

        //内容
        StringBuilder sb = new StringBuilder();
        sb.append("[" + gsMsg.getMessage("cmn.title") + "] " + ringiMdl.getTitleText());
        sb.append("\n");
        sb.append("[" + gsMsg.getMessage("rng.rng180.04") + "] "
            + NullDefault.getString(ringiMdl.getEntryIdText(), ""));
        //共有テンプレート使用時、テンプレート名を出力する
        RngRndataDao rngDao = new RngRndataDao(con__);
        RngRndataModel rngMdl = rngDao.select(rngSid);
        RngTemplateDao rtpDao = new RngTemplateDao(con__);
        RngTemplateModel rtpMdl = rtpDao.select(rngMdl.getRtpSid(), rngMdl.getRtpVer());
        if (rtpMdl != null && rtpMdl.getRtpType() == RngConst.RNG_TEMPLATE_SHARE) {
            sb.append("\n");
            sb.append("[" + gsMsg.getMessage("cmn.shared.template")
                + gsMsg.getMessage("cmn.name3")  + "] "
                + rtpMdl.getRtpTitle());
        }
        //LOG_CODE
        String logCode = "rngSid: " + rngSid;

        //オペレーションログ出力
        RngRestapiBiz biz = new RngRestapiBiz();
        biz.outPutLog(ctx__, action, GSConstLog.LEVEL_TRACE, opCode, sb.toString(), logCode);
    }

    /**
     * <br>[機  能] 草稿保存時のオペレーションログを出力する
     * <br>[解  説]
     * <br>[備  考]
     * @param ringiMdl 稟議情報
     * @throws SQLException
     */
    private void __outPutOpLogDraft(
        RngRestapiRingiModel ringiMdl) throws SQLException {

        GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());

        int rngSid = ringiMdl.getSid();

        //操作
        String opCode = gsMsg.getMessage("cmn.save.draft3");

        //内容
        StringBuilder sb = new StringBuilder();
        sb.append("[" + gsMsg.getMessage("cmn.title") + "] " + ringiMdl.getTitleText());
        sb.append("\n");
        //共有テンプレート使用時、テンプレート名を出力する
        RngRndataDao rngDao = new RngRndataDao(con__);
        RngRndataModel rngMdl = rngDao.select(rngSid);
        RngTemplateDao rtpDao = new RngTemplateDao(con__);
        RngTemplateModel rtpMdl = rtpDao.select(rngMdl.getRtpSid(), rngMdl.getRtpVer());
        if (rtpMdl != null && rtpMdl.getRtpType() == RngConst.RNG_TEMPLATE_SHARE) {
            sb.append("\n");
            sb.append("[" + gsMsg.getMessage("cmn.shared.template")
                + gsMsg.getMessage("cmn.name3")  + "] "
                + rtpMdl.getRtpTitle());
        }
        //LOG_CODE
        String logCode = "rngSid: " + rngSid;

        //オペレーションログ出力
        RngRestapiBiz biz = new RngRestapiBiz();
        biz.outPutLog(ctx__, "draft", GSConstLog.LEVEL_TRACE, opCode, sb.toString(), logCode);
    }

    /**
     * <br>[機  能] 実行結果の取得
     * <br>[解  説]
     * <br>[備  考]
     * @return 実行結果
     */
    public RngRestapiRingiModel getResult() {
        return result__;
    }

    /**
     * @return the resultSinseiModel
     */
    public RngRestApiRingiSinseiModel getResultSinseiModel() {
        return resultSinseiModel__;
    }
}
