package jp.groupsession.v2.rng.restapi.entities;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Objects;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.util.MessageResources;

import jp.co.sjts.util.EnumUtil.EnumOutRangeException;
import jp.co.sjts.util.encryption.EncryptionException;
import jp.co.sjts.util.io.IOToolsException;
import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.cmn.biz.ActionMessageBiz;
import jp.groupsession.v2.cmn.formbuilder.FormInputBuilder;
import jp.groupsession.v2.cmn.model.ActionMessageModel;
import jp.groupsession.v2.cmn.model.GSTemporaryPathModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.EnumError;
import jp.groupsession.v2.restapi.exception.RestApiPermissionException;
import jp.groupsession.v2.restapi.exception.RestApiValidateException;
import jp.groupsession.v2.restapi.msg.RestApiGsMessage;
import jp.groupsession.v2.restapi.parameter.annotation.MaxLength;
import jp.groupsession.v2.restapi.parameter.annotation.NotBlank;
import jp.groupsession.v2.restapi.parameter.annotation.ParamModel;
import jp.groupsession.v2.restapi.parameter.annotation.Selectable;
import jp.groupsession.v2.restapi.parameter.annotation.TextField;
import jp.groupsession.v2.restapi.parameter.annotation.Validator;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.RngValidate;
import jp.groupsession.v2.rng.RtpNotfoundException;
import jp.groupsession.v2.rng.biz.RngBiz;
import jp.groupsession.v2.rng.biz.RngFormBuildBiz;
import jp.groupsession.v2.rng.biz.RngTemplateBiz;
import jp.groupsession.v2.rng.dao.RingiDao;
import jp.groupsession.v2.rng.dao.RngRndataDao;
import jp.groupsession.v2.rng.model.RingiDataModel;
import jp.groupsession.v2.rng.model.RingiIdModel;
import jp.groupsession.v2.rng.model.RngAconfModel;
import jp.groupsession.v2.rng.model.RngRndataModel;
import jp.groupsession.v2.rng.model.RngTemplateModel;
import jp.groupsession.v2.rng.restapi.RngEnumReasonCode;
import jp.groupsession.v2.rng.restapi.RngRestapiBiz;
import jp.groupsession.v2.rng.restapi.parammodel.RngRestApiRingiBodyParamModel;
import jp.groupsession.v2.rng.restapi.parammodel.RngRestApiRingiRouteParamModel;
import jp.groupsession.v2.rng.rng020.Rng020Biz;
import jp.groupsession.v2.rng.rng020.Rng020EntryKeiroBiz;
import jp.groupsession.v2.rng.rng020.Rng020KeiroBlock;
import jp.groupsession.v2.rng.rng030.Rng030Biz;
import jp.groupsession.v2.struts.msg.GsMessage;

/**
 * <br>[機  能] 稟議を申請するAPI パラメータモデル
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author  JTS
 */
@ParamModel
public class RngEntitiesPostParamModel implements IRngEntitiesGetParam {

    /** テンプレート, または稟議のどちらを指定しているか */
    private EnumRngEntitiesType type__ = EnumRngEntitiesType.entry;

    //パスパラメータ
    /** 稟議SID */
    private int ringiSid__ = 0;

    //クエリパラメータ
    /** アクション */
    @NotBlank
    @TextField
    private String action__ = null;

    //リクエストボディ
    /** テンプレートSID */
    @NotBlank
    private int templateSid__ = 0;
    /** タイトル */
    @NotBlank
    @TextField
    @MaxLength(100)
    private String titleText__ = null;
    /** 申請ID手入力区分 */
    @Selectable({"0", "1"})
    private int entryIdInputKanouFlg__ = 0;
    /** 申請ID */
    private String entryIdText__ = null;
    /** 参照元稟議SID */
    private int referenceSid__ = 0;
    /** 申請内容 */
    private RngRestApiRingiBodyParamModel[] bodyArray__ = null;
    /** 承認経路情報 */
    private RngRestApiRingiRouteParamModel[] approvalRouteArray__ = null;
    /** 確認経路情報 */
    private RngRestApiRingiRouteParamModel[] checkRouteArray__ = null;

    /**
     * @return the type
     */
    public EnumRngEntitiesType getType() {
        return type__;
    }
    /**
     * @param type the type to set
     */
    public void setType(EnumRngEntitiesType type) {
        type__ = type;
    }
    /**
     * @return the ringiSid
     */
    public int getRingiSid() {
        return ringiSid__;
    }
    /**
     * @param ringiSid the ringiSid to set
     */
    public void setRingiSid(int ringiSid) {
        ringiSid__ = ringiSid;
    }
    /**
     * @return the action
     */
    public String getAction() {
        return action__;
    }
    /**
     * @param action the action to set
     */
    public void setAction(String action) {
        action__ = action;
    }
    /**
     * @return the templateSid
     */
    public int getTemplateSid() {
        return templateSid__;
    }
    /**
     * @param templateSid the templateSid to set
     */
    public void setTemplateSid(int templateSid) {
        templateSid__ = templateSid;
    }
    /**
     * @return the titleText
     */
    public String getTitleText() {
        return titleText__;
    }
    /**
     * @param titleText the titleText to set
     */
    public void setTitleText(String titleText) {
        titleText__ = titleText;
    }
    /**
     * @return the entryIdInputKanouFlg
     */
    public int getEntryIdInputKanouFlg() {
        return entryIdInputKanouFlg__;
    }
    /**
     * @param entryIdInputKanouFlg the entryIdInputKanouFlg to set
     */
    public void setEntryIdInputKanouFlg(int entryIdInputKanouFlg) {
        entryIdInputKanouFlg__ = entryIdInputKanouFlg;
    }
    /**
     * @return the entryIdText
     */
    public String getEntryIdText() {
        return entryIdText__;
    }
    /**
     * @param entryIdText the entryIdText to set
     */
    public void setEntryIdText(String entryIdText) {
        entryIdText__ = entryIdText;
    }
    /**
     * @return the referenceSid
     */
    public int getReferenceSid() {
        return referenceSid__;
    }
    /**
     * @param referenceSid the referenceSid to set
     */
    public void setReferenceSid(int referenceSid) {
        referenceSid__ = referenceSid;
    }
    /**
     * @return the bodyArray
     */
    public RngRestApiRingiBodyParamModel[] getBodyArray() {
        return bodyArray__;
    }

    /**
     * @param bodyArray the bodyArray to set
     */
    public void setBodyArray(RngRestApiRingiBodyParamModel[] bodyArray) {
        bodyArray__ = bodyArray;
    }
    /**
     * @return the approvalRouteArray
     */
    public RngRestApiRingiRouteParamModel[] getApprovalRouteArray() {
        return approvalRouteArray__;
    }
    /**
     * @param approvalRouteArray the approvalRouteArray to set
     */
    public void setApprovalRouteArray(
        RngRestApiRingiRouteParamModel[] approvalRouteArray) {
        approvalRouteArray__ = approvalRouteArray;
    }
    /**
     * @return the checkRouteArray
     */
    public RngRestApiRingiRouteParamModel[] getCheckRouteArray() {
        return checkRouteArray__;
    }
    /**
     * @param checkRouteArray the checkRouteArray to set
     */
    public void setCheckRouteArray(
        RngRestApiRingiRouteParamModel[] checkRouteArray) {
        checkRouteArray__ = checkRouteArray;
    }

    /**
     * <br>[機  能] 入力チェックを実行する
     * <br>[解  説]
     * <br>[備  考]
     * @param ctx RestApiコンテキスト
     * @throws EncryptionException
     */
    @Validator
    public void validate(RestApiContext ctx)
        throws SQLException, IOToolsException,
        RtpNotfoundException, EnumOutRangeException {

        ActionErrors errors = new ActionErrors();
        MessageResources msgRes = ctx.getMessageResources();
        ActionMessageBiz messageBiz = new ActionMessageBiz();
        GsMessage gsMsg = new GsMessage(ctx.getRequestModel());
        RngRestapiBiz rngApiBiz = new RngRestapiBiz();
        String temporarySubPath = "temporary";
        GSTemporaryPathModel tempPathMdl = GSTemporaryPathModel.getInstance(
            ctx.getRequestModel(),
            GSConst.PLUGINID_API,
            temporarySubPath);

        //重複チェック (申請内容 > フォームID)
        List<String> checkFormList = new ArrayList<String>();
        String dupMsg = msgRes.getMessage("error.select.dup.list", "formId");
        for (RngRestApiRingiBodyParamModel model : bodyArray__) {
            if (checkFormList.contains(model.getFormId())) {
                throw new RestApiValidateException(
                    RngEnumReasonCode.PARAM_INPUT_ERROR_ENTRY_PARAM,
                        "error.input.messages",
                        "bodyArray",
                        dupMsg
                );
            }
            checkFormList.add(model.getFormId());
        }

        //重複チェック (承認経路 > 経路ステップSID)
        List<Integer> checkSidList = new ArrayList<Integer>();
        dupMsg = msgRes.getMessage("error.select.dup.list", "templateStepSid");
        for (RngRestApiRingiRouteParamModel model : approvalRouteArray__) {
            if (checkSidList.contains(model.getTemplateStepSid())) {
                throw new RestApiValidateException(
                    RngEnumReasonCode.PARAM_INPUT_ERROR_SYOUNIN_KEIRO,
                        "error.input.messages",
                        "approvalRouteArray",
                        dupMsg
                );
            }
            checkSidList.add(model.getTemplateStepSid());
        }

        //重複チェック (確認経路 > 経路ステップSID)
        checkSidList = new ArrayList<Integer>();
        for (RngRestApiRingiRouteParamModel model : checkRouteArray__) {
            if (checkSidList.contains(model.getTemplateStepSid())) {
                throw new RestApiValidateException(
                    RngEnumReasonCode.PARAM_INPUT_ERROR_KAKUNIN_KEIRO,
                        "error.input.messages",
                        "checkRouteArray",
                        dupMsg
                );
            }
            checkSidList.add(model.getTemplateStepSid());
        }

        //指定したテンプレートを参照可能かをチェック
        RngFormBuildBiz formBiz = new RngFormBuildBiz(ctx.getRequestModel());

        RngTemplateModel rtpMdl = null;
        if (type__ == EnumRngEntitiesType.entry) {
            try {
                rtpMdl = formBiz.getRtpModelMaxVer(ctx.getCon(), templateSid__);
            } catch (RtpNotfoundException e) {
                //テンプレートが存在しない
                throw new RestApiValidateException(
                    RngEnumReasonCode.PARAM_CANT_ACCESS_TEMPLATE,
                        "error.no.access.data",
                        new GsMessage(ctx.getRequestModel())
                        .getMessage("main.useddisk.rng.template")
                );
            }

            RngTemplateBiz rtpBiz = new RngTemplateBiz();
            boolean canUseTemplate = rtpBiz.isUseableTemplate(
                rtpMdl, ctx.getRequestModel(), ctx.getCon());
            if (!canUseTemplate) {
                //テンプレートの使用権限がない
                throw new RestApiValidateException(
                    RngEnumReasonCode.PARAM_CANT_ACCESS_TEMPLATE,
                        "error.no.access.data",
                        new GsMessage(ctx.getRequestModel())
                        .getMessage("main.useddisk.rng.template")
                );
            }
        }

        //参照元稟議SIDチェック
        int referenceSid = -1;
        if (type__ == EnumRngEntitiesType.entry) {
            referenceSid = referenceSid__;
        } else if (type__ == EnumRngEntitiesType.retry) {
            referenceSid = ringiSid__;
        }

        //ここです
        if (referenceSid > 0) {
            RngRndataDao rngRndataDao = new RngRndataDao(ctx.getCon());
            RngRndataModel rngMdl = rngRndataDao.select(referenceSid);
            __checkReferenceRingi(ctx, rngMdl);

            if (type__ == EnumRngEntitiesType.retry) {
                rtpMdl = formBiz.getRtpModel(ctx.getCon(), rngMdl.getRtpSid(), rngMdl.getRtpVer());
            }
        }

        //入力情報生成
        FormInputBuilder formInputBuilder;

        String dirAccessErrMsg = msgRes.getMessage(
            "restapi.error.param.data.access",
            "bodyArray",
            gsMsg.getMessage("fil.fil080.9"));

        if (type__ == EnumRngEntitiesType.entry) {
            try {
                formInputBuilder = rngApiBiz.createFormInputBuilder(
                    templateSid__, bodyArray__, tempPathMdl, ctx);
            } catch (EncryptionException e) {
                //ディレクトリ識別文字列の解析に失敗
                throw new RestApiValidateException(
                    RngEnumReasonCode.PARAM_INPUT_ERROR_ENTRY_PARAM,
                        "error.input.messages",
                        "bodyArray",
                        dirAccessErrMsg
                );
            }
            //テンプレートの申請内容にて設定できない項目がないかチェック
            rngApiBiz.checkUseForm(ctx, formInputBuilder, true, "");
            //テンプレートの経路情報にて利用できない経路がないかチェック
            rngApiBiz.checkUseKeiro(ctx, rtpMdl, formInputBuilder, true, false, "");

        } else {
            try {
                formInputBuilder = rngApiBiz.createFormInputBuilder(
                    rtpMdl.getRtpSid(), rtpMdl.getRtpVer(), bodyArray__, tempPathMdl, ctx);
            } catch (EncryptionException e) {
                //ディレクトリ識別文字列の解析に失敗
                throw new RestApiValidateException(
                    RngEnumReasonCode.PARAM_INPUT_ERROR_ENTRY_PARAM,
                        "error.input.messages",
                        "bodyArray",
                        dirAccessErrMsg
                );
            }

            //選択可能なユーザ/グループが存在するかチェック
            rngApiBiz.checkUseForm(ctx, formInputBuilder, false, "ringiSid");

            //テンプレートの経路情報にて利用できない経路がないかチェック
            RngBiz rngBiz = new RngBiz(ctx.getCon());
            if (!rngBiz.isUserInSyouninKerio(ringiSid__)) {
                throw new RestApiValidateException(
                    RngEnumReasonCode.PARAM_NOTHING_USER_REAPPLICATION,
                    "restapi.error.saisinsei.keiro",
                    "ringiSid"
                );
            }
        }

        //申請ID手入力可能チェック
        if (entryIdInputKanouFlg__ == RngConst.RAR_SINSEI_MANUAL_KYOKA
            && type__ == EnumRngEntitiesType.entry) {
            RngBiz rngBiz = new RngBiz(ctx.getCon());
            RngAconfModel aconfMdl = rngBiz.getRngAconf(ctx.getCon());
            if (aconfMdl.getRarRngid() == RngConst.RAR_SINSEI_NONE) {
                //申請IDを使用しない
                throw new RestApiValidateException(
                    EnumError.PARAM_OTHER_INVALID,
                        "error.manual.input.auth",
                        "entryIdInputKanouFlg",
                        "entryIdText"
                );
            }

            RingiIdModel idModel = rngBiz.getRngidModel(rtpMdl.getRtpIdformatSid());
            if (rngApiBiz.getSinseiIdInputKanouFlg(idModel, rtpMdl)
                    != RngConst.RNG_API_SINSEI_MANUAL_KYOKA) {
                //申請IDの手入力権限がない
                throw new RestApiValidateException(
                    EnumError.PARAM_OTHER_INVALID,
                        "error.manual.input.auth",
                        "entryIdInputKanouFlg",
                        "entryIdText"
                );
            }

            //申請IDフォーマットチェック
            errors = RngValidate.validateCmnFieldText(
                    errors,
                    "entryIdText",
                    entryIdText__,
                    "entryIdText",
                    RngConst.MAX_LENGTH_RINGI_ID,
                    true);
            if (errors.size() > 0) {
                //申請IDの入力に誤りがある
                List<ActionMessageModel> messageModelList = messageBiz.getMessageKeyValue(errors);
                StringBuilder sb = new StringBuilder();
                for (ActionMessageModel messageModel : messageModelList) {
                    if (sb.length() > 0) {
                        sb.append("\r\n");
                    }
                    sb.append(msgRes.getMessage(messageModel.getKey(), messageModel.getValues()));
                }
                throw new RestApiValidateException(
                    EnumError.PARAM_OTHER_INVALID,
                        "errors.free.msg",
                        sb.toString()
                );
            }
            //申請ID重複チェック
            int escapeSid = 0;
            if (referenceSid > 0) {
                escapeSid = referenceSid;
            }
            if (!rngBiz.chkOverRapErrorRngId(entryIdText__, escapeSid)) {
                throw new RestApiValidateException(
                    EnumError.PARAM_OTHER_INVALID,
                        "error.double.timezone",
                        "entryIdText",
                        gsMsg.getMessage("rng.rng180.04")
                );
            }
        }

        //申請内容入力チェック
        boolean isSoukouTouroku = false;
        if (Objects.equals(action__, "draft")) {
            isSoukouTouroku = true;
        }
        rngApiBiz.checkBodyInfo(
            formInputBuilder, bodyArray__, referenceSid,
            rtpMdl, tempPathMdl, type__, isSoukouTouroku, ctx);

        if (type__ == EnumRngEntitiesType.retry || Objects.equals(action__, "draft")) {
            //再申請の場合は経路情報をリクエストボディに含めないため、経路に対してのチェックを行わない
            //草稿保存の場合は経路が未入力でも問題ないため、経路に対してのチェックを行わない
            return;
        }

        //経路情報入力チェック
        //経路情報MAPを生成する
        Map<Integer, Rng020KeiroBlock> syouninKeiroBlockMap
            = new HashMap<Integer, Rng020KeiroBlock>();
        Map<Integer, Rng020KeiroBlock> kakuninKeiroBlockMap
            = new HashMap<Integer, Rng020KeiroBlock>();

        if (type__ == EnumRngEntitiesType.entry) {
            rngApiBiz.createKeiroInfoMap(
                templateSid__,
                approvalRouteArray__,
                checkRouteArray__,
                syouninKeiroBlockMap,
                kakuninKeiroBlockMap,
                formInputBuilder,
                ctx);
        } else if (type__ == EnumRngEntitiesType.retry) {
            //再申請の場合は経路情報をリクエストボディに含めないため、経路に対してのチェックを行わない
            return;
        }

        Rng020EntryKeiroBiz keiroBiz = new Rng020EntryKeiroBiz(
            ctx.getCon(), ctx.getRequestModel(), 0);

        //承認経路チェック
        String keiro = gsMsg.getMessage("rng.42");
        int keiroCnt = 0;
        for (Entry<Integer, Rng020KeiroBlock> entry : syouninKeiroBlockMap.entrySet()) {
            keiroCnt += keiroBiz.validateKeiro(errors, entry, keiro, keiroCnt);
        }
        if (errors.size() > 0) {
            //経路情報の入力に誤りがある
            List<ActionMessageModel> messageModelList = messageBiz.getMessageKeyValue(errors);
            StringBuilder sb = new StringBuilder();
            for (ActionMessageModel messageModel : messageModelList) {
                if (sb.length() > 0) {
                    sb.append("\r\n");
                }
                sb.append(msgRes.getMessage(messageModel.getKey(), messageModel.getValues()));
            }
            throw new RestApiValidateException(
                RngEnumReasonCode.PARAM_INPUT_ERROR_SYOUNIN_KEIRO,
                    "error.input.messages",
                    "approvalRouteArray",
                    sb.toString()
            );
        }
        if (keiroCnt == 0) {
            //承認経路が0件
            throw new RestApiValidateException(
                RngEnumReasonCode.PARAM_INPUT_ERROR_SYOUNIN_KEIRO,
                    "error.input.messages",
                    "approvalRouteArray",
                    msgRes.getMessage("error.select.required.text", keiro)

            );
        }

        //確認経路チェック
        keiroCnt = 0;
        keiro = gsMsg.getMessage("rng.35");
        for (Entry<Integer, Rng020KeiroBlock> entry
                : kakuninKeiroBlockMap.entrySet()) {
            keiroCnt += keiroBiz.validateKeiro(errors, entry, keiro, keiroCnt);
        }
        if (errors.size() > 0) {
            //経路情報の入力に誤りがある
            List<ActionMessageModel> messageModelList = messageBiz.getMessageKeyValue(errors);
            StringBuilder sb = new StringBuilder();
            for (ActionMessageModel messageModel : messageModelList) {
                if (sb.length() > 0) {
                    sb.append("\r\n");
                }
                sb.append(msgRes.getMessage(messageModel.getKey(), messageModel.getValues()));
            }
            throw new RestApiValidateException(
                RngEnumReasonCode.PARAM_INPUT_ERROR_KAKUNIN_KEIRO,
                    "error.input.messages",
                    "checkRouteArray",
                    sb.toString()
            );
        }
    }

    /**
     * <br>[機  能] 参照元の稟議情報を使用できるかチェックする
     * <br>[解  説]
     * <br>[備  考]
     * @param ctx RestApiContext
     * @param rngMdl 参照元稟議情報
     * @throws IOToolsException
     * @throws SQLException
     */
    private void __checkReferenceRingi(
        RestApiContext ctx, RngRndataModel rngMdl) throws IOToolsException, SQLException {

        if (rngMdl == null) {
            //参照元稟議が存在しない
            if (type__ == EnumRngEntitiesType.entry) {
                throw new RestApiValidateException(
                    RngEnumReasonCode.PARAM_CANT_ACCESS_REFERENCE_RINGI,
                        "restapi.error.param.data.empty",
                        "referenceSid",
                        new GsMessage(ctx.getRequestModel())
                        .getMessage("main.useddisk.rng.rndata")
                );
            } else {
                throw new RestApiPermissionException(
                    RngEnumReasonCode.RESOURCE_CANT_ACCESS_RINGI,
                    "error.no.access.data",
                    new RestApiGsMessage()
                        .getMessage("main.useddisk.rng.rndata")
                );
            }
        }

        if (Objects.equals(action__, "draft")) {
            Rng020Biz rng020Biz = new Rng020Biz(ctx.getCon(), ctx.getRequestModel());
            if (!rng020Biz.chkViewRingi(
                ctx.getRequestUserSid(), rngMdl.getRngSid(), RngConst.RNG_CMDMODE_EDIT)) {
                throw new RestApiValidateException(
                    RngEnumReasonCode.PARAM_CANT_ACCESS_REFERENCE_RINGI,
                        "restapi.error.param.data.reference",
                        "referenceSid",
                        new GsMessage(ctx.getRequestModel())
                        .getMessage("main.useddisk.rng.rndata")
                );
            }
            return;
        } else if (rngMdl.getRngStatus() == RngConst.RNG_STATUS_DRAFT) {
            if (rngMdl.getRngAuid() != ctx.getRequestUserSid()) {
                //自身の草稿稟議ではない
                throw new RestApiValidateException(
                    RngEnumReasonCode.PARAM_CANT_ACCESS_REFERENCE_RINGI,
                        "restapi.error.param.data.access",
                        "referenceSid",
                        new GsMessage(ctx.getRequestModel())
                        .getMessage("main.useddisk.rng.rndata")
                );
            }
        } else {
            int referenceSid = rngMdl.getRngSid();
            Rng030Biz rng030Biz = new Rng030Biz(ctx.getCon(), ctx.getRequestModel());
            if (!rng030Biz.chkViewRingi(ctx.getRequestUserSid(), referenceSid)) {
                //複写申請できない
                if (type__ == EnumRngEntitiesType.entry) {
                    throw new RestApiValidateException(
                        RngEnumReasonCode.PARAM_CANT_ACCESS_REFERENCE_RINGI,
                            "restapi.error.param.data.reference",
                            "referenceSid",
                            new GsMessage(ctx.getRequestModel())
                            .getMessage("main.useddisk.rng.rndata")
                    );
                } else {
                    throw new RestApiPermissionException(
                        RngEnumReasonCode.RESOURCE_CANT_ACCESS_RINGI,
                        "error.no.access.data",
                        new RestApiGsMessage()
                            .getMessage("main.useddisk.rng.rndata")
                    );
                }
            }
        }
        if (type__ == EnumRngEntitiesType.retry) {
            //再申請の場合
            RingiDao ringiDao = new RingiDao(ctx.getCon());
            RingiDataModel ringiMdl =
                ringiDao.getRingiData(ringiSid__, ctx.getRequestUserSid());
            RngBiz rngBiz = new RngBiz(ctx.getCon());
            if (!rngBiz.canReApplicate(ringiMdl)) {
                throw new RestApiValidateException(
                    RngEnumReasonCode.PARAM_CANT_REAPPLICATION,
                    "restapi.error.cant.saisinsei",
                    "ringiSid"
                );
            }
        } else {
            //再申請以外の場合
            if (rngMdl.getRtpSid() != templateSid__) {
                //異なるテンプレートを使用している為、参照できない。
                throw new RestApiValidateException(
                    RngEnumReasonCode.PARAM_CANT_ACCESS_REFERENCE_RINGI,
                        "restapi.error.param.data.reference",
                        "referenceSid",
                        new GsMessage(ctx.getRequestModel())
                        .getMessage("main.useddisk.rng.rndata")
                );
            }
        }
    }
}
