package jp.groupsession.v2.rng.restapi.entities.files;

import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.co.sjts.util.NullDefault;
import jp.groupsession.v2.cmn.GSConstCommon;
import jp.groupsession.v2.cmn.GSConstLog;
import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.exception.TempFileException;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.cmn.model.base.CmnBinfModel;
import jp.groupsession.v2.restapi.controller.AbstractRestApiAction;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.controller.annotation.Get;
import jp.groupsession.v2.restapi.controller.annotation.Plugin;
import jp.groupsession.v2.restapi.response.RestApiAttachementResponseWriter;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.dao.RngRndataDao;
import jp.groupsession.v2.rng.model.RngRndataModel;
import jp.groupsession.v2.rng.restapi.RngRestapiBiz;
import jp.groupsession.v2.struts.msg.GsMessage;

/**
 * <br>[機  能] 稟議 添付ファイルダウンロードAPI アクションクラス
 * <br>[解  説]
 * <br>[備  考]
 */
@Plugin(RngConst.PLUGIN_ID_RINGI)
public class RngEntitiesFilesAction extends AbstractRestApiAction {

    /**
     * <br>[機  能] GETメソッド
     * <br>[解  説] 稟議RestAPI「稟議の添付ファイルをダウンロードする」
     * <br>[備  考]
     * @param req リクエスト
     * @param res レスポンス
     * @param param パラメータ
     * @param ctx コンテキスト
     * @throws SQLException SQL実行時例外
     * @throws TempFileException 添付ファイル情報の取得に失敗
     */
    @Get
    public void doGet(
        HttpServletRequest req,
        HttpServletResponse res,
        RngEntitiesFilesParamModel param,
        RestApiContext ctx) throws SQLException, TempFileException {

        //---オペレーションログ出力処理---
        RequestModel reqMdl = ctx.getRequestModel();
        CommonBiz cmnBiz = new CommonBiz();
        CmnBinfModel cbMdl = cmnBiz.getBinInfo(ctx.getCon(),
                                            Long.valueOf(param.getBinSid()),
                                            reqMdl.getDomain());

        if (cbMdl != null) {
            GsMessage gsMsg = new GsMessage(reqMdl);
            String opCode = gsMsg.getMessage("cmn.download");

            RngRndataDao rndataDao = new RngRndataDao(ctx.getCon());
            RngRndataModel rngDataMdl = rndataDao.select(param.getRingiSid());
            String opValue = "[" + gsMsg.getMessage("cmn.title") + "] "; //稟議タイトル
            opValue += rngDataMdl.getRngTitle();
            opValue += "\r\n[" + gsMsg.getMessage("rng.rng180.04") + "] "; //申請ID
            opValue += NullDefault.getString(rngDataMdl.getRngId(), "");

            opValue += "\r\n[" + gsMsg.getMessage("cmn.file.name") + "] "; //ファイル名
            opValue += cbMdl.getBinFileName();

            if (opValue.length() > GSConstCommon.MAX_LENGTH_LOG_OP_VALUE) {
                opValue.substring(0, GSConstCommon.MAX_LENGTH_LOG_OP_VALUE);
            }

            //LOG_CODE
            String logCode = "rngsid: " + String.valueOf(String.valueOf(param.getRingiSid()));

            RngRestapiBiz apiBiz = new RngRestapiBiz();
            apiBiz.outPutLog(ctx, GSConstLog.LEVEL_INFO, opCode, opValue, logCode);
        }
        //---オペレーションログ出力処理---

        //ファイルダウンロード処理
        RestApiAttachementResponseWriter.execute(res, req, ctx, param.getBinSid());
    }
}
