package jp.groupsession.v2.rng.restapi.entities.keiro;

import java.sql.Connection;
import java.sql.SQLException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.co.sjts.util.EnumUtil.EnumOutRangeException;
import jp.co.sjts.util.encryption.EncryptionException;
import jp.co.sjts.util.io.IOToolsException;
import jp.groupsession.v2.cmn.formbuilder.FormInputBuilder;
import jp.groupsession.v2.cmn.model.GSTemporaryPathModel;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.RtpNotfoundException;
import jp.groupsession.v2.rng.biz.RngFormBuildBiz;
import jp.groupsession.v2.rng.dao.RngRndataDao;
import jp.groupsession.v2.rng.model.RngRndataModel;
import jp.groupsession.v2.rng.model.RngTemplateModel;
import jp.groupsession.v2.rng.restapi.RngRestapiBiz;
import jp.groupsession.v2.rng.restapi.entities.RngEntitiesDeleteBiz;
import jp.groupsession.v2.rng.restapi.model.RngRestApiRingiSinseiModel;
import jp.groupsession.v2.struts.msg.GsMessage;

/**
 * <br>[機  能]
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author  JTS
 */
public class RngEntitiesKeiroGetBiz {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(RngEntitiesDeleteBiz.class);

    /** 実行結果*/
    private RngRestApiRingiSinseiModel result__ = null;
    /**
     * @return the result
     */
    public RngRestApiRingiSinseiModel getResult() {
        return result__;
    }
    /**
     * @param result the result to set
     */
    public void setResult(RngRestApiRingiSinseiModel result) {
        result__ = result;
    }

    /** リクエストパラメータ */
    private RngEntitiesKeiroGetParamModel param__;

    /** コンテキスト */
    private RestApiContext ctx__;
    /** テンポラリディレクトリ */
    GSTemporaryPathModel tempPathModel__;

    /**
     * コンストラクタ
     * @param param リクエストパラメータ
     * @param ctx コンテキスト
     * @param tempPathModel テンポラリディレクトリ
     */
    public RngEntitiesKeiroGetBiz(
        RngEntitiesKeiroGetParamModel param,
        RestApiContext ctx,
        GSTemporaryPathModel tempPathModel) {
        param__ = param;
        ctx__ = ctx;
        tempPathModel__ = tempPathModel;
    }

    /**
     *
     * <br>[機  能] テンプレートから稟議申請情報を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @throws SQLException SQL実行時例外
     * @throws RtpNotfoundException
     * @throws IOToolsException
     * @throws EnumOutRangeException
     * @throws EncryptionException
     */
    public void execute() throws SQLException,
        RtpNotfoundException, IOToolsException, EnumOutRangeException, EncryptionException {

        log__.info("稟議申請経路情報を取得するAPI(草稿から編集，複写申請) 実行");

        Connection con = ctx__.getCon();
        RngRndataDao rngDao = new RngRndataDao(con);
        RngRndataModel rngData = rngDao.select(param__.getRingiSid());

        RequestModel reqMdl = ctx__.getRequestModel();
        RngFormBuildBiz formBiz = new RngFormBuildBiz(reqMdl);
        RngTemplateModel rtpMdl = formBiz.getRtpModelMaxVer(con, rngData.getRtpSid());

        RngRestapiBiz restapiBiz = new RngRestapiBiz();

        FormInputBuilder fb = restapiBiz.createFormInputBuilder(
            rtpMdl.getRtpSid(), param__.getBodyArray(), tempPathModel__, ctx__);

        boolean isCopy = true;
        if (rngData.getRngStatus() == RngConst.RNG_STATUS_DRAFT) {
            isCopy = false;
        }
        //稟議から登録済みの経路情報を含めた状態で結果を取得
        result__ = restapiBiz.getRingiSinseiModelFromRng(
            ctx__, param__, rngData, rtpMdl, fb, false, isCopy);
        //リクエストボディに入力されているタイトルなどの基本情報を設定
        restapiBiz.setRingiBasicDataFromInput(ctx__, param__, rtpMdl, result__);

        if (rngData.getRtpVer() != rtpMdl.getRtpVer()) {
            String text = null;
            GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());
            if (rngData.getRngStatus() == RngConst.RNG_STATUS_DRAFT) {
                text = gsMsg.getMessage("cmn.draft");
            } else {
                text = gsMsg.getMessage("rng.rng020.09");
            }
            String message = ctx__.getMessageResources().getMessage(
                "error.open.update.template", text);
            result__.setTemplateVersionNoticeText(message);
        }
    }
}
