package jp.groupsession.v2.rng.restapi.entities.keiro;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.util.MessageResources;

import jp.co.sjts.util.EnumUtil.EnumOutRangeException;
import jp.co.sjts.util.encryption.EncryptionException;
import jp.co.sjts.util.io.IOToolsException;
import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.cmn.biz.ActionMessageBiz;
import jp.groupsession.v2.cmn.formbuilder.FormInputBuilder;
import jp.groupsession.v2.cmn.model.ActionMessageModel;
import jp.groupsession.v2.cmn.model.GSTemporaryPathModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.EnumError;
import jp.groupsession.v2.restapi.exception.RestApiPermissionException;
import jp.groupsession.v2.restapi.exception.RestApiValidateException;
import jp.groupsession.v2.restapi.msg.RestApiGsMessage;
import jp.groupsession.v2.restapi.parameter.annotation.MaxLength;
import jp.groupsession.v2.restapi.parameter.annotation.NotBlank;
import jp.groupsession.v2.restapi.parameter.annotation.ParamModel;
import jp.groupsession.v2.restapi.parameter.annotation.Selectable;
import jp.groupsession.v2.restapi.parameter.annotation.TextField;
import jp.groupsession.v2.restapi.parameter.annotation.Validator;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.RngValidate;
import jp.groupsession.v2.rng.RtpNotfoundException;
import jp.groupsession.v2.rng.biz.RngBiz;
import jp.groupsession.v2.rng.biz.RngFormBuildBiz;
import jp.groupsession.v2.rng.biz.RngTemplateBiz;
import jp.groupsession.v2.rng.dao.RngRndataDao;
import jp.groupsession.v2.rng.model.RingiIdModel;
import jp.groupsession.v2.rng.model.RngAconfModel;
import jp.groupsession.v2.rng.model.RngRndataModel;
import jp.groupsession.v2.rng.model.RngTemplateModel;
import jp.groupsession.v2.rng.restapi.RngEnumReasonCode;
import jp.groupsession.v2.rng.restapi.RngRestapiBiz;
import jp.groupsession.v2.rng.restapi.entities.EnumRngEntitiesType;
import jp.groupsession.v2.rng.restapi.entities.IRngEntitiesGetParam;
import jp.groupsession.v2.rng.restapi.parammodel.RngRestApiRingiBodyParamModel;
import jp.groupsession.v2.rng.restapi.parammodel.RngRestApiRingiRouteParamModel;
import jp.groupsession.v2.rng.rng030.Rng030Biz;
import jp.groupsession.v2.struts.msg.GsMessage;

/**
 * <br>[機  能] 稟議 稟議申請経路を取得するAPI パラメータモデル
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author  JTS
 */
@ParamModel
public class RngEntitiesKeiroGetParamModel implements IRngEntitiesGetParam {

    /** 稟議SID */
    private int ringiSid__ = 0;

    //リクエストボディ
    /** タイトル */
    @NotBlank
    @TextField
    @MaxLength(100)
    private String titleText__ = null;
    /** 申請ID手入力区分 */
    @Selectable({"0", "1"})
    private int entryIdInputKanouFlg__ = 0;
    /** 申請ID */
    private String entryIdText__ = null;
    /** 申請内容 */
    private RngRestApiRingiBodyParamModel[] bodyArray__ = null;
    /** 承認経路情報 */
    private RngRestApiRingiRouteParamModel[] approvalRouteArray__ = null;
    /** 確認経路情報 */
    private RngRestApiRingiRouteParamModel[] checkRouteArray__ = null;

    /**
     * @return the ringiSid
     */
    public int getRingiSid() {
        return ringiSid__;
    }
    /**
     * @param ringiSid the ringiSid to set
     */
    public void setRingiSid(int ringiSid) {
        ringiSid__ = ringiSid;
    }
    /**
     * @return the titleText
     */
    public String getTitleText() {
        return titleText__;
    }
    /**
     * @param titleText the titleText to set
     */
    public void setTitleText(String titleText) {
        titleText__ = titleText;
    }
    /**
     * @return the entryIdInputKanouFlg
     */
    public int getEntryIdInputKanouFlg() {
        return entryIdInputKanouFlg__;
    }
    /**
     * @param entryIdInputKanouFlg the entryIdInputKanouFlg to set
     */
    public void setEntryIdInputKanouFlg(int entryIdInputKanouFlg) {
        entryIdInputKanouFlg__ = entryIdInputKanouFlg;
    }
    /**
     * @return the entryIdText
     */
    public String getEntryIdText() {
        return entryIdText__;
    }
    /**
     * @param entryIdText the entryIdText to set
     */
    public void setEntryIdText(String entryIdText) {
        entryIdText__ = entryIdText;
    }
    /**
     * @return the bodyArray
     */
    public RngRestApiRingiBodyParamModel[] getBodyArray() {
        return bodyArray__;
    }
    /**
     * @param bodyArray the bodyArray to set
     */
    public void setBodyArray(RngRestApiRingiBodyParamModel[] bodyArray) {
        bodyArray__ = bodyArray;
    }
    /**
     * @return the approvalRouteArray
     */
    public RngRestApiRingiRouteParamModel[] getApprovalRouteArray() {
        return approvalRouteArray__;
    }
    /**
     * @param approvalRouteArray the approvalRouteArray to set
     */
    public void setApprovalRouteArray(
            RngRestApiRingiRouteParamModel[] approvalRouteArray) {
        approvalRouteArray__ = approvalRouteArray;
    }
    /**
     * @return the checkRouteArray
     */
    public RngRestApiRingiRouteParamModel[] getCheckRouteArray() {
        return checkRouteArray__;
    }
    /**
     * @param checkRouteArray the checkRouteArray to set
     */
    public void setCheckRouteArray(
            RngRestApiRingiRouteParamModel[] checkRouteArray) {
        checkRouteArray__ = checkRouteArray;
    }


    /**
     * <br>[機  能] 入力チェックを実行する
     * <br>[解  説]
     * <br>[備  考]
     * @param ctx RestApiコンテキスト
     * @throws EnumOutRangeException
     * @throws RtpNotfoundException
     * @throws IOToolsException
     * @throws EncryptionException
     */
    @Validator
    public void validate(RestApiContext ctx)
        throws SQLException, IOToolsException,
        RtpNotfoundException, EnumOutRangeException, EncryptionException {

        //指定した稟議を参照可能かをチェック
        Rng030Biz rng030Biz = new Rng030Biz(ctx.getCon(), ctx.getRequestModel());
        RngRndataDao rndataDao = new RngRndataDao(ctx.getCon());
        RngRndataModel rngDataMdl = rndataDao.select(ringiSid__);

        //稟議が存在しない
        if (rngDataMdl == null) {
            throw new RestApiPermissionException(
                RngEnumReasonCode.RESOURCE_CANT_ACCESS_RINGI,
                    "error.no.access.data",
                    new RestApiGsMessage()
                        .getMessage("main.useddisk.rng.rndata")
            );
        }

        //草稿 作成者とセッションユーザが一致しない
        if (rngDataMdl.getRngStatus() == RngConst.RNG_STATUS_DRAFT
            && rngDataMdl.getRngAuid() != ctx.getRequestUserSid()) {
            throw new RestApiPermissionException(
                RngEnumReasonCode.RESOURCE_CANT_ACCESS_RINGI,
                    "error.no.access.data",
                    new RestApiGsMessage()
                        .getMessage("main.useddisk.rng.rndata")
            );
        }

        //草稿以外 稟議へのアクセス権限がない
        if (rngDataMdl.getRngStatus() != RngConst.RNG_STATUS_DRAFT
            && !rng030Biz.chkViewRingi(ctx.getRequestUserSid(), ringiSid__)) {
            throw new RestApiPermissionException(
                RngEnumReasonCode.RESOURCE_CANT_ACCESS_RINGI,
                    "error.no.access.data",
                    new RestApiGsMessage()
                        .getMessage("main.useddisk.rng.rndata")
            );
        }

        __validateSinseiNaiyou(ctx, rngDataMdl);
    }

    /**
     * <br>[機  能] 申請内容の入力チェックを実行する
     * <br>[解  説]
     * <br>[備  考]
     * @param ctx RestApiコンテキスト
     * @param rngDataMdl 稟議データ情報
     * @throws EncryptionException
     */
    private void __validateSinseiNaiyou(
        RestApiContext ctx,
        RngRndataModel rngDataMdl)
        throws SQLException, IOToolsException,
        RtpNotfoundException, EnumOutRangeException {

        ActionErrors errors = new ActionErrors();
        MessageResources msgRes = ctx.getMessageResources();
        ActionMessageBiz messageBiz = new ActionMessageBiz();
        RngRestapiBiz restapiBiz = new RngRestapiBiz();
        GsMessage gsMsg = new GsMessage(ctx.getRequestModel());
        RngRestapiBiz rngApiBiz = new RngRestapiBiz();
        String temporarySubPath = "temporary";
        GSTemporaryPathModel tempPathMdl = GSTemporaryPathModel.getInstance(
            ctx.getRequestModel(),
            GSConst.PLUGINID_API,
            temporarySubPath);

        //重複チェック (申請内容 > フォームID)
        List<String> checkFormList = new ArrayList<String>();
        String dupMsg = msgRes.getMessage("error.select.dup.list", "formId");
        for (RngRestApiRingiBodyParamModel model : bodyArray__) {
            if (checkFormList.contains(model.getFormId())) {
                throw new RestApiValidateException(
                    RngEnumReasonCode.PARAM_INPUT_ERROR_ENTRY_PARAM,
                        "error.input.messages",
                        "bodyArray",
                        dupMsg
                );
            }
            checkFormList.add(model.getFormId());
        }

        //重複チェック (承認経路 > 経路ステップSID)
        List<Integer> checkSidList = new ArrayList<Integer>();
        dupMsg = msgRes.getMessage("error.select.dup.list", "templateStepSid");
        for (RngRestApiRingiRouteParamModel model : approvalRouteArray__) {
            if (checkSidList.contains(model.getTemplateStepSid())) {
                throw new RestApiValidateException(
                    RngEnumReasonCode.PARAM_INPUT_ERROR_SYOUNIN_KEIRO,
                        "error.input.messages",
                        "approvalRouteArray",
                        dupMsg
                );
            }
            checkSidList.add(model.getTemplateStepSid());
        }

        //重複チェック (確認経路 > 経路ステップSID)
        checkSidList = new ArrayList<Integer>();
        for (RngRestApiRingiRouteParamModel model : checkRouteArray__) {
            if (checkSidList.contains(model.getTemplateStepSid())) {
                throw new RestApiValidateException(
                    RngEnumReasonCode.PARAM_INPUT_ERROR_KAKUNIN_KEIRO,
                        "error.input.messages",
                        "checkRouteArray",
                        dupMsg
                );
            }
            checkSidList.add(model.getTemplateStepSid());
        }

        //指定したテンプレートを参照可能かをチェック
        RngFormBuildBiz formBiz = new RngFormBuildBiz(ctx.getRequestModel());

        RngTemplateModel rtpMdl = null;
        int templateSid = rngDataMdl.getRtpSid();
        try {
            rtpMdl = formBiz.getRtpModelMaxVer(ctx.getCon(), templateSid);
        } catch (RtpNotfoundException e) {
            //テンプレートが存在しない
            throw new RestApiValidateException(
                RngEnumReasonCode.PARAM_CANT_ACCESS_TEMPLATE,
                    "restapi.error.form.ringi.access.template",
                    "ringiSid"
            );
        }

        RngTemplateBiz rtpBiz = new RngTemplateBiz();
        boolean canUseTemplate = rtpBiz.isUseableTemplate(
            rtpMdl, ctx.getRequestModel(), ctx.getCon());
        if (!canUseTemplate) {
            //テンプレートの使用権限がない
            throw new RestApiValidateException(
                RngEnumReasonCode.PARAM_CANT_ACCESS_TEMPLATE,
                    "restapi.error.form.ringi.access.template",
                    "ringiSid"
            );
        }

        //入力情報生成
        FormInputBuilder formInputBuilder;
        try {
            formInputBuilder = rngApiBiz.createFormInputBuilder(
                templateSid, bodyArray__, tempPathMdl, ctx);
        } catch (EncryptionException e) {
            //ディレクトリ識別文字列の解析に失敗
            String dirAccessErrMsg = msgRes.getMessage(
                "restapi.error.param.data.access",
                "bodyArray",
                gsMsg.getMessage("fil.fil080.9"));
            throw new RestApiValidateException(
                RngEnumReasonCode.PARAM_INPUT_ERROR_ENTRY_PARAM,
                    "error.input.messages",
                    "bodyArray",
                    dirAccessErrMsg
            );
        }

        // //テンプレートの申請内容にて設定できない項目がないかチェック
        restapiBiz.checkUseForm(ctx, formInputBuilder, false, "ringiSid");

        // //テンプレートの経路情報にて利用できない経路がないかチェック
        restapiBiz.checkUseKeiro(ctx, rtpMdl, formInputBuilder, false, false, "ringiSid");

        //参照元稟議SIDチェック
        int rngSid = rngDataMdl.getRngSid();
        RngRndataDao rngDao = new RngRndataDao(ctx.getCon());
        RngRndataModel rngMdl = rngDao.select(rngSid);
        if (rngMdl == null) {
            //参照元稟議が存在しない
            throw new RestApiValidateException(
                RngEnumReasonCode.PARAM_CANT_ACCESS_REFERENCE_RINGI,
                    "restapi.error.param.data.empty",
                    String.valueOf(rngSid),
                    new GsMessage(ctx.getRequestModel())
                    .getMessage("main.useddisk.rng.rndata")
            );
        }
        if (rngMdl.getRngStatus() == RngConst.RNG_STATUS_DRAFT) {
            if (rngMdl.getRngAuid() != ctx.getRequestUserSid()) {
                //自身の草稿稟議ではない
                throw new RestApiValidateException(
                    RngEnumReasonCode.PARAM_CANT_ACCESS_REFERENCE_RINGI,
                        "restapi.error.param.data.access",
                        String.valueOf(rngSid),
                        new GsMessage(ctx.getRequestModel())
                        .getMessage("main.useddisk.rng.rndata")
                );
            }
        } else {
            //稟議詳細画面にアクセスできるか判定する処理で閲覧権限チェック
            Rng030Biz rng030Biz = new Rng030Biz(ctx.getCon(), ctx.getRequestModel());
            if (!rng030Biz.chkViewRingi(ctx.getRequestUserSid(), rngSid)) {
                //複写申請できない
                throw new RestApiValidateException(
                    RngEnumReasonCode.PARAM_CANT_ACCESS_REFERENCE_RINGI,
                        "restapi.error.param.data.reference",
                        String.valueOf(rngSid),
                        new GsMessage(ctx.getRequestModel())
                        .getMessage("main.useddisk.rng.rndata")
                );
            }
        }
        if (rngMdl.getRtpSid() != templateSid) {
            //異なるテンプレートを使用している為、参照できない。
            throw new RestApiValidateException(
                RngEnumReasonCode.PARAM_CANT_ACCESS_REFERENCE_RINGI,
                    "restapi.error.param.data.reference",
                    String.valueOf(rngSid),
                    new GsMessage(ctx.getRequestModel())
                    .getMessage("main.useddisk.rng.rndata")
            );
        }

        //申請ID手入力可能チェック
        if (entryIdInputKanouFlg__ == RngConst.RAR_SINSEI_MANUAL_KYOKA) {
            RngBiz rngBiz = new RngBiz(ctx.getCon());
            RngAconfModel aconfMdl = rngBiz.getRngAconf(ctx.getCon());
            if (aconfMdl.getRarRngid() == RngConst.RAR_SINSEI_NONE) {
                //申請IDを使用しない
                throw new RestApiValidateException(
                    EnumError.PARAM_OTHER_INVALID,
                        "error.manual.input.auth",
                        "entryIdInputKanouFlg",
                        "entryIdText"
                );
            }

            RingiIdModel idModel = rngBiz.getRngidModel(rtpMdl.getRtpIdformatSid());
            if (restapiBiz.getSinseiIdInputKanouFlg(idModel, rtpMdl)
                    != RngConst.RNG_API_SINSEI_MANUAL_KYOKA) {
                //申請IDの手入力権限がない
                throw new RestApiValidateException(
                    EnumError.PARAM_OTHER_INVALID,
                        "error.manual.input.auth",
                        "entryIdInputKanouFlg",
                        "entryIdText"
                );
            }

            //申請IDフォーマットチェック
            errors = RngValidate.validateCmnFieldText(
                    errors,
                    "entryIdText",
                    entryIdText__,
                    "entryIdText",
                    RngConst.MAX_LENGTH_RINGI_ID,
                    true);
            if (errors.size() > 0) {
                //申請IDの入力に誤りがある
                List<ActionMessageModel> messageModelList = messageBiz.getMessageKeyValue(errors);
                StringBuilder sb = new StringBuilder();
                for (ActionMessageModel messageModel : messageModelList) {
                    if (sb.length() > 0) {
                        sb.append("\r\n");
                    }
                    sb.append(msgRes.getMessage(messageModel.getKey(), messageModel.getValues()));
                }
                throw new RestApiValidateException(
                    EnumError.PARAM_OTHER_INVALID,
                        "errors.free.msg",
                        sb.toString()
                );
            }
            //申請ID重複チェック
            if (!rngBiz.chkOverRapErrorRngId(entryIdText__, rngSid)) {
                throw new RestApiValidateException(
                    EnumError.PARAM_OTHER_INVALID,
                        "error.double.timezone",
                        "entryIdText",
                        gsMsg.getMessage("rng.rng180.04")
                );
            }
        }

        //申請内容入力チェック
        rngApiBiz.checkBodyInfo(
            formInputBuilder, bodyArray__, rngSid, rtpMdl,
            tempPathMdl, EnumRngEntitiesType.entry, false, ctx);
    }
}
