package jp.groupsession.v2.rng.restapi.entities.templates;

import java.sql.SQLException;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.co.sjts.util.io.IOToolsException;
import jp.groupsession.v2.cmn.model.GSTemporaryPathModel;
import jp.groupsession.v2.restapi.controller.AbstractRestApiAction;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.controller.annotation.Get;
import jp.groupsession.v2.restapi.controller.annotation.Plugin;
import jp.groupsession.v2.restapi.response.RestApiResponseWriter;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.RtpNotfoundException;

/**
 * <br>[機  能] 稟議 申請情報取得API(新規申請) アクションクラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author  JTS
 */
@Plugin(RngConst.PLUGIN_ID_RINGI)
public class RngEntitiesTemplatesAction extends AbstractRestApiAction {

    /** ロギングクラス */
    private static Log log__ = LogFactory.getLog(RngEntitiesTemplatesAction.class);

    /**
     * <br>[機  能] GETメソッド
     * <br>[解  説] 稟議RestAPI「稟議申請情報を取得する」
     * <br>[備  考] 新規申請に対応している
     *
     * @param res レスポンス
     * @param param パラメータ
     * @param ctx コンテキスト
     * @param tempPath GSTemporaryPathModel
     * @throws SQLException SQL実行時例外
     * @throws RtpNotfoundException 対象の稟議テンプレートが存在しない
     * @throws IOToolsException 稟議フォーム情報生成時に例外発生
     */
    @Get
    public void doGet(
            HttpServletResponse res,
            RngEntitiesTemplatesGetParamModel param,
            RestApiContext ctx,
            GSTemporaryPathModel tempPath)
        throws SQLException, RtpNotfoundException, IOToolsException {

        log__.info("稟議 稟議申請情報を取得する(新規申請)RESTAPIの開始");
        RngEntitiesTemplatesGetBiz biz = new RngEntitiesTemplatesGetBiz(param, ctx, tempPath);
        biz.execute();
        log__.info("稟議 稟議詳細情報取得完了");

        RestApiResponseWriter.builder(res, ctx)
            .addResult(biz.getResult())
            .build().execute();
        log__.info("稟議 稟議申請情報を取得する(新規申請)RESTAPIのレスポンス完了");
    }


}

