package jp.groupsession.v2.rng.restapi.entities.templates;

import java.sql.Connection;
import java.sql.SQLException;

import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.RestApiPermissionException;
import jp.groupsession.v2.restapi.msg.RestApiGsMessage;
import jp.groupsession.v2.restapi.parameter.annotation.ParamModel;
import jp.groupsession.v2.restapi.parameter.annotation.Validator;
import jp.groupsession.v2.rng.RtpNotfoundException;
import jp.groupsession.v2.rng.biz.RngFormBuildBiz;
import jp.groupsession.v2.rng.biz.RngTemplateBiz;
import jp.groupsession.v2.rng.model.RngTemplateModel;
import jp.groupsession.v2.rng.restapi.RngEnumReasonCode;

/**
 *
 * <br>[機  能] 稟議 申請情報取得(新規申請)API パラメータモデル
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
@ParamModel
public class RngEntitiesTemplatesGetParamModel {
    /** テンプレートSID */
    private int templateSid__ = 0;

    /**
     * @return the templateSid
     */
    public int getTemplateSid() {
        return templateSid__;
    }

    /**
     * @param templateSid the templateSid to set
     */
    public void setTemplateSid(int templateSid) {
        templateSid__ = templateSid;
    }

    /**
     * <br>[機  能] 入力チェックを実行する
     * <br>[解  説]
     * <br>[備  考]
     * @param ctx RestApiコンテキスト
     * @throws RtpNotfoundException
     */
    @Validator
    public void validate(RestApiContext ctx)
        throws SQLException, RtpNotfoundException {

        RngTemplateModel rtpMdl = __getRngTemplateModel(ctx);

        //指定したテンプレートを参照可能かをチェック
        boolean canUseTemplate = __canUseTemplate(ctx, rtpMdl);
        if (!canUseTemplate) {
            throw new RestApiPermissionException(
                RngEnumReasonCode.RESOURCE_CANT_ACCESS_TEMPLATE,
                    "error.no.access.data",
                    new RestApiGsMessage()
                        .getMessage("main.useddisk.rng.template")
            );
        }
    }

    /**
     * <br>[機  能] テンプレート情報を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param ctx RestApiコンテキスト
     * @return テンプレート情報
     * @throws RtpNotfoundException
     */
    private RngTemplateModel __getRngTemplateModel(RestApiContext ctx) throws SQLException {
        //指定したテンプレートを参照可能かをチェック
        RequestModel reqMdl = ctx.getRequestModel();
        Connection con = ctx.getCon();
        RngFormBuildBiz formBiz = new RngFormBuildBiz(reqMdl);

        RngTemplateModel rtpMdl = null;
        try {
            rtpMdl = formBiz.getRtpModelMaxVer(con, templateSid__);
        } catch (RtpNotfoundException e) {
            //指定したテンプレートが見つからない場合は、rtpMdlをnullのままにしておく
            rtpMdl = null;
        }
        return rtpMdl;
    }

    /**
     * <br>[機  能] テンプレートが使用可能をチェックする
     * <br>[解  説]
     * <br>[備  考]
     * @param ctx RestApiコンテキスト
     * @param rtpMdl テンプレート情報
     * @return true:使用可能 false:使用不可
     * @throws SQLException
     */
    private boolean __canUseTemplate(
        RestApiContext ctx, RngTemplateModel rtpMdl) throws SQLException {
        RequestModel reqMdl = ctx.getRequestModel();
        Connection con = ctx.getCon();

        RngTemplateBiz rtpBiz = new RngTemplateBiz();
        boolean canUseTemplate = rtpBiz.isUseableTemplate(rtpMdl, reqMdl, con);

        return canUseTemplate;
    }

}
