package jp.groupsession.v2.rng.restapi.entities.templates.keiro;

import java.sql.SQLException;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.co.sjts.util.EnumUtil.EnumOutRangeException;
import jp.co.sjts.util.encryption.EncryptionException;
import jp.co.sjts.util.io.IOToolsException;
import jp.groupsession.v2.cmn.model.GSTemporaryPathModel;
import jp.groupsession.v2.restapi.controller.AbstractRestApiAction;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.controller.annotation.Post;
import jp.groupsession.v2.restapi.response.RestApiResponseWriter;
import jp.groupsession.v2.rng.RtpNotfoundException;

/**
 * <br>[機  能]
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author  JTS
 */
public class RngEntitiesTemplatesKeiroAction extends AbstractRestApiAction {


    /** ロギングクラス */
    private static Log log__ = LogFactory.getLog(RngEntitiesTemplatesKeiroAction.class);

    /**
     * <br>[機  能] POSTメソッド
     * <br>[解  説] 稟議RestAPI「稟議申請情報を取得する」
     * <br>[備  考] 新規申請に対応している
     *
     * @param res レスポンス
     * @param param パラメータ
     * @param ctx コンテキスト
     * @param tempPath GSTemporaryPathModel
     * @throws SQLException SQL実行時例外
     * @throws RtpNotfoundException 対象の稟議テンプレートが存在しない
     * @throws IOToolsException 稟議フォーム情報生成時に例外発生
     * @throws EnumOutRangeException
     * @throws EncryptionException
     */
    @Post
    public void doPost(
            HttpServletResponse res,
            RngEntitiesTemplatesKeiroGetParamModel param,
            RestApiContext ctx,
            GSTemporaryPathModel tempPath)
        throws SQLException, RtpNotfoundException,
        IOToolsException, EnumOutRangeException, EncryptionException {

        log__.info("稟議 稟議申請経路情報を取得する(新規申請)RESTAPIの開始");
        RngEntitiesTemplatesKeiroGetBiz biz =
            new RngEntitiesTemplatesKeiroGetBiz(param, ctx, tempPath);
        biz.execute();
        log__.info("稟議 稟議申請経路情報取得完了");

        RestApiResponseWriter.builder(res, ctx)
            .addResult(biz.getResult())
            .build().execute();
        log__.info("稟議 稟議申請経路情報を取得する(新規申請)RESTAPIのレスポンス完了");
    }
}
