package jp.groupsession.v2.rng.restapi.entities.templates.keiro;

import java.sql.Connection;
import java.sql.SQLException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.co.sjts.util.EnumUtil.EnumOutRangeException;
import jp.co.sjts.util.encryption.EncryptionException;
import jp.co.sjts.util.io.IOToolsException;
import jp.groupsession.v2.cmn.formbuilder.FormInputBuilder;
import jp.groupsession.v2.cmn.model.GSTemporaryPathModel;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.rng.RtpNotfoundException;
import jp.groupsession.v2.rng.biz.RngFormBuildBiz;
import jp.groupsession.v2.rng.model.RngTemplateModel;
import jp.groupsession.v2.rng.restapi.RngRestapiBiz;
import jp.groupsession.v2.rng.restapi.entities.RngEntitiesDeleteBiz;
import jp.groupsession.v2.rng.restapi.model.RngRestApiRingiSinseiModel;

/**
 * <br>[機  能]
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author  JTS
 */
public class RngEntitiesTemplatesKeiroGetBiz {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(RngEntitiesDeleteBiz.class);

    /** 実行結果*/
    private RngRestApiRingiSinseiModel result__ = null;
    /**
     * @return the result
     */
    public RngRestApiRingiSinseiModel getResult() {
        return result__;
    }
    /**
     * @param result the result to set
     */
    public void setResult(RngRestApiRingiSinseiModel result) {
        result__ = result;
    }

    /** リクエストパラメータ */
    private RngEntitiesTemplatesKeiroGetParamModel param__;

    /** コンテキスト */
    private RestApiContext ctx__;
    /** テンポラリディレクトリ */
    GSTemporaryPathModel tempPathModel__;

    /**
     * コンストラクタ
     * @param param リクエストパラメータ
     * @param ctx コンテキスト
     * @param tempPathModel テンポラリディレクトリ
     */
    public RngEntitiesTemplatesKeiroGetBiz(
        RngEntitiesTemplatesKeiroGetParamModel param,
        RestApiContext ctx,
        GSTemporaryPathModel tempPathModel) {
        param__ = param;
        ctx__ = ctx;
        tempPathModel__ = tempPathModel;
    }

    /**
     *
     * <br>[機  能] テンプレートから稟議申請情報を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @throws SQLException SQL実行時例外
     * @throws RtpNotfoundException
     * @throws IOToolsException
     * @throws EnumOutRangeException
     * @throws EncryptionException
     */
    public void execute() throws SQLException,
        RtpNotfoundException, IOToolsException, EnumOutRangeException, EncryptionException {

        log__.info("稟議申請経路情報を取得するAPI(新規申請) 実行");

        Connection con = ctx__.getCon();
        RequestModel reqMdl = ctx__.getRequestModel();
        RngFormBuildBiz formBiz = new RngFormBuildBiz(reqMdl);
        RngTemplateModel rtpMdl = formBiz.getRtpModelMaxVer(con, param__.getTemplateSid());

        RngRestapiBiz restapiBiz = new RngRestapiBiz();
        FormInputBuilder fb =  restapiBiz.createFormInputBuilder(
            param__.getTemplateSid(), param__.getBodyArray(), tempPathModel__, ctx__);

        //テンプレート，リクエストボディから申請内容情報と経路情報を取得
        result__ = restapiBiz.getRingiSinseiModelFromInput(
            ctx__, rtpMdl, fb, false, false, null, null);
        //リクエストボディに入力されているタイトルなどの基本情報を設定
        restapiBiz.setRingiBasicDataFromInput(ctx__, param__, rtpMdl, result__);
    }
}
