package jp.groupsession.v2.rng.restapi.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.struts.util.LabelValueBean;

import jp.groupsession.v2.cmn.formbuilder.FormAccesser;
import jp.groupsession.v2.cmn.formbuilder.FormInputBuilder;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.rng020.IRng020PeronalParam;
import jp.groupsession.v2.rng.rng020.Rng020KeiroBlock;

/**
 * <br>[機  能] 稟議申請用データを保持するモデル
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author  JTS
 */
public class RngRestapiRingiEntryModel implements IRng020PeronalParam {


    /** 稟議タイトル */
    private String rng020Title__ = null;
    /** 稟議テンプレートID*/
    private int rng020rtpSid__ = 0;
    /** テンプレートバージョン*/
    private int rng020rtpVer__ = 0;
    /** 経路テンプレートバージョン*/
    private int rng020rtpKeiroVersion__ = 0;

    /** 複写して申請 */
    private boolean rng020copyApply__ = false;
    /** フォーム入力要素 DBからのロード値*/
    private Map<FormAccesser, List<String>> rng020inputLoad__;

    /** 申請ID 使用フラグ 0：使用しない 1：使用する*/
    private int idUseFlg__ = 0;
    /** 申請ID */
    private String rng020ID__ = null;
    /** 発行予定申請ID */
    private String rng020PlanID__ = null;
    /** 申請ID タイトル */
    private String rng020IdTitle__ = null;
    /** 申請ID 手動入力フラグ 0:手入力変更しない 1:手入力変更する */
    private int rng020IdPrefManual__ = 0;
    /** 申請ID 手動入力 可能フラグ */
    private int idPrefManualEditable__ = 0;
    /** 読み込む経路テンプレートSID*/
    private int loadRctSid__ = 0;
    /** スクロール位置*/
    private int scrollY__;
    /** フォーム要素 */
    private FormInputBuilder rng020input__ = new FormInputBuilder();

    //表示項目

    /** 申請者 */
    private String rng020requestUser__ = null;
    /** 申請者 id*/
    private String rng020requestUserId__ = null;
    /** 申請者(選択) */
    private String rng020selectedRequestUserId__;
    /** 申請者(選択) ユーザ一覧 */
    private List<LabelValueBean> rng020selectedRequestUserList__;
    /** 申請者 グループ(選択) */
    private String rng020selectedRequestGroupId__;
    /** 申請者 グループ(選択) グループ一覧 */
    private List<LabelValueBean> rng020selectedRequestGroupList__;

    /** 作成日 */
    private String rng020createDate__ = null;

    /** 初期表示フラグ 0=初期 1=初期済み */
    private String rng020ScrollFlg__ = "0";
    /** 稟議テンプレート種類 */
    private int rng020rtpType__ = -1;
    /** テンプレート使用制限 */
    private int useTemplateFlg__ = -1;
    /** 個人経路テンプレート使用制限 */
    private int useKeiroTemplateFlg__ = -1;

    /**経路変更フラグ フォーム入力値によって変更があった場合のフラグ*/
    private int keiroAutoChanged__ = 0;
    /**テンプレート更新フラグ 草稿or複写で開いた稟議のテンプレートでバージョン判定(0:違いなし / 1:テンプレートバージョン違い / 2:経路バージョン違い / 3:両方違う) */
    private int rtpVerUpdated__ = 0;
    /**最終確認経路表示判定フラグ*/
    private int kakuninKeiroDspFlg__ = 0;
    /**複写用経路データ使用フラグ(個人テンプレート、汎用稟議テンプレート, 旧式テンプレートは使用しない)*/
    private boolean rng020useCopyKeiro__ = false;
    /** ボタン表示フラグ */
    private boolean rng020ButtonDsp__ = true;
    /** 決裁後アクションコメント */
    private String rng020ApiComment__;

    /** 稟議SID */
    private int rngSid__ = -1;
    /** 稟議テンプレートSID */
    private int rngSelectTplSid__ = 0;
    /** 経路設定 */
    private Map<Integer, Rng020KeiroBlock> rng020keiro__
        = new HashMap<Integer, Rng020KeiroBlock>();
    /** 最終確認設定 */
    private Map<Integer, Rng020KeiroBlock> rng020kakuninKeiro__
        = new HashMap<Integer, Rng020KeiroBlock>();
    /** 最終確認設定(非表示用) DBからのロード値*/
    private Map<Integer, Rng020KeiroBlock> rng020kakuninSvKeiro__
        = new HashMap<Integer, Rng020KeiroBlock>();

    /** 処理モード */
    private int rngCmdMode__ = RngConst.RNG_CMDMODE_ADD;

    /**
     * @return the rng020Title
     */
    public String getRng020Title() {
        return rng020Title__;
    }
    /**
     * @param rng020Title the rng020Title to set
     */
    public void setRng020Title(String rng020Title) {
        rng020Title__ = rng020Title;
    }
    /**
     * @return the rng020rtpSid
     */
    public int getRng020rtpSid() {
        return rng020rtpSid__;
    }
    /**
     * @param rng020rtpSid the rng020rtpSid to set
     */
    public void setRng020rtpSid(int rng020rtpSid) {
        rng020rtpSid__ = rng020rtpSid;
    }
    /**
     * @return the rng020rtpVer
     */
    public int getRng020rtpVer() {
        return rng020rtpVer__;
    }
    /**
     * @param rng020rtpVer the rng020rtpVer to set
     */
    public void setRng020rtpVer(int rng020rtpVer) {
        rng020rtpVer__ = rng020rtpVer;
    }
    /**
     * @return the rng020rtpKeiroVersion
     */
    public int getRng020rtpKeiroVersion() {
        return rng020rtpKeiroVersion__;
    }
    /**
     * @param rng020rtpKeiroVersion the rng020rtpKeiroVersion to set
     */
    public void setRng020rtpKeiroVersion(int rng020rtpKeiroVersion) {
        rng020rtpKeiroVersion__ = rng020rtpKeiroVersion;
    }
    /**
     * @return the rng020copyApply
     */
    public boolean isRng020copyApply() {
        return rng020copyApply__;
    }
    /**
     * @param rng020copyApply the rng020copyApply to set
     */
    public void setRng020copyApply(boolean rng020copyApply) {
        rng020copyApply__ = rng020copyApply;
    }
    /**
     * @return the rng020inputLoad
     */
    public Map<FormAccesser, List<String>> getRng020inputLoad() {
        return rng020inputLoad__;
    }
    /**
     * @param rng020inputLoad the rng020inputLoad to set
     */
    public void setRng020inputLoad(
            Map<FormAccesser, List<String>> rng020inputLoad) {
        rng020inputLoad__ = rng020inputLoad;
    }
    /**
     * @return the idUseFlg
     */
    public int getIdUseFlg() {
        return idUseFlg__;
    }
    /**
     * @param idUseFlg the idUseFlg to set
     */
    public void setIdUseFlg(int idUseFlg) {
        idUseFlg__ = idUseFlg;
    }
    /**
     * @return the rng020ID
     */
    public String getRng020ID() {
        return rng020ID__;
    }
    /**
     * @param rng020id the rng020ID to set
     */
    public void setRng020ID(String rng020id) {
        rng020ID__ = rng020id;
    }
    /**
     * @return the rng020PlanID
     */
    public String getRng020PlanID() {
        return rng020PlanID__;
    }
    /**
     * @param rng020PlanID the rng020PlanID to set
     */
    public void setRng020PlanID(String rng020PlanID) {
        rng020PlanID__ = rng020PlanID;
    }
    /**
     * @return the rng020IdTitle
     */
    public String getRng020IdTitle() {
        return rng020IdTitle__;
    }
    /**
     * @param rng020IdTitle the rng020IdTitle to set
     */
    public void setRng020IdTitle(String rng020IdTitle) {
        rng020IdTitle__ = rng020IdTitle;
    }
    /**
     * @return the rng020IdPrefManual
     */
    public int getRng020IdPrefManual() {
        return rng020IdPrefManual__;
    }
    /**
     * @param rng020IdPrefManual the rng020IdPrefManual to set
     */
    public void setRng020IdPrefManual(int rng020IdPrefManual) {
        rng020IdPrefManual__ = rng020IdPrefManual;
    }
    /**
     * @return the idPrefManualEditable
     */
    public int getIdPrefManualEditable() {
        return idPrefManualEditable__;
    }
    /**
     * @param idPrefManualEditable the idPrefManualEditable to set
     */
    public void setIdPrefManualEditable(int idPrefManualEditable) {
        idPrefManualEditable__ = idPrefManualEditable;
    }
    /**
     * @return the loadRctSid
     */
    public int getLoadRctSid() {
        return loadRctSid__;
    }
    /**
     * @param loadRctSid the loadRctSid to set
     */
    public void setLoadRctSid(int loadRctSid) {
        loadRctSid__ = loadRctSid;
    }
    /**
     * @return the scrollY
     */
    public int getScrollY() {
        return scrollY__;
    }
    /**
     * @param scrollY the scrollY to set
     */
    public void setScrollY(int scrollY) {
        scrollY__ = scrollY;
    }
    /**
     * @return the rng020input
     */
    public FormInputBuilder getRng020input() {
        return rng020input__;
    }
    /**
     * @param rng020input the rng020input to set
     */
    public void setRng020input(FormInputBuilder rng020input) {
        rng020input__ = rng020input;
    }
    /**
     * @return the rng020requestUser
     */
    public String getRng020requestUser() {
        return rng020requestUser__;
    }
    /**
     * @param rng020requestUser the rng020requestUser to set
     */
    public void setRng020requestUser(String rng020requestUser) {
        rng020requestUser__ = rng020requestUser;
    }
    /**
     * @return the rng020requestUserId
     */
    public String getRng020requestUserId() {
        return rng020requestUserId__;
    }
    /**
     * @param rng020requestUserId the rng020requestUserId to set
     */
    public void setRng020requestUserId(String rng020requestUserId) {
        rng020requestUserId__ = rng020requestUserId;
    }
    /**
     * @return the rng020selectedRequestUserId
     */
    public String getRng020selectedRequestUserId() {
        return rng020selectedRequestUserId__;
    }
    /**
     * @param rng020selectedRequestUserId the rng020selectedRequestUserId to set
     */
    public void setRng020selectedRequestUserId(String rng020selectedRequestUserId) {
        rng020selectedRequestUserId__ = rng020selectedRequestUserId;
    }
    /**
     * @return the rng020selectedRequestUserList
     */
    public List<LabelValueBean> getRng020selectedRequestUserList() {
        return rng020selectedRequestUserList__;
    }
    /**
     * @param rng020selectedRequestUserList the rng020selectedRequestUserList to set
     */
    public void setRng020selectedRequestUserList(
            List<LabelValueBean> rng020selectedRequestUserList) {
        rng020selectedRequestUserList__ = rng020selectedRequestUserList;
    }
    /**
     * @return the rng020selectedRequestGroupId
     */
    public String getRng020selectedRequestGroupId() {
        return rng020selectedRequestGroupId__;
    }
    /**
     * @param rng020selectedRequestGroupId the rng020selectedRequestGroupId to set
     */
    public void setRng020selectedRequestGroupId(
            String rng020selectedRequestGroupId) {
        rng020selectedRequestGroupId__ = rng020selectedRequestGroupId;
    }
    /**
     * @return the rng020selectedRequestGroupList
     */
    public List<LabelValueBean> getRng020selectedRequestGroupList() {
        return rng020selectedRequestGroupList__;
    }
    /**
     * @param rng020selectedRequestGroupList the rng020selectedRequestGroupList to set
     */
    public void setRng020selectedRequestGroupList(
            List<LabelValueBean> rng020selectedRequestGroupList) {
        rng020selectedRequestGroupList__ = rng020selectedRequestGroupList;
    }
    /**
     * @return the rng020createDate
     */
    public String getRng020createDate() {
        return rng020createDate__;
    }
    /**
     * @param rng020createDate the rng020createDate to set
     */
    public void setRng020createDate(String rng020createDate) {
        rng020createDate__ = rng020createDate;
    }
    /**
     * @return the rng020ScrollFlg
     */
    public String getRng020ScrollFlg() {
        return rng020ScrollFlg__;
    }
    /**
     * @param rng020ScrollFlg the rng020ScrollFlg to set
     */
    public void setRng020ScrollFlg(String rng020ScrollFlg) {
        rng020ScrollFlg__ = rng020ScrollFlg;
    }
    /**
     * @return the rng020rtpType
     */
    public int getRng020rtpType() {
        return rng020rtpType__;
    }
    /**
     * @param rng020rtpType the rng020rtpType to set
     */
    public void setRng020rtpType(int rng020rtpType) {
        rng020rtpType__ = rng020rtpType;
    }
    /**
     * @return the useTemplateFlg
     */
    public int getUseTemplateFlg() {
        return useTemplateFlg__;
    }
    /**
     * @param useTemplateFlg the useTemplateFlg to set
     */
    public void setUseTemplateFlg(int useTemplateFlg) {
        useTemplateFlg__ = useTemplateFlg;
    }
    /**
     * @return the useKeiroTemplateFlg
     */
    public int getUseKeiroTemplateFlg() {
        return useKeiroTemplateFlg__;
    }
    /**
     * @param useKeiroTemplateFlg the useKeiroTemplateFlg to set
     */
    public void setUseKeiroTemplateFlg(int useKeiroTemplateFlg) {
        useKeiroTemplateFlg__ = useKeiroTemplateFlg;
    }
    /**
     * @return the keiroAutoChanged
     */
    public int getKeiroAutoChanged() {
        return keiroAutoChanged__;
    }
    /**
     * @param keiroAutoChanged the keiroAutoChanged to set
     */
    public void setKeiroAutoChanged(int keiroAutoChanged) {
        keiroAutoChanged__ = keiroAutoChanged;
    }
    /**
     * @return the rtpVerUpdated
     */
    public int getRtpVerUpdated() {
        return rtpVerUpdated__;
    }
    /**
     * @param rtpVerUpdated the rtpVerUpdated to set
     */
    public void setRtpVerUpdated(int rtpVerUpdated) {
        rtpVerUpdated__ = rtpVerUpdated;
    }
    /**
     * @return the kakuninKeiroDspFlg
     */
    public int getKakuninKeiroDspFlg() {
        return kakuninKeiroDspFlg__;
    }
    /**
     * @param kakuninKeiroDspFlg the kakuninKeiroDspFlg to set
     */
    public void setKakuninKeiroDspFlg(int kakuninKeiroDspFlg) {
        kakuninKeiroDspFlg__ = kakuninKeiroDspFlg;
    }
    /**
     * @return the rng020useCopyKeiro
     */
    public boolean isRng020useCopyKeiro() {
        return rng020useCopyKeiro__;
    }
    /**
     * @param rng020useCopyKeiro the rng020useCopyKeiro to set
     */
    public void setRng020useCopyKeiro(boolean rng020useCopyKeiro) {
        rng020useCopyKeiro__ = rng020useCopyKeiro;
    }
    /**
     * @return the rng020ButtonDsp
     */
    public boolean isRng020ButtonDsp() {
        return rng020ButtonDsp__;
    }
    /**
     * @param rng020ButtonDsp the rng020ButtonDsp to set
     */
    public void setRng020ButtonDsp(boolean rng020ButtonDsp) {
        rng020ButtonDsp__ = rng020ButtonDsp;
    }
    /**
     * @return the rng020ApiComment
     */
    public String getRng020ApiComment() {
        return rng020ApiComment__;
    }
    /**
     * @param rng020ApiComment the rng020ApiComment to set
     */
    public void setRng020ApiComment(String rng020ApiComment) {
        rng020ApiComment__ = rng020ApiComment;
    }
    /**
     * @return the rngSid
     */
    public int getRngSid() {
        return rngSid__;
    }
    /**
     * @param rngSid the rngSid to set
     */
    public void setRngSid(int rngSid) {
        rngSid__ = rngSid;
    }
    /**
     * @return the rngSelectTplSid
     */
    public int getRngSelectTplSid() {
        return rngSelectTplSid__;
    }
    /**
     * @param rngSelectTplSid the rngSelectTplSid to set
     */
    public void setRngSelectTplSid(int rngSelectTplSid) {
        rngSelectTplSid__ = rngSelectTplSid;
    }
    /**
     * @return the rng020keiro
     */
    public Map<Integer, Rng020KeiroBlock> getRng020keiro() {
        return rng020keiro__;
    }
    /**
     * @param rng020keiro the rng020keiro to set
     */
    public void setRng020keiro(Map<Integer, Rng020KeiroBlock> rng020keiro) {
        rng020keiro__ = rng020keiro;
    }
    /**
     * @return the rng020kakuninKeiro
     */
    public Map<Integer, Rng020KeiroBlock> getRng020kakuninKeiro() {
        return rng020kakuninKeiro__;
    }
    /**
     * @param rng020kakuninKeiro the rng020kakuninKeiro to set
     */
    public void setRng020kakuninKeiro(
            Map<Integer, Rng020KeiroBlock> rng020kakuninKeiro) {
        rng020kakuninKeiro__ = rng020kakuninKeiro;
    }
    /**
     * @return the rng020kakuninSvKeiro
     */
    public Map<Integer, Rng020KeiroBlock> getRng020kakuninSvKeiro() {
        return rng020kakuninSvKeiro__;
    }
    /**
     * @param rng020kakuninSvKeiro the rng020kakuninSvKeiro to set
     */
    public void setRng020kakuninSvKeiro(
            Map<Integer, Rng020KeiroBlock> rng020kakuninSvKeiro) {
        rng020kakuninSvKeiro__ = rng020kakuninSvKeiro;
    }
    /**
     * <p>rng020keiro を取得します。
     * @return rng020keiro
     */
    public Map<Integer, Rng020KeiroBlock> getRng020keiroMap() {
        return rng020keiro__;
    }
    /**
     * <p>rng020keiro をセットします。
     * @param rng020keiro rng020keiro
     */
    public void setRng020keiroMap(Map<Integer, Rng020KeiroBlock> rng020keiro) {
        rng020keiro__ = rng020keiro;
    }
    /**
     * <p>rng020kakuninKeiro を取得します。
     * @return rng020kakuninKeiro
     */
    public Map<Integer, Rng020KeiroBlock> getRng020kakuninKeiroMap() {
        return rng020kakuninKeiro__;
    }
    /**
     * <p>rng020kakuninKeiro をセットします。
     * @param rng020kakuninKeiro rng020kakuninKeiro
     */
    public void setRng020kakuninKeiroMap(Map<Integer, Rng020KeiroBlock> rng020kakuninKeiro) {
        rng020kakuninKeiro__ = rng020kakuninKeiro;
    }
    /**
     * <p>rng020kakuninSvKeiro を取得します。
     * @return rng020kakuninSvKeiro
     */
    public Map<Integer, Rng020KeiroBlock> getRng020kakuninSvKeiroMap() {
        return rng020kakuninSvKeiro__;
    }
    /**
     * <p>rng020kakuninSvKeiro をセットします。
     * @param rng020kakuninSvKeiro rng020kakuninSvKeiro
     */
    public void setRng020kakuninSvKeiroMap(Map<Integer, Rng020KeiroBlock> rng020kakuninSvKeiro) {
        rng020kakuninSvKeiro__ = rng020kakuninSvKeiro;
    }
    /**
     * <p>rng020keiro を取得します。
     * @param sortNo 表示順
     * @return rng020keiro
     */
    public Rng020KeiroBlock getRng020keiro(String sortNo) {
        Integer sort = Integer.valueOf(sortNo);
        if (rng020keiro__.containsKey(sort)) {
            return rng020keiro__.get(sort);
        }
        Rng020KeiroBlock ret = new Rng020KeiroBlock();
        rng020keiro__.put(sort, ret);
        return ret;
    }
    /**
     * <p>rng020keiro をセットします。
     * @param sort 表示順
     * @param rng020keiro rng020keiro
     */
    public void setRng020keiro(Integer sort, Rng020KeiroBlock rng020keiro) {
        rng020keiro__.put(sort, rng020keiro);
    }
    /**
     * <p>rng020keiro をセットします。
     * @param rng020keiro rng020keiro
     * @return 追加したキー
     */
    public int putRng020keiro(Rng020KeiroBlock rng020keiro) {
        int max = 0;
        if (rng020keiro__.size() > 0) {
            //最終要素のキー値を取得する
            max = new ArrayList<Integer>(rng020keiro__.keySet()).get(rng020keiro__.size() - 1);
            max++;
        }
        setRng020keiro(max, rng020keiro);
        return max;

    }
    /**
     * <p>rng020kakuninKeiro を取得します。
     * @param sortNo 表示順
     * @return rng020kakuninKeiro
     */
    public Rng020KeiroBlock getRng020kakuninKeiro(String sortNo) {
        Integer sort = Integer.valueOf(sortNo);
        if (rng020kakuninKeiro__.containsKey(sort)) {
            return rng020kakuninKeiro__.get(sort);
        }
        Rng020KeiroBlock ret = new Rng020KeiroBlock();
        rng020kakuninKeiro__.put(sort, ret);
        return ret;
    }
    /**
     * <p>rng020kakuninKeiro をセットします。
     * @param sort 表示順
     * @param rng020kakuninKeiro rng020kakuninKeiro
     */
    public void setRng020kakuninKeiro(Integer sort, Rng020KeiroBlock rng020kakuninKeiro) {
        rng020kakuninKeiro__.put(sort, rng020kakuninKeiro);
    }
    /**
     * <p>rng020kakuninKeiro をセットします。
     * @param rng020kakuninKeiro rng020kakuninKeiro
     * @return 追加したキー
     */
    public int putRng020kakuninKeiro(Rng020KeiroBlock rng020kakuninKeiro) {
        int max = 0;
        if (rng020kakuninKeiro__.size() > 0) {
            //最終要素のキー値を取得する
            max = new ArrayList<Integer>(rng020kakuninKeiro__.keySet())
                    .get(rng020kakuninKeiro__.size() - 1);
            max++;
        }
        setRng020kakuninKeiro(max, rng020kakuninKeiro);
        return max;
    }
    /**
     * @return the rngCmdMode
     */
    public int getRngCmdMode() {
        return rngCmdMode__;
    }
    /**
     * @param rngCmdMode the rngCmdMode to set
     */
    public void setRngCmdMode(int rngCmdMode) {
        rngCmdMode__ = rngCmdMode;
    }
}
