package jp.groupsession.v2.rng.restapi.model.content;

import java.util.List;

import jp.groupsession.v2.cmn.formbuilder.EnumFormModelKbn;
import jp.groupsession.v2.restapi.response.annotation.ChildElementName;
import jp.groupsession.v2.rng.restapi.model.content.block.RngRestapiRingiBlockBodyRowArrayModel;
import jp.groupsession.v2.rng.restapi.model.content.block.RngRestapiRingiBlockRowArrayModel;

/**
 * <br>[機  能] 稟議 RESTAPI 稟議詳細情報 申請内容を保持するModel
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author  JTS
 */
public class RngRestapiRingiBodyContentModel {
    /** 種別 */
    private int formType__ = 0;

    /** 表要素 初期値情報を格納するパラメータであるか */
    private boolean isInitTableInfo__ = false;
    /** 申請用の添付ファイル情報か(添付ファイル要素ではない または 詳細情報取得時にfalse) */
    private boolean isApplyFileInfo__ = false;

    //--- ユーザ情報 ---
    /** ユーザID */
    private String userId__ = null;
    /** ユーザ名 */
    private String userName__ = null;
    /** ログイン停止フラグ */
    private int loginStopFlg__ = 0;
    /** ユーザ状態区分 */
    private int userDeleteFlg__ = 0;
    //--- ユーザ情報 ---

    //--- グループ情報 ---
    /** グループID */
    private String groupId__ = null;
    /** グループ名 */
    private String groupName__ = null;
    /** グループ状態区分 */
    private int groupDeleteFlg__ = 0;
    //--- グループ情報 ---

    //--- 添付ファイル ---
    /** バイナリSID */
    private long binSid__ = 0;
    /** ファイル名 */
    private String fileName__ = null;
    /** ファイルサイズ(Byte) */
    private long fileSizeByteNum__ = 0;
    /** ファイルインデックス */
    private int indexNum__ = -1;
    //--- 添付ファイル ---

    //--- block要素 ---
    /** 行要素 */
    @ChildElementName("rowInfo")
    private List<RngRestapiRingiBlockRowArrayModel> blockRowArray__ = null;

    //--- 表要素 ---
    /** ヘッダー */
    @ChildElementName("headerInfo")
    private List<RngRestapiRingiBlockRowArrayModel> headerArray__ = null;
    /** ボディ */
    @ChildElementName("bodyInfo")
    private List<RngRestapiRingiBlockBodyRowArrayModel> bodyArray__ = null;
    /** フッター */
    @ChildElementName("footerInfo")
    private List<RngRestapiRingiBlockRowArrayModel> footerArray__ = null;
    //--- 表要素 ---

    /**
     * コンストラクタ
     * @param formType フォーム種別
     */
    public RngRestapiRingiBodyContentModel(int formType) {
        formType__ = formType;
    }

    /**
     * コンストラクタ
     * @param formType フォーム種別
     * @param isInitTableInfo true:表要素 初期値情報を格納するパラメータである, false:表要素 初期値情報を格納するパラメータではない
     * @param isApplyFileInfo true:申請用の添付ファイル情報, false:申請用の添付ファイル情報ではない
     */
    public RngRestapiRingiBodyContentModel(
        int formType, boolean isInitTableInfo, boolean isApplyFileInfo) {
        formType__ = formType;
        isInitTableInfo__ = isInitTableInfo;
        isApplyFileInfo__ = isApplyFileInfo;
    }

    /**
     * @return the userId
     */
    public String getUserId() {
        return userId__;
    }
    /**
     * @param userId the userId to set
     */
    public void setUserId(String userId) {
        userId__ = userId;
    }
    /**
     * @return the userName
     */
    public String getUserName() {
        return userName__;
    }
    /**
     * @param userName the userName to set
     */
    public void setUserName(String userName) {
        userName__ = userName;
    }
    /**
     * @return the loginStopFlg
     */
    public int getLoginStopFlg() {
        return loginStopFlg__;
    }
    /**
     * @param loginStopFlg the loginStopFlg to set
     */
    public void setLoginStopFlg(int loginStopFlg) {
        loginStopFlg__ = loginStopFlg;
    }
    /**
     * @return the userDeleteFlg
     */
    public int getUserDeleteFlg() {
        return userDeleteFlg__;
    }
    /**
     * @param userDeleteFlg the userDeleteFlg to set
     */
    public void setUserDeleteFlg(int userDeleteFlg) {
        userDeleteFlg__ = userDeleteFlg;
    }
    /**
     * @return the groupId
     */
    public String getGroupId() {
        return groupId__;
    }
    /**
     * @param groupId the groupId to set
     */
    public void setGroupId(String groupId) {
        groupId__ = groupId;
    }
    /**
     * @return the groupName
     */
    public String getGroupName() {
        return groupName__;
    }
    /**
     * @param groupName the groupName to set
     */
    public void setGroupName(String groupName) {
        groupName__ = groupName;
    }
    /**
     * @return the groupDeleteFlg
     */
    public int getGroupDeleteFlg() {
        return groupDeleteFlg__;
    }
    /**
     * @param groupDeleteFlg the groupDeleteFlg to set
     */
    public void setGroupDeleteFlg(int groupDeleteFlg) {
        groupDeleteFlg__ = groupDeleteFlg;
    }
    /**
     * @return the binSid
     */
    public long getBinSid() {
        return binSid__;
    }
    /**
     * @param binSid the binSid to set
     */
    public void setBinSid(long binSid) {
        binSid__ = binSid;
    }
    /**
     * @return the fileName
     */
    public String getFileName() {
        return fileName__;
    }
    /**
     * @param fileName the fileName to set
     */
    public void setFileName(String fileName) {
        fileName__ = fileName;
    }
    /**
     * @return the fileSizeByteNum
     */
    public long getFileSizeByteNum() {
        return fileSizeByteNum__;
    }
    /**
     * @param fileSizeByteNum the fileSizeByteNum to set
     */
    public void setFileSizeByteNum(long fileSizeByteNum) {
        fileSizeByteNum__ = fileSizeByteNum;
    }
    /**
     * @return the indexNum
     */
    public int getIndexNum() {
        return indexNum__;
    }
    /**
     * @param indexNum the indexNum to set
     */
    public void setIndexNum(int indexNum) {
        indexNum__ = indexNum;
    }
    /**
     * @return the headerArray
     */
    public List<RngRestapiRingiBlockRowArrayModel> getHeaderArray() {
        return headerArray__;
    }
    /**
     * @param headerArray the headerArray to set
     */
    public void setHeaderArray(List<RngRestapiRingiBlockRowArrayModel> headerArray) {
        headerArray__ = headerArray;
    }
    /**
     * @return the bodyArray
     */
    public List<RngRestapiRingiBlockBodyRowArrayModel> getBodyArray() {
        return bodyArray__;
    }
    /**
     * @param bodyArray the bodyArray to set
     */
    public void setBodyArray(List<RngRestapiRingiBlockBodyRowArrayModel> bodyArray) {
        bodyArray__ = bodyArray;
    }
    /**
     * @return the footerArray
     */
    public List<RngRestapiRingiBlockRowArrayModel> getFooterArray() {
        return footerArray__;
    }
    /**
     * @param footerArray the footerArray to set
     */
    public void setFooterArray(List<RngRestapiRingiBlockRowArrayModel> footerArray) {
        footerArray__ = footerArray;
    }
    /**
     * @return the blockRowArray
     */
    public List<RngRestapiRingiBlockRowArrayModel> getBlockRowArray() {
        return blockRowArray__;
    }
    /**
     * @param blockRowArray the blockRowArray to set
     */
    public void setBlockRowArray(List<RngRestapiRingiBlockRowArrayModel> blockRowArray) {
        blockRowArray__ = blockRowArray;
    }
    /**
     * @return true: userIdを設定
     */
    public boolean canDisplayUserId() {
        return __isUserContent();
    }
    /**
     * @return true: userNameを設定
     */
    public boolean canDisplayUserName() {
        return __isUserContent();
    }
    /**
     * @return true: loginStopFlgを設定
     */
    public boolean canDisplayLoginStopFlg() {
        return __isUserContent();
    }
    /**
     * @return true: userDeleteFlgを設定
     */
    public boolean canDisplayUserDeleteFlg() {
        return __isUserContent();
    }
    /**
     * @return true: groupIdを設定
     */
    public boolean canDisplayGroupId() {
        return __isGroupContent();
    }
    /**
     * @return true: groupNameを設定
     */
    public boolean canDisplayGroupName() {
        return __isGroupContent();
    }
    /**
     * @return true: groupDeleteFlgを設定
     */
    public boolean canDisplayGroupDeleteFlg() {
        return __isGroupContent();
    }
    /**
     * @return true: binSidを設定
     */
    public boolean canDisplayBinSid() {
        return __isFileContent();
    }
    /**
     * @return true: fileNameを設定
     */
    public boolean canDisplayFileName() {
        return __isFileContent();
    }
    /**
     * @return true: fileSizeByteNumを設定
     */
    public boolean canDisplayFileSizeByteNum() {
        return __isFileContent();
    }
    /**
     * @return true: indexNumを設定
     */
    public boolean canDisplayIndexNum() {
        return __isFileContent() && isApplyFileInfo__;
    }
    /**
     * @return true: blockRowArrayを設定
     */
    public boolean canDisplayBlockRowArray() {
        return __isBlockContent();
    }
    /**
     * @return true: headerArrayを設定
     */
    public boolean canDisplayHeaderArray() {
        return __isBlocklistContent() && !isInitTableInfo__;
    }
    /**
     * @return true: bodyArrayを設定
     */
    public boolean canDisplayBodyArray() {
        return __isBlocklistContent();
    }
    /**
     * @return true: footerArrayを設定
     */
    public boolean canDisplayFooterArray() {
        return __isBlocklistContent() && !isInitTableInfo__;
    }

    /**
     * ユーザ情報関連の項目を出力するかを判定
     * @return true: 出力する
     */
    private boolean __isUserContent() {
        return formType__ == EnumFormModelKbn.user.getValue();
    }
    /**
     * グループ情報関連の項目を出力するかを判定
     * @return true: 出力する
     */
    private boolean __isGroupContent() {
        return formType__ == EnumFormModelKbn.group.getValue();
    }
    /**
     * 添付ファイル関連の項目を出力するかを判定
     * @return true: 出力する
     */
    private boolean __isFileContent() {
        return formType__ == EnumFormModelKbn.file.getValue();
    }
    /**
     * ブロック要素関連の項目を出力するかを判定
     * @return true: 出力する
     */
    private boolean __isBlockContent() {
        return formType__ == EnumFormModelKbn.block.getValue();
    }
    /**
     * 表要素関連の項目を出力するかを判定
     * @return true: 出力する
     */
    private boolean __isBlocklistContent() {
        return formType__ == EnumFormModelKbn.blocklist.getValue();
    }
}
