package jp.groupsession.v2.rng.restapi.templates.files;

import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.groupsession.v2.cmn.exception.TempFileException;
import jp.groupsession.v2.restapi.controller.AbstractRestApiAction;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.controller.annotation.Get;
import jp.groupsession.v2.restapi.controller.annotation.Plugin;
import jp.groupsession.v2.restapi.response.RestApiAttachementResponseWriter;
import jp.groupsession.v2.rng.RngConst;

/**
 * <br>[機  能] 稟議テンプレートの添付ファイルをダウンロードするAPI アクションクラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author  JTS
 */
@Plugin(RngConst.PLUGIN_ID_RINGI)
public class RngTemplatesFilesAction extends AbstractRestApiAction {

    /**
     * <br>[機  能] GETメソッド
     * <br>[解  説] 稟議RestAPI「稟議の添付ファイルをダウンロードする」
     * <br>[備  考]
     * @param req リクエスト
     * @param res レスポンス
     * @param param パラメータ
     * @param ctx コンテキスト
     * @throws SQLException SQL実行時例外
     * @throws TempFileException 添付ファイル情報の取得に失敗
     */
    @Get
    public void doGet(
        HttpServletRequest req,
        HttpServletResponse res,
        RngTemplatesFilesGetParamModel param,
        RestApiContext ctx) throws SQLException, TempFileException {

        //オペレーションログ出力
        RngTemplatesFilesGetBiz biz = new RngTemplatesFilesGetBiz(param, ctx);
        biz.outPutOpLog();

        //ファイルダウンロード処理
        RestApiAttachementResponseWriter.execute(res, req, ctx, param.getBinSid());
    }
}
