package jp.groupsession.v2.rng.restapi.templates.files;

import java.sql.Connection;
import java.sql.SQLException;

import jp.groupsession.v2.cmn.GSConstLog;
import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.exception.TempFileException;
import jp.groupsession.v2.cmn.model.base.CmnBinfModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.rng.dao.RngTemplateDao;
import jp.groupsession.v2.rng.model.RngTemplateModel;
import jp.groupsession.v2.rng.restapi.RngRestapiBiz;
import jp.groupsession.v2.struts.msg.GsMessage;

/**
 * <br>[機  能] 稟議テンプレートの添付ファイルをダウンロードするAPI ビジネスロジック
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author  JTS
 */
public class RngTemplatesFilesGetBiz {

    /** リクエストパラメータ */
    private RngTemplatesFilesGetParamModel param__;

    /** コンテキスト */
    private RestApiContext ctx__;
    /** DBコネクション */
    private Connection con__;

    /**
     * コンストラクタ
     * @param param リクエストパラメータ
     * @param ctx コンテキスト
     */
    public RngTemplatesFilesGetBiz(
        RngTemplatesFilesGetParamModel param,
        RestApiContext ctx) {
        param__ = param;
        ctx__ = ctx;
        con__ = ctx__.getCon();
    }

    /**
     * <br>[機  能] オペレーションログを出力する
     * <br>[解  説]
     * <br>[備  考]
     * @throws SQLException
     * @throws TempFileException
     */
    public void outPutOpLog() throws SQLException, TempFileException {

        GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());

        RngTemplateDao rtpDao = new RngTemplateDao(con__);
        RngTemplateModel rtpMdl = rtpDao.select(param__.getTemplateSid());
        CommonBiz cmnBiz = new CommonBiz();
        CmnBinfModel cbMdl = cmnBiz.getBinInfo(con__,
                                            Long.valueOf(param__.getBinSid()),
                                            ctx__.getRequestModel().getDomain());

        //操作
        String opCode = gsMsg.getMessage("cmn.download");

        //内容
        StringBuilder sb = new StringBuilder();
        //テンプレート名
        sb.append("[" + gsMsg.getMessage("rng.10") + "] " + rtpMdl.getRtpTitle());
        sb.append("\n");
        //ファイル名
        sb.append("[" + gsMsg.getMessage("cmn.file.name") + "] " + cbMdl.getBinFileName());
        sb.append("\n");

        //LOG_CODE
        String logCode = "binSid: " + param__.getBinSid();

        //オペレーションログ出力
        RngRestapiBiz biz = new RngRestapiBiz();
        biz.outPutLog(ctx__, GSConstLog.LEVEL_INFO, opCode, sb.toString(), logCode);
    }
}
