package jp.groupsession.v2.rng.restapi.templates.files;

import java.sql.Connection;
import java.sql.SQLException;

import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.RestApiPermissionException;
import jp.groupsession.v2.restapi.parameter.annotation.NotBlank;
import jp.groupsession.v2.restapi.parameter.annotation.ParamModel;
import jp.groupsession.v2.restapi.parameter.annotation.Validator;
import jp.groupsession.v2.rng.RtpNotfoundException;
import jp.groupsession.v2.rng.biz.RngFormBuildBiz;
import jp.groupsession.v2.rng.biz.RngTemplateBiz;
import jp.groupsession.v2.rng.dao.RngTemplateBinDao;
import jp.groupsession.v2.rng.model.RngTemplateModel;
import jp.groupsession.v2.rng.restapi.RngEnumReasonCode;
import jp.groupsession.v2.struts.msg.GsMessage;

/**
 * <br>[機  能] 稟議テンプレートの添付ファイルをダウンロードするAPI パラメータモデル
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author  JTS
 */
@ParamModel
public class RngTemplatesFilesGetParamModel {

    /** テンプレートSID */
    @NotBlank
    private int templateSid__ = 0;

    /** バイナリSID */
    @NotBlank
    private long binSid__ = 0;

    /**
     * @return the templateSid
     */
    public int getTemplateSid() {
        return templateSid__;
    }

    /**
     * @param templateSid the templateSid to set
     */
    public void setTemplateSid(int templateSid) {
        templateSid__ = templateSid;
    }

    /**
     * @return the binSid
     */
    public long getBinSid() {
        return binSid__;
    }

    /**
     * @param binSid the binSid to set
     */
    public void setBinSid(long binSid) {
        binSid__ = binSid;
    }

    /**
     * <br>[機  能] 入力チェックを実行する
     * <br>[解  説]
     * <br>[備  考]
     * @param ctx RestApiコンテキスト
     * @throws SQLException
     */
    @Validator
    public void validate(RestApiContext ctx) throws SQLException {

        RequestModel reqMdl = ctx.getRequestModel();
        Connection con = ctx.getCon();

        //稟議テンプレートSIDに0以下を指定した場合、エラー
        if (templateSid__ <= 0) {
            throw new RestApiPermissionException(
                RngEnumReasonCode.RESOURCE_CANT_ACCESS_TEMPLATE,
                    "error.no.access.data",
                    new GsMessage(ctx.getRequestModel())
                    .getMessage("rng.92")
            );
        }

        //稟議テンプレート情報取得
        RngFormBuildBiz formBiz = new RngFormBuildBiz(reqMdl);
        RngTemplateModel rtpMdl = null;
        try {
            rtpMdl = formBiz.getRtpModelMaxVer(con, templateSid__);
        } catch (RtpNotfoundException e) {
            //稟議テンプレートが存在しない場合、エラー
            throw new RestApiPermissionException(
                RngEnumReasonCode.RESOURCE_CANT_ACCESS_TEMPLATE,
                    "error.no.access.data",
                    new GsMessage(ctx.getRequestModel())
                    .getMessage("rng.92")
            );
        }

        //稟議テンプレートへのアクセス権限がない場合、エラー
        RngTemplateBiz rtpBiz = new RngTemplateBiz();
        if (!rtpBiz.isUseableTemplate(rtpMdl, reqMdl, con)) {
            throw new RestApiPermissionException(
                RngEnumReasonCode.RESOURCE_CANT_ACCESS_TEMPLATE,
                    "error.no.access.data",
                    new GsMessage(ctx.getRequestModel())
                    .getMessage("rng.92")
            );
        }

        //稟議テンプレートとバイナリSIDが紐づいていない場合、エラー
        RngTemplateBinDao rtbDao = new RngTemplateBinDao(con);
        if (!rtbDao.isCheckRngTemplateBin(templateSid__, binSid__)) {
            throw new RestApiPermissionException(
                RngEnumReasonCode.RESOURCE_CANT_ACCESS_TEMPLATE_FILE,
                    "error.no.access.data",
                    new GsMessage(ctx.getRequestModel())
                    .getMessage("cmn.attach.file")
            );
        }
    }
}
