package jp.groupsession.v2.rng.restapi.templates.forms.groups.query;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;

import jp.groupsession.v2.cmn.biz.GroupBiz;
import jp.groupsession.v2.cmn.dao.GroupDao;
import jp.groupsession.v2.cmn.dao.GroupModel;
import jp.groupsession.v2.cmn.model.base.CmnGroupmModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.dao.RngRndataDao;
import jp.groupsession.v2.rng.dao.RngTemplateDao;
import jp.groupsession.v2.rng.model.RngRndataModel;
import jp.groupsession.v2.rng.model.RngTemplateModel;

/**
 * <br>[機  能] 稟議 申請内容に選択できるグループを一覧取得するAPI ビジネスロジック
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class RngTemplatesFormsGroupsQueryBiz {

    /** 実行結果*/
    private List<RngTemplatesFormsGroupsQueryResultModel> result__ = new ArrayList<>();
    /** コンテキスト */
    private RestApiContext ctx__;
    /** DBコネクション */
    private Connection con__;
    /** パラメータモデル */
    private RngTemplatesFormsGroupsQueryParamModel param__;

    /** 対象JSONNode */
    private JsonNode jsonNode__ = null;
    /** 対象フォーム種別 */
    private String formType__ = null;
    /** デフォルトグループSID */
    private int defGroupSid__ = -1;


    /**
     * コンストラクタ
     * @param ctx コンテキスト
     * @param param パラメータモデル
     */
    public RngTemplatesFormsGroupsQueryBiz(
            RestApiContext ctx,
            RngTemplatesFormsGroupsQueryParamModel param) {
        ctx__ = ctx;
        con__ = ctx__.getCon();
        param__ = param;
    }

    /**
     *
     * <br>[機  能] 申請内容に選択できるグループを一覧取得する
     * <br>[解  説]
     * <br>[備  考]
     * @throws SQLException SQL実行時例外
     */
    public void execute() throws SQLException, JsonProcessingException, JsonMappingException {

        RngTemplateDao rtpDao = new RngTemplateDao(con__);
        RngTemplateModel rtpMdl = null;
        //テンプレート情報を取得
        if (param__.getRingiSid() > 0) {
            RngRndataDao rngDao = new RngRndataDao(con__);
            RngRndataModel rngMdl = rngDao.select(param__.getRingiSid());
            if (rngMdl != null) {
                rtpMdl = rtpDao.select(rngMdl.getRtpSid(), rngMdl.getRtpVer());
            }
        } else {
            //稟議テンプレートSIDから最新バージョンを取得
            rtpMdl = rtpDao.select(param__.getTemplateSid());
        }
        if (rtpMdl != null) {
            String templateForm = rtpMdl.getRtpForm();
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(templateForm);
            __searchForm(node, param__.getFormId());

            //対象のJSONNodeが存在する場合、対象を取得する
            if (jsonNode__ != null) {
                GroupBiz grpBiz = new GroupBiz();

                //デフォルトグループ取得
                GroupBiz gbiz = new GroupBiz();
                int defGroupSid = gbiz.getDefaultGroupSid(
                        ctx__.getRequestUserModel().getUsrsid(), con__);
                if (defGroupSid >= 0) {
                    defGroupSid__ = defGroupSid;
                }
                if (formType__.equals("group")
                        && jsonNode__.get("useSeigen").asInt()
                            == RngConst.RNG_USE_FORM_SELECTABLE) {
                    //制限対象を取得
                    Iterator<JsonNode> elements = jsonNode__.get("selectable").elements();
                    List<Integer> groupSidList = new ArrayList<Integer>();
                    while (elements.hasNext()) {
                        groupSidList.add(elements.next().asInt());
                    }
                    List<CmnGroupmModel> grpList = null;
                    grpList = grpBiz.getGroupTreeList(con__, groupSidList.stream()
                                                    .mapToInt(Integer::intValue)
                                                    .toArray());
                    for (CmnGroupmModel grpMdl : grpList) {
                        __addResult(grpMdl.getGrpSid(),
                                    grpMdl.getGrpId(),
                                    grpMdl.getGrpName());
                    }
                } else if (formType__.equals("user")
                            && jsonNode__.get("useSeigen").asInt() == 1) {

                    //制限対象を取得
                    Iterator<JsonNode> elements = jsonNode__.get("selectable").elements();
                    ArrayList<Integer> userSidList = new ArrayList<Integer>();
                    while (elements.hasNext()) {
                        userSidList.add(elements.next().asInt());
                    }
                    GroupDao gDao = new GroupDao(con__);
                    List<Integer> groupSidList = gDao.getUserGroup(userSidList);
                    List<CmnGroupmModel> grpList = null;
                    grpList = grpBiz.getGroupTreeList(con__, groupSidList.stream()
                                                    .mapToInt(Integer::intValue)
                                                    .toArray());
                    for (CmnGroupmModel grpMdl : grpList) {
                        __addResult(grpMdl.getGrpSid(),
                                    grpMdl.getGrpId(),
                                    grpMdl.getGrpName());
                    }
                } else if (formType__.equals("group") || formType__.equals("user")) {
                    //全件取得
                    ArrayList<GroupModel> grpList = null;
                    grpList = grpBiz.getGroupList(con__);
                    for (GroupModel grpMdl : grpList) {
                        __addResult(grpMdl.getGroupSid(),
                                    grpMdl.getGroupId(),
                                    grpMdl.getGroupName());
                    }
                }
            }
        }
    }

    /**
     * <br>[機  能] 指定したフォームIDが見つかるまで申請内容JSON内を検索する
     * <br>[解  説]
     * <br>[備  考]
     * @param node json情報
     * @param formId フォームID
     * @author JTS
     */
    private void __searchForm(JsonNode node, String formId) {
        __searchNode(node, formId);
        if (node.isObject() || node.isArray()) {
            Iterator<JsonNode> elements = node.elements();
            while (elements.hasNext()) {
                JsonNode childNode = elements.next();
                __searchForm(childNode, formId);
            }
        }
    }

    /**
     * <br>[機  能] 指定したフォームIDを取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param node json情報
     * @param formId フォームID
     * @author JTS
     */
    private void __searchNode(JsonNode node, String formId) {
        if (node.get("formID") == null || jsonNode__ != null) {
            return;
        }
        if (node.get("formID").asText().equals(formId)) {
            jsonNode__ = node.get("body");
            formType__ = node.get("type").asText();
        }
    }

    /**
     *
     * <br>[機  能] リザルトを追加する
     * <br>[解  説]
     * <br>[備  考]
     * @param id グループID
     * @param name グループ名
     * @param sid グループSID
     */
    private void __addResult(int sid, String id, String name) {
        RngTemplatesFormsGroupsQueryResultModel resultMdl
                = new RngTemplatesFormsGroupsQueryResultModel();
        resultMdl.setId(id);
        resultMdl.setName(name);
        if (sid == defGroupSid__) {
            resultMdl.setDefaultGrpFlg(1);
        } else {
            resultMdl.setDefaultGrpFlg(0);
        }
        result__.add(resultMdl);
    }

    /**
     *
     * <br>[機  能] 実行結果の取得
     * <br>[解  説]
     * <br>[備  考]
     * @return 実行結果
     */
    public List<RngTemplatesFormsGroupsQueryResultModel> getResult() {
        return result__;
    }

}
