package jp.groupsession.v2.rng.restapi.templates.forms.groups.query;

import java.sql.SQLException;
import java.util.Iterator;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;

import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.RestApiPermissionException;
import jp.groupsession.v2.restapi.exception.RestApiValidateException;
import jp.groupsession.v2.restapi.parameter.annotation.ParamModel;
import jp.groupsession.v2.restapi.parameter.annotation.Validator;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.RtpNotfoundException;
import jp.groupsession.v2.rng.biz.RngFormBuildBiz;
import jp.groupsession.v2.rng.biz.RngTemplateBiz;
import jp.groupsession.v2.rng.dao.RngRndataDao;
import jp.groupsession.v2.rng.model.RngRndataModel;
import jp.groupsession.v2.rng.model.RngTemplateModel;
import jp.groupsession.v2.rng.restapi.RngEnumReasonCode;
import jp.groupsession.v2.rng.rng030.Rng030Biz;
import jp.groupsession.v2.struts.msg.GsMessage;

/**
 * <br>[機  能] 稟議 申請内容に選択できるグループを一覧取得するAPI パラメータモデル
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
@ParamModel
public class RngTemplatesFormsGroupsQueryParamModel {

    /** テンプレートSID */
    private int templateSid__ = 0;

    /** 稟議SID */
    private int ringiSid__ = 0;

    /** フォームID */
    private String formId__;

    /**
     * @return the templateSid
     */
    public int getTemplateSid() {
        return templateSid__;
    }

    /**
     * @param templateSid the templateSid to set
     */
    public void setTemplateSid(int templateSid) {
        templateSid__ = templateSid;
    }

    /**
     * @return the ringiSid
     */
    public int getRingiSid() {
        return ringiSid__;
    }

    /**
     * @param ringiSid the ringiSid to set
     */
    public void setRingiSid(int ringiSid) {
        ringiSid__ = ringiSid;
    }

    /**
     * @return the formId
     */
    public String getFormId() {
        return formId__;
    }

    /**
     * @param formId the formId to set
     */
    public void setFormId(String formId) {
        formId__ = formId;
    }

    /** フォームID存在フラグ */
    private boolean formIdFoundFlg__ = false;
    /** フォーム種別 */
    private String formType__ = null;

    /**
     * <br>[機  能] 入力チェックを実行する
     * <br>[解  説]
     * <br>[備  考]
     * @param ctx RestApiコンテキスト
     */
    @Validator
    public void validate(RestApiContext ctx)
            throws SQLException, JsonProcessingException, JsonMappingException {
        //テンプレートを参照可能かをチェック
        RngFormBuildBiz formBiz = new RngFormBuildBiz(ctx.getRequestModel());
        RngTemplateModel rtpMdl = null;
        try {
            if (ringiSid__ > 0) {
                //稟議SIDからテンプレート取得
                RngRndataDao rngDao = new RngRndataDao(ctx.getCon());
                RngRndataModel rngMdl = rngDao.select(ringiSid__);
                if (rngMdl == null) {
                    //稟議が存在しない
                    throw new RestApiPermissionException(
                        RngEnumReasonCode.RESOURCE_CANT_ACCESS_RINGI,
                            "error.no.access.data",
                            new GsMessage(ctx.getRequestModel())
                            .getMessage("main.useddisk.rng.rndata")
                    );
                }
                //稟議へのアクセス権限がない
                Rng030Biz rng030Biz = new Rng030Biz(ctx.getCon(), ctx.getRequestModel());
                if (rngMdl.getRngStatus() == RngConst.RNG_STATUS_DRAFT
                    || (rngMdl.getRngStatus() != RngConst.RNG_STATUS_DRAFT
                    && !rng030Biz.chkViewRingi(ctx.getRequestUserSid(), ringiSid__))) {
                    throw new RestApiPermissionException(
                        RngEnumReasonCode.RESOURCE_CANT_ACCESS_RINGI,
                            "error.no.access.data",
                            new GsMessage(ctx.getRequestModel())
                            .getMessage("main.useddisk.rng.rndata")
                    );
                }
                rtpMdl = formBiz.getRtpModel(ctx.getCon(), rngMdl.getRtpSid(), rngMdl.getRtpVer());
            } else {
                //テンプレートSIDからテンプレート取得
                rtpMdl = formBiz.getRtpModelMaxVer(ctx.getCon(), templateSid__);
            }
        } catch (RtpNotfoundException e) {
            //テンプレートが存在しない
            if (ringiSid__ > 0) {
                throw new RestApiValidateException(
                    RngEnumReasonCode.PARAM_CANT_ACCESS_TEMPLATE,
                    "restapi.error.form.ringi.access.template",
                    "ringiSid"
                );
            } else {
                throw new RestApiPermissionException(
                    RngEnumReasonCode.RESOURCE_CANT_ACCESS_TEMPLATE,
                        "error.no.access.data",
                        new GsMessage(ctx.getRequestModel())
                        .getMessage("main.useddisk.rng.template")
                );
            }
        }

        RngTemplateBiz rtpBiz = new RngTemplateBiz();
        boolean canUseTemplate = rtpBiz.isUseableTemplate(
            rtpMdl, ctx.getRequestModel(), ctx.getCon());
        if (!canUseTemplate) {
            //テンプレートの使用権限がない
            if (ringiSid__ > 0) {
                throw new RestApiValidateException(
                    RngEnumReasonCode.PARAM_CANT_ACCESS_TEMPLATE,
                        "restapi.error.form.ringi.access.template",
                        "ringiSid"
                );
            } else {
                throw new RestApiPermissionException(
                    RngEnumReasonCode.RESOURCE_CANT_ACCESS_TEMPLATE,
                        "error.no.access.data",
                        new GsMessage(ctx.getRequestModel())
                        .getMessage("main.useddisk.rng.template")
                );
            }
        }

        //フォームIDが存在するかチェック
        String templateForm = rtpMdl.getRtpForm();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(templateForm);
        __searchForm(node, formId__);
        if (!formIdFoundFlg__) {
            //フォームIDが存在しない
            throw new RestApiPermissionException(
                RngEnumReasonCode.RESOURCE_CANT_ACCESS_FORMID,
                    "error.no.access.data",
                    new GsMessage(ctx.getRequestModel())
                    .getMessage("rng.rng110.31")
            );
        } else if (!formType__.equals("group")
                && !formType__.equals("user")) {
            //フォーム種別が「ユーザ選択」「グループ選択」以外
            StringBuffer msg = new StringBuffer();
            msg.append(new GsMessage(ctx.getRequestModel()).getMessage("rng.rng110.06"));
            msg.append(" または ");
            msg.append(new GsMessage(ctx.getRequestModel()).getMessage("rng.rng110.07"));
            throw new RestApiValidateException(
                RngEnumReasonCode.PARAM_SELECT_ERROR_FORM_TYPE,
                    "restapi.error.get.form.type",
                    "formId",
                    msg.toString()
            );
        }
    }

    /**
     * <br>[機  能] 指定したフォームIDが見つかるまで申請内容JSON内を検索する
     * <br>[解  説]
     * <br>[備  考]
     * @param node json情報
     * @param formId フォームID
     * @author JTS
     */
    private void __searchForm(JsonNode node, String formId) {
        __searchNode(node, formId);
        if (node.isObject() || node.isArray()) {
            Iterator<JsonNode> elements = node.elements();
            while (elements.hasNext()) {
                JsonNode childNode = elements.next();
                __searchForm(childNode, formId);
            }
        }
    }

    /**
     * <br>[機  能] 指定したフォームIDを取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param node json情報
     * @param formId フォームID
     * @author JTS
     */
    private void __searchNode(JsonNode node, String formId) {
        if (node.get("formID") == null || formIdFoundFlg__) {
            return;
        }
        if (node.get("formID").asText().equals(formId)) {
            formIdFoundFlg__ = true;
            formType__ = node.get("type").asText();
        }
    }
}
