package jp.groupsession.v2.rng.restapi.templates.forms.users.query;

import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;

import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.restapi.controller.AbstractRestApiAction;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.controller.annotation.Get;
import jp.groupsession.v2.restapi.controller.annotation.Plugin;
import jp.groupsession.v2.restapi.response.RestApiResponseWriter;

/**
 * <br>[機  能] 稟議 申請内容に選択できるユーザを一覧取得するAPI アクションクラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
@Plugin(GSConst.PLUGIN_ID_RINGI)
public class RngTemplatesFormsUsersQueryAction extends AbstractRestApiAction {
    /**
     *
     * <br>[機  能] 申請内容に選択できるユーザを一覧取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param res レスポンス
     * @param req リクエスト
     * @param param パラメータ
     * @param ctx コンテキスト
     */
    @Get
    public void doGet(
        HttpServletRequest req,
        HttpServletResponse res,
        RngTemplatesFormsUsersQueryParamModel param,
        RestApiContext ctx) throws SQLException, JsonProcessingException, JsonMappingException {

        RngTemplatesFormsUsersQueryBiz biz = new RngTemplatesFormsUsersQueryBiz(ctx, param);
        biz.execute();

        RestApiResponseWriter.builder(res, ctx)
        .addResultList(biz.getResult())
        .setMax(biz.getMaxCount())
        .build().execute();
    }

}
