package jp.groupsession.v2.rng.restapi.templates.forms.users.query;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;

import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.cmn.biz.UserBiz;
import jp.groupsession.v2.cmn.dao.UserSearchDao;
import jp.groupsession.v2.cmn.dao.base.CmnGroupmDao;
import jp.groupsession.v2.cmn.dao.base.CmnUsrmDao;
import jp.groupsession.v2.cmn.model.CmnUserModel;
import jp.groupsession.v2.cmn.model.base.CmnGroupmModel;
import jp.groupsession.v2.cmn.model.base.CmnUsrmInfModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.dao.RngRndataDao;
import jp.groupsession.v2.rng.dao.RngTemplateDao;
import jp.groupsession.v2.rng.model.RngRndataModel;
import jp.groupsession.v2.rng.model.RngTemplateModel;
import jp.groupsession.v2.usr.GSConstUser;

/**
 * <br>[機  能] 稟議 申請内容に選択できるユーザを一覧取得するAPI ビジネスロジック
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class RngTemplatesFormsUsersQueryBiz {

    /** 実行結果*/
    private List<RngTemplatesFormsUsersQueryResultModel> result__ = new ArrayList<>();
    /** 最大件数 */
    private int maxCnt__;
    /** コンテキスト */
    private RestApiContext ctx__;
    /** DBコネクション */
    private Connection con__;
    /** パラメータモデル */
    private RngTemplatesFormsUsersQueryParamModel param__;

    /** 対象JSONNode */
    private JsonNode jsonNode__ = null;
    /** 対象フォーム種別 */
    private String formType__ = null;


    /**
     * コンストラクタ
     * @param ctx コンテキスト
     * @param param パラメータモデル
     */
    public RngTemplatesFormsUsersQueryBiz(
            RestApiContext ctx,
            RngTemplatesFormsUsersQueryParamModel param) {
        ctx__ = ctx;
        con__ = ctx__.getCon();
        param__ = param;
    }

    /**
     *
     * <br>[機  能] 申請内容に選択できるユーザを一覧取得する
     * <br>[解  説]
     * <br>[備  考]
     * @throws SQLException SQL実行時例外
     */
    public void execute() throws SQLException, JsonProcessingException, JsonMappingException {

        RngTemplateDao rtpDao = new RngTemplateDao(con__);
        RngTemplateModel rtpMdl = null;
        //テンプレート情報を取得
        if (param__.getRingiSid() > 0) {
            RngRndataDao rngDao = new RngRndataDao(con__);
            RngRndataModel rngMdl = rngDao.select(param__.getRingiSid());
            if (rngMdl != null) {
                rtpMdl = rtpDao.select(rngMdl.getRtpSid(), rngMdl.getRtpVer());
            }
        } else {
            //稟議テンプレートSIDから最新バージョンを取得
            rtpMdl = rtpDao.select(param__.getTemplateSid());
        }
        if (rtpMdl != null) {
            String templateForm = rtpMdl.getRtpForm();
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(templateForm);
            __searchForm(node, param__.getFormId());

            //対象のJSONNodeが存在する場合、対象を取得する
            if (jsonNode__ != null && formType__.equals("user")) {
                List<Integer> userSidList = new ArrayList<Integer>();
                if (param__.getGroupId() != null) {
                    //groupIdからgroupSid取得
                    CmnGroupmDao gDao = new CmnGroupmDao(con__);
                    CmnGroupmModel gMdl = gDao.getGroupInf(param__.getGroupId());
                    if (gMdl != null) {
                        //該当グループの所属ユーザ一覧取得
                        UserBiz uBiz = new UserBiz();
                        ArrayList<CmnUsrmInfModel> groupUserList = uBiz.getBelongUserList(
                                                                        con__, gMdl.getGrpSid(),
                                                                        null);
                        userSidList = groupUserList.stream()
                                            .filter(mdl ->
                                                mdl.getUsrSid() > GSConstUser.USER_RESERV_SID)
                                            .map(mdl -> mdl.getUsrSid())
                                            .collect(Collectors.toList());
                    }
                } else {
                    //全ユーザを取得
                    CmnUsrmDao cumDao = new CmnUsrmDao(con__);
                    userSidList = cumDao.getUsrAll().stream()
                                        .filter(mdl -> mdl.getUsrJkbn() == GSConst.JTKBN_TOROKU
                                            && mdl.getUsrSid() > GSConstUser.USER_RESERV_SID)
                                        .map(mdl -> mdl.getUsrSid())
                                        .collect(Collectors.toList());
                }
                if (jsonNode__.get("useSeigen").asInt() == RngConst.RNG_USE_FORM_SELECTABLE) {
                    //制限されたユーザ情報を取得
                    Iterator<JsonNode> elements = jsonNode__.get("selectable").elements();
                    ArrayList<Integer> selectableSidList = new ArrayList<Integer>();
                    while (elements.hasNext()) {
                        int selectableUserSid = elements.next().asInt();
                        if (userSidList.contains(selectableUserSid)) {
                            selectableSidList.add(selectableUserSid);
                        }
                    }
                    userSidList = selectableSidList;
                }

                //取得したユーザの件数を取得
                CmnUsrmDao cumDao = new CmnUsrmDao(con__);
                maxCnt__ = cumDao.getCountActiveUser(userSidList);

                //「OFFSET < 件数」の場合、LIMIT/OFFSETを元に取得したユーザの詳細情報を取得
                if (param__.getOffset() < maxCnt__) {
                    UserSearchDao usDao = new UserSearchDao(con__);
                    List<CmnUserModel> usrList
                        = usDao.getUsersDataList(
                            userSidList,
                            true,
                            param__.getLimit(),
                            param__.getOffset());

                    //結果モデルにセット
                    for (CmnUserModel usrMdl : usrList) {
                        RngTemplatesFormsUsersQueryResultModel resultMdl
                            = new RngTemplatesFormsUsersQueryResultModel();
                        resultMdl.setUserId(usrMdl.getUsrLgid());
                        resultMdl.setUserName(usrMdl.getUsiName());
                        resultMdl.setLoginStopFlg(usrMdl.getUsrUkoFlg());
                        if (usrMdl.getUsrJkbn() == GSConst.JTKBN_TOROKU) {
                            resultMdl.setUserDeleteFlg(0);
                        } else {
                            resultMdl.setUserDeleteFlg(1);
                        }
                        result__.add(resultMdl);
                    }
                }
            }
        }
    }

    /**
     * <br>[機  能] 指定したフォームIDが見つかるまで申請内容JSON内を検索する
     * <br>[解  説]
     * <br>[備  考]
     * @param node json情報
     * @param formId フォームID
     * @author JTS
     */
    private void __searchForm(JsonNode node, String formId) {
        __searchNode(node, formId);
        if (node.isObject() || node.isArray()) {
            Iterator<JsonNode> elements = node.elements();
            while (elements.hasNext()) {
                JsonNode childNode = elements.next();
                __searchForm(childNode, formId);
            }
        }
    }

    /**
     * <br>[機  能] 指定したフォームIDを取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param node json情報
     * @param formId フォームID
     * @author JTS
     */
    private void __searchNode(JsonNode node, String formId) {
        if (node.get("formID") == null || jsonNode__ != null) {
            return;
        }
        if (node.get("formID").asText().equals(formId)) {
            jsonNode__ = node.get("body");
            formType__ = node.get("type").asText();
        }
    }

    /**
     *
     * <br>[機  能] 実行結果の取得
     * <br>[解  説]
     * <br>[備  考]
     * @return 実行結果
     */
    public List<RngTemplatesFormsUsersQueryResultModel> getResult() {
        return result__;
    }

    /**
     * <br>[機  能] 最大件数の取得
     * <br>[解  説]
     * <br>[備  考]
     * @return 最大件数
     * @throws SQLException
     */
    public int getMaxCount() throws SQLException {
        return maxCnt__;
    }

}
