package jp.groupsession.v2.rng.restapi.templates.query;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.biz.RngBiz;
import jp.groupsession.v2.rng.model.RngAconfModel;
import jp.groupsession.v2.rng.model.RngTemplateCategoryModel;
import jp.groupsession.v2.rng.model.RngTemplateModel;

/**
 * <br>[機  能] 稟議 稟議テンプレートを一覧取得するAPI ビジネスロジック
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class RngTemplatesQueryBiz {

    /** 実行結果*/
    private List<RngTemplatesQueryResultModel> result__ = new ArrayList<>();
    /** コンテキスト */
    private RestApiContext ctx__;
    /** DBコネクション */
    private Connection con__;
    /** パラメータモデル */
    private RngTemplatesQueryParamModel param__;

    /**
     * コンストラクタ
     * @param ctx コンテキスト
     * @param param パラメータモデル
     */
    public RngTemplatesQueryBiz(RestApiContext ctx, RngTemplatesQueryParamModel param) {
        ctx__ = ctx;
        con__ = ctx__.getCon();
        param__ = param;
    }

    /**
     *
     * <br>[機  能] 稟議テンプレートを一覧取得する
     * <br>[解  説]
     * <br>[備  考]
     * @throws SQLException SQL実行時例外
     */
    public void execute() throws SQLException {

        RngBiz biz = new RngBiz(con__);
        ArrayList<RngTemplateCategoryModel> categoryList = null;
        ArrayList<RngTemplateModel> templateList  = null;
        int selectRtcSid = RngConst.RNG_RTC_SID_NONE;
        RngAconfModel aconfMdl = biz.getRngAconf(con__);
        if (param__.getCategorySearchType() == RngConst.RNG_API_SEARCH_RTC_ALL) {
            //全て
            selectRtcSid = RngConst.RNG_RTC_SID_ALL;
        } else if (param__.getCategorySearchType() == RngConst.RNG_API_SEARCH_RTC_NONE) {
            //カテゴリなし
        } else if (param__.getCategorySearchType() == RngConst.RNG_API_SEARCH_RTC_SID) {
            //カテゴリSIDを指定
            selectRtcSid = param__.getCategorySid();
        }

        //管理者権限を取得
        CommonBiz cmnBiz = new CommonBiz();
        boolean isAdmin
            = cmnBiz.isPluginAdmin(con__, ctx__.getRequestUserModel(), RngConst.PLUGIN_ID_RINGI);

        //共有テンプレート
        if (param__.getTemplateType() == RngConst.RNG_TEMPLATE_ALL
                || param__.getTemplateType() == RngConst.RNG_TEMPLATE_SHARE
                || param__.getCategorySearchType() == RngConst.RNG_API_SEARCH_RTC_SID) {
            //共有カテゴリを取得する
            categoryList = biz.getTemplateCategoryList(RngConst.RNG_TEMPLATE_SHARE,
                                                    ctx__.getRequestUserSid(),
                                                    isAdmin, RngConst.RTPLIST_MOKUTEKI_USE);
            //共有テンプレートを取得する
            templateList  = biz.getTemplateList(ctx__.getRequestModel(),
                                                    RngConst.RNG_TEMPLATE_SHARE,
                                                    categoryList, selectRtcSid,
                                                    isAdmin, RngConst.RTPLIST_MOKUTEKI_USE);

            //リザルト追加
            addResult(categoryList, templateList,
                aconfMdl.getRarHanyoFlg() == RngConst.RAR_HANYO_FLG_YES);
        }

        //個人テンプレート
        if (aconfMdl.getRarTemplatePersonalFlg() == RngConst.RAR_TEMPLATE_PERSONAL_FLG_YES
                && (param__.getTemplateType() == RngConst.RNG_TEMPLATE_ALL
                || param__.getTemplateType() == RngConst.RNG_TEMPLATE_PRIVATE
                || param__.getCategorySearchType() == RngConst.RNG_API_SEARCH_RTC_SID)) {
            //個人カテゴリを取得する
            categoryList = biz.getTemplateCategoryList(RngConst.RNG_TEMPLATE_PRIVATE,
                                                    ctx__.getRequestUserSid(),
                                                    true, RngConst.RTPLIST_MOKUTEKI_USE);
            //個人テンプレートを取得する
            templateList  = biz.getTemplateList(ctx__.getRequestModel(),
                                                    RngConst.RNG_TEMPLATE_PRIVATE,
                                                    categoryList, selectRtcSid,
                                                    true, RngConst.RTPLIST_MOKUTEKI_USE);

            //リザルト追加
            addResult(categoryList, templateList, false);
        }
    }

    /**
     *
     * <br>[機  能] リザルト追加
     * <br>[解  説]
     * <br>[備  考]
     * @param categoryList カテゴリリスト
     * @param templateList テンプレートリスト
     * @param hanyoFlg 汎用稟議テンプレート使用フラグ
     */
    public void addResult(ArrayList<RngTemplateCategoryModel> categoryList,
                            ArrayList<RngTemplateModel> templateList,
                            boolean hanyoFlg) {

        //カテゴリSIDとカテゴリ名のMap作成
        Map<Integer, String> categoryMap = categoryList.stream()
                                                .collect(Collectors.toMap(
                                                    m -> m.getRtcSid(),
                                                    m -> (String) m.getRtcName()));

        for (RngTemplateModel templateModel : templateList) {
            if (templateModel.getRtpSid() == 0
                && !hanyoFlg) {
                //汎用稟議テンプレートを使用しない場合、スキップする
                continue;
            }
            RngTemplatesQueryResultModel resultModel = new RngTemplatesQueryResultModel();
            resultModel.setSid(templateModel.getRtpSid());
            resultModel.setType(templateModel.getRtpType());
            resultModel.setName(templateModel.getRtpTitle());
            resultModel.setCategorySid(templateModel.getRtcSid());
            resultModel.setCategoryName(categoryMap.get(templateModel.getRtcSid()));
            result__.add(resultModel);
        }
    }

    /**
     *
     * <br>[機  能] 実行結果の取得
     * <br>[解  説]
     * <br>[備  考]
     * @return 実行結果
     */
    public List<RngTemplatesQueryResultModel> getResult() {
        return result__;
    }

}
