package jp.groupsession.v2.rng.restapi.templates.query;

import java.sql.SQLException;
import java.util.ArrayList;

import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.EnumError;
import jp.groupsession.v2.restapi.exception.RestApiPermissionException;
import jp.groupsession.v2.restapi.exception.RestApiValidateException;
import jp.groupsession.v2.restapi.parameter.annotation.ParamModel;
import jp.groupsession.v2.restapi.parameter.annotation.Selectable;
import jp.groupsession.v2.restapi.parameter.annotation.Validator;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.biz.RngBiz;
import jp.groupsession.v2.rng.dao.RngTemplateCategoryDao;
import jp.groupsession.v2.rng.dao.RngTemplatecategoryAdmDao;
import jp.groupsession.v2.rng.dao.RngTemplatecategoryUseDao;
import jp.groupsession.v2.rng.model.RngAconfModel;
import jp.groupsession.v2.rng.model.RngTemplateCategoryModel;
import jp.groupsession.v2.rng.restapi.RngEnumReasonCode;
import jp.groupsession.v2.struts.msg.GsMessage;

/**
 * <br>[機  能] 稟議 稟議テンプレートを一覧取得するAPI パラメータモデル
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
@ParamModel
public class RngTemplatesQueryParamModel {

    /** 稟議テンプレート対象種別 */
    @Selectable({"0", "1", "2"})
    private int templateType__ = 0;
    /** 稟議カテゴリ検索種別 */
    @Selectable({"0", "1", "2"})
    private int categorySearchType__ = 0;
    /** 稟議カテゴリSID */
    private int categorySid__ = -1;
    /**
     * @return the templateType
     */
    public int getTemplateType() {
        return templateType__;
    }
    /**
     * @param templateType the templateType to set
     */
    public void setTemplateType(int templateType) {
        templateType__ = templateType;
    }
    /**
     * @return the categorySearchType
     */
    public int getCategorySearchType() {
        return categorySearchType__;
    }
    /**
     * @param categorySearchType the categorySearchType to set
     */
    public void setCategorySearchType(int categorySearchType) {
        categorySearchType__ = categorySearchType;
    }
    /**
     * @return the categorySid
     */
    public int getCategorySid() {
        return categorySid__;
    }
    /**
     * @param categorySid the categorySid to set
     */
    public void setCategorySid(int categorySid) {
        categorySid__ = categorySid;
    }

    /**
     * <br>[機  能] 入力チェックを実行する
     * <br>[解  説]
     * <br>[備  考]
     * @param ctx RestApiコンテキスト
     */
    @Validator
    public void validate(RestApiContext ctx) throws SQLException {

        RngBiz biz = new RngBiz(ctx.getCon());
        RngAconfModel aconfMdl = biz.getRngAconf(ctx.getCon());

        // 検索種別 全て or カテゴリなし
        if (categorySearchType__ == RngConst.RNG_API_SEARCH_RTC_ALL
            || categorySearchType__ == RngConst.RNG_API_SEARCH_RTC_NONE) {
            // [RINGI-217] 個人カテゴリを指定したテンプレート取得時、個人テンプレートが制限されている
            if (templateType__ == RngConst.RNG_TEMPLATE_PRIVATE
                    && aconfMdl.getRarTemplatePersonalFlg()
                        == RngConst.RAR_TEMPLATE_PERSONAL_FLG_NO) {
                throw new RestApiValidateException(
                    RngEnumReasonCode.PARAM_CANT_USE_PRIVATE_TEMPLATE,
                        "error.use.limit",
                        new GsMessage(ctx.getRequestModel())
                        .getMessage("cmn.personal.template"));
            }
        }
        // 検索種別 カテゴリSID指定
        if (categorySearchType__ == RngConst.RNG_API_SEARCH_RTC_SID) {
            // カテゴリSIDが未入力
            if (categorySid__ < 1) {
                throw new RestApiValidateException(
                        EnumError.PARAM_REQUIRED,
                        "error.input.number.over",
                        "categorySid", "1");
            }
            // カテゴリSIDを指定時、使用制限を確認する
            RngTemplateCategoryDao categoryDao = new RngTemplateCategoryDao(ctx.getCon());
            RngTemplateCategoryModel categoryModel = categoryDao.select(categorySid__);

            if (categoryModel == null) {
                // [RINGI-204] 指定した稟議カテゴリへアクセスできない
                throw new RestApiValidateException(
                    RngEnumReasonCode.PARAM_CANT_ACCESS_CATEGORY,
                        "error.no.access.data",
                        new GsMessage(ctx.getRequestModel())
                        .getMessage("rng.62")
                        + new GsMessage(ctx.getRequestModel())
                        .getMessage("cmn.category"));
            } else if (categoryModel.getRtcType() == RngConst.RNG_API_RTC_SHARE) {
                // [RINGI-204] 共有カテゴリを指定したテンプレート取得時、カテゴリの使用が制限されている
                // カテゴリ管理者権限のあるカテゴリSID一覧を取得
                RngTemplatecategoryAdmDao rtcAdmDao
                    = new RngTemplatecategoryAdmDao(ctx.getCon());
                ArrayList<Integer> amdSidList
                    = rtcAdmDao.getRngTemplatecategorySidList(ctx.getRequestUserSid());

                // 許可or制限のあるカテゴリSID一覧を取得
                RngTemplatecategoryUseDao rtcUseDao = new RngTemplatecategoryUseDao(ctx.getCon());
                ArrayList<Integer> useSidList
                    = rtcUseDao.getRngTemplatecategorySidList(ctx.getRequestUserSid());

                boolean isAdmSid = amdSidList.contains(categorySid__);
                boolean isUseSid = useSidList.contains(categorySid__);

                if (categoryModel.getRtcUseLimit() == RngConst.LIMIT_USE
                        && !isAdmSid
                        && ((categoryModel.getRtcLimitType() == RngConst.LIMIT_TYPE_LIMIT
                                && isUseSid)
                            || (categoryModel.getRtcLimitType() == RngConst.LIMIT_TYPE_ACCEPT
                                && !isUseSid))) {
                    throw new RestApiValidateException(
                        RngEnumReasonCode.PARAM_CANT_ACCESS_CATEGORY,
                            "error.no.access.data",
                            new GsMessage(ctx.getRequestModel())
                            .getMessage("rng.62")
                            + new GsMessage(ctx.getRequestModel())
                            .getMessage("cmn.category")
                    );
                }
            } else if (categoryModel.getRtcType() == RngConst.RNG_API_RTC_PRIVATE) {
                //[RINGI-217] 個人カテゴリを指定したテンプレート取得時、個人テンプレートが制限されている
                if (aconfMdl.getRarTemplatePersonalFlg()
                        == RngConst.RAR_TEMPLATE_PERSONAL_FLG_NO) {
                    throw new RestApiValidateException(
                        RngEnumReasonCode.PARAM_CANT_USE_PRIVATE_TEMPLATE,
                            "error.use.limit",
                            new GsMessage(ctx.getRequestModel())
                            .getMessage("cmn.personal.template")
                    );
                //[RINGI-204] 他人の個人カテゴリにはアクセスできない
                } else if (categoryModel.getUsrSid() != ctx.getRequestUserSid()) {
                    throw new RestApiValidateException(
                        RngEnumReasonCode.PARAM_CANT_ACCESS_CATEGORY,
                            "error.no.access.data",
                            new GsMessage(ctx.getRequestModel())
                            .getMessage("rng.62")
                            + new GsMessage(ctx.getRequestModel())
                            .getMessage("cmn.category")
                    );
                }
            }
        }
    }
}
