package jp.groupsession.v2.rng.restapi.templates.steps.groups.query;

import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.groupsession.v2.restapi.controller.AbstractRestApiAction;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.controller.annotation.Get;
import jp.groupsession.v2.restapi.controller.annotation.Plugin;
import jp.groupsession.v2.restapi.response.RestApiResponseWriter;
import jp.groupsession.v2.rng.RngConst;

/**
 * <br>[機  能] 経路に選択できるグループを一覧取得する アクションクラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author  JTS
 */
@Plugin(RngConst.PLUGIN_ID_RINGI)
public class RngTemplatesStepsGroupsQueryAction extends AbstractRestApiAction {

    /**
     * GETメソッド
     * @param req リクエスト
     * @param res レスポンス
     * @param ctx コンテキスト
     * @param param リクエストパラメータ
     * @throws SQLException
     */
    @Get
    public void doGet(
        HttpServletRequest req,
        HttpServletResponse res,
        RngTemplatesStepsGroupsQueryGetParamModel param,
        RestApiContext ctx) throws SQLException {

        //経路に選択できるグループを一覧取得する
        RngTemplatesStepsGroupsQueryGetBiz biz = new RngTemplatesStepsGroupsQueryGetBiz(param, ctx);
        biz.execute();

        RestApiResponseWriter.builder(res, ctx)
        .addResultList(biz.getResult())
        .build().execute();
    }
}
