package jp.groupsession.v2.rng.restapi.templates.steps.groups.query;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.groupsession.v2.cmn.GSConstCommon;
import jp.groupsession.v2.cmn.biz.GroupBiz;
import jp.groupsession.v2.cmn.biz.UserGroupSelectBiz;
import jp.groupsession.v2.cmn.dao.GroupDao;
import jp.groupsession.v2.cmn.dao.base.CmnGroupmDao;
import jp.groupsession.v2.cmn.model.base.CmnGroupmModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.biz.RngBiz;
import jp.groupsession.v2.rng.biz.RngTemplateBiz;
import jp.groupsession.v2.rng.dao.RngTemplateKeiroDao;
import jp.groupsession.v2.rng.dao.RngTemplateKeiroUserDao;
import jp.groupsession.v2.rng.model.RngTemplateKeiroModel;
import jp.groupsession.v2.rng.model.RngTemplateKeiroUserModel;
import jp.groupsession.v2.rng.rng110keiro.EnumKeiroKbn;
import jp.groupsession.v2.usr.GSConstUser;

/**
 * <br>[機  能] 経路に選択できるグループを一覧取得する ビジネスロジック
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author  JTS
 */
public class RngTemplatesStepsGroupsQueryGetBiz {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(RngTemplatesStepsGroupsQueryGetBiz.class);

    /** リクエストパラメータ */
    private RngTemplatesStepsGroupsQueryGetParamModel param__;
    /** 実行結果*/
    private List<RngTemplatesStepsGroupsQueryResultModel> result__ = new ArrayList<>();

    /** コンテキスト */
    private RestApiContext ctx__;
    /** DBコネクション */
    private Connection con__;

    /**
     * コンストラクタ
     * @param param リクエストパラメータ
     * @param ctx コンテキスト
     */
    public RngTemplatesStepsGroupsQueryGetBiz(
        RngTemplatesStepsGroupsQueryGetParamModel param,
        RestApiContext ctx) {
        param__ = param;
        ctx__ = ctx;
        con__ = ctx__.getCon();
    }

    /**
     *
     * <br>[機  能] 経路に選択できるグループを一覧取得する
     * <br>[解  説]
     * <br>[備  考]
     * @throws SQLException SQL実行時例外
     */
    public void execute() throws SQLException {

        log__.info("経路に選択できるグループを一覧取得するAPI execute");

        //経路情報を取得する
        RngTemplateKeiroDao rtkDao = new RngTemplateKeiroDao(con__);
        RngTemplateKeiroModel rtkMdl = rtkDao.select(param__.getStepSid());

        //経路種別に応じたグループ一覧を取得し、結果モデルにセットする
        if (rtkMdl != null) {
            switch (rtkMdl.getRtkType()) {
                //ユーザ選択
                case EnumKeiroKbn.USERSEL_VAL:
                    __setResultForUserSelect(rtkMdl);
                    break;
                //グループ選択
                case EnumKeiroKbn.GROUPSEL_VAL:
                    __setResultForGroupSelect(rtkMdl);
                    break;
                //上長指定
                case EnumKeiroKbn.BOSSTARGET_VAL:
                    __setResultForBossTarget(rtkMdl);
                    break;
                default:
                    break;
            }
        }
    }

    /**
     * <br>[機  能] 実行結果の取得
     * <br>[解  説]
     * <br>[備  考]
     * @return 実行結果
     */
    public List<RngTemplatesStepsGroupsQueryResultModel> getResult() {
        return result__;
    }

    /**
     * <br>[機  能] 「ユーザ選択」経路の場合の取得結果をセットする
     * <br>[解  説]
     * <br>[備  考]
     * @param rtkMdl 経路情報
     * @throws SQLException
     */
    private void __setResultForUserSelect(RngTemplateKeiroModel rtkMdl) throws SQLException {

        //取得対象グループSIDリスト
        List<Integer> grpSidList = new ArrayList<Integer>();

        //経路の選択対象を取得
        RngTemplateKeiroUserDao rkuDao = new RngTemplateKeiroUserDao(con__);
        List<RngTemplateKeiroUserModel> rkuMdlList = rkuDao.select(rtkMdl.getRtkSid());

        if (rkuMdlList == null || rkuMdlList.isEmpty()) {
            //経路の選択対象にグループ/ユーザが指定されていない場合、全てのグループを取得
            CmnGroupmDao cgmDao = new CmnGroupmDao(con__);
            grpSidList = cgmDao.getGrpSidList();

        } else {
            //経路の選択対象が指定されている場合、選択対象グループ/ユーザを取得
            List<String> selectable = new ArrayList<String>();
            for (RngTemplateKeiroUserModel rkuMdl : rkuMdlList) {
                if (rkuMdl.getUsrSid() > GSConstUser.USER_RESERV_SID) {
                    selectable.add(String.valueOf(rkuMdl.getUsrSid()));
                } else if (rkuMdl.getGrpSid() > -1) {
                    selectable.add(
                        UserGroupSelectBiz.GROUP_PREFIX
                        + String.valueOf(rkuMdl.getGrpSid()));
                }
            }

            //選択対象から選択不可グループ/ユーザを除外したリストを生成
            RngBiz rngBiz = new RngBiz(con__);
            List<Integer> usrSidList = new ArrayList<Integer>();
            rngBiz.createSelectableForUserSel(
                selectable.toArray(String[]::new),
                grpSidList,
                usrSidList,
                rtkMdl.getRtkOwnsingi(),
                ctx__.getRequestModel());

            //ユーザが所属するグループ一覧を取得
            GroupDao grpDao = new GroupDao(con__);
            grpSidList.addAll(grpDao.getUserGroup(usrSidList));
        }

        //取得結果をセット
        __setResult(grpSidList);
    }

    /**
     * <br>[機  能] 「グループ選択」経路の場合の取得結果をセットする
     * <br>[解  説]
     * <br>[備  考]
     * @param rtkMdl 経路情報
     * @throws SQLException
     */
    private void __setResultForGroupSelect(RngTemplateKeiroModel rtkMdl) throws SQLException {

        //取得対象グループSIDリスト
        List<Integer> grpSidList = new ArrayList<Integer>();

        //経路の選択対象を取得
        RngTemplateKeiroUserDao rkuDao = new RngTemplateKeiroUserDao(con__);
        List<RngTemplateKeiroUserModel> rkuMdlList = rkuDao.select(rtkMdl.getRtkSid());

        if (rkuMdlList == null || rkuMdlList.isEmpty()) {
            //経路の選択対象にグループが指定されていない場合、全てのグループを取得
            CmnGroupmDao cgmDao = new CmnGroupmDao(con__);
            grpSidList = cgmDao.getGrpSidList();

        } else {
            //経路の選択対象に指定されているグループを取得
            grpSidList = rkuMdlList.stream()
                                        .filter(mdl -> mdl.getGrpSid() > -1)
                                        .map(mdl -> mdl.getGrpSid())
                                        .collect(Collectors.toList());

            //承認者数の閾値
            int threshould = 1;
            if (rtkMdl.getRtkOutcondition() == RngConst.RNG_OUT_CONDITION_NUMBER) {
                threshould = rtkMdl.getRtkOutcondBorder();
            }

            //選択可能グループを取得
            RngBiz rngBiz = new RngBiz(con__);
            grpSidList = rngBiz.getSelectableForGrpSel(
                            grpSidList, rtkMdl.getRtkMultiselFlg(), threshould);
        }
        //取得結果をセット
        __setResult(grpSidList);
    }

    /**
     * <br>[機  能] 「上長指定」経路の場合の取得結果をセットする
     * <br>[解  説]
     * <br>[備  考]
     * @param rtkMdl 経路情報
     * @throws SQLException
     */
    private void __setResultForBossTarget(RngTemplateKeiroModel rtkMdl) throws SQLException {

        //上長指定に選択できるグループを取得
        RngTemplateBiz rtpBiz = new RngTemplateBiz();
        List<Integer> grpSidList
            = rtpBiz.getBossTargetGroup(rtkMdl, ctx__.getRequestUserSid(), con__);

        //取得結果をセット
        __setResult(grpSidList);
    }

    /**
     * <br>[機  能] 結果モデルにグループ一覧をセットする
     * <br>[解  説]
     * <br>[備  考]
     * @param grpSidList グループSIDリスト
     * @throws SQLException
     */
    private void __setResult(List<Integer> grpSidList) throws SQLException {

        //セッションユーザのデフォルトグループを取得
        GroupBiz grpBiz = new GroupBiz();
        int defGrpSid = grpBiz.getDefaultGroupSid(ctx__.getRequestUserSid(), con__);

        //グループ一覧を結果モデルにセット
        int[] grpSids = grpSidList.stream()
                        .mapToInt(Integer::intValue)
                        .toArray();
        List<CmnGroupmModel> grpMdlList
            = grpBiz.getGroupTreeList(con__, grpSids);
        for (CmnGroupmModel grpMdl : grpMdlList) {
            RngTemplatesStepsGroupsQueryResultModel resultMdl
                = new RngTemplatesStepsGroupsQueryResultModel();
            resultMdl.setId(grpMdl.getGrpId());
            resultMdl.setName(grpMdl.getGrpName());
            if (grpMdl.getGrpSid() == defGrpSid) {
                resultMdl.setDefaultGrpFlg(
                    GSConstCommon.RESTAPI_GROUPS_DEFAULTGROUP_YES);
            } else {
                resultMdl.setDefaultGrpFlg(
                    GSConstCommon.RESTAPI_GROUPS_DEFAULTGROUP_NO);
            }
            result__.add(resultMdl);
        }
    }
}
